/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Flap, flap.  That's the noise that penguins make.
 *
 * This class is a special kind of socket that speaks AOL's "flap"
 * and feeds incoming server garbage into SNAC handler classes.
 */

#import <Foundation/NSObject.h>
#import <Grouch/GrouchSocket.h>
#import <Oscar/OscarSnacHandler.h>

@class NSString, NSMutableDictionary;
@class OscarClient, OscarBuffer, OscarIncomingSnac, OscarSnacHandler;
@class OscarTlvListIn;

@protocol OscarCredentials
/* Should write as TLV */
- (void)writeCredentials:(OscarBuffer*)buf;
@end

typedef enum
{
	FLAP_SIGNON	= 1,
	FLAP_DATA	= 2,
	FLAP_ERROR	= 3,
	FLAP_SIGNOFF	= 4,
	FLAP_KEEPALIVE	= 5
} OscarFlapType;

@interface OscarFlap : GrouchSocket <OscarSnacHandler>
{
@private
	int inSeq, outSeq;
	BOOL gotSeq;

	id<OscarCredentials> creds;
	OscarSnacHandler *snacs;
	OscarClient *oscar;
}

+ (OscarFlap*)socketForHost:(NSString*)host
            withCredentials:(id<OscarCredentials>)c 
	     andSnacHandler:(OscarSnacHandler*)snac
		  forClient:(OscarClient*)cli
		withRunLoop:(NSRunLoop*)loop;
+ (OscarFlap*)socketForHost:(NSString*)host atPort:(int)port
            withCredentials:(id<OscarCredentials>)c 
	     andSnacHandler:(OscarSnacHandler*)snac
		  forClient:(OscarClient*)cli
		withRunLoop:(NSRunLoop*)loop;

- init;
- (void)dealloc;

- initForHost:(NSString*)host atPort:(int)port
                     withCredentials:(id<OscarCredentials>)c
		     andSnacHandler:(OscarSnacHandler*)snac
			  forClient:(OscarClient*)cli
			withRunLoop:(NSRunLoop*)loop;
- initForHost:(NSString*)host withCredentials:(id<OscarCredentials>)c
		     andSnacHandler:(OscarSnacHandler*)snac
			  forClient:(OscarClient*)cli
			withRunLoop:(NSRunLoop*)loop;

- (void)write:(OscarBuffer*)buf;
- (void)write:(OscarBuffer*)buf withType:(OscarFlapType)type;

// Snac handler protocol
- (void)handleSnacForClient:(OscarFlap*)flap
                   ofFamily:(int)family andType:(int)type
                   withFlags:(int)flags andTag:tag
                   buffer:(OscarIncomingSnac*)buf;
// More snac handler junk
- (OscarSnacHandler*)snacHandler;
- (OscarClient*)client;
- (void)setClient:(OscarClient*)client;

// Overridden by auth client
- (void)handleSignoffFlap:(OscarTlvListIn*)data;
- (void)sendingCookie;
- (void)welcome;

// Glue for socket
- (void)keepAlive:sock;
- (void)bytesIn:sock atBuffer:(const void*)buf withLength:(size_t)len;
- (void)handleIncomingData:(int)type atBuffer:(const void*)buf
	withLength:(size_t)len;
@end

// XXX this is an ugly hack
@interface OscarDetachedFlapInitializer : NSObject
{
	NSString *host;
	int port;
	id<OscarCredentials> creds;
	OscarSnacHandler *snac;
	OscarClient *cli;
	NSRunLoop *loop;
	BOOL fatal;
	BOOL usingThreading;
}

+ go:(OscarFlap*)flap host:(NSString*)str port:(int)port creds:creds
  snac:(OscarSnacHandler*)snac client:(OscarClient*)cli loop:(NSRunLoop*)loop
  fatal:(BOOL)fatal;
+ go:(OscarFlap*)flap host:(NSString*)str creds:creds
  snac:(OscarSnacHandler*)snac client:(OscarClient*)cli loop:(NSRunLoop*)loop
  fatal:(BOOL)fatal;

- (void)go:(OscarFlap*)flap;
- (void)activate:(OscarFlap*)flap;
@end
