/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 * --
 * Keeps a local copy of Server-Stored Information
 */

#import <Foundation/NSObject.h>

@class NSData, NSString, NSArray, NSMutableArray, NSMutableDictionary;
@class OscarBuffer, OscarTlvListIn, OscarBos;
@protocol GrouchUser;

typedef enum
{
	OscarSsiUser		= 0x0,
	OscarSsiGroup		= 0x1,
	OscarSsiPermit		= 0x2,
	OscarSsiDeny		= 0x3,
	OscarSsiPrivacy		= 0x4,
	OscarSsiVisiblility	= 0x5,
	OscarSsiTimeStamp	= 0xf
} OscarSsiType;

@class OscarSsiRecord;
@protocol GrouchClient;

@interface OscarSsiList : NSObject
{
	NSMutableArray *records;
	NSMutableDictionary *groupsByNumber;
	NSMutableArray *buddies;
	NSMutableDictionary *buddiesByGroupAndNumber;
	//NSMutableDictionary *buddiesByNumber;
	id<GrouchClient> cli;
}

- init;
- (void)dealloc;

- (void)setClient:c;

- (void)addChild:(OscarSsiRecord*)rec;
- (void)addRecord:(NSString*)d item:(int)iid group:(int)gid type:(int)type
  tlv:tlv;
- (NSArray*)findRecordsOfType:(OscarSsiType)type;
- (NSArray*)getContactList:(BOOL)showOfflineUsers;
- (void)setUp:(OscarSsiRecord*)obj;
- (int)nextGroup;
- (int)nextBuddyForGroup:(int)gid;

- (OscarSsiRecord*)groupById:(int)gid;
- (OscarSsiRecord*)userById:(int)user andGroup:(int)gid;

- (BOOL)containsUser:(id<GrouchUser>)user;

- (void)reparentChildrenForBos:(OscarBos*)bos;
- (void)confirmAdd:(OscarSsiRecord*)obj bos:(OscarBos*)bos;

- (void)setAlias:(NSString*)alias forUser:(id<GrouchUser>)user
	withBos:(OscarBos*)bos;

- (void)_remove:(OscarSsiRecord*)rec;
@end

@interface OscarSsiRecord : NSObject
{
	NSObject *desc;
	int type, iid, gid;
	NSMutableArray *children;
	BOOL virtual;
	OscarBuffer *tlv;
	id parent;
	BOOL marked;
}

- (void)dealloc;

- description;
- (void)setDescription:obj;

- (int)type;
- (void)setType:(int)i;
- (int)item;
- (void)setItem:(int)i;
- (int)gid;
- (void)setGid:(int)i;
- parent;
- (void)setParent:p;

- (BOOL)isVirtual;
- (void)setVirtual:(BOOL)v;

- (OscarBuffer*)tlvRaw;
- (OscarTlvListIn*)tlv;
- (void)setTlv:tlv;

- (void)output:(OscarBuffer*)buf children:(BOOL)children;
- (void)output:(OscarBuffer*)buf;

- (NSArray*)children;
- (void)addChild:(OscarSsiRecord*)rec;
- (void)remove;

- (BOOL)marked;
- (void)mark;
@end

