/*
 * Grouch.app				Copyright (C) 2006 Andy Sveikauskas
 * ------------------------------------------------------------------------
 * This program is free software under the GNU General Public License
 */

#import <Prefs.h>
#import <Renaissance/Renaissance.h>
#import <Renaissance/GNUstep.h>
#import <AppKit/AppKit.h>

static NSPanel *prefs = nil;
static NSMutableArray *views = nil;
static NSMutableArray *objectsToFree = nil;
static NSMutableArray *panes = nil;

@interface PrefsController : NSObject
@end

@implementation PrefsController

- (void)save:sender
{
	int i;
	for(i=0; i<[panes count]; ++i)
		[[panes objectAtIndex:i] save];
	[prefs performClose:sender];
}

@end

@interface PrefsPanelController : NSObject
@end
@implementation PrefsPanelController
- (BOOL)windowShouldClose:(NSWindow*)wnd
{
	prefs = nil;
	[self release];
	[views release];
	[objectsToFree release];
	[panes release];
	return YES;
}
@end
@interface PrefsButtonController : NSObject
{
	NSView *item;
}
@end
@implementation PrefsButtonController
- initWithView:(NSView*)view
{
	self = [super init];
	item = view;
	return self;
}
+ controllerWithView:(NSView*)view
{
	return [[self alloc] initWithView:view];
}
- (void)click:sender
{
	int i;
	for(i=0; i<[views count]; ++i)
	{
		NSView *v = [views objectAtIndex:i];
		[v setHidden:YES];
	}
	[item setHidden:NO];
	// XXX
	[[prefs contentView] addSubview:item];
}
@end

static float currentX = 0.0f;

static void addPane(id<PreferencePane> p)
{
	NSView *v = [p create];
	NSButton *b = [p button];
	id c = [PrefsButtonController controllerWithView:v];
	NSView *contents = [prefs contentView];

	if(currentX != 0.0f)
		[v setHidden:YES];
	[views addObject:v];
	[objectsToFree addObject:c];

	[b setTarget:c];
	[b setAction:@selector(click:)];
	[b sizeToFit];

	{
		NSRect window = [contents frame];
		NSRect button = [b frame];
		NSRect center = [v frame];

		button.origin.x = 10 + currentX;
		currentX += button.size.width;
		button.origin.y = -10 + window.size.height - button.size.height;
		[b setFrame:button];

		center.origin.x = (window.size.width - center.size.width)/2;
		center.origin.y = (window.size.height - center.size.height)/2;
		[v setFrame:center];
	}

	[contents addSubview:b];
	[contents addSubview:v];

	[panes addObject:p];
}

void GrouchShowPrefs()
{
	if(!prefs)
	{
		id controller = [PrefsPanelController new];
		NSButton *save, *cancel;
		NSRect frame, windowFrame;

		views = [NSMutableArray new];
		objectsToFree = [NSMutableArray new];
		panes = [NSMutableArray new];

		prefs = [[NSPanel alloc]
			 initWithContentRect:NSMakeRect(0,0,480,270)
			 styleMask:(NSTitledWindowMask|
				    NSMiniaturizableWindowMask|
				    NSClosableWindowMask)
			 backing:NSBackingStoreBuffered
			 defer:YES];
		[prefs setTitle:_(@"Preferences")];
		[prefs setDelegate:controller];
		[prefs center];

		currentX = 0.0f;

		addPane([[PrefsEvents new] autorelease]); 

		save = [[NSButton alloc] initWithFrame:NSMakeRect(0,0,0,0)];
		[save setTitle:_(@"Save")];
		[save setKeyEquivalent:@"\r"];
		[save sizeToFit];
		frame = [save frame];
		windowFrame = [[prefs contentView] frame];
		frame.origin.x = windowFrame.size.width - 10 - frame.size.width;
		frame.origin.y = 10;
		[save setFrame:frame];
		[[prefs contentView] addSubview:[save autorelease]];

		cancel = [[NSButton alloc] initWithFrame:frame];
		[cancel setTitle:_(@"Cancel")];
		[cancel sizeToFit];
		frame = [cancel frame];
		frame.origin.x -= 10 + frame.size.width;
		[cancel setFrame:frame];
		[[prefs contentView] addSubview:[cancel autorelease]];

		{
			PrefsController *c=[[PrefsController new] autorelease];
			[objectsToFree addObject:c];
			[save setTarget:c];
			[save setAction:@selector(save:)];
		}

		[cancel setTarget:prefs];
		[cancel setAction:@selector(performClose:)];
	}
	[prefs makeKeyAndOrderFront:prefs];
}
