/**************************************************************************
 *                                                                        *
 *   Copyright (C) 2001 Grub, Inc.                                        *
 *                                                                        *
 *   This program is free software; you can redistribute it and/or modify *
 *   it under the terms of the GNU General Public License as published by *
 *   the Free Software Foundation; either version 1, or (at your option)  *
 *   any later version.                                                   *
 *                                                                        *
 *   This program is distributed in the hope that it will be useful,      *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 *   GNU General Public License for more details.                         *
 *                                                                        *
 *   You should have received a copy of the GNU General Public License    *
 *   along with this program; if not, write to the Free Software          *
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
 *                                                                        *
 *                                                                        *
 **************************************************************************/ 
/* Project: GRUB 
 * <http://www.grub.org>
 * module: CREP
 * Author: Kosta Damevski (Kosta42@hotmail.com)
 * Last revision: 08 Jan, 2001
 * Files: PutParser.cpp PutParser.h
 *
 * Class PutParser is part of the PUT or REPORT part of
 * the protocol. The majority of the processing is currently
 * performed by PutProtocol.cpp however this class provides abstraction
 * similar to GET part of the protocol and can be used in the future 
 * when the client actually extracts URLs.
 */


//***********************************************************
#ifndef _PutParser_H_
#define _PutParser_H_

#include <stdio.h>
#include <string.h>
#include <string>
#include <Communication.h>
#include "Parser.h"
#include <ClientDB.h>
#include <clog.h>

class PutParser : public Parser
{
  public:
  	PutParser(char *);
  	virtual void putNewURL();
        virtual void putDueURL();
        void parse() throw (ParseExp);
  private:
  	char *distracts;	
        Communication *comm;
};

#endif
