#ifndef _RMFILES_H_
#define _RMFILES_H_

/* possible modes */
#define RMFILES_STOP_ON_FIRST_FAIL 0
#define RMFILES_CONT_ON_FAIL       1

/* error codes */
#define RMFILES_SUCCESS 0
#define RMFILES_FAILURE -1

/* rmfiles_byext()
 * Removes files from a given path that match certain extension, or more
 * correctly, files whose last characters of their names match the given
 * ones.  This function runs in two modes.  In the first mode, it will stop
 * its actions after the first failure to remove files.  In the second mode,
 * It will keep trying to remove even after a failure.  However, there is no
 * way of getting why the removal failed or how many files were successfully
 * removed.  This function is not reentrant.  Function exits successfully if
 * no files match.
 * Parameters:
 *   path -- the path to start removing from.  No subdirectories will be
 *           included.
 *   extension -- the last characters a file must match
 *   mode -- RMFILES_STOP_ON_FIRST_FAIL or zero for the first mode;
 *           RMFILES_CONT_ON_FAIL for the second mode
 * Returns:
 *   RMFILES_SUCCESS -- all files the matched were removed
 *   RMFILES_FAILURE -- in the first mode, failure to remove a file.
 *     You can check errno for more information.  In the second mode, one or
 *     more (possibly all) files failed to be removed.  Do not rely on errno
 *     for a reason.
 */
int rmfiles_byext( const char *path, const char *extension, int mode );

#endif  /* _RMFILES_H_ */
