# gsmssend.spec -- RPM spec file for gsmsend
#
# GNOME-SmsSend (c) 2001 Eric Lassauge <lassauge@mail.dotcom.fr>
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation.
#
# This file is provided AS IS with no warranties of any kind.  The author
# shall have no liability with respect to the infringement of copyrights,
# trade secrets or any patents by this file or any part thereof.  In no
# event will the author be liable for any lost revenue or profits or
# other special, indirect and consequential damages.
#
# mailto:lassauge@mail.dotcom.fr
# http://lassauge.free.fr/smssend/

%define 	name	gsmssend
%define 	version	1.7
%define 	release	1
%define 	prefix	/usr

Summary: 	GNOME user interface for SmsSend
Summary(fr):    Interface GNOME  SmsSend
Summary(cz):    GNOME rozhran pro SmsSend
Summary(de):	GNOME-Interface fr SmsSend
Summary(nl):	GNOME SmsSend interface

Name:		%{name}
Version:	%{version}
Release:	%{release}
Copyright:	GPL
Group:		Applications/Internet
Url:		http://lassauge.free.fr/smssend/
Vendor:		Eric Lassauge <lassauge@mail.dotcom.fr>
Source:		http://lassauge.free.fr/smssend/%{name}-%{version}.tar.gz
Packager:	Eric Lassauge <lassauge@mail.dotcom.fr>
BuildRoot:	/var/tmp/%{name}-%{version}-root
Requires:	gtk+ >= 1.2.8, smssend >= 2.9

%description
GNOME-SmsSend is a gnome UI to the smssend tools written by
Christophe CALMEJANE 'Ze KiLleR / SkyTech'
http://zekiller.skytech.org/smssend_menu_en.html

It will detect the provider script files in the default locations
(current dir, ~/.smssend, and smssend default global) and create a small UI
for each one. When you click on the APPLY button it will fork/exec
smssend with proper options.
All options to SmsSend can be set through the preference dialog.

%description -l fr
GNOME-SmsSend est une interface homme-machine GNOME  l'outil
SmsSend crit par Christophe CALMEJANE 'Ze KiLleR / SkyTech'
http://zekiller.skytech.org/smssend_menu_fr.html

Cette application dtecte les scripts de provider install
(repertoire courant, ~/.smssend, et scripts installs par dfaut) et
cre une IHM spcifique pour chacun des providers.
Toutes les options de SmsSend sont configurables par les diffrents dialogues.


%prep
%setup -q
CFLAGS=$MYCFLAGS \
	./configure --prefix=%{prefix}

%build
make

%install
[ -d $RPM_BUILD_ROOT ] && rm -rf $RPM_BUILD_ROOT;
make -e prefix=$RPM_BUILD_ROOT%{prefix} install

%clean
[ -d $RPM_BUILD_ROOT ] && rm -rf $RPM_BUILD_ROOT;

%files
%defattr(-,root,root)
%doc ChangeLog COPYING README NEWS TODO
%{prefix}/bin/gsmssend
%{prefix}/share/gnome/apps/Internet/gsmssend.desktop
%{prefix}/share/pixmaps/gnome-smssend.png
%{prefix}/share/pixmaps/gsmssend
%{prefix}/share/gsmssend
%{prefix}/man/*/gsmssend.*
%{prefix}/share/locale/*/LC_MESSAGES/gsmssend.mo
%doc %{prefix}/share/gnome/help/gsmssend/*

%changelog
* Fri Nov 23 2001 Eric Lassauge <lassauge@mail.dotcom.fr>
- use MYCFLAGS for configure
* Tue Nov 20 2001 Eric Lassauge <lassauge@mail.dotcom.fr>
- Updated with some translations
