/* callback.c --- code of the different callbacks  */

/* Copyright (c) E. Lassauge, 2000-2001.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 * mailto:lassauge@mail.dotcom.fr
 * http://lassauge.free.fr/
 *
 * REVISION HISTORY: see Changelog
 *
 */

#include <stdlib.h>

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>

#include "sms.h"
#include "callbacks.h"
#include "interface.h"
#include "support.h"

/* local variables */
static int aliasRow = -1;
static const GtkSortType clist_sort[] = 
	{GTK_SORT_ASCENDING,GTK_SORT_DESCENDING};
static GtkSortType sort[SCRIPT_CLIST_COLS] = {0,1,1}; /* is index in previous array */

#include "checked.xpm"
static GdkPixmap *check = (GdkPixmap *) NULL;
static GdkBitmap *mask  = (GdkBitmap *)NULL;

/* All callbacks */
void on_script_ok_pressed(GtkWidget * widget, GtkFileSelection *filesel)
{
    /* callback on script selection */
    gchar      *filename;
    gchar      *ext;
    PProvider_t Pv=NULL;

    filename = g_strdup(gtk_file_selection_get_filename(GTK_FILE_SELECTION(filesel)));
    gtk_widget_destroy(GTK_WIDGET(filesel));
    ext = (gchar *)g_extension_pointer(filename);
    if (g_strncasecmp(g_extension_pointer(filename),SMSSEND_SUF,3) == 0)
    {
	Pv = create_provider(filename);
	if (!Pv)
	{
	    g_printerr(_("Error for '%s'!\n"),filename);
	}
        else
	{
    	    gchar *status;
    	    status = g_strdup_printf(_("%s : %d provider(s) found"),PACKAGE,NumProvider);
    	    gnome_appbar_set_status(GNOME_APPBAR(Appbar), status);
    	    g_free(status);
	}
    }
    g_free(filename);
}

void on_pref_ok_pressed(GtkButton * button, gpointer user_data)
{
    /* update preferences variables: user_data is 1 if write pref file */
    GtkWidget *widget = GTK_WIDGET(button);
    gchar     *config_file;

    UseProxy = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(widget, "use_proxy")));

    if (UseProxy)
    {
	g_snprintf(ProxyHost, P_LENGTH, "%s", gtk_entry_get_text(GTK_ENTRY(lookup_widget(widget, "proxy_host"))));
	ProxyPort = (gint) atoi(gtk_entry_get_text(GTK_ENTRY(lookup_widget(widget, "proxy_port"))));

	g_snprintf(ProxyUser, P_LENGTH, "%s", gtk_entry_get_text(GTK_ENTRY(lookup_widget(widget, "proxy_user"))));
	g_snprintf(ProxyPass, P_LENGTH, "%s", gtk_entry_get_text(GTK_ENTRY(lookup_widget(widget, "proxy_password"))));
    }

    DebugLevel = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(lookup_widget(widget, "debug_level")));
    TimeOut    = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(lookup_widget(widget, "timeout")));
    AutoCheck  = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(widget, "auto_check")));
    DelaySend  = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(widget, "delay_send")));
    KeepPass   = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(widget, "keep_pass")));
    Retries    = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(lookup_widget(widget, "retries")));

    config_file = gtk_entry_get_text(GTK_ENTRY(lookup_widget(widget, "header_file")));
    if (strlen(config_file))
    	HeaderFile =  g_strdup(config_file);

    /* Save current configuration */
    if ((int)user_data == OK_PRESSED)
    {
	gchar *path;
        config_file=gnome_util_prepend_user_home(".smssend/smssendrc");
	/* =/home/me/.smssend/smssendrc=/Proxy/use_proxy=true */
	path = g_strdup_printf("=%s=/Proxy/use_proxy",config_file);
	gnome_config_set_bool(path,UseProxy);
	g_free(path);
	if (UseProxy)
	{
	    gchar *temp;

	    path = g_strdup_printf("=%s=/Proxy/proxy_host",config_file);
	    gnome_config_set_string(path,ProxyHost);
	    g_free(path);
	    path = g_strdup_printf("=%s=/Proxy/proxy_port",config_file);
	    gnome_config_set_int(path,ProxyPort);
	    g_free(path);
	    path = g_strdup_printf("=%s=/Proxy/proxy_user",config_file);
	    gnome_config_set_string(path,ProxyUser);
	    g_free(path);
	    path = g_strdup_printf("=%s=/Proxy/proxy_password",config_file);
	    temp = g_strdup(ProxyPass);
	    crypt_password(temp);
	    gnome_config_set_string(path,temp);
	    g_free(temp);
	    g_free(path);
	}
	path = g_strdup_printf("=%s=/Misc/debug_level",config_file);
	gnome_config_set_int(path,DebugLevel);
	g_free(path);
	path = g_strdup_printf("=%s=/Misc/timeout",config_file);
	gnome_config_set_int(path,TimeOut);
	g_free(path);
	path = g_strdup_printf("=%s=/Misc/auto_check",config_file);
	gnome_config_set_bool(path,AutoCheck);
	g_free(path);
	path = g_strdup_printf("=%s=/Misc/keep_pass",config_file);
	gnome_config_set_bool(path,KeepPass);
	g_free(path);
	path = g_strdup_printf("=%s=/Misc/delay_calls",config_file);
	gnome_config_set_bool(path,DelaySend);
	path = g_strdup_printf("=%s=/Misc/retries",config_file);
	gnome_config_set_int(path,Retries);
	g_free(path);

	gnome_config_sync();
        g_free(config_file);
    }
}

void on_new_file_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    /* Open a dialog box to choose a new provider file */
    Scripts_fs=create_scripts_file_selection();
    gtk_widget_show(Scripts_fs);
}

void on_goto_smssend_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    /* Open a web browser on the smssend homepage */
    gnome_url_show(SMSSEND_URL_SCRIPTS);
}

void on_sendnow_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    if (DelayList)
    {
        gnome_appbar_set_status(GNOME_APPBAR(Appbar), "SmsSend ...");
        gnome_appbar_set_progress(GNOME_APPBAR(Appbar), 0.0);
	/* call DelayedSms for each element of the list */
	g_slist_foreach(DelayList, DelayedSms, (gpointer) NULL);

	/* free list (all elements are freed in DelayedSms) */
	g_slist_free(DelayList);
	DelayList = (GSList*)NULL;
    }
}

void on_close_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    /* remove currently selected notebook tab, but not Provider struct */
    GtkNotebook *nb = GTK_NOTEBOOK(Notebook);
    gint        curpage = gtk_notebook_get_current_page(nb);
    GtkWidget   *curwidget;
    PProvider_t Pv;

    /* check page number ! */
    if (curpage < 0)
	return;
    /* get Provider struct from selected tab (saved at creation) */
    curwidget = nb->cur_page->child;
    Pv = (PProvider_t) gtk_object_get_data(GTK_OBJECT(curwidget),"provider");
    /* remove from hash */
    g_hash_table_remove(ShownProviderHash, (gconstpointer) Pv->Filename);
    gtk_notebook_remove_page(nb,curpage);
}

void on_exit_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    if (DelayList)
    {
	gnome_appbar_set_status(GNOME_APPBAR(Appbar), _("** WARNING **: You have delayed messages !"));
	g_warning(_("You have delayed SMS messages !"));
	return;
    }
    /* this is the end TODO: wait for end of current connection */
    gtk_exit(0);
}

void on_preferences_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    /* open the preference dialog box */
    Preference = create_preferences();
    gtk_widget_show(Preference);
}

void on_check_updates_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    /* launch "smssend -update" */
    LaunchSms(NULL, FALSE, TRUE);
}

void on_manage_alias_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    /* open the alias dialog box */
    if (!Alias)
        Alias = create_aliases();
    gtk_widget_show(Alias);
}

void on_script_clist_click_column(GtkCList        *clist,
                                  gint             column,
                                  gpointer         user_data)
{
    int sort_type = sort[column];
    sort[column] = (sort_type + 1) % 2;
    gtk_clist_set_sort_column(clist,column);
    gtk_clist_set_sort_type(clist,clist_sort[sort[column]]);
    gtk_clist_sort(clist);
}


void on_script_clist_select_row(GtkCList        *clist,
                                gint             row,
                                gint             column,
                                GdkEvent        *event,
                                gpointer         user_data)
{
#if 0
    GtkStyle *row_style = gtk_widget_get_style(GTK_WIDGET(clist));
#endif

    if ((int)user_data == SEL_PRESSED)
    {
#if 0
	/* TODO: set_background/set_row_style doesn't do what I want : get rid of selection bg */
	gtk_style_set_background (row_style,GTK_WIDGET(clist)->window,GTK_STATE_NORMAL);
	gtk_clist_set_row_style(clist,row,row_style);
#endif
	if (column)
	{
    	    /* gtk_clist_set_text(clist,row,column,"/"); */
	    gtk_clist_set_pixmap(clist, row, column,check,mask);
	}
    }
    else
    {
	if (column)
    		gtk_clist_set_text(clist,row,column," ");
    }
}

static void update_script_dialog(gpointer key,
                  		 gpointer value,
                  		 gpointer user_data)
{
    GtkCList *clist = GTK_CLIST(user_data);
    gchar *row_data[SCRIPT_CLIST_COLS] = {NULL," "," "};
    gint row = -1;
    gint col = -1;
    row_data[SCRIPT_COL] = (gchar *)key;
    /* called for each detected script */
    if ( (SavedProviderHash) && (g_hash_table_lookup (SavedProviderHash, (gconstpointer) key)) )
    {
	/* script was allready saved */
	col = SAVE_COL;
    	row = gtk_clist_append(clist,row_data);	
        /* SAVE/SHOW column will be updated by "select-row" signal */
	gtk_clist_select_row(clist,row,col);
     	if ( g_hash_table_lookup(ShownProviderHash, (gconstpointer) key) )
     	{
	    /* script was allready shown */
	    col = SHOW_COL;
	    gtk_clist_select_row(clist,row,col);
     	}
	return;
    }
    if ( g_hash_table_lookup(ShownProviderHash, (gconstpointer) key) )
    {
	/* script was allready shown */
	col = SHOW_COL;
    }
    row = gtk_clist_append(clist,row_data);	
    if (col > SCRIPT_COL)
    	/* SHOW column will be updated by "select-row" signal */
	gtk_clist_select_row(clist,row,col);
}

void on_manage_scripts_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    GtkCList *clist;
    /* open the script dialog box */
    if (!Scripts)
    {
        Scripts = create_scripts();
    }
    clist = GTK_CLIST(lookup_widget(GTK_WIDGET(Scripts), "script_clist"));
    gtk_widget_show(Scripts);
    /* update the script dialog content */
    if (!check)
    {
    	check = gdk_pixmap_create_from_xpm_d(clist->clist_window,&mask,NULL,check_data);
    }
    gtk_clist_freeze(clist);
    g_hash_table_foreach(ProviderHash,update_script_dialog,(gpointer)clist);
    gtk_clist_set_sort_column(clist,0);
    gtk_clist_set_sort_type(clist,GTK_SORT_ASCENDING);
    gtk_clist_sort(clist);
    gtk_clist_columns_autosize(clist);
    gtk_clist_unselect_all(clist);
    gtk_clist_thaw(clist);
}

void on_about_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    /* open the about dialog box */
    About = create_about();
    gtk_widget_show(About);
}

void on_send_pressed(GtkButton * button, gpointer user_data)
{
    /* lauch smsend for the current provider */
    PProvider_t Pv = (PProvider_t) user_data;
    if (DelaySend)
    {
    	/* allocate parameters struct */
    	PcmdParam_t sms_param = g_new(cmdParam_t, 1);

    	sms_param->Pv        = Pv;
    	sms_param->Help      = FALSE;
    	sms_param->Update    = FALSE;
    	sms_param->Callback  = 0;
    	sms_param->Callback2 = 0;
    	sms_param->Done      = 999;
    	sms_param->argc      = 0;
	CreateArgv(sms_param);

	DelayList = g_slist_append(DelayList,(gpointer)sms_param);
	gnome_appbar_set_status(GNOME_APPBAR(Appbar), _("SmsSend delayed ..."));
	gnome_appbar_set_progress(GNOME_APPBAR(Appbar), 0.0);

    }
    else
    	LaunchSms(Pv, FALSE, FALSE);
}

void on_message_changed(GtkEditable * editable, gpointer user_data)
{
    /* check length of message with respect to the maximum size */

    guint Size = (guint) (user_data);	/* user_data yields Size field */
    GtkText *message = GTK_TEXT(editable);
    guint CurSize = gtk_text_get_length(message);
    GtkWidget *SizeVal = (GtkWidget *) gtk_object_get_data(GTK_OBJECT(message), "remain");	/* remaining entry widget is saved in editable widget */

    if (CurSize >= Size)
    {
	/* check if not too much data: erase it */
	gtk_text_set_point(message, CurSize);
	gtk_text_backward_delete(message, (CurSize - Size));
	CurSize = gtk_text_get_length(message);
    }
    if ((Size - CurSize) < 0)
	return;
    if (SizeVal != (GtkWidget *) NULL)
    {
	/* update remaining */
	char remain[4];
	g_snprintf(remain, 4, "%d", Size - CurSize);
	gtk_entry_set_text(GTK_ENTRY(SizeVal), remain);
    }
}

void on_value_check(GtkEditable * editable, gpointer user_data)
{
    /* Check if a parameter entry is an alias and change it */
    GtkEntry *param = GTK_ENTRY(editable);
    gchar *tmp = gtk_entry_get_text(param);
    gchar *key,*value;

    if ((AliasHash) && (tmp) && (tmp[0] == '@'))
    {
	key = g_strdup(tmp+1);
	/* Check in alias hash array */
        value = (gchar *)g_hash_table_lookup (AliasHash, (gconstpointer) key);
	if (value)
	{
	   /* update with aliased value */
	   gtk_entry_set_text(param,value);
	}
    	g_free(key);
    }
}

void on_alias_clist_select_row(GtkCList *clist,
                               gint     row,
                               gint     column,
                               GdkEvent *event,
                               gpointer user_data)
{
    /* called on each select/unselect in the aliases clist */
    GtkEntry *alias = GTK_ENTRY(lookup_widget(GTK_WIDGET(clist), "alias_key"));
    GtkEntry *value = GTK_ENTRY(lookup_widget(GTK_WIDGET(clist), "alias_value"));
    gchar *key_s;
    gchar *value_s;

    if ((int)user_data == SEL_PRESSED)
    {
    	gtk_clist_get_text(clist, row, KEY_COL, &key_s);
    	gtk_clist_get_text(clist, row, VAL_COL, &value_s);

    	aliasRow = row;
    	gtk_entry_set_text(alias,key_s);
    	gtk_entry_set_text(value,value_s);
    }
    else
    {
	aliasRow = -1;
    	gtk_entry_set_text(alias,"");
    	gtk_entry_set_text(value,"");
    }
}

void on_updown_clicked(GtkButton *button, gpointer user_data)
{
    /* Called to moved items in the clist */
    GtkCList *clist = GTK_CLIST(lookup_widget(GTK_WIDGET(button), "alias_clist"));

    if (aliasRow >= 0)
    {
        gint row1;
        gint row2;

    	if ((int)user_data == UP_PRESSED)
	{
	    row1 = aliasRow; row2 = aliasRow -1;
	}
	else
	{
	    row1 = aliasRow+1; row2 = aliasRow;
	}
    	gtk_clist_moveto(clist, aliasRow,KEY_COL,0.5,0.5);
	gtk_clist_swap_rows(clist, row1, row2);
    	gtk_clist_unselect_row(clist,row1,KEY_COL);
    	gtk_clist_unselect_row(clist,row2,KEY_COL);
    	aliasRow = -1;
    }
}

void on_add_clicked(GtkButton *button, gpointer user_data)
{
    /* called to add a new pair of alias/value */
    GtkCList *clist = GTK_CLIST(lookup_widget(GTK_WIDGET(button), "alias_clist"));
    GtkEntry *alias = GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "alias_key"));
    GtkEntry *value = GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "alias_value"));
    gchar *key_s   = gtk_entry_get_text(alias);
    gchar *value_s = gtk_entry_get_text(value);
    gchar *tmp[ALIAS_CLIST_COLS];

    if (key_s && value_s && strlen(key_s) && strlen(value_s))
    {
        tmp[KEY_COL] = (gchar *) key_s;
        tmp[VAL_COL] = (gchar *) value_s;

	if (!AliasHash)
		AliasHash = g_hash_table_new(g_str_hash,g_str_equal);
	if (g_hash_table_lookup (AliasHash, (gconstpointer) key_s) == NULL)
	{
		/* add it to clist and hash if not allready present */
        	gtk_clist_append (clist,tmp);
        	g_hash_table_insert(AliasHash,(gpointer) key_s, (gpointer) value_s);
	}

    	gtk_entry_set_text(alias,"");
    	gtk_entry_set_text(value,"");
    }
    if (aliasRow >= 0)
    {
    	gtk_clist_unselect_row(clist,aliasRow,KEY_COL);
    	aliasRow = -1;
    }
}

void on_delete_clicked(GtkButton *button, gpointer user_data)
{
    /* called to delete a selected pair of alias/value */
    GtkEntry *alias = GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "alias_key"));
    GtkEntry *value = GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "alias_value"));
    GtkCList *clist = GTK_CLIST(lookup_widget(GTK_WIDGET(button), "alias_clist"));
    gchar *key_s   = gtk_entry_get_text(alias);

    if (aliasRow >= 0)
    {
       	gtk_clist_remove(clist,aliasRow);
    	gtk_clist_unselect_row(clist,aliasRow,KEY_COL);
    	g_hash_table_remove(AliasHash, (gconstpointer) key_s);
    	aliasRow = -1;
    }

    gtk_entry_set_text(alias,"");
    gtk_entry_set_text(value,"");
}

static void update_alias_file(gpointer key,
                  	gpointer value,
                  	gpointer user_data)
{
   /* local function called for each each alias/value pair */
   FILE *fp = (FILE *)user_data;

   fprintf(fp,"%s %s\n",(gchar *) key,(gchar *) value);
}

void on_alias_ok_pressed(GtkButton * button, gpointer user_data)
{
    gchar *path;

    if (((int)user_data == OK_PRESSED) && (g_hash_table_size(AliasHash)>0))
    {
	FILE *fp;
	/* We have a hash : save the file */
	path = gnome_util_prepend_user_home(".smssend/aliases");
	if (g_file_test(path, G_FILE_TEST_ISFILE))
	    unlink(path);
	fp = fopen(path,"a");
	if (fp != (FILE *)NULL)
        {
	    time_t now = time(NULL); 
	    fprintf(fp,"# Alias file generated by %s version %s\n#\n",PACKAGE,VERSION);
	    fprintf(fp,"# Date: %s#\n",ctime(&now));
  	    g_hash_table_foreach(AliasHash,update_alias_file,(gpointer)fp);
	    fclose(fp);
	}
	g_free(path);
    }
}

static void update_script_file(gpointer key,
                  	       gpointer value,
                  	       gpointer user_data)
{
   /* local function called for each each script */
   FILE *fp = (FILE *)user_data;

   fprintf(fp,"%s\n",(gchar *) key);
}

void on_script_val_pressed(GtkButton * button, gpointer user_data)
{
    GtkCList *clist = GTK_CLIST(lookup_widget(GTK_WIDGET(Scripts), "script_clist"));

    /* if OK or APPLY, updated hashes and notebook */
    if ((int)user_data != CANCEL_PRESSED)
    {
        GtkNotebook *nb = GTK_NOTEBOOK(Notebook);
	int row;

	if (!SavedProviderHash)
	    SavedProviderHash = g_hash_table_new(g_str_hash,g_str_equal);
        /* get script selection state from clist*/
	for (row=0;row < NumProvider;row++)
	{
    	    gchar *row_data[SCRIPT_CLIST_COLS] = {NULL,NULL,NULL};
	    GdkPixmap *pixmap;
	    GdkBitmap *mask;
	    gint is_show,is_save;
	    #define FILENAME row_data[SCRIPT_COL]
	    #define SHOW row_data[SHOW_COL]
	    #define SAVE row_data[SAVE_COL]
            PProvider_t Pv = (PProvider_t) NULL;

    	    gtk_clist_get_text(clist, row, SCRIPT_COL, &FILENAME);
	    /*
    	    gtk_clist_get_text(clist, row, SHOW_COL, &SHOW);
    	    gtk_clist_get_text(clist, row, SAVE_COL, &SAVE);
	    */
	    is_show = gtk_clist_get_pixmap(clist, row, SHOW_COL,
                                           &pixmap, &mask);
	    is_save = gtk_clist_get_pixmap(clist, row, SAVE_COL,
                                           &pixmap, &mask);
	    Pv = g_hash_table_lookup(ProviderHash,(gconstpointer)FILENAME);
	    /* add it or not to the hash */
	    if (is_show)
	    {
	        if (g_hash_table_lookup(ShownProviderHash,(gconstpointer)FILENAME) == NULL)
		    show_provider(FILENAME,Pv);
	    }
	    else /* Not SHOW */
	    {
	        Pv = g_hash_table_lookup(ShownProviderHash,(gconstpointer)FILENAME);
		if (Pv)
		{
		    /* get page number */
		    gint page = gtk_notebook_page_num(nb,Pv->PageWidget);
		    /* TODO: free stuff ? */
		    /* Remove from hash */
		    g_hash_table_remove(ShownProviderHash,(gconstpointer)FILENAME);
		    /* Remove from notebook */
		    gtk_notebook_remove_page(nb,page);
		}
	    }
	    if (is_save)
	    {
	        if (g_hash_table_lookup(SavedProviderHash,(gconstpointer)FILENAME) == NULL)
		    /* Add it to saved hash */
		    g_hash_table_insert(SavedProviderHash,(gpointer)FILENAME, (gpointer) Pv);
	    }
	    else /* Not SAVE */
	    {
	        Pv = g_hash_table_lookup(SavedProviderHash,(gconstpointer)FILENAME);
		if (Pv)
		{
		    /* TODO: free stuff ? */
		    /* Remove from hash */
		    g_hash_table_remove(SavedProviderHash,(gconstpointer)FILENAME);
		}
	    }
	}
	
	/* destroy hash if empty */
    	if (g_hash_table_size(SavedProviderHash) == 0)
    	{
	    g_hash_table_destroy (SavedProviderHash);
	    SavedProviderHash = (GHashTable *) NULL;
    	}
    }
    /* only save in user file when OK */
    if ((int)user_data == OK_PRESSED)
    {
	FILE *fp;
    	gchar *path;
	/* Save the list of scripts in a file */
	path = gnome_util_prepend_user_home(".smssend/scripts");
	if (g_file_test(path, G_FILE_TEST_ISFILE))
	    unlink(path);
	if (SavedProviderHash)
	{
	fp = fopen(path,"a");
	    if (fp != (FILE *)NULL)
            {
	    	time_t now = time(NULL); 
	    	fprintf(fp,"# Scripts file generated by %s version %s\n#\n",PACKAGE,VERSION);
	    	fprintf(fp,"# Date: %s#\n",ctime(&now));
  	    	g_hash_table_foreach(SavedProviderHash,update_script_file,(gpointer)fp);
	    	fclose(fp);
	    }
	}
	g_free(path);
    }
    /* delete clist */
    gtk_clist_clear(clist);
    gtk_widget_hide(Scripts);
}
