// Generated by gmmproc 2.50.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_EVENT_H
#define _GSTREAMERMM_EVENT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2016 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/miniobject.h>
#include <gstreamermm/format.h>
#include <gstreamermm/clock.h>
#include <gstreamermm/segment.h>
#include <gstreamermm/caps.h>


namespace Glib
{
    template<typename T>
    Glib::RefPtr<T> wrap_event_derived(GstEvent* object, bool take_copy)
    {
      if(take_copy && object)
        gst_event_ref(object);

      // See the comment at the top of this file, if you want to know why the cast works.
      return Glib::RefPtr<T>(reinterpret_cast<T*>(object));
    }

}

namespace Gst
{

#define GST_EVENT_MAKE_TYPE(num,flags) \
    (((num) << GST_EVENT_NUM_SHIFT) | (flags))

#define FLAG(name) GST_EVENT_TYPE_##name

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var EventType EVENT_UNKNOWN
 * Unknown event.
 * 
 *  @var EventType EVENT_FLUSH_START
 * Start a flush operation. This event clears all data
 * from the pipeline and unblock all streaming threads.
 * 
 *  @var EventType EVENT_FLUSH_STOP
 * Stop a flush operation. This event resets the
 * running-time of the pipeline.
 * 
 *  @var EventType EVENT_STREAM_START
 * Event to mark the start of a new stream. Sent before any
 * other serialized event and only sent at the start of a new stream,
 * not after flushing seeks.
 * 
 *  @var EventType EVENT_CAPS
 * Gst::Caps event. Notify the pad of a new media type.
 * 
 *  @var EventType EVENT_SEGMENT
 * A new media segment follows in the dataflow. The
 * segment events contains information for clipping buffers and
 * converting buffer timestamps to running-time and
 * stream-time.
 * 
 *  @var EventType EVENT_TAG
 * A new set of metadata tags has been found in the stream.
 * 
 *  @var EventType EVENT_BUFFERSIZE
 * Notification of buffering requirements. Currently not
 * used yet.
 * 
 *  @var EventType EVENT_SINK_MESSAGE
 * An event that sinks turn into a message. Used to
 * send messages that should be emitted in sync with
 * rendering.
 * 
 *  @var EventType EVENT_EOS
 * End-Of-Stream. No more data is to be expected to follow
 * without a SEGMENT event.
 * 
 *  @var EventType EVENT_SEGMENT_DONE
 * Marks the end of a segment playback.
 * 
 *  @var EventType EVENT_GAP
 * Marks a gap in the datastream.
 * 
 *  @var EventType EVENT_TOC
 * An event which indicates that a new table of contents (TOC)
 * was found or updated.
 * 
 *  @var EventType EVENT_PROTECTION
 * An event which indicates that new or updated
 * encryption information has been found in the stream.
 * 
 *  @var EventType EVENT_QOS
 * A quality message. Used to indicate to upstream elements
 * that the downstream elements should adjust their processing
 * rate.
 * 
 *  @var EventType EVENT_SEEK
 * A request for a new playback position and rate.
 * 
 *  @var EventType EVENT_NAVIGATION
 * Navigation events are usually used for communicating
 * user requests, such as mouse or keyboard movements,
 * to upstream elements.
 * 
 *  @var EventType EVENT_LATENCY
 * Notification of new latency adjustment. Sinks will use
 * the latency information to adjust their synchronisation.
 * 
 *  @var EventType EVENT_STEP
 * A request for stepping through the media. Sinks will usually
 * execute the step operation.
 * 
 *  @var EventType EVENT_RECONFIGURE
 * A request for upstream renegotiating caps and reconfiguring.
 * 
 *  @var EventType EVENT_TOC_SELECT
 * A request for a new playback position based on TOC
 * entry's UID.
 * 
 *  @var EventType EVENT_CUSTOM_UPSTREAM
 * Upstream custom event.
 * 
 *  @var EventType EVENT_CUSTOM_DOWNSTREAM
 * Downstream custom event that travels in the
 * data flow.
 * 
 *  @var EventType EVENT_CUSTOM_DOWNSTREAM_OOB
 * Custom out-of-band downstream event.
 * 
 *  @var EventType EVENT_CUSTOM_DOWNSTREAM_STICKY
 * Custom sticky downstream event.
 * 
 *  @var EventType EVENT_CUSTOM_BOTH
 * Custom upstream or downstream event.
 * In-band when travelling downstream.
 * 
 *  @var EventType EVENT_CUSTOM_BOTH_OOB
 * Custom upstream or downstream out-of-band event.
 * 
 *  @enum EventType
 * 
 * Gst::EventType lists the standard event types that can be sent in a pipeline.
 * 
 * The custom event types can be used for private messages between elements
 * that can't be expressed using normal
 * GStreamer buffer passing semantics. Custom events carry an arbitrary
 * Gst::Structure.
 * Specific custom events are distinguished by the name of the structure.
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%EventType operator|(EventType, EventType)</tt><br>
 * <tt>%EventType operator&(EventType, EventType)</tt><br>
 * <tt>%EventType operator^(EventType, EventType)</tt><br>
 * <tt>%EventType operator~(EventType)</tt><br>
 * <tt>%EventType& operator|=(EventType&, EventType)</tt><br>
 * <tt>%EventType& operator&=(EventType&, EventType)</tt><br>
 * <tt>%EventType& operator^=(EventType&, EventType)</tt><br>
 */
enum EventType
{
  EVENT_UNKNOWN = GST_EVENT_MAKE_TYPE (0, 0),
  EVENT_FLUSH_START = GST_EVENT_MAKE_TYPE (10, FLAG(BOTH)),
  EVENT_FLUSH_STOP = GST_EVENT_MAKE_TYPE (20, FLAG(BOTH) | FLAG(SERIALIZED)),
  EVENT_STREAM_START = GST_EVENT_MAKE_TYPE (40, FLAG(DOWNSTREAM) | FLAG(SERIALIZED) | FLAG(STICKY)),
  EVENT_CAPS = GST_EVENT_MAKE_TYPE (50, FLAG(DOWNSTREAM) | FLAG(SERIALIZED) | FLAG(STICKY)),
  EVENT_SEGMENT = GST_EVENT_MAKE_TYPE (70, FLAG(DOWNSTREAM) | FLAG(SERIALIZED) | FLAG(STICKY)),
  EVENT_TAG = GST_EVENT_MAKE_TYPE (80, FLAG(DOWNSTREAM) | FLAG(SERIALIZED) | FLAG(STICKY) | FLAG(STICKY_MULTI)),
  EVENT_BUFFERSIZE = GST_EVENT_MAKE_TYPE (90, FLAG(DOWNSTREAM) | FLAG(SERIALIZED) | FLAG(STICKY)),
  EVENT_SINK_MESSAGE = GST_EVENT_MAKE_TYPE (100, FLAG(DOWNSTREAM) | FLAG(SERIALIZED) | FLAG(STICKY) | FLAG(STICKY_MULTI)),
  EVENT_EOS = GST_EVENT_MAKE_TYPE (110, FLAG(DOWNSTREAM) | FLAG(SERIALIZED) | FLAG(STICKY)),
  EVENT_TOC = GST_EVENT_MAKE_TYPE (120, FLAG(DOWNSTREAM) | FLAG(SERIALIZED) | FLAG(STICKY) | FLAG(STICKY_MULTI)),
  EVENT_PROTECTION = GST_EVENT_MAKE_TYPE (130, FLAG (DOWNSTREAM) | FLAG (SERIALIZED) | FLAG (STICKY) | FLAG (STICKY_MULTI)),
  EVENT_SEGMENT_DONE = GST_EVENT_MAKE_TYPE (150, FLAG(DOWNSTREAM) | FLAG(SERIALIZED)),
  EVENT_GAP = GST_EVENT_MAKE_TYPE (160, FLAG(DOWNSTREAM) | FLAG(SERIALIZED)),
  EVENT_QOS = GST_EVENT_MAKE_TYPE (190, FLAG(UPSTREAM)),
  EVENT_SEEK = GST_EVENT_MAKE_TYPE (200, FLAG(UPSTREAM)),
  EVENT_NAVIGATION = GST_EVENT_MAKE_TYPE (210, FLAG(UPSTREAM)),
  EVENT_LATENCY = GST_EVENT_MAKE_TYPE (220, FLAG(UPSTREAM)),
  EVENT_STEP = GST_EVENT_MAKE_TYPE (230, FLAG(UPSTREAM)),
  EVENT_RECONFIGURE = GST_EVENT_MAKE_TYPE (240, FLAG(UPSTREAM)),
  EVENT_TOC_SELECT = GST_EVENT_MAKE_TYPE (250, FLAG(UPSTREAM)),
  EVENT_CUSTOM_UPSTREAM = GST_EVENT_MAKE_TYPE (270, FLAG(UPSTREAM)),
  EVENT_CUSTOM_DOWNSTREAM = GST_EVENT_MAKE_TYPE (280, FLAG(DOWNSTREAM) | FLAG(SERIALIZED)),
  EVENT_CUSTOM_DOWNSTREAM_OOB = GST_EVENT_MAKE_TYPE (290, FLAG(DOWNSTREAM)),
  EVENT_CUSTOM_DOWNSTREAM_STICKY = GST_EVENT_MAKE_TYPE (300, FLAG(DOWNSTREAM) | FLAG(SERIALIZED) | FLAG(STICKY) | FLAG(STICKY_MULTI)),
  EVENT_CUSTOM_BOTH = GST_EVENT_MAKE_TYPE (310, FLAG(BOTH) | FLAG(SERIALIZED)),
  EVENT_CUSTOM_BOTH_OOB = GST_EVENT_MAKE_TYPE (320, FLAG(BOTH))
};

/** @ingroup gstreamermmEnums */
inline EventType operator|(EventType lhs, EventType rhs)
  { return static_cast<EventType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline EventType operator&(EventType lhs, EventType rhs)
  { return static_cast<EventType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline EventType operator^(EventType lhs, EventType rhs)
  { return static_cast<EventType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline EventType operator~(EventType flags)
  { return static_cast<EventType>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline EventType& operator|=(EventType& lhs, EventType rhs)
  { return (lhs = static_cast<EventType>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline EventType& operator&=(EventType& lhs, EventType rhs)
  { return (lhs = static_cast<EventType>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline EventType& operator^=(EventType& lhs, EventType rhs)
  { return (lhs = static_cast<EventType>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::EventType> : public Glib::Value_Flags<Gst::EventType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var EventTypeFlags EVENT_TYPE_UPSTREAM
 * Set if the event can travel upstream.
 * 
 *  @var EventTypeFlags EVENT_TYPE_DOWNSTREAM
 * Set if the event can travel downstream.
 * 
 *  @var EventTypeFlags EVENT_TYPE_SERIALIZED
 * Set if the event should be serialized with data
 * flow.
 * 
 *  @var EventTypeFlags EVENT_TYPE_STICKY
 * Set if the event is sticky on the pads.
 * 
 *  @var EventTypeFlags EVENT_TYPE_STICKY_MULTI
 * Multiple sticky events can be on a pad, each
 * identified by the event name.
 * 
 *  @enum EventTypeFlags
 * 
 * Gst::EventTypeFlags indicate the aspects of the different Gst::EventType
 * values. You can get the type flags of a Gst::EventType with the
 * Gst::Event::type_get_flags() function.
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%EventTypeFlags operator|(EventTypeFlags, EventTypeFlags)</tt><br>
 * <tt>%EventTypeFlags operator&(EventTypeFlags, EventTypeFlags)</tt><br>
 * <tt>%EventTypeFlags operator^(EventTypeFlags, EventTypeFlags)</tt><br>
 * <tt>%EventTypeFlags operator~(EventTypeFlags)</tt><br>
 * <tt>%EventTypeFlags& operator|=(EventTypeFlags&, EventTypeFlags)</tt><br>
 * <tt>%EventTypeFlags& operator&=(EventTypeFlags&, EventTypeFlags)</tt><br>
 * <tt>%EventTypeFlags& operator^=(EventTypeFlags&, EventTypeFlags)</tt><br>
 */
enum EventTypeFlags
{
  EVENT_TYPE_UPSTREAM = 1 << 0,
  EVENT_TYPE_DOWNSTREAM = 1 << 1,
  EVENT_TYPE_SERIALIZED = 1 << 2,
  EVENT_TYPE_STICKY = 1 << 3,
  EVENT_TYPE_STICKY_MULTI = 1 << 4
};

/** @ingroup gstreamermmEnums */
inline EventTypeFlags operator|(EventTypeFlags lhs, EventTypeFlags rhs)
  { return static_cast<EventTypeFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline EventTypeFlags operator&(EventTypeFlags lhs, EventTypeFlags rhs)
  { return static_cast<EventTypeFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline EventTypeFlags operator^(EventTypeFlags lhs, EventTypeFlags rhs)
  { return static_cast<EventTypeFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline EventTypeFlags operator~(EventTypeFlags flags)
  { return static_cast<EventTypeFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline EventTypeFlags& operator|=(EventTypeFlags& lhs, EventTypeFlags rhs)
  { return (lhs = static_cast<EventTypeFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline EventTypeFlags& operator&=(EventTypeFlags& lhs, EventTypeFlags rhs)
  { return (lhs = static_cast<EventTypeFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline EventTypeFlags& operator^=(EventTypeFlags& lhs, EventTypeFlags rhs)
  { return (lhs = static_cast<EventTypeFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::EventTypeFlags> : public Glib::Value_Flags<Gst::EventTypeFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var QOSType QOS_TYPE_OVERFLOW
 * The QoS event type that is produced when upstream
 * elements are producing data too quickly and the element can't keep up
 * processing the data. Upstream should reduce their production rate. This
 * type is also used when buffers arrive early or in time.
 * 
 *  @var QOSType QOS_TYPE_UNDERFLOW
 * The QoS event type that is produced when upstream
 * elements are producing data too slowly and need to speed up their
 * production rate.
 * 
 *  @var QOSType QOS_TYPE_THROTTLE
 * The QoS event type that is produced when the
 * application enabled throttling to limit the data rate.
 * 
 *  @enum QOSType
 * 
 * The different types of QoS events that can be given to the
 * Gst::Event::new_qos() method.
 *
 * @ingroup gstreamermmEnums
 */
enum QOSType
{
  QOS_TYPE_OVERFLOW,
  QOS_TYPE_UNDERFLOW,
  QOS_TYPE_THROTTLE
};

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::QOSType> : public Glib::Value_Enum<Gst::QOSType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{

/** 
 *  @var StreamFlags STREAM_FLAG_NONE
 * This stream has no special attributes.
 * 
 *  @var StreamFlags STREAM_FLAG_SPARSE
 * This stream is a sparse stream (e.g. a subtitle
 * stream), data may flow only in irregular intervals with large gaps in
 * between.
 * 
 *  @var StreamFlags STREAM_FLAG_SELECT
 * This stream should be selected by default. This
 * flag may be used by demuxers to signal that a stream should be selected
 * by default in a playback scenario.
 * 
 *  @var StreamFlags STREAM_FLAG_UNSELECT
 * This stream should not be selected by default.
 * This flag may be used by demuxers to signal that a stream should not
 * be selected by default in a playback scenario, but only if explicitly
 * selected by the user (e.g. an audio track for the hard of hearing or
 * a director's commentary track).
 * 
 *  @enum StreamFlags
 *
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%StreamFlags operator|(StreamFlags, StreamFlags)</tt><br>
 * <tt>%StreamFlags operator&(StreamFlags, StreamFlags)</tt><br>
 * <tt>%StreamFlags operator^(StreamFlags, StreamFlags)</tt><br>
 * <tt>%StreamFlags operator~(StreamFlags)</tt><br>
 * <tt>%StreamFlags& operator|=(StreamFlags&, StreamFlags)</tt><br>
 * <tt>%StreamFlags& operator&=(StreamFlags&, StreamFlags)</tt><br>
 * <tt>%StreamFlags& operator^=(StreamFlags&, StreamFlags)</tt><br>
 */
enum StreamFlags
{
  STREAM_FLAG_NONE = 0x0,
  STREAM_FLAG_SPARSE = (1 << 0),
  STREAM_FLAG_SELECT = (1 << 1),
  STREAM_FLAG_UNSELECT = (1 << 2)
};

/** @ingroup gstreamermmEnums */
inline StreamFlags operator|(StreamFlags lhs, StreamFlags rhs)
  { return static_cast<StreamFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline StreamFlags operator&(StreamFlags lhs, StreamFlags rhs)
  { return static_cast<StreamFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline StreamFlags operator^(StreamFlags lhs, StreamFlags rhs)
  { return static_cast<StreamFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline StreamFlags operator~(StreamFlags flags)
  { return static_cast<StreamFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline StreamFlags& operator|=(StreamFlags& lhs, StreamFlags rhs)
  { return (lhs = static_cast<StreamFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline StreamFlags& operator&=(StreamFlags& lhs, StreamFlags rhs)
  { return (lhs = static_cast<StreamFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline StreamFlags& operator^=(StreamFlags& lhs, StreamFlags rhs)
  { return (lhs = static_cast<StreamFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::StreamFlags> : public Glib::Value_Flags<Gst::StreamFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

namespace Gst
{


#undef FLAG

class Message;
class Structure;
class TagList;
class Buffer;
class Toc;

namespace Enums
{

/** Gets a printable name for the given event type.
 *
 * @param type The event type.
 * @return A reference to the static name of the event.
 */
Glib::ustring get_name(EventType type);

/** Gets the unique quark for the given event type.
 *
 * @param type The event type.
 * @return The quark associated with the event type.
 */
Glib::QueryQuark get_quark(EventType type);

/** Gets the Gst::EventTypeFlags associated with type.
 * @param type A Gst::EventType.
 * @return A Gst::EventTypeFlags.
 */
EventTypeFlags get_flags(EventType type);

} //namespace Enums

/** A class that represents events that are passed up and down a pipeline.
 * The event class provides factory methods to construct and functions query
 * (parse) events.
 *
 * Events are usually created by using the Gst::Event derrived classes'
 * create() methods. To send an event application will usually use
 * Gst::Element::send_event() and elements will use Gst::Pad::send_event() or
 * Gst::Pad::push_event().
 *
 * Events that have been received can be parsed with their respective parse()
 * functions.
 *
 * Events are passed between elements in parallel to the data stream. Some
 * events are serialized with buffers, others are not. Some events only travel
 * downstream, others only upstream. Some events can travel both upstream and
 * downstream.
 *
 * The events are used to signal special conditions in the datastream such as
 * EOS (end of stream) or the start of a new stream-segment. Events are also
 * used to flush the pipeline of any pending data.
 *
 * Most of the event API is used inside plugins. Applications usually only
 * construct and use seek events. To do that Gst::EventSeek::create() is used
 * to create a seek event. It takes the needed parameters to specity seeking
 * time and mode.  The event is then sent to the element like so:
 * @code
 * pipeline->send_event(event);
 * @endcode
 */
class Event : public MiniObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = Event;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstEvent*       gobj();

  ///Provides access to the underlying C instance.
  const GstEvent* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstEvent* gobj_copy() const;

  Event() = delete;

  // noncopyable
  Event(const Event&) = delete;
  Event& operator=(const Event&) = delete;

protected:
  // Do not derive this.  Gst::Event can neither be constructed nor deleted.

  void operator delete(void*, std::size_t);

private:

  
public:
// A copy is taken so that the original is not freed by the wrapper.
 

  /** Access the structure of the event.
   * 
   * @return The structure of the event. The structure is still
   * owned by the event, which means that you should not free it and
   * that the pointer becomes invalid when you free the event.
   * 
   * MT safe.
   */
  Gst::Structure get_structure() const;

  
  /** Checks if @a event has the given @a name. This function is usually used to
   * check the name of a custom event.
   * 
   * @param name Name to check.
   * @return <tt>true</tt> if @a name matches the name of the event structure.
   */
  bool has_name(const Glib::ustring& name) const;

  
  /** Retrieve the sequence number of a event.
   * 
   * Events have ever-incrementing sequence numbers, which may also be set
   * explicitly via set_seqnum(). Sequence numbers are typically used to
   * indicate that a event corresponds to some other set of events or messages,
   * for example an EOS event corresponding to a SEEK event. It is considered good
   * practice to make this correspondence when possible, though it is not
   * required.
   * 
   * Note that events and messages share the same sequence number incrementor;
   * two events or messages will never have the same sequence number unless
   * that correspondence was made explicitly.
   * 
   * @return The event's sequence number.
   * 
   * MT safe.
   */
  guint32 get_seqnum() const;
  
  /** Set the sequence number of a event.
   * 
   * This function might be called by the creator of a event to indicate that the
   * event relates to other events or messages. See get_seqnum() for
   * more information.
   * 
   * MT safe.
   * 
   * @param seqnum A sequence number.
   */
  void set_seqnum(guint32 seqnum);

  
  /** Retrieve the accumulated running time offset of the event.
   * 
   * Events passing through Gst::Pads that have a running time
   * offset set via Gst::Pad::set_offset() will get their offset
   * adjusted according to the pad's offset.
   * 
   * If the event contains any information that related to the
   * running time, this information will need to be updated
   * before usage with this offset.
   * 
   * @return The event's running time offset
   * 
   * MT safe.
   */
  gint64 get_running_time_offset() const;
  
  /** Set the running time offset of a event. See
   * get_running_time_offset() for more information.
   * 
   * MT safe.
   * 
   * @param offset A the new running time offset.
   */
  void set_running_time_offset(gint64 offset);

  
  /** Copy the event using the event specific copy function.
   * 
   * @return The new event.
   */
  Glib::RefPtr<Gst::Event> copy() const;

  /**
   * Makes a writable event from the given event. If the source event is
   * already writable, this will simply return the same event.
   * @return A Gst::Event (possibly the same reference) that is writable.
   */
  Glib::RefPtr<Gst::Event> create_writable();

  /** Check if an event can travel downstream.
   */
  bool is_downstream() const;

  /** Check if an event is serialized with the data stream.
   */
  bool is_serialized() const;

  /** Check if an event can travel upstream.
   */
  bool is_upstream() const;

  /** Get the Gst::EventType of the event.
   */
  EventType get_event_type() const;

  /** Get the Gst::ClockTime timestamp of the event. This is the time when the
   * event was created.
   */
  Gst::ClockTime get_timestamp() const;


};

/** A flush start event.  See create() for more details.
 */
class EventFlushStart : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventFlushStart;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Allocate a new flush start event. The flush start event can be sent
   * upstream and downstream and travels out-of-bounds with the dataflow.
   * 
   * It marks pads as being flushing and will make them return
   * Gst::FLOW_FLUSHING when used for data flow with Gst::Pad::push(),
   * Gst::Pad::chain(), Gst::Pad::get_range() and Gst::Pad::pull_range().
   * Any event (except a Gst::EVENT_FLUSH_STOP) received
   * on a flushing pad will return <tt>false</tt> immediately.
   * 
   * Elements should unlock any blocking functions and exit their streaming
   * functions as fast as possible when this event is received.
   * 
   * This event is typically generated after a seek to flush out all queued data
   * in the pipeline so that the new media is played as soon as possible.
   * 
   * @return A new flush start event.
   */
  static Glib::RefPtr<Gst::EventFlushStart> create();


};

/**  A flush stop event.  See create() for more details.
 */
class EventFlushStop : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventFlushStop;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Allocate a new flush stop event. The flush stop event can be sent
   * upstream and downstream and travels serialized with the dataflow.
   * It is typically sent after sending a FLUSH_START event to make the
   * pads accept data again.
   * 
   * Elements can process this event synchronized with the dataflow since
   * the preceding FLUSH_START event stopped the dataflow.
   * 
   * This event is typically generated to complete a seek and to resume
   * dataflow.
   * 
   * @param reset_time If time should be reset.
   * @return A new flush stop event.
   */
  static Glib::RefPtr<Gst::EventFlushStop> create(bool reset_time);

  /** Retrieve a reset time member.
   * @return TRUE, if time should be reset; FALSE, otherwise.
   */
  bool parse_reset_time() const;
  

};

/** A stream-start event.  See create() for more details.
 */
class EventStreamStart : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventStreamStart;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new STREAM_START event. The stream start event can only
   * travel downstream synchronized with the buffer flow. It is expected
   * to be the first event that is sent for a new stream.
   * 
   * Source elements, demuxers and other elements that create new streams
   * are supposed to send this event as the first event of a new stream. It
   * should not be sent after a flushing seek or in similar situations
   * and is used to mark the beginning of a new logical stream. Elements
   * combining multiple streams must ensure that this event is only forwarded
   * downstream once and not for every single input stream.
   * 
   * The @a stream_id should be a unique string that consists of the upstream
   * stream-id, / as separator and a unique stream-id for this specific
   * stream. A new stream-id should only be created for a stream if the upstream
   * stream is split into (potentially) multiple new streams, e.g. in a demuxer,
   * but not for every single element in the pipeline.
   * Gst::Pad::create_stream_id() or Gst::Pad::create_stream_id_printf() can be
   * used to create a stream-id.  There are no particular semantics for the
   * stream-id, though it should be deterministic (to support stream matching)
   * and it might be used to order streams (besides any information conveyed by
   * stream flags).
   * 
   * @param stream_id Identifier for this stream.
   * @return The new STREAM_START event.
   */
  static Glib::RefPtr<Gst::EventStreamStart> create(const Glib::ustring& stream_id);

  /** Parse a stream-id event.
   *
   * @return A stream id.
   */
  Glib::ustring parse_stream_id() const;
  

  /** @param flags The stream flags to set.
   */
  void set_stream_flags(Gst::StreamFlags flags);

  /** Parse a stream flag.
   *
   * @return A stream flags.
   */
  Gst::StreamFlags parse_stream_flags() const;
  

  /** @param group_id Address of variable where to store the group id.
   * @return <tt>true</tt> if a group id was set on the event and could be parsed,
   * <tt>false</tt> otherwise.
   */
  bool parse_group_id(guint& group_id) const;
  
  /** All streams that have the same group id are supposed to be played
   * together, i.e.\ all streams inside a container file should have the
   * same group id but different stream ids. The group id should change
   * each time the stream is started, resulting in different group ids
   * each time a file is played for example.
   * 
   * Use gst_util_group_id_next() to get a new group id.
   * 
   * @param group_id The group id to set.
   */
  void set_group_id(guint group_id);


};

/** A caps event. See create() for more details.
 */
class EventCaps : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventCaps;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new CAPS event for @a caps. The caps event can only travel downstream
   * synchronized with the buffer flow and contains the format of the buffers
   * that will follow after the event.
   * 
   * @param caps A Gst::Caps.
   * @return The new CAPS event.
   */
  static Glib::RefPtr<Gst::EventCaps> create(const Glib::RefPtr<Gst::Caps>& caps);

  /** Get the caps from @a event. The caps remains valid as long as @a event remains
   * valid.
   *
   * @return A caps object.
   */
  Glib::RefPtr<Gst::Caps> parse_caps();
  

  /** Get the caps from @a event. The caps remains valid as long as @a event remains
   * valid.
   *
   * @return A caps object.
   */
  Glib::RefPtr<const Gst::Caps> parse_caps() const;


};

/** A segment event. See create() for more details.
 */
class EventSegment : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventSegment;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new SEGMENT event for @a segment. The segment event can only travel
   * downstream synchronized with the buffer flow and contains timing information
   * and playback properties for the buffers that will follow.
   * 
   * The segment event marks the range of buffers to be processed. All
   * data not within the segment range is not to be processed. This can be
   * used intelligently by plugins to apply more efficient methods of skipping
   * unneeded data. The valid range is expressed with the @a start and @a stop
   * values.
   * 
   * The time value of the segment is used in conjunction with the start
   * value to convert the buffer timestamps into the stream time. This is
   * usually done in sinks to report the current stream_time.
   *  @a time represents the stream_time of a buffer carrying a timestamp of
   *  @a start. @a time cannot be -1.
   * 
   *  @a start cannot be -1, @a stop can be -1. If there
   * is a valid @a stop given, it must be greater or equal the @a start, including
   * when the indicated playback @a rate is < 0.
   * 
   * The @a applied_rate value provides information about any rate adjustment that
   * has already been made to the timestamps and content on the buffers of the
   * stream. ( @a rate * @a applied_rate) should always equal the rate that has been
   * requested for playback. For example, if an element has an input segment
   * with intended playback @a rate of 2.0 and applied_rate of 1.0, it can adjust
   * incoming timestamps and buffer content by half and output a segment event
   * with @a rate of 1.0 and @a applied_rate of 2.0
   * 
   * After a segment event, the buffer stream time is calculated with:
   * 
   * time + (TIMESTAMP(buf) - start) * ABS (rate * applied_rate)
   * 
   * @param segment A Gst::Segment.
   * @return The new SEGMENT event.
   */
  static Glib::RefPtr<Gst::EventSegment> create(const Gst::Segment& segment);

  /** Parses a segment event and copies the GstSegment.
   *
   * @return A copy of a Gst::Segment.
   */
  Gst::Segment copy_segment() const;
  
  
};

/** A tag event. See create() for more details.
 */
class EventTag : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventTag;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Generates a metadata tag event from the given @a taglist.
   * 
   * The scope of the taglist specifies if the taglist applies to the
   * complete medium or only to this specific stream. As the tag event
   * is a sticky event, elements should merge tags received from
   * upstream with a given scope with their own tags with the same
   * scope and create a new tag event from it.
   * 
   * @param taglist Metadata list. The event will take ownership
   * of the taglist.
   * @return A new Gst::Event.
   */
  static Glib::RefPtr<Gst::EventTag> create(const Gst::TagList& taglist);

  /** Gets a tag list.
   * @return A Gst::TagList.
   */
  Gst::TagList parse_tag_list() const;
  

};

/** A buffer size event.  See create() for more details.
 */
class EventBufferSize : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventBufferSize;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new buffersize event. The event is sent downstream and notifies
   * elements that they should provide a buffer of the specified dimensions.
   * 
   * When the @a async flag is set, a thread boundary is preferred.
   * 
   * @param format Buffer format.
   * @param minsize Minimum buffer size.
   * @param maxsize Maximum buffer size.
   * @param async Thread behavior.
   * @return A new Gst::Event.
   */
  static Glib::RefPtr<Gst::EventBufferSize> create(Format format, gint64 minsize, gint64 maxsize, bool async);

  /** Get the format, minsize, maxsize and async-flag in the buffersize event.
   *
   * @param format A reference to store the format in.
   * @param minsize A reference to store the minsize in.
   * @param maxsize A reference to store the maxsize in.
   * @param async A reference to store the async-flag in.
   */
  void parse(Format& format, gint64& minsize, gint64& maxsize, bool& async) const;
  

  /** Get the minsize in the buffersize event.
   *
   * @return The mininum size.
   */
  gint64 parse_min_size() const;

  /** Get the format, in the buffersize event.
   *
   * @return The format.
   */
  Gst::Format parse_format() const;

  /** Get the maxsize in the buffersize event.
   *
   * @return The maximum size.
   */
  gint64 parse_max_size() const;

  /** Get the async-flag in the buffersize event.
   *
   * @return The async flag.
   */
  bool parse_async() const;


};

/** A sink-message event.  See create() for more details.
 */
class EventSinkMessage : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventSinkMessage;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new sink-message event. The purpose of the sink-message event is
   * to instruct a sink to post the message contained in the event synchronized
   * with the stream.
   * 
   *  @a name is used to store multiple sticky events on one pad.
   * 
   * @param name A name for the event.
   * @param message The Gst::Message to be posted.
   * @return A new Gst::Event.
   */
  static Glib::RefPtr<Gst::EventSinkMessage> create(const Glib::ustring& name, const Glib::RefPtr<Gst::Message>& message);

  /** Parse the sink-message event.
   * @return the sink-messge's event message.
   */
  Glib::RefPtr<Gst::Message> parse_message();
  

  /** Parse the sink-message event.
   * @return the sink-messge's event message.
   */
  Glib::RefPtr<const Gst::Message> parse_message() const;


};

/** An end of stream event. See create() for more details.
 */
class EventEos : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventEos;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new EOS event. The eos event can only travel downstream
   * synchronized with the buffer flow. Elements that receive the EOS
   * event on a pad can return Gst::FLOW_EOS as a Gst::FlowReturn
   * when data after the EOS event arrives.
   * 
   * The EOS event will travel down to the sink elements in the pipeline
   * which will then post the Gst::MESSAGE_EOS on the bus after they have
   * finished playing any buffered data.
   * 
   * When all sinks have posted an EOS message, an EOS message is
   * forwarded to the application.
   * 
   * The EOS event itself will not cause any state transitions of the pipeline.
   * 
   * @return The new EOS event.
   */
  static Glib::RefPtr<Gst::EventEos> create();


};

/** A new table of content event. See create() for more details.
 */
class EventToc : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventToc;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Generate a TOC event from the given @a toc. The purpose of the TOC event is to
   * inform elements that some kind of the TOC was found.
   * 
   * @param toc Gst::Toc structure.
   * @param updated Whether @a toc was updated or not.
   * @return A new Gst::Event.
   */
  static Glib::RefPtr<Gst::EventToc> create(const Glib::RefPtr<Gst::Toc>& toc, bool updated);

  /** Parse a TOC event and store the results in the given toc and updated locations.
   *
   * @param toc A Gst::Toc structure.
   * @param updated A TOC update flag.
   */
  void parse(Glib::RefPtr<Gst::Toc>& toc, bool& updated);
  

  /** Parse a TOC event and store the results in the given toc and updated locations.
   *
   * @param toc A Gst::Toc structure.
   * @param updated A TOC update flag.
   */
  void parse(Glib::RefPtr<const Gst::Toc>& toc, bool& updated) const;

  /** Parse a Toc structure.
   *
   * @return A Gst::Toc structure.
   */
  Glib::RefPtr<Gst::Toc> parse_toc();

  /** Parse a Toc structure.
   *
   * @return A Gst::Toc structure.
   */
  Glib::RefPtr<const Gst::Toc> parse_toc() const;

  /** Parse a TOC update flag.
   *
   * @return A TOC update flag.
   */
  bool parse_updated() const;


};

/** A protection event. See create() for more details.
 */
class EventProtection : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventProtection;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Creates a new event containing information specific to a particular
   * protection system (uniquely identified by @a system_id), by which that
   * protection system can acquire key(s) to decrypt a protected stream.
   * 
   * In order for a decryption element to decrypt media
   * protected using a specific system, it first needs all the
   * protection system specific information necessary to acquire the decryption
   * key(s) for that stream. The functions defined here enable this information
   * to be passed in events from elements that extract it
   * (e.g., ISOBMFF demuxers, MPEG DASH demuxers) to protection decrypter
   * elements that use it.
   * 
   * Events containing protection system specific information are created using
   * #gst_event_new_protection, and they can be parsed by downstream elements
   * using #gst_event_parse_protection.
   * 
   * In Common Encryption, protection system specific information may be located
   * within ISOBMFF files, both in movie (moov) boxes and movie fragment (moof)
   * boxes; it may also be contained in ContentProtection elements within MPEG
   * DASH MPDs. The events created by #gst_event_new_protection contain data
   * identifying from which of these locations the encapsulated protection system
   * specific information originated. This origin information is required as
   * some protection systems use different encodings depending upon where the
   * information originates.
   * 
   * The events returned by new_protection() are implemented
   * in such a way as to ensure that the most recently-pushed protection info
   * event of a particular @a origin and @a system_id will
   * be stuck to the output pad of the sending element.
   * 
   * @param system_id A string holding a UUID that uniquely
   * identifies a protection system.
   * @param data A Gst::Buffer holding protection system specific
   * information. The reference count of the buffer will be incremented by one.
   * @param origin A string indicating where the protection
   * information carried in the event was extracted from. The allowed values
   * of this string will depend upon the protection scheme.
   * @return A Gst::EVENT_PROTECTION event, if successful; <tt>nullptr</tt>
   * if unsuccessful.
   */
  static Glib::RefPtr<Gst::EventProtection> create(const Glib::ustring& system_id, const Glib::RefPtr<Gst::Buffer>& data, const Glib::ustring& origin);

 /**
  * Parses an event containing protection system specific information and stores the results in system_id, data and origin.
  *
  * @param system_id Result location for the UUID string uniquely identifying a content protection system.
  * @param data Result location for the Gst::Buffer holding protection system specific information.
  * @param origin Result location for the value that indicates where the protection information carried by event was extracted from.
  */
  void parse(Glib::ustring& system_id, Glib::RefPtr<Gst::Buffer>& data, Glib::ustring& origin) const;
  

  /** Parse UUID of the protection event.
   * @return The UUID.
   */
  Glib::ustring parse_system_id() const;

  /** Parse data of the protection event.
   * @return The data.
   */
  Glib::RefPtr<Gst::Buffer> parse_data();

  /** Parse data of the protection event.
   * @return The data.
   */
  Glib::RefPtr<const Gst::Buffer> parse_data() const;

  /** Parse origin of the protection event.
   * @return The origin.
   */
  Glib::ustring parse_origin() const;


};

/** A segment done event. See create() for more details.
 */
class EventSegmentDone : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventSegmentDone;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new segment-done event. This event is sent by elements that
   * finish playback of a segment as a result of a segment seek.
   * 
   * @param p1 The format of the position being done.
   * @param position The position of the segment being done.
   * @return A new Gst::Event.
   */
  static Glib::RefPtr<Gst::EventSegmentDone> create(Gst::Format p1, gint64 position);

 /**
  * Extracts the position and format from the segment done event.
  *
  * @param format Result location for the format.
  * @param position Result location for the position.
  */
  void parse(Gst::Format& format, gint64& position) const;
  

  /** Parse format of the segment done event.
   * @return The format.
   */
  Gst::Format parse_format() const;

  /** Parse position of the segment done event.
   * @return The position.
   */
  gint64 parse_position() const;


};

/** A gap in the stream event. See create() for more details.
 */
class EventGap : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventGap;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new GAP event. A gap event can be thought of as conceptually
   * equivalent to a buffer to signal that there is no data for a certain
   * amount of time. This is useful to signal a gap to downstream elements
   * which may wait for data, such as muxers or mixers or overlays, especially
   * for sparse streams such as subtitle streams.
   * 
   * @param timestamp The start time (pts) of the gap.
   * @param duration The duration of the gap.
   * @return The new GAP event.
   */
  static Glib::RefPtr<Gst::EventGap> create(Gst::ClockTime timestamp, Gst::ClockTime duration);

 /**
  * Extract timestamp and duration from a new GAP event.
  *
  * @param timestamp Location where to store the start time (pts) of the gap.
  * @param duration Location where to store the duration of the gap.
  */
  void parse(Gst::ClockTime& timestamp, Gst::ClockTime& duration) const;
  

  /** Parse timestamp of the gap event.
   * @return The timestamp.
   */
  Gst::ClockTime parse_timestamp() const;

  /** Parse duration of the gap event.
   * @return The duration.
   */
  Gst::ClockTime parse_duration() const;


};

/** A QOS event.  See create() for more details.
 */
class EventQos : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventQos;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Allocate a new qos event with the given values.
   * The QOS event is generated in an element that wants an upstream
   * element to either reduce or increase its rate because of
   * high/low CPU load or other resource usage such as network performance or
   * throttling. Typically sinks generate these events for each buffer
   * they receive.
   * 
   *  @a type indicates the reason for the QoS event. Gst::QOS_TYPE_OVERFLOW is
   * used when a buffer arrived in time or when the sink cannot keep up with
   * the upstream datarate. Gst::QOS_TYPE_UNDERFLOW is when the sink is not
   * receiving buffers fast enough and thus has to drop late buffers. 
   * Gst::QOS_TYPE_THROTTLE is used when the datarate is artificially limited
   * by the application, for example to reduce power consumption.
   * 
   *  @a proportion indicates the real-time performance of the streaming in the
   * element that generated the QoS event (usually the sink). The value is
   * generally computed based on more long term statistics about the streams
   * timestamps compared to the clock.
   * A value < 1.0 indicates that the upstream element is producing data faster
   * than real-time. A value > 1.0 indicates that the upstream element is not
   * producing data fast enough. 1.0 is the ideal @a proportion value. The
   * proportion value can safely be used to lower or increase the quality of
   * the element.
   * 
   *  @a diff is the difference against the clock in running time of the last
   * buffer that caused the element to generate the QOS event. A negative value
   * means that the buffer with @a timestamp arrived in time. A positive value
   * indicates how late the buffer with @a timestamp was. When throttling is
   * enabled, @a diff will be set to the requested throttling interval.
   * 
   *  @a timestamp is the timestamp of the last buffer that cause the element
   * to generate the QOS event. It is expressed in running time and thus an ever
   * increasing value.
   * 
   * The upstream element can use the @a diff and @a timestamp values to decide
   * whether to process more buffers. For positive @a diff, all buffers with
   * timestamp <= @a timestamp + @a diff will certainly arrive late in the sink
   * as well. A (negative) @a diff value so that @a timestamp + @a diff would yield a
   * result smaller than 0 is not allowed.
   * 
   * The application can use general event probes to intercept the QoS
   * event and implement custom application specific QoS handling.
   * 
   * @param type The QoS type.
   * @param proportion The proportion of the qos message.
   * @param diff The time difference of the last Clock sync.
   * @param timestamp The timestamp of the buffer.
   * @return A new QOS event.
   */
  static Glib::RefPtr<Gst::EventQos> create(QOSType type, double proportion, Gst::ClockTimeDiff diff, Gst::ClockTime timestamp);

 /**
  * Gets the type, proportion, diff and timestamp from the qos event. 
  *
  * @param type A pointer to store the QoS type in.
  * @param proportion A pointer to store the proportion in.
  * @param diff A pointer to store the diff in.
  * @param timestamp A pointer to store the timestamp in.
  */
  void parse(QOSType& type, double& proportion, Gst::ClockTimeDiff& diff, Gst::ClockTime& timestamp) const;
  

  /** Get the QoS type. See create() for more information
   * about the different QoS values.
   *
   * @return The QoS type.
   */
  QOSType parse_type() const;

  /** Get the proportion in the qos event. See create() for more information
   * about the different QoS values.
   *
   * @return The proportion.
   */
  double parse_proportion() const;

  /** Get the diff in the qos event. See create() for more information about
   * the different QoS values.
   *
   * @return The difference.
   */
  Gst::ClockTimeDiff parse_diff() const;

  /** Get the timestamp in the qos event. See create() for more information
   * about the different QoS values.
   * @return The timestamp.
   */
  Gst::ClockTime parse_timestamp() const;


};

/** A seek event.  See create() for more details.
 */
class EventSeek : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventSeek;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Allocate a new seek event with the given parameters.
   * 
   * The seek event configures playback of the pipeline between @a start to @a stop
   * at the speed given in @a rate, also called a playback segment.
   * The @a start and @a stop values are expressed in @a format.
   * 
   * A @a rate of 1.0 means normal playback rate, 2.0 means double speed.
   * Negatives values means backwards playback. A value of 0.0 for the
   * rate is not allowed and should be accomplished instead by PAUSING the
   * pipeline.
   * 
   * A pipeline has a default playback segment configured with a start
   * position of 0, a stop position of -1 and a rate of 1.0. The currently
   * configured playback segment can be queried with Gst::QUERY_SEGMENT. 
   * 
   *  @a start_type and @a stop_type specify how to adjust the currently configured 
   * start and stop fields in playback segment. Adjustments can be made relative
   * or absolute to the last configured values. A type of Gst::SEEK_TYPE_NONE
   * means that the position should not be updated.
   * 
   * When the rate is positive and @a start has been updated, playback will start
   * from the newly configured start position. 
   * 
   * For negative rates, playback will start from the newly configured stop
   * position (if any). If the stop position is updated, it must be different from
   * -1 (Gst::CLOCK_TIME_NONE) for negative rates.
   * 
   * It is not possible to seek relative to the current playback position, to do
   * this, PAUSE the pipeline, query the current playback position with
   * Gst::QUERY_POSITION and update the playback segment current position with a
   * Gst::SEEK_TYPE_SET to the desired position.
   * 
   * @param rate The new playback rate.
   * @param format The format of the seek values.
   * @param flags The optional seek flags.
   * @param start_type The type and flags for the new start position.
   * @param start The value of the new start position.
   * @param stop_type The type and flags for the new stop position.
   * @param stop The value of the new stop position.
   * @return A new seek event.
   */
  static Glib::RefPtr<Gst::EventSeek> create(double rate, Format format, SeekFlags flags, SeekType start_type, gint64 start, SeekType stop_type, gint64 stop);

  /** Parses a seek event and stores the results in the given result locations.
   *
   * @param rate Result location for the rate.
   * @param format Result location for the stream format.
   * @param flags Result location for the Gst::SeekFlags.
   * @param start_type Result location for the Gst::SeekType of the start
   * position.
   * @param start Result location for the start postion expressed in format.
   * @param stop_type Result location for the Gst::SeekType of the stop
   * position.
   * @param stop Result location for the stop postion expressed in format.
   */
  void parse(double& rate, Format& format, SeekFlags& flags,
    SeekType& start_type, gint64& start, SeekType& stop_type,
    gint64& stop) const;
  

  /** Parses the start of a seek event.
   * @return The start.
   */
  gint64 parse_start() const;

  /** Parses the rate of a seek event.
   * @return The rate.
   */
  double parse_rate() const;

  /** Parses the format of a seek event.
   * @return The format.
   */
  Format parse_format() const;

  /** Parses the flags of a seek event.
   * @return The flags.
   */
  SeekFlags parse_flags() const;

  /** Parses the start type of a seek event.
   * @return The start type.
   */
  SeekType parse_start_type() const;

  /** Parses the stop type of a seek event.
   * @return The stop type.
   */
  SeekType parse_stop_type() const;

  /** Parses the stop of a seek event.
   * @return The stop.
   */
  gint64 parse_stop() const;


};

/** A latency event.  See create() for more details.
 */
class EventLatency : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventLatency;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new latency event. The event is sent upstream from the sinks and
   * notifies elements that they should add an additional @a latency to the
   * running time before synchronising against the clock.
   * 
   * The latency is mostly used in live sinks and is always expressed in
   * the time format.
   * 
   * @param latency The new latency value.
   * @return A new Gst::Event.
   */
  static Glib::RefPtr<Gst::EventLatency> create(Gst::ClockTime latency);

  /** Get the latency in the latency event.
   *
   * @return The latency.
   */
  Gst::ClockTime parse_latency() const;
  

};

/** A step event.  See create() for more details.
 */
class EventStep : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventStep;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new step event. The purpose of the step event is to instruct a sink
   * to skip @a amount (expressed in @a format) of media. It can be used to implement
   * stepping through the video frame by frame or for doing fast trick modes.
   * 
   * A rate of <= 0.0 is not allowed. Pause the pipeline, for the effect of rate
   * = 0.0 or first reverse the direction of playback using a seek event to get
   * the same effect as rate < 0.0.
   * 
   * The @a flush flag will clear any pending data in the pipeline before starting
   * the step operation.
   * 
   * The @a intermediate flag instructs the pipeline that this step operation is
   * part of a larger step operation.
   * 
   * @param format The format of @a amount.
   * @param amount The amount of data to step.
   * @param rate The step rate.
   * @param flush Flushing steps.
   * @param intermediate Intermediate steps.
   * @return A new Gst::Event.
   */
  static Glib::RefPtr<Gst::EventStep> create(Gst::Format format, guint64 amount, double rate, bool flush, bool intermediate);

  /** Parse the step event.
   *
   * @param format A reference to store the format in.
   * @param amount A reference to store the amount in.
   * @param rate A reference to store the rate in.
   * @param flush A reference to store the flush boolean in.
   * @param intermediate A reference to store the intermediate boolean in.
   */
  void parse(Gst::Format& format, guint64& amount, double& rate,
    bool& flush, bool& intermediate) const;
  

  /** Get the amount in a step event.
   * @return The amount.
   */
  guint64 parse_amount() const;

  /** Get the format in a step event.
   * @return The format.
   */
  Gst::Format parse_format() const;

  /** Get the rate in a step event.
   * @return The rate.
   */
  double parse_rate() const;

  /** Get the flush in a step event.
   * @return The flush flag.
   */
  bool parse_flush() const;

  /** Get the intermediate flag in a step event.
   * @return The intermediate flag.
   */
  bool parse_intermediate() const;


};

/** A reconfigure event.  See create() for more details.
 */
class EventReconfigure : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventReconfigure;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Create a new reconfigure event. The purpose of the reconfigure event is
   * to travel upstream and make elements renegotiate their caps or reconfigure
   * their buffer pools. This is useful when changing properties on elements
   * or changing the topology of the pipeline.
   * 
   * @return A new Gst::Event.
   */
  static Glib::RefPtr<Gst::EventReconfigure> create();


};

/** A toc select event. See create() for more details.
 */
class EventTocSelect : public Event
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  using CppObjectType = EventTocSelect;
  using BaseObjectType = GstEvent;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
 

  /** Generate a TOC select event with the given @a uid. The purpose of the
   * TOC select event is to start playback based on the TOC's entry with the
   * given @a uid.
   * 
   * @param uid UID in the TOC to start playback from.
   * @return A new Gst::Event.
   */
  static Glib::RefPtr<Gst::EventTocSelect> create(const Glib::ustring& uid);

  /** Parse the UID in a toc select event.
   * @return The UID.
   */
  Glib::ustring parse_uid() const;
  

};

} //namespace Gst


namespace Glib
{

  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Event
   */
  Glib::RefPtr<Gst::Event> wrap(GstEvent* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_EVENT_H */

