/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#include <bonobo.h>
#include <gdk-pixbuf/gdk-pixbuf-loader.h>
#include "image-viewer.h"
#include "ui.h"
#include "viewer-control.h"

#define BUFFER_SIZE (16*1024)


void 
load_stream (BonoboPersistStream *ps,
	     Bonobo_Stream stream,
	     Bonobo_Persist_ContentType type,
	     gpointer callback_data,
	     CORBA_Environment *ev)
{
	ViewerControl *control = callback_data;
	GdkPixbufLoader *loader;
	Bonobo_Stream_iobuf *buffer;
	gint length;

	/* load from stream */

	loader = gdk_pixbuf_loader_new ();
	do {
		Bonobo_Stream_read (stream, BUFFER_SIZE, &buffer, ev);
		if (ev->_major != CORBA_NO_EXCEPTION) {
			CORBA_exception_set (ev, 
					     CORBA_USER_EXCEPTION,
					     ex_Bonobo_IOError, 
					     NULL);
			gdk_pixbuf_loader_close (loader);
			gtk_object_unref (GTK_OBJECT (loader));
			return;
		}

		length = buffer->_length;

		if ((length > 0) && 
		    !gdk_pixbuf_loader_write (loader, 
					      buffer->_buffer, 
					      length)) {
			CORBA_exception_set (ev, 
					     CORBA_USER_EXCEPTION,
					     ex_Bonobo_Persist_WrongDataType,
					     NULL);
			CORBA_free (buffer);
			gdk_pixbuf_loader_close (loader);
			gtk_object_unref (GTK_OBJECT (loader));
			return;
		}
		CORBA_free (buffer);
	} while (length > 0);
	
	gdk_pixbuf_loader_close (loader);
	image_viewer_load_from_pixbuf_loader (control->viewer, loader);
	gtk_object_unref (GTK_OBJECT (loader));

	update_menu_sensitivity (control); 
}


Bonobo_Persist_ContentTypeList * 
get_supported_types (BonoboPersistStream *ps,
		     gpointer data,
		     CORBA_Environment *ev)
{
	 return bonobo_persist_generate_content_types (
		 14, 
		 "image/jpeg",
		 "image/gif",
		 "image/png",
		 "image/tiff",
		 "image/x-bmp",
		 "image/x-cmu-raster",
		 "image/x-ico",
		 "image/x-png",
		 "image/x-portable-anymap",
		 "image/x-portable-bitmap",
		 "image/x-portable-graymap",
		 "image/x-portable-pixmap",
		 "image/x-xpixmap",
		 "image/xpm");
}
