/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef CATALOG_PNG_EXPORTER_H
#define CATALOG_PNG_EXPORTER_H


#include <glib.h>
#include <gdk/gdk.h>
#include <libgnomevfs/gnome-vfs-types.h>
#include "thumb-loader.h"
#include "typedefs.h"


#define CATALOG_PNG_EXPORTER_TYPE        catalog_png_exporter_get_type()
#define CATALOG_PNG_EXPORTER(o)          (GTK_CHECK_CAST ((o), CATALOG_PNG_EXPORTER_TYPE, CatalogPngExporter))
#define CATALOG_PNG_EXPORTER_CLASS(k)    (GTK_CHECK_CLASS_CAST ((k), CATALOG_PNG_EXPORTER_TYPE,  CatalogPngExporterClass))
#define IS_CATALOG_PNG_EXPORTER(o)       (GTK_CHECK_TYPE ((o), CATALOG_PNG_EXPORTER_TYPE))
#define IS_CATALOG_PNG_EXPORTER_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), CATALOG_PNG_EXPORTER_TYPE))


typedef struct _CatalogPngExporter       CatalogPngExporter;
typedef struct _CatalogPngExporterClass  CatalogPngExporterClass;


typedef enum {
	CAPTION_COMMENT    = 1 << 0,
	CAPTION_FILE_PATH  = 1 << 1,
	CAPTION_FILE_NAME  = 1 << 2,
	CAPTION_FILE_SIZE  = 1 << 3,
	CAPTION_IMAGE_DIM  = 1 << 4
} CaptionFields;


typedef enum {
	FRAME_STYLE_NONE   = 1 << 0,
	FRAME_STYLE_SLIDE  = 1 << 1,
	FRAME_STYLE_SIMPLE = 1 << 2,
	FRAME_STYLE_SHADOW = 1 << 3
} FrameStyle;


struct _CatalogPngExporter {
	GtkObject __parent;

	/* -- private -- */

	GList *       file_list;              /* gchar* elements. */

	int           thumb_width;
	int           thumb_height;
	int           frame_width;
	int           frame_height;
	int           page_width;             
	int           page_height;
	int           page_rows;              /* Number of rows and columns
	 				       * each page must have. */
	int           page_cols;
	gboolean      page_size_use_row_col;  /* Set the page size from the
					       * number of rows and columns. */
	int *         pages_height;           /* Array containing the height 
					       * of the pages if the user 
					       * specify the size of the page 
					       * by the number of rows and 
					       * columns. */

	gchar *       directory;              /* Save files in this 
					       * directory. */
	gchar *       filename1;              /* Files will be named this way:
					       * filename1NNNfilename2.png
					       * where NNN is the file 
					       * number. */ 
	gchar *       filename2;

	guint8        caption_fields;
	char *        text_font;
	GdkColor      page_color;
	GdkColor      frame_color;
	GdkColor      text_color;
	FrameStyle    frame_style;
	SortMethod    sort_method;
	GtkSortType   sort_type;
	
	gboolean      write_image_map;

	/* -- very private data -- */

	ThumbLoader * tloader;
	GList *       file_to_load;          /* Next file to be loaded. */

	gint          n_images;              /* Used for the progress signal.*/
	gint          n_images_done;

	GdkPixmap *   pixmap;
	GdkGC *       gc;
	GdkFont *     font;
	GdkColor      white;
	GdkColor      black;
	GdkColor      gray;
	GdkColor      dark_gray;

	GnomeVFSHandle *imap_handle;         /* handle to write image map 
					      * files. */
};


struct _CatalogPngExporterClass {
	GtkObjectClass __parent;

	/* -- signals -- */
	
	void (*done)             (CatalogPngExporter *ce);

	void (*progress)         (CatalogPngExporter *ce,
				  gfloat percent);
};


GtkType    catalog_png_exporter_get_type              (void);

void       catalog_png_exporter_construct             (CatalogPngExporter *ce,
						       GList *file_list);

CatalogPngExporter *  catalog_png_exporter_new        (GList *file_list);

void       catalog_png_exporter_set_directory         (CatalogPngExporter *ce,
						       char *directory);

void       catalog_png_exporter_set_name              (CatalogPngExporter *ce,
						       char *filename1,
						       char *filename2);

void       catalog_png_exporter_set_page_size         (CatalogPngExporter *ce,
						       int width,
						       int height);

void       catalog_png_exporter_set_page_size_row_col (CatalogPngExporter *ce,
						       int rows,
						       int cols);

void       catalog_png_exporter_set_thumb_size        (CatalogPngExporter *ce,
						       int width,
						       int height);

void       catalog_png_exporter_set_text_font         (CatalogPngExporter *ce,
						       char *text_font);

void       catalog_png_exporter_set_page_color        (CatalogPngExporter *ce,
						       gushort r,
						       gushort g,
						       gushort b);

void       catalog_png_exporter_set_text_color        (CatalogPngExporter *ce,
						       gushort r,
						       gushort g,
						       gushort b);

void       catalog_png_exporter_set_frame_color       (CatalogPngExporter *ce,
						       gushort r,
						       gushort g,
						       gushort b);

void       catalog_png_exporter_set_caption           (CatalogPngExporter *ce,
						       CaptionFields caption);

void       catalog_png_exporter_set_frame_style       (CatalogPngExporter *ce,
						       FrameStyle style);

void       catalog_png_exporter_write_image_map       (CatalogPngExporter *ce,
						       gboolean do_write);

void       catalog_png_exporter_set_sort_method       (CatalogPngExporter *ce,
						       SortMethod method);

/* how to sort: ascending or discending. */
void       catalog_png_exporter_set_sort_type         (CatalogPngExporter *ce,
						       GtkSortType sort_type);

void       catalog_png_exporter_export                (CatalogPngExporter *ce);


#endif /* CATALOG_PNG_EXPORTER_H */
