/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef THUMB_LOADER_H
#define THUMB_LOADER_H


#include <gdk-pixbuf/gdk-pixbuf.h>
#include <libgnomevfs/gnome-vfs-types.h>
#include "image-loader.h"


#define THUMB_LOADER_TYPE        thumb_loader_get_type ()
#define THUMB_LOADER(o)          GTK_CHECK_CAST (o, THUMB_LOADER_TYPE, ThumbLoader)
#define THUMB_LOADER_CLASS(k)    GTK_CHECK_CLASS_CAST (k, THUMB_LOADER_TYPE, ThumbLoaderClass)
#define IS_THUMB_LOADER(o)       GTK_CHECK_TYPE (o, THUMB_LOADER_TYPE)


typedef struct _ThumbLoader       ThumbLoader;
typedef struct _ThumbLoaderClass  ThumbLoaderClass;


struct _ThumbLoader 
{
	GtkObject  __parent;
	gpointer   priv;
};


struct _ThumbLoaderClass
{
	GtkObjectClass __parent_class;

	/* -- Signals -- */

	void (* error)       (ThumbLoader *il);

	void (* done)        (ThumbLoader *il);

	void (* progress)    (ThumbLoader *il, 
			      gfloat percent);
};


GtkType        thumb_loader_get_type           (void);

GtkObject *    thumb_loader_new                (const gchar *path, 
						gint width, 
						gint height);

/* whether to load from and save to cache. */
void           thumb_loader_use_cache          (ThumbLoader *tl,
						gboolean use);

void           thumb_loader_set_path           (ThumbLoader *tl,
						const gchar *path);

gchar *        thumb_loader_get_path           (ThumbLoader *tl);

void           thumb_loader_set_uri            (ThumbLoader *tl,
						const GnomeVFSURI *uri);

GnomeVFSURI *  thumb_loader_get_uri            (ThumbLoader *tl);

GdkPixbuf *    thumb_loader_get_pixbuf         (ThumbLoader *tl);

ImageLoader *  thumb_loader_get_image_loader   (ThumbLoader *tl);

void           thumb_loader_start              (ThumbLoader *tl);

void           thumb_loader_stop               (ThumbLoader *tl);

gint           thumb_from_xpm_d                (const char **data, 
						gint max_w, 
						gint max_h, 
						GdkPixmap **pixmap, 
						GdkBitmap **mask);

#endif /* THUMB_LOADER_H */
