/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef MENU_CALLBACKS_H
#define MENU_CALLBACKS_H

/* file menu callbacks. */

void   new_window_cb                  (GtkWidget *widget, 
				       void *data);

void   add_bookmark_cb                (GtkWidget *widget, 
				       void *data);

void   delete_history_cb              (GtkWidget *widget, 
				       void *data);

void   close_cb                       (GtkWidget *widget, 
				       void *data);

void   quit_cb                        (GtkWidget *widget, 
				       void *data);

void   export_as_image_cb             (GtkWidget *widget, 
				       void *data);

/* edit menu callbacks. */

void   rotate_cb                      (GtkWidget *widget, 
				       void *data);

void   rotate_180_cb                  (GtkWidget *widget, 
				       void *data);

void   flip_cb                        (GtkWidget *widget, 
				       void *data);

void   mirror_cb                      (GtkWidget *widget, 
				       void *data);

void   rename_cb                      (GtkWidget *widget, 
				       void *data);

void   copy_cb                        (GtkWidget *widget, 
				       void *data);

void   move_cb                        (GtkWidget *widget, 
				       void *data);

void   delete_cb                      (GtkWidget *widget, 
				       void *data);

void   select_all_cb                  (GtkWidget *widget, 
				       void *data);

void   delete_comment_cb              (GtkWidget *widget, 
				       void *data);

void   add_to_catalog_cb              (GtkWidget *widget, 
				       void *data);

void   remove_from_catalog_cb         (GtkWidget *widget, 
				       void *data);

/* tools menu */

void   slideshow_cb                   (GtkWidget *widget, 
				       void *data);

void   remove_old_thumbnails_cb       (GtkWidget *widget, 
				       void *data);

void   remove_old_comments_cb         (GtkWidget *widget, 
				       void *data);

void   set_as_wallpaper_centered_cb   (GtkWidget *widget, 
				       void *data);

void   set_as_wallpaper_tiled_cb      (GtkWidget *widget, 
				       void *data);

void   set_as_wallpaper_scaled_cb     (GtkWidget *widget, 
				       void *data);

void   set_as_wallpaper_stretched_cb  (GtkWidget *widget, 
				       void *data);

void   restore_wallpaper_cb           (GtkWidget *widget, 
				       void *data);

void   preferences_cb                 (GtkWidget *widget, 
				       void *data);


/* view menu callbacks. */

void   fullscreen_cb                  (GtkWidget *widget, 
				       void *data);

void   browser_cb                     (GtkWidget *widget,
				       void *data);

void   dir_browser_cb                 (GtkWidget *widget,
				       void *data);

void   catalog_browser_cb             (GtkWidget *widget,
				       void *data);

void   toggle_animation_cb            (GtkWidget *widget, 
				       void *data);

void   step_animation_cb              (GtkWidget *widget, 
				       void *data);

void   refresh_cb                     (GtkWidget *widget, 
				       void *data);

void   sort_by_name_cb                (GtkWidget *widget, 
				       void *data);

void   sort_by_size_cb                (GtkWidget *widget, 
				       void *data);

void   sort_by_time_cb                (GtkWidget *widget, 
				       void *data);

void   sort_by_path_cb                (GtkWidget *widget, 
				       void *data);

void   reversed_order_cb              (GtkWidget *widget, 
				       void *data);

void   thumbnails_cb                  (GtkWidget *widget, 
				       void *data);

void   trans_white_cb                 (GtkWidget *widget, 
				       void *data);
void   trans_gray_cb                  (GtkWidget *widget, 
				       void *data);
void   trans_black_cb                 (GtkWidget *widget, 
				       void *data);
void   trans_checked_cb               (GtkWidget *widget, 
				       void *data);

/* bookmarks menu. */

void   edit_bookmarks_cb              (GtkWidget *widget, 
				       void *data);


/* help menu callbacks. */

void   about_cb                       (GtkWidget *widget, 
				       void *data);

/* toolbar specific callbacks. */

void   go_up_cb                       (GtkWidget *widget,
				       void *data);

void   go_home_cb                     (GtkWidget *widget,
				       void *data);

void   zoom_in_cb                     (GtkWidget *widget,
				       void *data);

void   zoom_out_cb                    (GtkWidget *widget,
				       void *data);

void   zoom_to_fit_cb                 (GtkWidget *widget,
				       void *data);

void   no_zoom_cb                     (GtkWidget *widget,
				       void *data);

void   high_quality_zoom_cb           (GtkWidget *widget,
				       void *data);

void   low_quality_zoom_cb            (GtkWidget *widget,
				       void *data);


#endif /* MENU_CALLBACKS_H */
