/*
 * $Id: hsep.h,v 1.1 2004/08/25 05:40:39 rmanfredi Exp $
 *
 * Copyright (c) 2004, Raphael Manfredi
 *
 *----------------------------------------------------------------------
 * This file is part of gtk-gnutella.
 *
 *  gtk-gnutella is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  gtk-gnutella is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with gtk-gnutella; if not, write to the Free Software
 *  Foundation, Inc.:
 *      59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *----------------------------------------------------------------------
 */

#ifndef _if_core_hsep_h_
#define _if_core_hsep_h_

#include <glib.h>

#include "lib/event.h"			/* For frequency_t */

typedef guint64 hsep_triple[3];

#define HSEP_N_MAX 7		/* number of hops to consider */

enum {
	HSEP_IDX_NODES = 0,
	HSEP_IDX_FILES = 1,
	HSEP_IDX_KIB = 2
};

/*
 * Public interface, visible from the bridge.
 */

#ifdef CORE_SOURCES

const gchar *hsep_get_static_str(gint row, gint column);
gint hsep_get_table_size(void);
void hsep_get_non_hsep_triple(hsep_triple *tripledest);
void hsep_add_global_table_listener(GCallback cb,
	frequency_t type, guint32 interval);
void hsep_remove_global_table_listener(GCallback cb);

#endif /* CORE_SOURCES */
#endif /* _if_core_hsep_h */

/* vi: set ts=4 sw=4 cindent: */
