/*
 * GUI actions module header
 * Basically, actions are invoked via menubar, right-click menu or toolbar.
 * Their callback routines internally calls the routines in this module.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GDIFF_ACTIONS_H__
#define __GDIFF_ACTIONS_H__

#include "properties.h"

#ifdef __cplusplus 
extern "C" {
#endif /* __cplusplus */

/* Global function declarations */
extern void act_close_view(GtkWidget *view);
extern void act_reload(GtkWidget *view);

/* Actions for directory view */
extern void act_dv_show_path(GtkWidget *dirview, ShowPathDView show_path);
extern void act_dv_rowhide_func(GtkWidget *dirview, RowHideMask rh_mask, gboolean mask_on);
extern void act_dv_rowhide_stat(GtkWidget *dirview, FilesStatus hide_mask, gboolean mask_on);
extern void act_dv_checksum(GtkWidget *dirview);

/* Actions for file view */
extern void act_fv_mode_change(GtkWidget *fview, ViewType vtype);
extern void act_fv_show_linenum(GtkWidget *fview, gboolean to_show);
extern void act_fv_highlight(GtkWidget *fview, gboolean to_highlight);
extern void act_fv_show_fill(GtkWidget *fview, gboolean to_show);
extern void act_fv_go_dirview(GtkWidget *fview);
extern void act_fv_toggle_textwrap(GtkWidget *fview);
extern void act_fv_move_diff(GtkWidget *fview, MoveDiff mv_diff);
extern void act_fv_edit_file(GtkWidget *fview, const char *filename);

/* Actions for merge view */
extern void act_merge_insert_remove_all(GtkWidget *mergeview, WhichFile whichfile, gboolean to_insert);
extern void act_merge_insert_remove(GtkWidget *mergeview, WhichFile whichfile, gboolean to_insert);
extern void act_merge_output_file(GtkWidget *mergeview);

	
#ifdef __cplusplus
} 
#endif /* __cplusplus */
 
#endif /* __GDIFF_ACTIONS_H__ */
