/* mimic.c
 * Written by David Allen
 * <s2mdalle@titan.vcu.edu>
 * http://opop.nols.com/
 *
 * This builds in a few things to somewhat fake gnome looks.  I'm not going
 * to be using gnome for GTKeyboard anytime soon because of compatibility
 * issues with some users.  This may end up being a ridiculous failure of an
 * attempt, but hey, that's life.
 */
/* GTKeyboard - A Graphical Keyboard For X
 * Copyright (C) 1999, 2000 David Allen  
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

#define MIMIC_C

#ifndef MASTER_H
#  include "master.h"
#endif /* MASTER_H */
#ifndef MIMIC_H 
#  include "include/mimic.h"
#endif /* MIMIC_H */

GtkWidget *create_cancel_button_with_signal(GtkSignalFunc function, 
					    gpointer func_data)
{
     GtkWidget *button = gtk_button_new();
     GtkWidget *label  = gtk_label_new("  Cancel  ");
     GtkWidget *hbox   = gtk_hbox_new(FALSE, MIMIC_PADDING);
     GtkWidget *pixmap = xpm_to_widget(window, (gchar **)xpm_GCANCEL);
     
     gtk_box_pack_start(GTK_BOX(hbox), pixmap, FALSE, FALSE, 0);
     gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, FALSE, 0);

     gtk_container_add(GTK_CONTAINER(button), hbox);

     gtk_signal_connect(GTK_OBJECT(button), "clicked",
			function, func_data);

     gtk_box_set_homogeneous(GTK_BOX(hbox), TRUE);
     gtk_box_set_child_packing(GTK_BOX(hbox), pixmap, TRUE, TRUE, TRUE,
			       GTK_PACK_START);
     gtk_box_set_child_packing(GTK_BOX(hbox), label, TRUE, TRUE, TRUE,
			       GTK_PACK_END);

     gtk_widget_show_all(button);
     return(button);
} /* End create_cancel_button_with_signal() */

/* Create a purty xpm enhanced cancel button */
GtkWidget *create_cancel_button(GtkWidget *todestroy)
{
     GtkWidget *button = gtk_button_new();
     GtkWidget *label = gtk_label_new(" Cancel ");
     GtkWidget *pixmap = xpm_to_widget(todestroy, (gchar **)xpm_GCANCEL);
     GtkWidget *hbox = gtk_hbox_new(FALSE, MIMIC_PADDING);
     
     gtk_signal_connect(GTK_OBJECT(button), "clicked", 
			GTK_SIGNAL_FUNC(smack), todestroy);

     gtk_box_pack_start(GTK_BOX(hbox), pixmap, FALSE, FALSE, 0);
     gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, FALSE, 0);
     gtk_container_add(GTK_CONTAINER(button), hbox);

     gtk_box_set_homogeneous(GTK_BOX(hbox), FALSE);
     gtk_box_set_child_packing(GTK_BOX(hbox), pixmap, TRUE, TRUE, TRUE,
			       GTK_PACK_START);
     gtk_box_set_child_packing(GTK_BOX(hbox), label, TRUE, TRUE, TRUE,
			       GTK_PACK_END);

     gtk_widget_show_all(button);
     return(button);
} /* End create_cancel_button */

/* Creates an OK button with the standard text in it
 * as well as adding a purty pixmap.  :)
 * 
 * Arguments are the function and the data you want executed when
 * the button gets clicked 
 */
GtkWidget *create_ok_button(GtkSignalFunc function, gpointer func_data)
{
     GtkWidget *button = gtk_button_new();
     GtkWidget *label  = gtk_label_new("   OK   ");
     GtkWidget *hbox   = gtk_hbox_new(FALSE, MIMIC_PADDING);
     GtkWidget *pixmap = xpm_to_widget(window, (gchar **)xpm_GOK);
     
     gtk_box_pack_start(GTK_BOX(hbox), pixmap, FALSE, FALSE, 0);
     gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, FALSE, 0);

     gtk_container_add(GTK_CONTAINER(button), hbox);

     gtk_signal_connect(GTK_OBJECT(button), "clicked",
			function, func_data);

     gtk_box_set_homogeneous(GTK_BOX(hbox), FALSE);

     gtk_box_set_child_packing(GTK_BOX(hbox), pixmap, TRUE, TRUE, TRUE,
			       GTK_PACK_START);
     gtk_box_set_child_packing(GTK_BOX(hbox), label, TRUE, TRUE, TRUE,
			       GTK_PACK_END);

     /* GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT); */
     /* gtk_widget_grab_default(button); */

     gtk_widget_show_all(button);
     return(button);
} /* End create_ok_button */



