/* gtkfind.h */
/* globals, prototypes, and macros for gtkfind */

/*
  gtkfind - a graphical "find" program
  Copyright (C) 1999  Matthew Grossman <mattg@oz.net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
  
#ifndef GTKFIND_H
#define GTKFIND_H

/*********************/
/* includes          */

#include"config.h"

#include<stdlib.h>
#include<sys/param.h>
#include<sys/types.h>

#if defined(HAVE_DIRENT_H)
#include<dirent.h>
#endif
#if defined(HAVE_NDIR_H)
#include<ndir.h>
#endif
#if defined(HAVE_SYS_DIR_H)
#include<sys/dir.h>
#endif
#if defined(HAVE_SYS_NDIR_H)
#include<sys/ndir.h>
#endif

/* report that SGI and Solaris need this */
#ifdef HAVE_ALLOCA_H
#include<alloca.h>
#endif /* HAVE_ALLOCA_H */

#include<sys/stat.h>

#ifdef HAVE_UNISTD_H
#include<unistd.h>
#endif

#include<grp.h>
#include<pwd.h>
#include<time.h>
#ifdef TM_IN_SYS_TIME
#include<sys/time.h>
#endif

#include<ctype.h>
#include<string.h>

#include<errno.h>

/* for "major" and "minor" macros */
#if defined MAJOR_IN_MKDEV
#include<mkdev.h>
#elif defined MAJOR_IN_SYSMACROS
#include<sys/sysmacros.h>
#endif

#include<stdarg.h> /* for print_error */

#include<gtk/gtk.h>

#include"flags.h"
#include"util.h"
#include"create.h"

/*********************/
/* globals           */

GtkWidget *output_toplevel;
GtkWidget *output_text;
static time_t global_atime;
static time_t global_ctime;
static time_t global_mtime;


/*********************/
/* externs           */

/* variables */

extern GtkWidget *toplevel;

extern GtkWidget *directory; /* the directory to search in */

extern GtkWidget *pattern;  /* the file pattern to search for */
extern GtkWidget *content_pattern;

extern GtkWidget *shell_command; /* if we run a shell command, this is it */

extern GtkWidget *login_entry;
extern GtkWidget *group_entry;

extern GtkWidget *atime_month_spin, *atime_day_spin, *atime_year_spin,
  *atime_hour_spin, *atime_minute_spin, *atime_second_spin;
extern GtkWidget *mtime_month_spin, *mtime_day_spin, *mtime_year_spin,
  *mtime_hour_spin, *mtime_minute_spin, *mtime_second_spin;
extern GtkWidget *ctime_month_spin, *ctime_day_spin, *ctime_year_spin,
  *ctime_hour_spin, *ctime_minute_spin, *ctime_second_spin;

extern GtkWidget *stop_button;
extern int stop_flag;

/* functions */

/* widgets.h */
extern void make_widgets();

/* glob.h */
extern char **glob_string(char *pattern, char *string, int copy_stringp);
extern void free_glob_registers(char **registers);
extern char **allocate_glob_registers();

/* gtk_print1.h */
extern void gtk_print1(gchar *str);

/*********************/
/* prototypes        */


void quit(gpointer *quit_button);
void find(gpointer *find_button, gpointer *pattern);
void find_and_print(char *dir_name, char *text,
		    char *content_string, int recursep);

void set_globals();

int execute_shell_command(char **registers, char *full_file_name,
			  struct stat sbuf);
char *substitute_filename(char *target, char **registers);

char *get_search_directory(GtkWidget *directory);

int match_type(unsigned short mode);
int match_mode(unsigned short mode);
int set_uid_and_gid();
int match_owner(struct stat sbuf);

void reset_window_output_text();
void output_toplevel_delete();
void make_output_window();
void print_to_window(char *text);
void save_output_callback();
void save_output_cancel(GtkWidget *w, GtkFileSelection *filesel);
void save_output_ok(GtkWidget *w, GtkFileSelection *filesel);

int match_atime(time_t t);
int match_mtime(time_t t);
int match_ctime(time_t t);

time_t get_user_time(GtkWidget *month, GtkWidget *day, GtkWidget *year,
		     GtkWidget *hour, GtkWidget *minute, GtkWidget *second);

void set_find_to_abort(gpointer *find_button);
void reset_find_button(gpointer *find_button);

int sane_date_p(GtkWidget *month, GtkWidget *day, GtkWidget *year);
int set_global_dates();
char **match_filename(char *text, char *filename);
int match_contents(char *d_name, struct stat sbuf, char *content_string);

char *make_long_format(char *full_file_name, char *short_file_name,
		       struct stat sbuf);
void output_file_data(char *full_file_name, char *short_file_name,
		      struct stat sbuf);
void print_error(const char *format, ...);

#endif /* !GTKFIND_H */
