/* Gnometoaster's dialog routines */

#include <stdlib.h>
#include "config.h"
#ifdef HAVE_GNOME
#include <gnome.h>
#else
#include <gtk/gtk.h>
#endif

#include "int.h"
#include "dialog.h"

/* we need this for our common dialogs */
typedef struct
{
   dialog_replycallback cb;
   gpointer data;
   GtkWidget *dialog;
   GtkWidget *entry;
} dialog_question_info;

void dialog_question_callback_destroy(GtkWidget *w,dialog_question_info *info)
{
   gtk_widget_destroy(info->dialog);
   free(info);
};

void dialog_question_callback_yes(GtkWidget *w,dialog_question_info *info)
{
   info->cb(DIALOG_YES,info->data);
   gtk_widget_destroy(info->dialog);
   free(info);
};

void dialog_question_callback_no(GtkWidget *w,dialog_question_info *info)
{
   info->cb(DIALOG_NO,info->data);
   gtk_widget_destroy(info->dialog);
   free(info);
};

/* define message functions ourselves if gnome is not present */
#ifndef HAVE_GNOME

GtkWidget *dialog_ok(const gchar *msg)
{
   GtkWidget *dialog;
   GtkWidget *okbutton;
   GtkWidget *text;
   dialog_question_info *info;
   
   dialog=gtk_dialog_new();
   gtk_window_set_position(GTK_WINDOW(dialog),GTK_WIN_POS_CENTER);
      
   info=(dialog_question_info*)malloc(sizeof(dialog_question_info));
   info->dialog=dialog;
   
   text=gtk_label_new(msg);
   gtk_widget_show(text);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),text,TRUE,TRUE,0);
   
   okbutton=gtk_button_new_with_label(_("OK"));
   gtk_widget_show(okbutton);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		      okbutton,TRUE,TRUE,0);
   gtk_signal_connect(GTK_OBJECT(okbutton),"clicked",
		      GTK_SIGNAL_FUNC(dialog_question_callback_destroy),(gpointer)info);
   
   gtk_widget_show(dialog);
   return dialog;
};


GtkWidget *dialog_question(const gchar *msg,
			   dialog_replycallback callback,
			   gpointer data)
{
   GtkWidget *dialog;
   GtkWidget *yesbutton;
   GtkWidget *nobutton;
   GtkWidget *text;
   
   dialog_question_info *info;
   
   dialog=gtk_dialog_new();
   gtk_window_set_position(GTK_WINDOW(dialog),GTK_WIN_POS_CENTER);
   
   text=gtk_label_new(msg);
   gtk_widget_show(text);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),text,TRUE,TRUE,0);
   
   info=(dialog_question_info*)malloc(sizeof(dialog_question_info));
   info->cb=callback;
   info->data=data;
   info->dialog=dialog;
   
   yesbutton=gtk_button_new_with_label(_("YES"));
   gtk_widget_show(yesbutton);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		      yesbutton,TRUE,TRUE,0);
   gtk_signal_connect(GTK_OBJECT(yesbutton),"clicked",
		      GTK_SIGNAL_FUNC(dialog_question_callback_yes),info);

   nobutton=gtk_button_new_with_label(_("NO"));
   gtk_widget_show(nobutton);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		      nobutton,TRUE,TRUE,0);
   gtk_signal_connect(GTK_OBJECT(nobutton),"clicked",
		      GTK_SIGNAL_FUNC(dialog_question_callback_no),info);
   
   gtk_widget_show(dialog);
   return dialog;
};

void dialog_string_callback_ok(GtkWidget *w,dialog_question_info *info)
{
   info->cb((int)gtk_entry_get_text(GTK_ENTRY(info->entry)),
	    info->data);
   gtk_widget_destroy(info->dialog);
   free(info);
};

void dialog_string_callback_cancel(GtkWidget *w,dialog_question_info *info)
{
   info->cb((int)NULL,info->data);
   gtk_widget_destroy(info->dialog);
   free(info);
};

GtkWidget *dialog_string(const gchar *prompt,
			 const gchar *defaulttext,
			 int maxlength,			 
			 dialog_stringcallback callback,
			 gpointer data)
{
   GtkWidget *dialog;
   GtkWidget *okbutton;
   GtkWidget *cancelbutton;
   GtkWidget *text;
   
   dialog_question_info *info;
   
   dialog=gtk_dialog_new();
   gtk_window_set_position(GTK_WINDOW(dialog),GTK_WIN_POS_CENTER);
   
   text=gtk_label_new(prompt);
   gtk_widget_show(text);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),text,TRUE,TRUE,0);
   
   text=gtk_entry_new();
   gtk_entry_set_text(GTK_ENTRY(text),defaulttext);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),text,TRUE,TRUE,0);
   gtk_widget_show(text);   
      
   info=(dialog_question_info*)malloc(sizeof(dialog_question_info));
   info->cb=(dialog_replycallback)callback;
   info->data=data;
   info->dialog=dialog;
   info->entry=text;
   
   okbutton=gtk_button_new_with_label(_("OK"));
   gtk_widget_show(okbutton);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		      okbutton,TRUE,TRUE,0);
   gtk_signal_connect(GTK_OBJECT(okbutton),"clicked",
		      GTK_SIGNAL_FUNC(dialog_string_callback_ok),info);

   cancelbutton=gtk_button_new_with_label(_("Cancel"));
   gtk_widget_show(cancelbutton);
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
		      cancelbutton,TRUE,TRUE,0);
   gtk_signal_connect(GTK_OBJECT(cancelbutton),"clicked",
		      GTK_SIGNAL_FUNC(dialog_string_callback_cancel),info);
   
   gtk_widget_show(dialog);
   return dialog;
};

#endif

GtkWidget *dialog_showuserwidget(gchar *title,				 
				 GtkWidget *w,
				 int type,
				 dialog_replycallback callback,
				 gpointer data)
{
   GtkWidget *dialog;
   GtkWidget *yesbutton;
   GtkWidget *nobutton;
   
   dialog_question_info *info;
   
   dialog=gtk_dialog_new();
   
   gtk_window_set_title(GTK_WINDOW(dialog),title);
   gtk_window_set_position(GTK_WINDOW(dialog),GTK_WIN_POS_CENTER);

   gtk_widget_show(w);
   
   gtk_window_set_modal(GTK_WINDOW(dialog),1);
   
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox),w,TRUE,TRUE,0);
   
   info=(dialog_question_info*)malloc(sizeof(dialog_question_info));
   info->cb=callback;
   info->data=data;
   info->dialog=dialog;

   if (type&(DIALOG_USERWIDGET_QUESTION|DIALOG_USERWIDGET_OKCANCEL))
     {
#ifdef HAVE_GNOME
	yesbutton=gnome_stock_button(GNOME_STOCK_BUTTON_OK);
#else
	yesbutton=gtk_button_new_with_label((type&DIALOG_USERWIDGET_QUESTION)?_("YES"):_("OK"));
#endif   
	gtk_widget_show(yesbutton);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
			   yesbutton,TRUE,TRUE,0);
	gtk_signal_connect(GTK_OBJECT(yesbutton),"clicked",
			   GTK_SIGNAL_FUNC(dialog_question_callback_yes),info);
	
#ifdef HAVE_GNOME   
	nobutton=gnome_stock_button((type&DIALOG_USERWIDGET_QUESTION)?GNOME_STOCK_BUTTON_NO:GNOME_STOCK_BUTTON_CANCEL);
#else
	nobutton=gtk_button_new_with_label((type&DIALOG_USERWIDGET_QUESTION)?_("NO"):_("CANCEL"));
#endif   
	gtk_widget_show(nobutton);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
			   nobutton,TRUE,TRUE,0);
	gtk_signal_connect(GTK_OBJECT(nobutton),"clicked",
			   GTK_SIGNAL_FUNC(dialog_question_callback_no),info);
     };
   if (type&DIALOG_USERWIDGET_OK)
     {
#ifdef HAVE_GNOME   
	nobutton=gnome_stock_button(GNOME_STOCK_BUTTON_OK);
#else
	nobutton=gtk_button_new_with_label(_("OK"));
#endif   
	gtk_widget_show(nobutton);
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),
			   nobutton,TRUE,TRUE,0);
	gtk_signal_connect(GTK_OBJECT(nobutton),"clicked",
			   GTK_SIGNAL_FUNC(dialog_question_callback_destroy),info);
     };
   
   gtk_widget_show(dialog);
   return dialog;
};
