/* this is the esd soundcard driver for gnometoaster */

/* could enlightenment be detected ? */
#include "config.h"
#ifdef HAVE_ESD

#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <esd.h>

#include "audio.h"
#include "piping.h"
#include "stdfiletrack.h"

#include "defaultentries.h"

int audio_esd_open(gpointer data)
{
   audio_driver *driver=(audio_driver*)data;
   
   int inp=-1;
      
   if (driver->descriptor==-1)
     {
	driver->descriptor=esd_play_stream(ESD_BITS16|
					   ESD_STEREO,
					   44100,
					   NULL,
					   NULL);
	
	/* only start byteswap if esd connect was successful */
	if (driver->descriptor!=-1)
	  {	     
	     
	     driver->data=(gpointer)piping_create_function(stdfiletrack_byteswap,
							   NULL,
							   &inp,
							   &driver->descriptor,
							   NULL);	
	     driver->descriptor=inp;
	  };
	return driver->descriptor;
     }
   else
     return -1;
   /* return -1 if sound device is in use */
};
			   
void audio_esd_close(gpointer data)
{
   int status;
   audio_driver *driver=(audio_driver*)data;

   if (driver->descriptor!=-1)
     {	
	esd_close(driver->descriptor);
	driver->descriptor=-1;
	/* wait for byteswap to finish */
	if ((int)driver->data!=-1)
	  {
             /* say good by, byteswap */    
	     kill((int)driver->data,SIGTERM);      	     
	     waitpid((int)driver->data,&status,0);
	  };
     };
};

void audio_esd_init()
{
   audio_driver_register(audio_driver_create(DEFAULTENTRIES_AUDIO_DEFAULT_ENLIGHTENMENT,
					     audio_esd_open,
					     audio_esd_close,
					     (gpointer)-1));
};
			 
#endif   
	  
			   
