/* GNOME Transcript
 * Copyright (C) 1999-2000 the Free Software Foundation
 * Authors : Paul Gammans, Matias Mutchinick
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#ifndef __GTRANS_STRING_H__
#define __GTRANS_STRING_H__


#include <glib.h>


/**
 * gtrans_string_escaped_len:
 * @str  : A character string
 *
 * Return the length of the string plus the number of 
 * reserved chars.
 */
gint
gtrans_string_escaped_len(gchar *str);




/**
 * gtrans_string_escaped_concat:
 * @tgt     : String to concatenate to
 * @src     : String to concatenate
 *
 * Concatenates @src to @tgt adding a \ before each
 * reserved (or conflictive) character.
 * Note     : Currenty dosen't check \n \0 \t \r \b
 */
gchar *
gtrans_string_escaped_concat(gchar *tgt, 
			     gchar *src);



/**
 * gtrans_string_escaped_dup:
 * @src : A character string
 *
 * Duplicates @src string and adds a \ before each conflictive
 * character.
 */
gchar *
gtrans_string_escaped_dup(gchar *src);




#endif /* __GTRANS_STRING_H__ */
