//$Id: togglebutton.cc,v 1.2 2001/08/18 14:23:02 cactus Exp $ -*- c++ -*-

/* Guikachu Copyright (C) 2001 RDI Gerg <cactus@cactus.rulez.org>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "togglebutton.h"

#include "config.h"
#include <libgnome/libgnome.h>

using namespace Guikachu::GUI;

ToggleButton::ToggleButton (Property<bool> &property_):
    property (property_),
    update_block (false)
{
    using namespace SigC;
    
    clicked.connect (slot (this, &ToggleButton::clicked_cb));
    
    property.changed.connect (slot (this, &ToggleButton::update));
    update ();
}

void ToggleButton::update ()
{
    update_block = true;
    
    set_active (property);
    
    remove ();
    if (property)
	add_label (_("Yes"), 0.5, 0.5);
    else
	add_label (_("No"),  0.5, 0.5);

    update_block = false;
}

void ToggleButton::clicked_cb ()
{
    if (!update_block)
	property = get_active ();
}
