/*
 * Copyright (C) 2009, 2010 Hermann Meyer, James Warden, Andreas Degert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/******************************************************************************
xpm pixmaps for the GtkReglerClass used as inline data
******************************************************************************/

/* XPM */
static const char * knob1_xpm[] = {
	"51 51 31 1",
	" 	c None",
	".	c #030602",
	"+	c #11120F",
	"@	c #181917",
	"#	c #1E1F1D",
	"$	c #232422",
	"%	c #272826",
	"&	c #2B2D2B",
	"*	c #313230",
	"=	c #353735",
	"-	c #3A3B39",
	";	c #40413F",
	">	c #434346",
	",	c #444643",
	"'	c #484947",
	")	c #4C4D4B",
	"!	c #515250",
	"~	c #595A58",
	"{	c #60615F",
	"]	c #676967",
	"^	c #6F716F",
	"/	c #777876",
	"(	c #7F817E",
	"_	c #888A87",
	":	c #929492",
	"<	c #A2A4A2",
	"[	c #B5B7B4",
	"}	c #C7C9C6",
	"|	c #D6D8D7",
	"1	c #E5E6E4",
	"2	c #F8F9F7",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                     !!~/__:_^                     ",
	"                  !_}|||}}}[[[<:(                  ",
	"                !<|111||}[[<<:::__(                ",
	"              ~<|111|[[<:((//(_:_(//]              ",
	"             (2|111}[_(////////^^//^]~             ",
	"            _2|11||<__((////^^^^^^^/^!)            ",
	"           _2}|12}<<:_(///^^^^^^^]^]]{,,           ",
	"          /2}|12}[[<:_(//^^^]]]]]]]]]]~--          ",
	"         !|}||2}[[<<:_(/^^]]]]]]]]]]]]]~**         ",
	"        %<[}}1[[[[<::_(/^]]]]]]]{{{{{{{{)%#        ",
	"        ;[}[[<<<<<<::_(/^]]{{{{{{{{{{{{{{*#        ",
	"       #([[<:::<<:::_(/^]]{{{{{{{{{{{{~~{!%@       ",
	"       &:[<:((______((/]]{{{{{~~~~~~~~~~~~*@       ",
	"      .,<<_^^////((((/^]{{{~~~~~~~~~~~~~~~,$+      ",
	"      +]<:/]]]]]^^//^^]]{~~~~~~~~!!!!!!!!!!&+      ",
	"      $(<({{{{{]]]]]]]{{~~~~!!!!!!!!!!!!!!!&+      ",
	"     .%(:/~~~~~{{{{{{~~~~!!!!!!!!!!!))))))!-#.     ",
	"     .%((]!!!!!~~~~~~~~!!!!!)))))))))))))'';$.     ",
	"     .$/^~!!!!!!!!!!!!!!)))))')'''''''''''''%.     ",
	"     .$^]!))))))))))))))''''''''''',,,,>,>>'%.     ",
	"     .$^{!))))))))))))))''''''''>'',,,>,>,>'%.     ",
	"     .$]{)''''''''''','',,,,,,,,,,,,,,;,;>>'%.     ",
	"     .#{~'',>,,,,,,,,,,,,,;;;,;;;;>;;;;;;;;;$.     ",
	"     .#{~,,,,,;;;;;;;;;;;>;;;;;;;;;;;;;;;;;;#.     ",
	"     .@!!>;>;;;;;;;;;;;;;;>;---------------=#.     ",
	"      +;'>;;;;--->----------------------==-%+      ",
	"      .$,;------------====================-#.      ",
	"      .+,;-===================****=**=*****@.      ",
	"       +=-==*=****************************%+       ",
	"       .@==****&&&&&*************&**&&*&&*@.       ",
	"        +*=**&&&&&&&&&&&&&&&&&&&&&&&&&&&&%+        ",
	"        .+&&&&%%%%%&&&&&&&%&&&&&&&&&&&%%&@.        ",
	"         .$&&$$$$$%%%%&&%%%%%%%%%%%%%%%&$+         ",
	"          +$$###$$$$$%%&%%%%%%%%%%$$$$%%+          ",
	"           +%######$$$%%$$$$$$$$$$$$$%%+           ",
	"            @########$$$$###########$$+            ",
	"             +@@@####################+             ",
	"              ..@####@#@##@@@@@@###@.              ",
	"                .+@@@###@@@@###@@@+                ",
	"                  ..+$#@++++@#$+.                  ",
	"                     .........                     ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   "};

/* XPM */
static const char * knob2_xpm[] = {
	"51 51 31 1",
	" 	c None",
	".	c #100101",
	"+	c #0A0402",
	"@	c #1B0101",
	"#	c #270001",
	"$	c #360100",
	"%	c #440001",
	"&	c #540000",
	"*	c #6A0000",
	"=	c #1A1C19",
	"-	c #890000",
	";	c #AD0000",
	">	c #292524",
	",	c #C40000",
	"'	c #522322",
	")	c #E00800",
	"!	c #3B3433",
	"~	c #743B3C",
	"{	c #5F4142",
	"]	c #4E4948",
	"^	c #B2321F",
	"/	c #EE360C",
	"(	c #655F5E",
	"_	c #855D5B",
	":	c #766F6E",
	"<	c #807B7A",
	"[	c #938D8C",
	"}	c #A29D9C",
	"|	c #B7B2B1",
	"1	c #C4C0BE",
	"2	c #FCDD7C",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                     }||1111||}]                   ",
	"                  [|111||}}||1111[:                ",
	"                }11|<::::::::::<}11|!              ",
	"              }11<::::::(]](::::::<|1|             ",
	"            ]|1[:::(>++++++++++>(:::<|1(           ",
	"           (|}::<]++++++++++++++++]:::}1:          ",
	"          (|[::(+++++=>]]::]>>.+++++(::[|<         ",
	"         (|<::]++++:|||||||||||[.++++]::<|(        ",
	"        ]}[::!++++}||||||||||||||:++++=::<}]       ",
	"        [[::>+++..]|1}(({'{(:}1||>..+++=::[}!      ",
	"       <[::]+++...@:#@##$$$$###:}@@...++!::[[      ",
	"       [<:(++<[..@@##$'______~$$#@@@@}}++]::[!     ",
	"      <<::++![:.@@#$$%__~~~__~%%$$#@@>[:++::<<     ",
	"     ]<::]++(].@@#$$&&&**---**&&%$$#@@@]]+!::<]    ",
	"     ]:::++>].@#('%&&**-----;-**&%~{'@@.!++::::    ",
	"     :::]++>.@@{{~&&*---^^^^----*&%'$@@..++!:::    ",
	"    !:::=++..@#''&&*--;;;,,;;;---*&%$#@@..++<::]   ",
	"    ](::+++.@@#$%&*--;;,)//)),;;--*&%$@@..++::(]   ",
	"    ](::++..@@#$&&*^^;))////)),;--*&%$#@@.++]:(]   ",
	"    ](:]++..@@$%&*--;,)))///))),;--*&$#@@.++>:(]   ",
	"    ](:!++..@#$%&*-;;)))/////)));--*&%$@@..+=::]   ",
	"    ](:>++..@#$%&*-;,))//22///));;-*&%$@@..++::]=  ",
	"    !(:=++.@@#$%&*-;,))//22///));;-*&%$#@..++::]=  ",
	"    !(:!++..@#$%&*-;,))///////));;-*&%$@@..++::!   ",
	"    >]:]++..@#$%&*-;;)))/////)));--*&%$@@..+>:(!   ",
	"    >]:(++..@@$%&*--;,)))///))),;--*&$#@@.++!:]>   ",
	"    =!::++..@@#$&**-;;)))))))),;--*&%$#@@.++]:!=   ",
	"    +>::+++.@@#$%&*--;;,))))),;;--*&%$#@..++<:>+   ",
	"     =(:!++..@@$$&&*--;;;,,,;;;--*&%$#@@..+>::=+   ",
	"     =!:(++..@@#$%&&*---;;;;----*&&$$@@..++]:]=    ",
	"     +>::>++..@@#$%&&**-------**&&$$#@@..++::>+    ",
	"      =]:(+++..@@#$%&&&*******&&%$$#@@..++(:(=     ",
	"      +=::!++..@@@#$$%&&&&&&&&%%$$#@@..+++::>=     ",
	"       =]::+++..@@@#$$$%%%%%%$$$##@@...++::]=      ",
	"       +=(::+++...@@@##$$$$$$$##@@@...++(:(=+      ",
	"        ==(:(+++...@@@@@#####@@@@...+++]::>=       ",
	"         =>:::++++...@@@@@@@@@@@...+++(::>=        ",
	"          ==:::=+++..............++++:::>=         ",
	"           ==(::(+++++........+++++]::(>=          ",
	"            ==]:::]=++++++++++++=]:::]==           ",
	"             +==(::::]=++++++=]::::(>==            ",
	"               ==>(::::::::::::::(>==              ",
	"                 ===>](::::::(]>>==+               ",
	"                   ++====>>====++                  ",
	"                        ++++                       ",
	"                                                   ",
	"                                                   "};

/* XPM */
static const char * knob3_xpm[] = {
	"51 51 31 1",
	" 	c None",
	".	c #03020B",
	"+	c #070215",
	"@	c #05021D",
	"#	c #040602",
	"$	c #070135",
	"%	c #080229",
	"&	c #090147",
	"*	c #0C015C",
	"=	c #100070",
	"-	c #160189",
	";	c #1700A6",
	">	c #1500C2",
	",	c #191918",
	"'	c #3604E5",
	")	c #262627",
	"!	c #292254",
	"~	c #6120E6",
	"{	c #423B6A",
	"]	c #42414F",
	"^	c #434344",
	"/	c #6F2BDB",
	"(	c #7538CD",
	"_	c #5C5B60",
	":	c #635C87",
	"<	c #6E706D",
	"[	c #727077",
	"}	c #838387",
	"|	c #9B9B9D",
	"1	c #B7B7B9",
	"2	c #D0D1CF",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                     |11111111|^                   ",
	"                  }122111||111221}<                ",
	"                |211}[[[[[[[[[[[|121^              ",
	"              |11}[[[[[[_^^_[[[[[[[111             ",
	"            ^11}[[[_)..##..##..)_[[[}11_           ",
	"           <1|[[[_.#............#.^[[[|1<          ",
	"          <1|[[_,#...,)]_[[]))....#._[[}1}         ",
	"         _1}[[_#...[11111111111|+....^[[[|_        ",
	"        ^|}[[)#...|11111111111111[....,[[}|_       ",
	"        |}[[)#....]11|[]]{]_[|111@+....,[[}|^      ",
	"       }|[[^#....+@[%+%%$$$$%@%[|@++...#)[[}}      ",
	"       }[[_#.[|.++@@%$!::::::{$$%@@++||.._[[|^     ",
	"      <}[[..)|[++@%$$&::{!{::{&&$%%@+)}[..[[}}     ",
	"     ^}[[^#.[_++@%$&&***==--=**&&$$@+++_].][[}^    ",
	"     _<[[..)]++%:!&&**=----;;==**&{{{@++].#[[[<    ",
	"     <[[^#.)++@]{{&*==-;((((;--=**&!$@+++..][[<    ",
	"    )<[[,..+++@!!&*=--;;>>>>;;;-=**&$%@++..,[[<^   ",
	"    ^<[[....++%$&**=-;>>'~~~'>;;-=*&&$@++..#[[<^   ",
	"    ^_[[#..++@%$&*=-;>>'~''~''>;;-=*&$%++...^[_^   ",
	"    ^_[^#..++@$&**-;;>'''''''''>;-=*&$%@++..)[_^   ",
	"    ^_[^...++@$&*=-;>''''~~''''>;;-*&&%@++..,[[^   ",
	"    ^_[)...++%$&*=-;>'''~//~''''>;-=*&$@++..,[[^,  ",
	"    ^_[,...++%$&*=-;>'''/((/''''>;-=*&$@++...[[^,  ",
	"    )_[)...++%$&*=-;>'''~((/~'''>;-=*&$@++..,[[^   ",
	"    )_[^...++@$&*=-;>'''~~/~'''';;-*&&%@++..)[_)   ",
	"    )^[_#..++@$&**-;;>'''''''''>;-=*&$%@++..)[_)   ",
	"    ,^[[...++@%$&*=-;>>'''''''>;;-=*&$%++..#_[^,   ",
	"    ,)[[....++%$&**--;>>'''''>;;-=*&&$@++...[[),   ",
	"     ,_[)...++@%$&*=--;;>>>>>;;-=**&$%@++..)[[,#   ",
	"     ,^[_#..+++%$&&*=--;;;;;;--=**&$%@++...^[_,    ",
	"     #)[[)...++@%$&&**=------==**&&$%@++...[[),    ",
	"      ,^[_#...++@%$&&***=====**&&$$%@++..._[_,     ",
	"      #,[[)...+++@%$$&&&*****&&&$$%@++....[[),     ",
	"       ,^[[....+++@%%$$&&&&&&&$$%@+++....[[^,      ",
	"       #,_[[....++++@%%%$$$$$%%@@+++...._[_,,      ",
	"        ,,_[_.....++++@@@@@@@@@++++....^[[),       ",
	"         ,)[[[......+++++++++++++....._[[),        ",
	"          ,,[[[,......+++++++++......[[[),         ",
	"           ,,_[[_.................._[[_),          ",
	"            ,,^[[[^,#...........,^[[[_,,           ",
	"             ,,,_[[[[^,,....,,^[[[[_),,            ",
	"               ,,)_[[[[[[[[[[[[[[_),,              ",
	"                 ,,,)^_[[[[[[_^)),,#               ",
	"                   #,,,,,)),,,,,#                  ",
	"                        #,,#                       ",
	"                                                   ",
	"                                                   "};

/* XPM */
static const char * knob5_xpm[] = {
	"51 51 31 1",
	" 	c None",
	".	c #080000",
	"+	c #0A0301",
	"@	c #120203",
	"#	c #150400",
	"$	c #1B0400",
	"%	c #200604",
	"&	c #250600",
	"*	c #290602",
	"=	c #2D0706",
	"-	c #2A0905",
	";	c #350806",
	">	c #310A02",
	",	c #390A02",
	"'	c #3F0A08",
	")	c #3B0D05",
	"!	c #3C0E08",
	"~	c #420D04",
	"{	c #490D0A",
	"]	c #451009",
	"^	c #4C0F06",
	"/	c #50130B",
	"(	c #571208",
	"_	c #541608",
	":	c #5A150B",
	"<	c #5C170D",
	"[	c #5F1909",
	"}	c #65170C",
	"|	c #681A0F",
	"1	c #6F1A13",
	"2	c #6A1C11",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                     ]^/[}}|}<                     ",
	"                  ]}22222222||||}                  ",
	"                ^|2212222|||||||}}[                ",
	"              /|211222|||}}[[}}}}}[[:              ",
	"             }121122|}}[[[[[[[[<<[[<:/             ",
	"            }121122|}}}[[[[[<<<<<<<[<^]            ",
	"           }122112||}}}[[[<[<<<<<:<::_!)           ",
	"          [122212||||}}[[<<<::::::::::/>>          ",
	"         ^2222122|||}}}[<<:::::::((((((^&&         ",
	"        $||2212|||||}}}[<:::(((((__:___(]#@        ",
	"        ,|2||||2||||}}}[<:((____________(*+        ",
	"       @}||||||||||}}}[<:(_____(_((//////]$+       ",
	"       $||||}}}}}}}}}}[::(__((////////////&+       ",
	"      .!|2}<<[[[[}}}[[<:(_(/////////^^^^^^)#.      ",
	"      +(||[((:::<<[[<<:(_////^^^^^^^^^^^^^^%.      ",
	"      @}|}_____(:::::(_(//^^^^^^^^^^^^^{{^^%+      ",
	"     .#}}[//////__(/////^^^^^{{{]]]]]]]]]{]=+.     ",
	"     .#}}(^^^^^^^^///^^^^^{]]]{]]]]]]]~]~~~,@.     ",
	"     .@[</^^^{{{^^^^^^^]]]]~~~~~~~~~~~~~~'''$.     ",
	"     .#<:^]]]]]]]]]]]]]~~~~~~~~''''!!!!!!'''$.     ",
	"     .#<_]]]]]]]~]]]]~~~~~~~~~~'!''!!!'!'))'$.     ",
	"     .@:_~~~~~~~~~~~'!~'!!!!!!))))),,,,,,,,!#.     ",
	"     .@(/~~!!!!!!!!!),)),,,,,,,,,,,,,,,,,,,,@.     ",
	"     .+(^!),,,,,,,,,,,,,,,,,,,,,;;;;>>>>>>>>@.     ",
	"     .+^],,,,,,,,,;;;;>;>>>>>>>>;>>>>>>>>>>-+.     ",
	"      .,~,;>>>>>>;>>>>>>>>>>>>>>==========>$.      ",
	"      .#,,>>>>>>===============--------***>+.      ",
	"      .+),=====----*******-************&&&-+.      ",
	"       .=>*****&&&&&********&&&&&&&&&&&&&&$.       ",
	"       .+-*&&&%%&&&&%&&%%%&&%%%&%%%%%%%%&&+.       ",
	"        .%*&%&%%%%%%%&&&&&&&&&&%%%%%%%%%&$.        ",
	"        .+%&%$$#$$$$%%%%%%%%%%%$$$%%$$$$%+.        ",
	"         .#%%@##@##$$$$$$$$$$$$$$$$$$$$%@.         ",
	"          .@#@@@@#@@##$$$$$###########$$.          ",
	"           .#@@@@@@@#@###@@@@##@@###@#$+           ",
	"            ++@+@@@@@#@#@@@@@@@@@@@@##+            ",
	"             .+++++++@@@+++++@++++@@+.             ",
	"              ..++@@+++++++++++++@@+.              ",
	"                ..+++@@++++++@@+++.                ",
	"                  ...@@+....+@@..                  ",
	"                     .........                     ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   "};


/* XPM */
static const char * knob4_xpm[] = {
	"51 51 31 1",
	" 	c None",
	".	c #010400",
	"+	c #040703",
	"@	c #0D0605",
	"#	c #060905",
	"$	c #100B0A",
	"%	c #0A0D09",
	"&	c #0F110E",
	"*	c #151110",
	"=	c #111310",
	"-	c #141513",
	";	c #171916",
	">	c #1B1818",
	",	c #191B18",
	"'	c #1B1C1A",
	")	c #1F1D1F",
	"!	c #201E21",
	"~	c #1F201E",
	"{	c #222421",
	"]	c #252725",
	"^	c #282629",
	"/	c #292A28",
	"(	c #2C2E2B",
	"_	c #322E2D",
	":	c #30322F",
	"<	c #303436",
	"[	c #323431",
	"}	c #353634",
	"|	c #373936",
	"1	c #3B3D3A",
	"2	c #3E3F3D",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                     ]/(}||1|}                     ",
	"                  ]|222222221111|                  ",
	"                /122222221111111|||                ",
	"              (1222222111|||||||||}}[              ",
	"             |2222221|||||||}}}}[||}<(             ",
	"            |2222221||||||}}}}}}}}[}[/]            ",
	"           |22222211|||||}}_[[[[[<[[[(~~           ",
	"          |2222221112|||}}[[[[[[[[[[[:(,;          ",
	"         /2222222111||||}[[[[[:::::::::/-=         ",
	"        %11222211111|||}[[[:::::::::::::]%#        ",
	"        !12111121111|||}[[::::::((((((((_-+        ",
	"       #|1111111111||||[:::::((_(__((((((]%@       ",
	"       &1111||||||||||}[:::(__((((((((((((=.       ",
	"      .~12|[}}}|||||||}[:(_(((((((((//////~%.      ",
	"      .:12|::[[[[}}}}[[:(((((////_/////////&.      ",
	"      @|1|:((:::::[[_::_((///////////////^/&.      ",
	"     .%||}((((((((_(((((////////]]]]]]]]]^];+.     ",
	"     .%||:////////(((//////]]]^]]]]]]]{]{{{~%.     ",
	"     .%|<(//^//////////]]]]{{{{{{{{{{{{{{{{{$.     ",
	"     .%<:/]]]]]]]]]]]]]{{{{{{{{{{{{~~~~~~!!{%.     ",
	"     .%[:]]]]]]]{^^]]{{{{{{{{{{{!{{~~~!~!~!{%.     ",
	"     .@[({{{^{{~{{{{{~~{~~~~~~~~~~~~~~!~!!!~%.     ",
	"     .#:({{~~~~~~~~~~~~~~~!!!~!!!~!''''''''!%.     ",
	"     .+_/~~~~~!!!~~~'')''''''''''''',,,,,,,,#.     ",
	"     ../]!'''''''''''',',,,,,,,,>,,,,,;;;;;-+.     ",
	"      .'{!',,,,,,>,,,,,,;;;;;;;;;;;;;;;;;;;%.      ",
	"      .%~!,;;;;;;;;;;;;;;;;;;;;;;;;>;;;---;+.      ",
	"      ..~~;;;;;;;;;----------------------->@.      ",
	"       .;;--*----==--*-----------=---*===-%.       ",
	"       ..;----==****=*==================*-..       ",
	"        .=--=*&&&&&&&**********&&&&&&&&&*%.        ",
	"        ..=*&&%%%%%&&&&&&&&&&&&&&&#&&&&%&..        ",
	"         .%&&%%%%%%%%%&&%%%%%%%%$%%%%%%&@.         ",
	"          .%%###@%%%%%%&%%$%%%%%%%%%%%%%.          ",
	"           .%#+####@%%%%%%%%%%@@%%%%@%%.           ",
	"            .+#+#####%%%@########@+@%%.            ",
	"             ....++++###++++++++++@@+.             ",
	"              ...+##@.+@++......+##..              ",
	"                .....##+....+##....                ",
	"                  ...@#......#@..                  ",
	"                     .........                     ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   "};

/* XPM */
static const char * knob6_xpm[] = {
	"51 51 31 1",
	" 	c None",
	".	c #010400",
	"+	c #000902",
	"@	c #040C00",
	"#	c #011203",
	"$	c #061200",
	"%	c #031701",
	"&	c #051A00",
	"*	c #021E04",
	"=	c #0A2000",
	"-	c #042303",
	";	c #0B2601",
	">	c #052A06",
	",	c #0B2D02",
	"'	c #053107",
	")	c #0B3403",
	"!	c #0E3707",
	"~	c #093A02",
	"{	c #0C3C05",
	"]	c #104009",
	"^	c #154203",
	"/	c #0E4506",
	"(	c #154A0B",
	"_	c #145108",
	":	c #19550D",
	"<	c #165A08",
	"[	c #1B5E0D",
	"}	c #1F6111",
	"|	c #206212",
	"1	c #1C660B",
	"2	c #226B11",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                     /(_[1111<                     ",
	"                  /|222222222211|                  ",
	"                (12222222221111111[                ",
	"              _1222222211|}[[|11|}[[<              ",
	"             |2222222|}[[[[[[[[<<[[<:_             ",
	"            122222211||[[[[[<<<<<<<[<(/            ",
	"           |222222111|}[[[<<<<<<<<<<<_{~           ",
	"          [2222222211|}[[<<<<<<<<<<<<<_),          ",
	"         (22222222111|}[<<<<<<<<<::::::(;-         ",
	"        &122222222111|}[<<<<::::::::::::/%@        ",
	"        !222211221111|}[<<:::::::________;@        ",
	"       @|221111111111|[<<::::____________/&@       ",
	"       &1211}}|1111||}[<<::_______________-+       ",
	"      .{12|<<[[[[}}}[}<<:___________((((((~%.      ",
	"      +:11[::<<<<<[[<<<:_____((((((((((((((*.      ",
	"      $}1}:__:::<<<<<::___(((((((((((((//((=+      ",
	"     .%|1[______________(((((//////////////,@.     ",
	"     .%}|:((((((((___(((((////////////^/^]]!%.     ",
	"     .%[[_(((///(((((((////^]]^]]]]]]]]^]{{{&.     ",
	"     .$<<(/////////////^]]]^]]]{{{{{{{{{{~{{&.     ",
	"     .$<:///////^////^^^]]]]]]]{{{{{{{~{~~~{&.     ",
	"     .$<_^]]]^]^]]]]{{{{{{{{{{~~~~~!!!!!!!!{%.     ",
	"     .@:_]{{{{{{{{{~~!~~!!!!!!!!!!!))))))))!%.     ",
	"     .@_({~!!!!!!!!!))!)))))))))))))''''''''#.     ",
	"     .+(/!))))))))))))')'''')))))'''''',,,',@.     ",
	"      .)]!)'''')))))'''',,,,,,,,,,,,,,,,,,,&.      ",
	"      .%!!',,,,,,,,,,,,,,,,,,,,>>>>>>>>>>>,@.      ",
	"      .+~!,,,,,>>>>>>>>>>>>>;;;;;;;;;;;;;;,@.      ",
	"       .,,>;>;;;;--;;;;;;;;;;;;;;-;;;;---;&.       ",
	"       .@>>;;;-------;-----;-------------;@.       ",
	"        .-;;--******=----------=====*==*-&.        ",
	"        .+--*&&%&&&&***********&&&**&&&&*+.        ",
	"         .$=*%$$%%%&&&&&&&&&&&&&&&&&&&&*$.         ",
	"          .%%###$$%%%%&&&&&%%%%%%%%%%%&&.          ",
	"           .%##@@##$$%%%%%%%%%%%%$$$$%&+           ",
	"            @@#@#@@##$%$$###########$%+            ",
	"             .@+@@@@@@#@@@@@@@@@@@$#@.             ",
	"              ..+@#@@@@@@@@@@@@@@@#+.              ",
	"                ..@@@##@@@+@@@@@@@.                ",
	"                  ...$#+....@#$..                  ",
	"                     .........                     ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   ",
	"                                                   "};


/* XPM */
static const char * switchit_xpm[] = {
	"74 28 241 2","  	c None",". 	c #000000","+ 	c #040404","@ 	c #080808",
	"# 	c #090909","$ 	c #050505","% 	c #010101","& 	c #151515","* 	c #2B2B2B",
	"= 	c #2D2D2D","- 	c #191919","; 	c #060606","> 	c #030303",", 	c #141414",
	"' 	c #2A2A2A",") 	c #070707","! 	c #F86925","~ 	c #C53F02","{ 	c #C33D00",
	"] 	c #C83E01","^ 	c #46E41B","/ 	c #2FCA04","( 	c #29BF00","_ 	c #2BC701",
	": 	c #FFC77A","< 	c #FFC075","[ 	c #FE7A31","} 	c #E64D07","| 	c #D84400",
	"1 	c #D14100","2 	c #CA3E00","3 	c #1B1B1B","4 	c #3A3A3A","5 	c #414141",
	"6 	c #C6FF94","7 	c #AFFF7C","8 	c #63FE31","9 	c #37E607","0 	c #2ED800",
	"a 	c #2CD100","b 	c #2CD000","c 	c #020202","d 	c #FFB86E","e 	c #FFF8B0",
	"f 	c #FFB26C","g 	c #ED5712","h 	c #D44300","i 	c #CD4000","j 	c #C23C00",
	"k 	c #C62C00","l 	c #353535","m 	c #D0D1D1","n 	c #D0D0D1","o 	c #D1D1D0",
	"p 	c #D0D0D0","q 	c #373737","r 	c #76F946","s 	c #A3FF70","t 	c #E1FFB0",
	"u 	c #9CFF6C","v 	c #41ED12","w 	c #2ED400","x 	c #2CCD00","y 	c #2AC600",
	"z 	c #2FDD00","A 	c #0B0B0B","B 	c #F65308","C 	c #FD7028","D 	c #FFA862",
	"E 	c #FFA15D","F 	c #EA5714","G 	c #CF4201","H 	c #C83E00","I 	c #CA3A00",
	"J 	c #4D4D4D","K 	c #C4C4C5","L 	c #C5C4C5","M 	c #C4C4C4","N 	c #C4C4C3",
	"O 	c #C3C3C3","P 	c #C4C3C4","Q 	c #C3C4C3","R 	c #40F60E","S 	c #5AFD28",
	"T 	c #92FF62","U 	c #8CFF5D","V 	c #42EA14","W 	c #2DCF01","X 	c #2BC800",
	"Y 	c #2AC200","Z 	c #2FDB01","` 	c #272727"," .	c #313131","..	c #E44801",
	"+.	c #E44B05","@.	c #E95410","#.	c #E85513","$.	c #D44605","%.	c #CA3F00",
	"&.	c #C43D00","*.	c #BE3B00","=.	c #C93300","-.	c #B8B8B8",";.	c #B8B7B8",">.	c #B7B8B8",
	",.	c #B7B7B7","'.	c #B7B7B6",").	c #363636","!.	c #32E201","~.	c #35E405","{.	c #3EE910",
	"].	c #40E813","^.	c #32D405","/.	c #2BCA00","(.	c #2AC400","_.	c #29BE00",":.	c #2ED500",
	"<.	c #B5B5B5","[.	c #404040","}.	c #4A4A4A","|.	c #B6B7B6","1.	c #DA4400","2.	c #D74300",
	"3.	c #D44200","4.	c #CF4100","5.	c #C03C00","6.	c #BA3A00","7.	c #A82300","8.	c #ABABAC",
	"9.	c #ABACAB","0.	c #ABACAC","a.	c #ABABAB","b.	c #ABAAAB","c.	c #AAABAB","d.	c #AAAAAA",
	"e.	c #ABABAA","f.	c #2ED700","g.	c #2DCF00","h.	c #29C000","i.	c #28BA00","j.	c #2BC900",
	"k.	c #A9A9AA","l.	c #A9A9A9","m.	c #7D7D7D","n.	c #AAAAAB","o.	c #D14000","p.	c #D04000",
	"q.	c #CC4000","r.	c #BF3B00","s.	c #BB3A00","t.	c #AE3500","u.	c #9F9FA0",
	"v.	c #9FA09F","w.	c #9F9F9F","x.	c #9E9F9F","y.	c #3E3E3E","z.	c #0C0C0C","A.	c #101010",
	"B.	c #9E9E9F","C.	c #9E9E9E","D.	c #9E9D9D","E.	c #2DD200","F.	c #2CCC00","G.	c #28BB00",
	"H.	c #27B600","I.	c #9D9D9D","J.	c #9D9E9D","K.	c #9D9E9E","L.	c #0F0F0F","M.	c #9E9F9E",
	"N.	c #C13B00","O.	c #C53E00","P.	c #AF3500","Q.	c #B33400","R.	c #939393","S.	c #929393",
	"T.	c #939392","U.	c #6F6E6E","V.	c #929291","W.	c #929192","X.	c #929292",
	"Y.	c #919191","Z.	c #28BE00","`.	c #29C500"," +	c #3C3C3C",".+	c #4B4B4B",
	"++	c #939394","@+	c #B22500","#+	c #CF3C00","$+	c #C03100","%+	c #A72300",
	"&+	c #868687","*+	c #868787","=+	c #868686","-+	c #858685",";+	c #858485",
	">+	c #858585",",+	c #2DD301","'+	c #2DD100",")+	c #2AC700","!+	c #878686",
	"~+	c #6C6C6C","{+	c #878787","]+	c #878888","^+	c #888787","/+	c #878788",
	"(+	c #7A7A7A","_+	c #797979",":+	c #787878","<+	c #797878","[+	c #7B7B7B",
	"}+	c #7A7A7B","|+	c #7B7A7B","1+	c #7B7B7C","2+	c #7C7B7B","3+	c #7C7C7C",
	"4+	c #6D6D6D","5+	c #696969","6+	c #6E6F6E","7+	c #6F6F6E","8+	c #6F6F6F",
	"9+	c #706F70","0+	c #6F706F","a+	c #6F6F70","b+	c #707070","c+	c #616161",
	"d+	c #606060","e+	c #636363","f+	c #646463","g+	c #636463","h+	c #646464",
	"i+	c #656564","j+	c #585758","k+	c #575757","l+	c #585858","m+	c #575758",
	"n+	c #585958","o+	c #585859","p+	c #4C4B4B","q+	c #4C4C4C","r+	c #4C4D4D",
	"                                                                                                                                                    ",
	"                                                                                                                                                    ",
	"                                                                                                                  . . . .                           ",
	"                                                                                                                . + @ # $ %                         ",
	"                                                                                                              . + & * = - ; .                       ",
	"                                    - - - - - - - -                                                           > + , ' = - ) >                       ",
	"        ! ~ { ]                 - - - - - - - - - - - -                           ^ / ( _                 - - % . + @ # $ % % - -                   ",
	"    : < [ } | 1 2             - - - - 3 = 4 5 ' - - - - -                     6 7 8 9 0 a b             - - - % . . . . . . c - - -                 ",
	"    d e f g h i j k         - - - - l m n o p p p q - - - -                 r s t u v w x y z         - - - - # . . . . . . A - - - -               ",
	"  B C D E F G H j I         - - - J K L M N O P P Q J - - -                 R S T U V W X Y Z         - - - J ` . . . . . .  .J - - -               ",
	"  ..+.@.#.$.%.&.*.=.      - - - q -.;.-.-.>.,.,.,.'.,.).- - -               !.~.{.].^./.(._.:.      - - - ).<.[.+ . . . . $ }.|.q - - -             ",
	"  1.2.3.4.%.&.5.6.7.      - - - 8.9.0.8.a.a.b.a.c.d.e.d.3 - -               0 f.w g./.(.h.i.j.      - - 3 k.l.m.> . . . . % n.e.n.- - -             ",
	"  o.p.q.H &.r.s.t.        - - ' u.v.w.x.y.z.A.J B.C.D.C.= - -               E.b F.X (.( G.H.        - - = I.J.K.L.. . . . 3 M.M.w.' - -             ",
	"    N.O.j *.6.P.Q.        - - 5 R.S.T.U.+ . . c V.W.X.Y.4 - -                 j.y Y Z.i.H.`.        - - 4 X.V.X. +> . . ; .+R.R.++5 - -             ",
	"      @+#+$+%+            - - 4 &+*+=+ +> . . ; .+-+;+>+5 - -                   ,+f.'+)+            - - 5 !+&+&+~++ . . c {+]+^+/+4 - -             ",
	"                          - - = (+(+(+L.. . . . 3 _+:+<+' - -                                       - - ' (+[+}+|+y.z.A.J 1+2+[+3+= - -             ",
	"                          - - 3 4+4+5+> . . . . % ~+~+~+- - -                                       - - - 6+7+8+8+9+0+a+9+9+b+b+b+3 - -             ",
	"                          - - - ).c+[.+ . . . . $ }.d+q - - -                                       - - - q e+e+e+f+g+e+h+h+h+i+).- - -             ",
	"                            - - - J ` . . . . . .  .J - - -                                           - - - J j+k+l+m+l+n+o+l+J - - -               ",
	"                            - - - - # . . . . . . A - - - -                                           - - - - l p+q+q+q+r+q+q - - - -               ",
	"                              - - - % . . . . . . c - - -                                               - - - - 3 = 4 5 ' - - - - -                 ",
	"                                - - % . + @ # $ % % - -                                                   - - - - - - - - - - - -                   ",
	"                                    > + , ' = - ) >                                                           - - - - - - - -                       ",
	"                                    . + & * = - ; .                                                                                                 ",
	"                                      . + @ # $ %                                                                                                   ",
	"                                        . . . .                                                                                                     ",
	"                                                                                                                                                    ",
	"                                                                                                                                                    "};

/* XPM */
static const char * slidersm_xpm[] = {
	"140 10 69 1"," 	c None",".	c #060606","+	c #020202","@	c #010101","#	c #222222",
	"$	c #2E2E2E","%	c #2C2C2C","&	c #1D1D1D","*	c #000000","=	c #0E0E0E",
	"-	c #A7A7A7",";	c #F9F9F9",">	c #CFCFCF",",	c #B4B4B4","'	c #969696",
	")	c #878787","!	c #696968","~	c #1E1E1E","{	c #A0A0A0",
	"]	c #0C0C0C","^	c #515150","/	c #EAEAEA","(	c #909090","_	c #787878",
	":	c #707070","<	c #676868","[	c #656565","}	c #626262","|	c #4E4E4E",
	"1	c #292929","2	c #646464","3	c #AEAEAE","4	c #929292","5	c #424242",
	"6	c #9B9B9B","7	c #686868","8	c #5E5E5E","9	c #585858","0	c #505050",
	"a	c #4C4C4C","b	c #464646","c	c #424142","d	c #3C3C3C","e	c #605F5F",
	"f	c #808080","g	c #787979","h	c #6E6E6E","i	c #343434","j	c #494949",
	"k	c #373737","l	c #303030","m	c #2A2A2A","n	c #3C3C3E","o	c #575757",
	"p	c #454545","q	c #525252","r	c #262626","s	c #181818","t	c #141414",
	"u	c #242424","v	c #101010","w	c #1F1F1F","x	c #383838","y	c #080808",
	"z	c #040404","A	c #0A0A0A","B	c #101111","C	c #1C1C1C","D	c #070707",
	"                                                                                                                             .+@#$%&*+.     ",
	"                                                                                                                          ***=-;>,')!~****  ",
	"                                                                                                                         **{]^/(_:<[}|*12** ",
	"                                                                                                                        *3*4+567890abc*de*f*",
	"*************************************************************************************************************************g*h*ihj5dkilm*#n*o*",
	"*************************************************************************************************************************p*|*mqlmr#~st*=u*%*",
	"                                                                                                                        *v*%*wxst=y.z@*@v*y*",
	"                                                                                                                         **A*BC+@********** ",
	"                                                                                                                          ****.***********  ",
	"                                                                                                                             D+******+D     "};

/* XPM */
static const char * switch_xpm[] = {
	"40 10 78 1",
	" 	c #444242",
	".	c #000000",
	"+	c #888989",
	"@	c #818181",
	"#	c #797979",
	"$	c #717171",
	"%	c #696969",
	"&	c #616161",
	"*	c #5A595A",
	"=	c #515151",
	"-	c #4A4A4A",
	";	c #28BB00",
	">	c #373737",
	",	c #1C1919",
	"'	c #868686",
	")	c #7E7E7E",
	"!	c #767676",
	"~	c #6E6E6E",
	"{	c #666666",
	"]	c #5E5E5F",
	"^	c #565656",
	"/	c #4F4E4F",
	"(	c #474747",
	"_	c #2DCF01",
	":	c #828383",
	"<	c #7B7B7B",
	"[	c #737373",
	"}	c #6B6B6B",
	"|	c #636364",
	"1	c #5B5B5B",
	"2	c #535353",
	"3	c #4B4C4B",
	"4	c #434344",
	"5	c #808080",
	"6	c #787878",
	"7	c #707070",
	"8	c #686968",
	"9	c #606060",
	"0	c #595858",
	"a	c #515050",
	"b	c #484949",
	"c	c #414140",
	"d	c #7D7D7D",
	"e	c #757575",
	"f	c #6D6E6D",
	"g	c #656566",
	"h	c #5D5E5E",
	"i	c #555655",
	"j	c #4E4D4E",
	"k	c #454646",
	"l	c #3E3E3E",
	"m	c #7B7A7A",
	"n	c #737372",
	"o	c #6A6A6A",
	"p	c #636362",
	"q	c #5B5A5B",
	"r	c #535352",
	"s	c #4B4B4A",
	"t	c #434342",
	"u	c #3B3B3B",
	"v	c #777778",
	"w	c #6F6F70",
	"x	c #686768",
	"y	c #5F605F",
	"z	c #575757",
	"A	c #504F50",
	"B	c #484848",
	"C	c #404040",
	"D	c #383838",
	"E	c #747475",
	"F	c #6D6C6C",
	"G	c #646464",
	"H	c #5D5D5D",
	"I	c #555555",
	"J	c #4D4D4D",
	"K	c #444545",
	"L	c #3D3D3D",
	"M	c #353535",
	"                                        ",
	" ........ +@#$%&*=-  ;;;;;;;;; ........ ",
	" .>>>,... ')!~{]^/(  ;_____;;; .>>>,... ",
	" .>>,.... :<[}|1234  ;___;;;;; .>>,.... ",
	" .>,..... 567890abc  ;__;;;;;; .>,..... ",
	" .,...... defghijkl  ;_;;;;;;; .,...... ",
	" ........ mnopqrstu  ;_;;;;;;; ........ ",
	" ........ vwxyzABCD  ;;;;;;;;; ........ ",
	" ........ EFGHIJKLM  ;;;;;;;;; ........ ",
	"                                        "};

/* XPM */
static const char * wheel_xpm[] = {
	"200 8 21 1",
	" 	c None",
	".	c #213E41",
	"+	c #1A4042",
	"@	c #044746",
	"#	c #1F403D",
	"$	c #124444",
	"%	c #263F3D",
	"&	c #2D3E3E",
	"*	c #333E3F",
	"=	c #094A49",
	"-	c #3B3F41",
	";	c #3F413F",
	">	c #444643",
	",	c #314E51",
	"'	c #484A47",
	")	c #4F514E",
	"!	c #535552",
	"~	c #575856",
	"{	c #5D5F5C",
	"]	c #636562",
	"^	c #676966",
	"^    ]    ]    {    {    {    ~    ~    !    )    )    '    '    >    >    ;    ;    ;    -    -    *    *    *    &    &    &    %    %    .    +    +    +    $    $    $    $    @    @    =    =   =",
	"^    ]    ]    {    {    {    ~    ~    !    )    )    '    '    >    >    ;    ;    ;    -    -    *    *    *    &    &    &    %    %    .    +    +    +    $    $    $    $    @    @    =    =   =",
	"^    ]    ]    {    {    {    ~    ~    !    )    )    '    '    >    >    ;    ;    -    -    *    *    *    *    &    &    &    %    %    %    +    +    +    $    $    $    $    @    @    @    =   =",
	"^    ]    ]    {    {    {    ~    ~    !    )    )    '    '    >    >    ;    ;    -    -    *    *    *    *    &    &    &    %    %    %    +    +    +    $    $    $    $    @    @    @    =   =",
	"^    ]    ]    {    {    {    ~    ~    !    )    )    '    '    >    >    ;    ;    -    -    *    *    *    *    &    &    &    %    %    %    #    +    +    $    $    $    $    @    @    @    =   =",
	"^    ]    ]    {    {    {    ~    !    !    )    )    '    '    >    >    ;    ;    ;    -    -    *    *    *    &    &    &    %    %    #    +    +    +    $    $    $    $    @    @    @    =   =",
	"^    ]    ]    {    {    {    ~    !    !    )    )    '    '    >    >    ;    ;    ;    -    -    *    *    *    &    &    &    %    %    #    +    +    +    $    $    $    $    @    @    @    =   =",
	"^    ]    ]    {    {    {    ~    !    !    )    )    '    '    >    >    ;    ;    ;    -    -    *    *    *    &    &    &    %    .    +    #    +    +    $    $    $    $    @    @    @    =   ="};

/* XPM */
static const char * wheel_s_xpm[] = {
	"40 8 21 1",
	" 	c None",
	".	c #252422",
	"+	c #353634",
	"@	c #484947",
	"#	c #575756",
	"$	c #5E5F5D",
	"%	c #686967",
	"&	c #737472",
	"*	c #80817F",
	"=	c #8D8D8C",
	"-	c #979896",
	";	c #A1A4A3",
	">	c #AEAEAD",
	",	c #B7B8B6",
	"'	c #C1C1BE",
	")	c #C9C9C6",
	"!	c #D3D4D2",
	"~	c #DDDFDD",
	"{	c #E7E9E6",
	"]	c #EEF0EE",
	"^	c #F9FBF7",
	"#$%&*=-;>')!~{^^]{~!)',>>;-=**&%$#@@++..",
	"#$%&*=-;>')!~{^^]{~!)',>>;-=**&%$#@@++..",
	"#$%&*=-;>,)!~{^^]{~!)',>;;-=**&%$#@@++..",
	"#$%&*=-;>,)!~{^^]{~!)',>;;-=**&%$#@@++..",
	"#$%&*=-;>,)!~{^^]{~!)),,>;-=**&%$#@@++..",
	"#$%&*=-;>,)!~{^^]{~!!),,>;-=**&%$#@@++..",
	"#$%&*=-;>,)!~{^^]{~!!),,>;-=**&%$#@@++..",
	"##%&*=-;>,)!~{^^]{~!!)',>;-=**&%$#@@++.."};


/* XPM */
static const char * pointer_xpm[] = {
	"2 8 2 1",
	" 	c None",
	".	c #2525A4",
	"..",
	"..",
	"..",
	"..",
	"..",
	"..",
	"..",
	".."};

/* XPM */
static const char * button_xpm[] = {
	"25 30 31 1",
	" 	c None",
	".	c #0F110E",
	"+	c #171211",
	"@	c #1C1817",
	"#	c #231F1E",
	"$	c #282423",
	"%	c #252A22",
	"&	c #2F2B2A",
	"*	c #242F25",
	"=	c #283B26",
	"-	c #3B3736",
	";	c #2F472A",
	">	c #474342",
	",	c #2A5927",
	"'	c #1F6624",
	")	c #585151",
	"!	c #2F642A",
	"~	c #625D5C",
	"{	c #6B6665",
	"]	c #3D813D",
	"^	c #726E6C",
	"/	c #7B7675",
	"(	c #7E7A78",
	"_	c #3E963A",
	":	c #379B33",
	"<	c #8A8584",
	"[	c #39A738",
	"}	c #42B839",
	"|	c #3ABD3D",
	"1	c #42BB43",
	"2	c #A79F9F",
	"         $&--&#@         ",
	"       ++$&--&#@++       ",
	"     .#)<2<<<(((>$@.     ",
	"    +>22/{/(//^^<^-#.    ",
	"   .^2({/((///((//^>@.   ",
	"  .)2~(//(((/((((//{-$.  ",
	" .@/<{//((((((((((/^>&+. ",
	" .&^^<//((((((((((/^>$@. ",
	" .+)<///((((((((((/~-#+. ",
	"  .-(^//((((((((//{>$@.  ",
	"   .-~^((((((((//~-$+.   ",
	"    +#-){^//^^{)>&#+.    ",
	"     .+#$&---&$$@@+.     ",
	"       +++++.+++++       ",
	"         +++++++         ",
	"         @@###@@         ",
	"       ..@@###@@..       ",
	"     .@%;]_[[[_];%@.     ",
	"    +*![1||}|}||1[!*+    ",
	"   +,:||}|||||||}||:,+   ",
	"  .=:1|}|||||||||}|1:=.  ",
	" .+,}}|||||||||||||}},+. ",
	" .#'|||||||||||||||||'#. ",
	" .+,}}|||||||||||||}},+. ",
	"  .=:1|}|||||||||}|1:=.  ",
	"   +,:||}|||||||}||:,+   ",
	"    +*![1||}|}||1[!*+    ",
	"     .@%;]_[[[_];%@.     ",
	"       ..@@###@@..       ",
	"         @@###@@         "};

/* XPM */
static const char * button1_xpm[] = {
	"25 30 31 1",
	" 	c None",
	".	c #020400",
	"+	c #0C0503",
	"@	c #080A06",
	"#	c #100A09",
	"$	c #140F0D",
	"%	c #181413",
	"&	c #1C1817",
	"*	c #221E1D",
	"=	c #262322",
	"-	c #2A2726",
	";	c #302C2B",
	">	c #34302F",
	",	c #393635",
	"'	c #403B3A",
	")	c #454140",
	"!	c #4C4746",
	"~	c #575251",
	"{	c #675D5D",
	"]	c #716C6B",
	"^	c #777271",
	"/	c #7E7A78",
	"(	c #857F7E",
	"_	c #898483",
	":	c #918C8B",
	"<	c #95908F",
	"[	c #999392",
	"}	c #9B9694",
	"|	c #A6A19F",
	"1	c #C3AFB2",
	"2	c #CFC3C3",
	"         *;',-&$         ",
	"       ++*;',-&$++       ",
	"     .&{|2||||<:!*$.     ",
	"    #~12::::}[(/}/'&.    ",
	"   @(2</:<<:::<<::(!$.   ",
	"  .{2][::<<<:<<<<::^>*.  ",
	" .#:|/::<<<<<<<<<<:(!=+. ",
	" .-(/}::<<<<<<<<<<:(!*#. ",
	" .@{}_::<<<<<<<<<<:]>&+. ",
	"  .'[(::<<<<<<<::_^!=@.  ",
	"   .>]_<<<<<<<<:_{'*@.   ",
	"    +&'~^(_:_/^{)-&@.    ",
	"     .#&*-,',;=*%$+.     ",
	"       ++###@++#++       ",
	"         ###@++#         ",
	"         $$%&%$$         ",
	"       ..$$%&%$$..       ",
	"     .$=']/(_(/]'=$.     ",
	"    +=~(|[[[[[[[|(~=+    ",
	"   +!/}[[[}[}[}[[[}/!+   ",
	"  .>^<[[[}}}}}}}[[[<^>.  ",
	" .@)<[[}}}}}}}}}}}[[<)@. ",
	" .&!}[[}}}}}}}}}}}[[}!&. ",
	" .@)<[[}}}}}}}}}}}[[<)@. ",
	"  .>^<[[[}}}}}}}[[[<^>.  ",
	"   +!/}[[[}[}[}[[[}/!+   ",
	"    +=~(|[[[[[[[|(~=+    ",
	"     .$=']/(_(/]'=$.     ",
	"       ..$$%&%$$..       ",
	"         $$%&%$$         "};

/* XPM */
static const char * eqslider1_xpm[] = {
"13 120 25 1",
" 	c None",
".	c #000200",
"+	c #060805",
"@	c #131413",
"#	c #282928",
"$	c #323432",
"%	c #3F403E",
"&	c #4B4C4B",
"*	c #575856",
"=	c #60615F",
"-	c #666765",
";	c #676866",
">	c #6E706E",
",	c #71716F",
"'	c #7B7B79",
")	c #00AD00",
"!	c #7E7F7D",
"~	c #878987",
"{	c #8F908E",
"]	c #9B9D9A",
"^	c #AAABA9",
"/	c #ACAEAB",
"(	c #00F210",
"_	c #B2B3B0",
":	c #B9BBB8",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"     ;..     ",
"   :_^^^~-   ",
"  ~__^{{!-=  ",
"  #+++++++@  ",
"  ~:_{!!-*&  ",
"  !~'=**%$$  ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())/    ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     ",
"     ())     "};

/* XPM */
static const char * eqslider_xpm[] = {
	"13 120 21 1",
	" 	c None",
	".	c #000200",
	"+	c #282927",
	"@	c #433F3E",
	"#	c #4F5252",
	"$	c #656664",
	"%	c #9B680C",
	"&	c #90720E",
	"*	c #8B7710",
	"=	c #857F14",
	"-	c #00AA00",
	";	c #7A8A11",
	">	c #719213",
	",	c #848485",
	"'	c #679B17",
	")	c #5CA718",
	"!	c #50B118",
	"~	c #4AB81B",
	"{	c #45BD19",
	"]	c #3CC51B",
	"^	c #25D816",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"    @...@    ",
	"  @@@@@@@@@  ",
	" @,,$#@+...@ ",
	"@@@#@+@.@.@@@",
	" @@+.......@ ",
	"  @@@@@@@@@  ",
	"    @-^-@    ",
	"    @-^-@    ",
	"    @-^-@    ",
	"    @-^-@    ",
	"    @-^-@    ",
	"    @-^-@    ",
	"    @-^-@    ",
	"    @-^-@    ",
	"    @-^-@    ",
	"    @-^-@    ",
	"    @-^-@    ",
	"    @-^-@    ",
	"    @-^-@    ",
	"    @-^-@    ",
	"    @-^-@    ",
	"    @-]-@    ",
	"    @-]-@    ",
	"    @-]-@    ",
	"    @-]-@    ",
	"    @-{-@    ",
	"    @-{-@    ",
	"    @-{-@    ",
	"    @-~-@    ",
	"    @-~-@    ",
	"    @-~-@    ",
	"    @-!-@    ",
	"    @-!-@    ",
	"    @-!-@    ",
	"    @-)-@    ",
	"    @-)-@    ",
	"    @-)-@    ",
	"    @-)-@    ",
	"    @-)-@    ",
	"    @-'-@    ",
	"    @-'-@    ",
	"    @-'-@    ",
	"    @-'-@    ",
	"    @->-@    ",
	"    @->-@    ",
	"    @->-@    ",
	"    @-;-@    ",
	"    @-;-@    ",
	"    @-;-@    ",
	"    @-=-@    ",
	"    @-=-@    ",
	"    @-=-@    ",
	"    @-=-@    ",
	"    @-=-@    ",
	"    @-*-@    ",
	"    @-*-@    ",
	"    @-&-@    ",
	"    @-&-@    ",
	"    @-&-@    ",
	"    @-%-@    ",
	"    @-%-@    ",
	"    @-%-@    ",
	"    @-%-@    "};


/* XPM */
static const char * led_xpm[] = {
"20 40 21 1",
" 	c None",
".	c #030702",
"+	c #0F0401",
"@	c #210403",
"#	c #540A07",
"$	c #7C0809",
"%	c #092E0C",
"&	c #2C221D",
"*	c #A4040D",
"=	c #D50D0F",
"-	c #434542",
";	c #784641",
">	c #1B6F15",
",	c #777A75",
"'	c #1C9E1D",
")	c #B08B87",
"!	c #24D11A",
"~	c #ABAFA9",
"{	c #3CFF36",
"]	c #8AFF82",
"^	c #C4FDB9",
"                    ",
"                    ",
"                    ",
"                    ",
"       ~~,-         ",
"     ~~~,,-&..      ",
"    ~~);$##@...     ",
"   ,,;*==###@+.     ",
"   ,;*=====$#@..    ",
"   -#=======$#@.    ",
"   -#=======*$@.    ",
"   &@=======**@.    ",
"   &@$======*$+.    ",
"   ..@*====*$@.     ",
"    .++$***$@+.     ",
"     ..+++++..      ",
"      ......        ",
"                    ",
"                    ",
"                    ",
"                    ",
"                    ",
"                    ",
"                    ",
"       ~~,-         ",
"     ~~~,,-&..      ",
"    ~~~,,--&...     ",
"   ,,,~^^>>>%..     ",
"   ,,~^^]]{'>%..    ",
"   --]^]]{{{'>&.    ",
"   --]]]{{{{!'%.    ",
"   &&]]{{{{{!!%.    ",
"   &&'{{{{{{!'%.    ",
"   ..&!{{{{!'%.     ",
"    ...'!!!'%..     ",
"     .........      ",
"      ......        ",
"                    ",
"                    ",
"                    "};

/* XPM */
static const char * rbutton_xpm[] = {
"22 46 26 1",
" 	c None",
".	c #000300",
"+	c #020230",
"@	c #2C052A",
"#	c #141513",
"$	c #380646",
"%	c #250D7B",
"&	c #022D01",
"*	c #222421",
"=	c #063031",
"-	c #132A8D",
";	c #A00E49",
">	c #E00D20",
",	c #3A3C39",
"'	c #EE1011",
")	c #484947",
"!	c #555654",
"~	c #686967",
"{	c #747673",
"]	c #00A608",
"^	c #80827F",
"/	c #8D8F8C",
"(	c #989A97",
"_	c #19E20A",
":	c #00F00C",
"<	c #C2C4C1",
"<!^^^^^^^^^^^^^^^^^^!<",
"!~~~~~~~~~~~~~~~~~~~~!",
",,,,,,,,,,,,,,,,,,,,,,",
"*....................*",
"*....................*",
"*....................*",
"*....................*",
"*....................*",
"*......%;'>;@........*",
"*.....@>''''>@.......*",
"*.....;'''''';.......*",
"*.....>''''''>+......*",
"*.....>''''''>.......*",
"*.....;'''''';.......*",
"*.....@>''''>@.......*",
"*......$;'>;@........*",
"*....................*",
"*....................*",
"*....................*",
"*....................*",
",********************,",
"!!!!!!!!!!!!!!!!!!!!!!",
"^{^^^^^^^^^^^^^^^^^^{^",
"<^<<<<<<<<<<<<<<<<<<^<",
"{(((((((((((((((((((({",
"!))))))))))))))))))))!",
"*....................*",
"#....................#",
"#....................#",
"#....................#",
"#....................#",
"#......-::_]&........#",
"#.....&_::::_&.......#",
"#.....]::::::].......#",
"#....._:::::::+......#",
"#....._::::::_.......#",
"#.....]::::::].......#",
"#.....&_::::_&.......#",
"#......=]:_]&........#",
"#....................#",
"#....................#",
"#....................#",
"#....................#",
",********************,",
"~{{{{{{{{{{{{{{{{{{{{~",
"/<<<<<<<<<<<<<<<<<<<</"};



/* XPM */
static const char * pbutton_xpm[] = {
"22 46 25 1",
" 	c #000100",
".	c #04051C",
"+	c #02005A",
"@	c #040438",
"#	c #0000AB",
"$	c #0B0D0A",
"%	c #0C0A2C",
"&	c #06028F",
"*	c #02076F",
"=	c #030A61",
"-	c #0802D6",
";	c #141513",
">	c #1300FC",
",	c #222321",
"'	c #393B38",
")	c #40423F",
"!	c #484947",
"~	c #545653",
"{	c #686967",
"]	c #747673",
"^	c #80827F",
"/	c #8D8F8C",
"(	c #989A96",
"_	c #17F10C",
":	c #C2C4C0",
":~^^^^^^^^^^^^^^^^^^~:",
"~{{{{{{{{{{{{{{{{{{{{~",
")'''''''''''''''''''')",
",$$$$$$$$$$$$$$$$$$$$,",
",                    ,",
",                    ,",
",                    ,",
",                    ,",
",      *#.           ,",
",      *>>*          ,",
",      *>>>-=        ,",
",      *>>>>>-@      ,",
",      *>>>>-@       ,",
",      *>>>=         ,",
",      *>&           ,",
",      %.            ,",
",                    ,",
",                    ,",
",                    ,",
",                    ,",
"',,,,,,,,,,,,,,,,,,,,'",
"~~~~~~~~~~~~~~~~~~~~~~",
"^]^^^^^^^^^^^^^^^^^^]^",
":^::::::::::::::::::^:",
"]((((((((((((((((((((]",
"~!!!!!!!!!!!!!!!!!!!!~",
",                    ,",
";                    ;",
";                    ;",
";                    ;",
";                    ;",
";      #_            ;",
";      #__-          ;",
";      #____&        ;",
";      #______@      ;",
";      #_____+       ;",
";      #___&         ;",
";      #_-           ;",
";      @.            ;",
";                    ;",
";                    ;",
";                    ;",
";                    ;",
"',,,,,,,,,,,,,,,,,,,,'",
"{]]]]]]]]]]]]]]]]]]]]{",
"/::::::::::::::::::::/"};

