// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************

// Copyright 2008, 2009, 2010, 2011 Guy Voncken
//
// This file is part of guymager.
//
// guymager is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// guymager is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with guymager. If not, see <http://www.gnu.org/licenses/>.

#ifndef __MAINWINDOW_H__
#define __MAINWINDOW_H__

#include <QtGui>  //lint !e537 repeated include

#ifndef __COMMON_H__
   #include "common.h"
#endif
#ifndef __DEVICE_H__
   #include "device.h"
#endif

class t_MainWindowLocal;

class t_MainWindow: public QMainWindow
{
   Q_OBJECT

   public:
      t_MainWindow (void);
      t_MainWindow (t_pDeviceList pDeviceList, QWidget *pParent = 0, Qt::WFlags Flags = 0);
     ~t_MainWindow ();

   APIRET RemoveSpecialDevice (t_pDevice pDevice);
   bool   AutoExit (void);

   private:
      APIRET CreateMenu (void);

   protected:
      void closeEvent (QCloseEvent *pEvent);

   private slots:
      void SlotAddSpecialDevice (void);
      void SlotDebug            (void);
      void SlotAboutGuymager    (void);
      void SlotAboutQt          (void);
      void SlotAutoExit         (void);
      void SlotScanFinished     (t_pDeviceList);
      void SlotRefresh          ();

   signals:
      void SignalAutoExit       (void);
      
   private:
      t_MainWindowLocal *pOwn;
};


// ------------------------------------
//             Error codes
// ------------------------------------

enum
{
   ERROR_MAINWINDOW_CONSTRUCTOR_NOT_SUPPORTED = ERROR_BASE_MAINWINDOW + 1,
   ERROR_MAINWINDOW_INVALID_COLUMN,
   ERROR_MAINWINDOW_INVALID_DATATYPE,
   ERROR_MAINWINDOW_DEVICE_NOT_FOUND
};


#endif

