/*
Gwenview - A simple image viewer for KDE
Copyright (C) 2000-2002 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef DIRVIEW_H
#define DIRVIEW_H

// QT includes
#include <qmap.h>

// KDE includes
#include <klistview.h>
#include <kfileitem.h>
#include <kurl.h>

namespace KIO {
	class Job;
}

class QPopupMenu;
class DirViewItem;
class KDirLister;
class QTimer;
typedef QList<KFileItem> KFileItemList;


class DirView : public KListView {
Q_OBJECT
	friend class DirViewItem;

public:
	DirView(QWidget* parent);
	~DirView();

public slots:
	void setFolder(QString folder);

signals:
	void folderChanged(QString folder);

protected:
	void contentsDragMoveEvent(QDragMoveEvent* event);
	void contentsDragLeaveEvent(QDragLeaveEvent* event);
	void contentsDropEvent(QDropEvent*);
	void startDrag();

private:
	KURL mURL;
	KDirLister* mDirLister;
	QPopupMenu* mPopupMenu;
	QMap<KFileItem*,DirViewItem*> mItemMap;
	QList<KFileItem> mNewDirQueue;
	QTimer* mNewDirTimer;
	QTimer* mAutoOpenTimer;
	DirViewItem* mDropTarget;

	void addDir(KFileItem* fileItem);
	DirViewItem* find(const KURL&) const;
	void removeViewItemFromItemMap(QListViewItem*);

private slots:
	void onSelectionChanged(QListViewItem*);
	void processNewDirQueue();

	void onNewItems(const KFileItemList&);
	void onDeleteItem(KFileItem*);
	void onRefreshItems(const KFileItemList& items);

	void onContextMenu(KListView*,QListViewItem*,const QPoint&);
	void makeDir();
	void renameDir();
	void removeDir();
	void showPropertiesDialog();

	void onDirMade(KIO::Job*);
	void onDirRenamed(KIO::Job*);
	void onDirRemoved(KIO::Job*);

	void autoOpenDropTarget();
};


#endif
