/*
 *  AttributesPanel.h: Interface and declarations for the AttributesPanel Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef ATTRIBUTESPANEL_H
#define ATTRIBUTESPANEL_H

#import <AppKit/NSView.h>
#include "InspectorsProtocol.h"

@class NSString;
@class NSArray;
@class NSDictionary;
@class NSImage;
@class NSTextField;
@class NSBox;
@class NSButton;
@class PermsBox;
@class TimeDateView;

@interface AttributesPanel : NSView <InspectorsProtocol>
{
	NSArray *insppaths;
	int pathscount;
	NSDictionary *attributes;
	BOOL iamRoot, isMyFile;
	NSString *currentPath;	
	NSImage *fileIcon, *multipleIcon;
	NSTextField *linktolabel;
	NSTextField *namefield, *pathfield, *linktofield;
	NSTextField *sizefield, *ownerfield, *groupfield;
	NSButton *calculateButt;
	PermsBox *permissionsBox;
	TimeDateView *timeDateView;
	NSTextField *yearlabel;
	NSBox *changedDateBox;
	NSButton *revertbutt, *okbutt;
	id fm;
	NSString *localizedStr;
}

- (void)computeSize:(id)sender;

- (void)permsButtonClicked;

- (void)changePermissions:(id)sender;

- (void)revertToOldPermissions:(id)sender;

@end

#endif // ATTRIBUTESPANEL_H
