/*  -*-objc-*-
 *  ContentsPanel.m: Implementation of the ContentsPanel Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "ContentsPanel.h"
#include "GenericContsView.h"
#include "Functions.h"
#include "Viewers/ContentViewersProtocol.h"
#include "GNUstep.h"

#define GENERIC_CONTS_INDEX [tabview numberOfTabViewItems] -2
#define NO_MULT_INDEX [tabview numberOfTabViewItems] -1

@implementation ContentsPanel

- (void)dealloc
{
	RELEASE (insppaths);
	RELEASE (currentPath);
	RELEASE (fileIcon);
	RELEASE (multipleIcon);
	RELEASE (namefield);
	RELEASE (pathfield);
	RELEASE (viewers);
	RELEASE (genericContsView);
	RELEASE (tabview);
	RELEASE (revertbutt);
	RELEASE (okbutt);		
  [super dealloc];
}

- (id)init
{	
	self = [super init];
	
	if(self) {
		NSArray *bundlesPaths;
		NSTabViewItem *item;
		id label, identifier;
		NSView *view;
		int i, index;

#define VERIFY_VIEWERS( x ) \
if (!x) { \
NSRunAlertPanel(NSLocalizedString(@"error", @""), \
NSLocalizedString(@"No Contents Inspectors found!", @""), \
NSLocalizedString(@"OK", @""), nil, nil); \
insppaths = nil; \
fileIcon = nil; \
return self; \
} 

		fm = [NSFileManager defaultManager];
		ws = [NSWorkspace sharedWorkspace];

		[self setFrame: NSMakeRect(0, 0, 274, 385)];	
					
		ASSIGN (multipleIcon, [NSImage imageNamed: @"MultipleSelection.tiff"]);    

		tabview = [[NSTabView alloc] initWithFrame: NSMakeRect(8, 40, 257, 245)];
		[tabview setTabViewType: NSNoTabsNoBorder];
		[tabview setAutoresizingMask: (NSViewWidthSizable | NSViewHeightSizable)];
  	[tabview setAutoresizesSubviews: YES];

		[tabview setDelegate: self];
  	[self addSubview: tabview];		

  	bundlesPaths = [[NSBundle mainBundle] pathsForResourcesOfType: @"bundle"
					      																			inDirectory: nil];
																											
		VERIFY_VIEWERS (bundlesPaths && [bundlesPaths count]);																								
		
		viewers = [[NSMutableArray alloc] initWithCapacity: 1];
		index = 0;
		
  	for (i = 0; i < [bundlesPaths count]; i++) {
			NSString *bpath = [bundlesPaths objectAtIndex: i];
			NSBundle *bundle = [NSBundle bundleWithPath: bpath]; 

			if (bundle != nil) {
				Class principalClass = [bundle principalClass];
				if ([principalClass conformsToProtocol: @protocol(ContentViewersProtocol)]) {	
					id <ContentViewersProtocol>vwr = [[principalClass alloc] initInPanel: self 
														withFrame: NSMakeRect(0, 0, 257, 245) index: index];
					[viewers addObject: vwr];
								
					identifier = [NSString string];				
	  			item = [[NSTabViewItem alloc] initWithIdentifier: (id)identifier];
					[item setView: vwr];
					RELEASE ((id)vwr);
  				[tabview addTabViewItem: item]; 
					RELEASE (item);
					[tabview resizeWithOldSuperviewSize: [tabview frame].size];
				
					index++;
				}
			}
		}
		
		VERIFY_VIEWERS ([viewers count]);																								
	
		view = [[NSView alloc] initWithFrame: NSMakeRect(0, 0, 257, 245)];		
		genericContsView = [[GenericContsView alloc] initWithFrame: NSMakeRect(2, 80, 253, 90)];
  	[genericContsView setMinSize: [genericContsView frame].size];
  	[genericContsView setMaxSize: [genericContsView frame].size];
  	[genericContsView setSelectable: YES];
  	[genericContsView setVerticallyResizable: NO];
  	[genericContsView setHorizontallyResizable: NO];
  	[[genericContsView textContainer] setContainerSize: [genericContsView frame].size];
		
		[view addSubview: genericContsView];
		
		identifier = [NSString stringWithString: @"genericConts"];
		item = [[NSTabViewItem alloc] initWithIdentifier: (id)identifier];
		[item setView: view];
		RELEASE (view);
		[tabview addTabViewItem: item];
		RELEASE (item);

		view = [[NSView alloc] initWithFrame: NSMakeRect(0, 0, 257, 245)];
		MAKE_LOCALIZED_LABEL (label, NSMakeRect(2, 103, 255, 65), @"No Contents Inspector\nFor Multiple Selection", @"", 'c', YES, view);		  
		[label setFont: [NSFont systemFontOfSize: 18]];
		[label setTextColor: [NSColor grayColor]];				
		identifier = [NSString string];
		item = [[NSTabViewItem alloc] initWithIdentifier: (id)identifier];
		[item setView: view];
		RELEASE (view);
		[tabview addTabViewItem: item];
		RELEASE (item);	
		
		MAKE_LABEL (namefield, NSMakeRect(66, 343, 200, 25), nil, 'l', NO, self);		  
		[namefield setFont: [NSFont systemFontOfSize: 18]];
		MAKE_LOCALIZED_LABEL (label, NSMakeRect(9, 301, 40, 20),  @"Path:", @"", 'l', YES, self);		  
		MAKE_LABEL (pathfield, NSMakeRect(44, 301, 215, 20), nil, 'l', NO, self);		  
		
		revertbutt = [[NSButton alloc] initWithFrame: NSMakeRect(17, 10, 115, 24)];
		[revertbutt setButtonType: NSMomentaryLight];
		[revertbutt setTitle: NSLocalizedString(@"Revert", @"")];	
		[revertbutt setEnabled: NO];	
		[self addSubview: revertbutt]; 
				
		okbutt = [[NSButton alloc] initWithFrame: NSMakeRect(140, 10, 115, 24)];
		[okbutt setButtonType: NSMomentaryLight];
		[okbutt setTitle: NSLocalizedString(@"OK", @"")];	
		[okbutt setKeyEquivalent: @"\r"];
		[okbutt setImagePosition: NSImageRight];
		[okbutt setImage: [NSImage imageNamed: @"common_ret"]];	
		[okbutt setEnabled: NO];
		[self addSubview: okbutt]; 
		
		insppaths = nil;
		fileIcon = nil;
	}
	return self;
}

- (void)activateForPaths:(NSArray *)paths
{
	id viewer;
	NSString *s;
	NSWindow *win;
	
	if ([paths isEqualToArray: insppaths] == YES) {
		return;
  }
  
	ASSIGN (insppaths, paths);
	pathscount = [insppaths count];
	ASSIGN (currentPath, [insppaths objectAtIndex: 0]);

	if (pathscount == 1) {   // Single Selection
		ASSIGN (fileIcon, [ws iconForFile: currentPath]);
		[namefield setStringValue: [currentPath lastPathComponent]];
		s = [currentPath stringByDeletingLastPathComponent];
		s = relativePathFittingInContainer(pathfield, s);
		[pathfield setStringValue: s];
		
		viewer = [self viewerForFileAtPath: currentPath];
		if (viewer != nil) {
			[viewer activateForPath: currentPath];
			[tabview selectTabViewItemAtIndex: [viewer index]];			
			winName = [viewer winname];
		} else {		
			[genericContsView findContentsAtPath: [insppaths objectAtIndex: 0]];
			[tabview selectTabViewItemAtIndex: GENERIC_CONTS_INDEX];
			winName = NSLocalizedString(@"Contents Inspector", @"");
		}
		
	} else {	   // Multiple Selection
		ASSIGN (fileIcon, multipleIcon);		
		[namefield setStringValue: [NSString stringWithFormat: @"%i items", pathscount]];
		s = [currentPath stringByDeletingLastPathComponent];
		s = relativePathFittingInContainer(pathfield, s);
		[pathfield setStringValue: s];
		[tabview selectTabViewItemAtIndex: NO_MULT_INDEX];
		winName = NSLocalizedString(@"Contents Inspector", @"");
	}
	
	win = [self window];	
	[win setTitle: winName];
	[self setNeedsDisplay: YES];
	[tabview setNeedsDisplay: YES];
}

- (void)deactivate
{
	[self removeFromSuperview];
}

- (NSString *)inspname
{
	return NSLocalizedString(@"Contents", @"");
}

- (NSString *)winname
{
	return winName;
}

- (id)viewerForFileAtPath:(NSString *)path
{
	NSString *defApp, *fileType, *extension;
	int i;
		
	[ws getInfoForFile: path application: &defApp type: &fileType];
	extension = [path pathExtension];
	
	for (i = 0; i < [viewers count]; i++) {
		id vwr = [viewers objectAtIndex: i];
		if([vwr canDisplayFileOfType: fileType nameExtension: extension] == NO) {
			continue;
    }
		return vwr;
	}

	return nil;
}

- (NSButton *)revertButton
{
	return revertbutt;
}

- (NSButton *)okButton
{
	return okbutt;
}

- (void)drawRect:(NSRect)rect
{
	STROKE_LINE (darkGrayColor, 0, 385, 274, 385);
	STROKE_LINE (whiteColor, 0, 384, 274, 384);

	if(fileIcon != nil) {
		[fileIcon compositeToPoint: NSMakePoint(8, 325) operation: NSCompositeSourceOver];
	}
	
	STROKE_LINE (darkGrayColor, 0, 294, 274, 294);
	STROKE_LINE (whiteColor, 0, 293, 274, 293);
}

//
// NSTabView delegate Methods
//
- (BOOL)tabView:(NSTabView *)tabView shouldSelectTabViewItem:(NSTabViewItem *)tabViewItem
{
  return YES;
}

- (void)tabView:(NSTabView *)tabView willSelectTabViewItem:(NSTabViewItem *)tabViewItem
{
}

- (void)tabView:(NSTabView *)tabView didSelectTabViewItem:(NSTabViewItem *)tabViewItem
{
}

- (void)tabViewDidChangeNumberOfTabViewItems:(NSTabView *)TabView
{
}

@end
