/*
 *  Interface and declarations for the IconViewsPrefsView Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef ICONVIEWSPREFERENCES_H
#define ICONVIEWSPREFERENCES_H

#import <AppKit/NSView.h>

typedef enum { 
	leftarrow,
	rightarrow
} ArrowPosition;

@class NSString;
@class NSNotification;
@class NSEvent;
@class NSImage;
@class NSTextField;
@class NSTextFieldCell;
@class NSButton;
@class NSWorkspace;
@class GWorkspace;

@interface ArrowResizer : NSView
{
  NSImage *arrow;
  ArrowPosition position;
  id prefview;
}

- (id)initWithPosition:(ArrowPosition)pos inPrefView:(id)view;

- (ArrowPosition)position;

@end

@interface IconViewsPrefsView : NSView
{
  NSImage *icon;
  NSTextField *nameField;
  NSString *fname;
  ArrowResizer *leftResizer, *rightResizer;
  NSTextFieldCell *cell;
  NSButton *setButt;
  int cellsWidth;
	NSWorkspace *ws;
  GWorkspace *gw;  
}

- (NSString *)prefsname;

- (void)resizeParts;

- (void)selectionChanged:(NSNotification *)n;

- (void)mouseDown:(NSEvent *)theEvent onResizer:(ArrowResizer *)resizer;

- (void)setNewWidth:(int)w;

- (void)setDefaultWidth:(id)sender;

@end

#endif // ICONVIEWSPREFERENCES_H
