 /*  -*-objc-*-
 *  PreferencesWin.m: Implementation of the PreferencesWin Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "PreferencesWin.h"
#include "DefaultEditor.h"
#include "DefaultXTerm.h"
#include "DefaultSortType.h"
#include "ViewersPreferences.h"
#include "IconViewsPreferences.h"
#include "ShelfPreferences.h"
#include "BrowserViewsPreferences.h"
#include "DesktopPreferences.h"
#include "GWorkspace.h"
#include "Functions.h"
#include "GNUstep.h"

@implementation MainView

- (void)drawRect:(NSRect)rect
{
  NSRect r = [self frame];
	[super drawRect: rect];

	STROKE_LINE (darkGrayColor, 0, r.size.height - 30, 
																r.size.width, r.size.height - 30);
	STROKE_LINE (whiteColor, 0, r.size.height - 31, 
																r.size.width, r.size.height - 31);
}

@end

@implementation PreferencesWin

- (void)dealloc
{
	RELEASE (prefsViews);
	RELEASE (popUp);
	RELEASE (mainView);
  [super dealloc];
}

- (id)init
{
#define ADD_PREF_VIEW(c) \
currPrefView = [[c alloc] init]; \
[popUp addItemWithTitle: [currPrefView prefsname]]; \
[prefsViews addObject: currPrefView]; \
RELEASE (currPrefView)
        
	self = [super initWithContentRect: NSZeroRect
						    styleMask: NSTitledWindowMask | NSClosableWindowMask 
				  							      backing: NSBackingStoreBuffered defer: NO];
	if(self) {
		NSRect r;

    if ([self setFrameUsingName: @"preferencesWin"] == NO) {
      [self setFrame: NSMakeRect(100, 100, 396, 310) display: NO];
    }

  	[self setTitle: NSLocalizedString(@"GWorkspace Preferences", @"")];
		[self setReleasedWhenClosed: NO];

    r = [[self contentView] frame];
		mainView = [[MainView alloc] initWithFrame: r];			

		popUp = [[NSPopUpButton alloc] initWithFrame: NSZeroRect pullsDown: NO];
    [popUp setFrame: NSMakeRect((r.size.width - 150) / 2, (r.size.height - 25), 150, 20)];	
 		[popUp setTarget: self];
		[popUp setAction: @selector(activatePrefView:)];

		[mainView addSubview: popUp];    
		[self setContentView: mainView];

		prefsViews = [[NSMutableArray alloc] initWithCapacity: 1];

		ADD_PREF_VIEW ([DefaultEditorView class]);
		ADD_PREF_VIEW ([DefaultXTermView class]);
		ADD_PREF_VIEW ([DefaultSortTypeView class]);		
		ADD_PREF_VIEW ([ViewersPrefsView class]);
		ADD_PREF_VIEW ([IconViewsPrefsView class]);
		ADD_PREF_VIEW ([ShelfPrefsView class]);
		ADD_PREF_VIEW ([BrowserViewsPrefsView class]);
		ADD_PREF_VIEW ([DesktopPrefsView class]);
    
		currPrefView = nil;
		
		[popUp selectItemAtIndex: 0];
		[self activatePrefView: popUp];
	}
	
	return self;
}

- (void)activate
{
  [self orderFront: nil];
}

- (void)activatePrefView:(id)sender
{
	NSString *prefsname = [popUp titleOfSelectedItem];
	int i;
	
	if(currPrefView != nil) {
		if([[currPrefView prefsname] isEqualToString: prefsname] == YES) {
			return;
    }
    [currPrefView removeFromSuperview];
	}
	
	for (i = 0; i < [prefsViews count]; i++) {
		id prefsview = [prefsViews objectAtIndex: i];		
		if([[prefsview prefsname] isEqualToString: prefsname]) {
			currPrefView = prefsview;
			break;
		}
	}

  [mainView addSubview: currPrefView];  
  [currPrefView setFrame: NSMakeRect(0, 0, [mainView frame].size.width, 270)];	  
  [currPrefView setNeedsDisplay: YES];	
	[self orderFrontRegardless];  
}

- (void)updateDefaults
{
  [self saveFrameUsingName: @"preferencesWin"];
}

- (void)close
{
  [self updateDefaults];
	[super close];
  [[GWorkspace gworkspace] closePreferences];
}

@end
