module:      operating-system
author:      Tom Emerson, tree@tiac.net
             [based on unattributed previous work]
copyright:   Copyright 1999 Thomas R. Emerson
synopsis:    Constant definitions containing information about the software
             and hardware installed on the host machine.
note:        This file is generated by gen-makefile from Makegen.

/*
   Copyright (C) 1999 Thomas R. Emerson

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA  02111-1307, USA.

   Bug reports, questions, comments, and suggestions should be sent by
   E-mail to the Internet address "gd-bugs@gwydiondylan.org".
*/

//
// The semantics of these constants are taken from the documentation for
// the operating-system library in Harlequin Dylan 1.2:
//
// http://www.harlequin.com/products/ads/dylan/doc12/io/io_222.htm
//
// The HQN documentation does not specify the types of $machine-name and
// $os-name, though HD 1.2 returns a <symbol> for each.
//
// Note that the value of $architecture-little-endian? is computed during
// configuration. It is not taken from the platforms.descr for the target
// architecture. This should not be a problem, but it is worth documenting
// this possible cause of conflicting values.
//
define constant $architecture-little-endian? = #t;
define constant $machine-name = #"i586";
define constant $os-name = #"Linux";
define constant $os-variant = #"Linux";
define constant $os-version = "2.4.17";
define constant $platform-name = #"i586-Linux";
