/**
 *
 * @file     xmmsctrl.h
 * @author   Aleix Conchillo Flaque <aleix@member.fsf.org>
 * @date     Thu Aug 07, 2003 21:20
 * @brief    XMMS GNOME applet control functions
 *
 * $Id: xmmsctrl.h,v 1.3 2004/09/02 22:19:54 aleix Exp $
 *
 * @if copyright
 *
 * Copyright (C) 2003, 2004 Aleix Conchillo Flaque
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * @endif
 */


#ifndef XMMSCTRL_H_ALEIX0308072120
#define XMMSCTRL_H_ALEIX0308072120

#include "types.h"


void xmms_start(XMMSData *xmms);

void xmms_prev(XMMSData *xmms);

void xmms_play_pause(XMMSData *xmms);

void xmms_stop(XMMSData *xmms);

void xmms_next(XMMSData *xmms);

void xmms_eject(XMMSData *xmms);

void xmms_seek(XMMSData *xmms, gdouble t);

void xmms_repeat(XMMSData *xmms, gboolean active);

void xmms_shuffle(XMMSData *xmms, gboolean active);

void xmms_main_win(XMMSData *xmms);

void xmms_pl_win(XMMSData *xmms);

void xmms_eq_win(XMMSData *xmms);

void xmms_show_hide(XMMSData *xmms);

void xmms_preferences(XMMSData *xmms);

void xmms_lower_volume(XMMSData *xmms);

void xmms_raise_volume(XMMSData *xmms);

#endif /* XMMSCTRL_H_ALEIX0308072120 */
