/* -*- C++ -*- */

#ifndef _TIMEHEAP_H
#define _TIMEHEAP_H

#include <stdio.h>
#include <windows.h>

#include "timer.h"

// Routine to read Pentium time stamp counter
#if 1
#if 0
_inline _declspec( naked ) __int64 RDTSC()
{
	_asm RDTSC
	_asm ret
}
#endif

class MyTimer {
public:
	MyTimer (void)
		: counter (0)
	{}

	inline void start (void) {
		currentCounter = RDTSC();
	}
	inline void stop (void) {
		counter += (RDTSC() - currentCounter);
	}
	operator double (void) {
		return (double) counter / ((double) 600.0 * 1e6);
	}
private:
	__int64 counter;
	__int64 currentCounter;
};
#endif

#if 0
#include <process.h>
#endif

template <class SuperHeap>
class TimeHeap : public SuperHeap {
public:

  ~TimeHeap (void) {
#if 1
	  char fname[255];
	  sprintf (fname, "memops-%d", GetCurrentProcessId());
	  FILE * f = fopen (fname, "w+");
	  fprintf (f, "Time spent in memory operations = %f\n", (double) t);
	fflush (f);
	  fclose (f);
#else
	  FILE * f = stderr;
	  fprintf (f, "Time spent in memory operations = %f\n", (double) t);
	fflush (f);
#endif
  }

  inline void * malloc (size_t sz) {
    t.start();
    void * ptr = SuperHeap::malloc (sz);
    t.stop();
    return ptr;
  }
    
  inline void free (void * ptr) {
    t.start();
    SuperHeap::free (ptr);
    t.stop();
  }

private:
  MyTimer t;
};


#endif
