-- do not edit; automatically generated by UU.AG
module KindInferencing where

import Top.Types
import Top.Solver.Greedy
import Top.Solver
import Top.Constraint.Information
import TypeConstraints
import UHA_Syntax
import Args
import qualified Data.Map as M
import TypeConstraints
import Utils (internalError)
import TopSort (topSort)
import ImportEnvironment hiding (setTypeSynonyms)
import KindErrors
import Char (isLower)
import BindingGroupAnalysis (Assumptions, PatternAssumptions, noAssumptions, combine, single) 

type KindEnvironment = M.Map Name TpScheme
type KindConstraint  = TypeConstraint  KindError
type KindConstraints = TypeConstraints KindError

type BindingGroups = [BindingGroup]
type BindingGroup  = (PatternAssumptions,Assumptions,KindConstraints)

combineBindingGroup :: BindingGroup -> BindingGroup -> BindingGroup
combineBindingGroup (e1,a1,c1) (e2,a2,c2) = (e1 `M.union` e2,a1 `combine` a2,c1++c2)

concatBindingGroups :: BindingGroups -> BindingGroup
concatBindingGroups = foldr combineBindingGroup emptyBindingGroup

emptyBindingGroup :: BindingGroup
emptyBindingGroup = (noAssumptions, noAssumptions, [])

performBindingGroup :: BindingGroups -> (PatternAssumptions, Assumptions, KindConstraints)
performBindingGroup = glueGroups . bindingGroupAnalysis    
   where   
      bindingGroupAnalysis :: BindingGroups -> BindingGroups
      bindingGroupAnalysis cs
         = let indexMap = concat (zipWith f cs [0..])
               f (env,_,_) i = [ (n,i) | n <- M.keys env ]
               edges    = concat (zipWith f' cs [0..])
               f' (_,ass,_) i = [ (i,j)| n <- M.keys ass, (n',j) <- indexMap, n==n' ]
               list = topSort (length cs-1) edges
           in map (concatBindingGroups . map (cs !!)) list
           
      glueGroups :: BindingGroups -> (PatternAssumptions, Assumptions, KindConstraints)
      glueGroups = foldr op (noAssumptions, noAssumptions, []) 
         where
            op (env, aset, cset) (environment, assumptions, constraints) = 
               let (cset1,aset')        = (env .===. aset)            (\n -> unexpected $ "BindingGroup.same "++show n)
                   (cset2,assumptions') = (!<==!) [] env assumptions  (\n -> unexpected $ "BindingGroup.instance "++show n)
               in ( env `M.union` environment
                  , aset' `combine` assumptions'
                  , cset1 ++ cset ++ cset2 ++ constraints
                  )             

getKindsFromImportEnvironment :: ImportEnvironment -> KindEnvironment
getKindsFromImportEnvironment = M.map f . typeConstructors
   where f i = generalizeAll ([] .=>. foldr (.->.) star (replicate i star))

getTypeVariables :: Assumptions -> Names
getTypeVariables = filter p . M.keys
   where p n = case show n of
                  []  -> False
                  c:_ -> isLower c

unexpected :: String -> KindError
unexpected msg = 
   internalError "KindInferencing.ag" "unexpected" ("unexpected kind error: "++msg)

instance TypeConstraintInfo KindError
instance PolyTypeConstraintInfo KindError

(<==>) :: Kind -> Kind -> ((Kind, Kind) -> KindError) -> KindConstraint
(k1 <==> k2) info = (k1 .==. k2) (info (k1, k2))
-- Alternative -------------------------------------------------
-- semantic domain
type T_Alternative = (BindingGroups) ->
                     (Int) ->
                     ( (BindingGroups),(Int),(Alternative))
-- cata
sem_Alternative :: (Alternative) ->
                   (T_Alternative)
sem_Alternative ((Alternative_Alternative (_range) (_pattern) (_righthandside))) =
    (sem_Alternative_Alternative ((sem_Range (_range))) ((sem_Pattern (_pattern))) ((sem_RightHandSide (_righthandside))))
sem_Alternative ((Alternative_Empty (_range))) =
    (sem_Alternative_Empty ((sem_Range (_range))))
sem_Alternative_Alternative :: (T_Range) ->
                               (T_Pattern) ->
                               (T_RightHandSide) ->
                               (T_Alternative)
sem_Alternative_Alternative (range_) (pattern_) (righthandside_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Alternative)
            _rangeIself :: (Range)
            _patternIself :: (Pattern)
            _righthandsideIbindingGroups :: (BindingGroups)
            _righthandsideIkappaUnique :: (Int)
            _righthandsideIself :: (RightHandSide)
            _righthandsideObindingGroups :: (BindingGroups)
            _righthandsideOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _patternIself) =
                (pattern_ )
            ( _righthandsideIbindingGroups,_righthandsideIkappaUnique,_righthandsideIself) =
                (righthandside_ (_righthandsideObindingGroups) (_righthandsideOkappaUnique))
            (_self@_) =
                Alternative_Alternative _rangeIself _patternIself _righthandsideIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _righthandsideIbindingGroups
            (_lhsOkappaUnique@_) =
                _righthandsideIkappaUnique
            (_righthandsideObindingGroups@_) =
                _lhsIbindingGroups
            (_righthandsideOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Alternative_Empty :: (T_Range) ->
                         (T_Alternative)
sem_Alternative_Empty (range_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Alternative)
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_self@_) =
                Alternative_Empty _rangeIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- Alternatives ------------------------------------------------
-- semantic domain
type T_Alternatives = (BindingGroups) ->
                      (Int) ->
                      ( (BindingGroups),(Int),(Alternatives))
-- cata
sem_Alternatives :: (Alternatives) ->
                    (T_Alternatives)
sem_Alternatives (list) =
    (Prelude.foldr (sem_Alternatives_Cons) (sem_Alternatives_Nil) ((Prelude.map sem_Alternative list)))
sem_Alternatives_Cons :: (T_Alternative) ->
                         (T_Alternatives) ->
                         (T_Alternatives)
sem_Alternatives_Cons (hd_) (tl_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Alternatives)
            _hdIbindingGroups :: (BindingGroups)
            _hdIkappaUnique :: (Int)
            _hdIself :: (Alternative)
            _hdObindingGroups :: (BindingGroups)
            _hdOkappaUnique :: (Int)
            _tlIbindingGroups :: (BindingGroups)
            _tlIkappaUnique :: (Int)
            _tlIself :: (Alternatives)
            _tlObindingGroups :: (BindingGroups)
            _tlOkappaUnique :: (Int)
            ( _hdIbindingGroups,_hdIkappaUnique,_hdIself) =
                (hd_ (_hdObindingGroups) (_hdOkappaUnique))
            ( _tlIbindingGroups,_tlIkappaUnique,_tlIself) =
                (tl_ (_tlObindingGroups) (_tlOkappaUnique))
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _tlIbindingGroups
            (_lhsOkappaUnique@_) =
                _tlIkappaUnique
            (_hdObindingGroups@_) =
                _lhsIbindingGroups
            (_hdOkappaUnique@_) =
                _lhsIkappaUnique
            (_tlObindingGroups@_) =
                _hdIbindingGroups
            (_tlOkappaUnique@_) =
                _hdIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Alternatives_Nil :: (T_Alternatives)
sem_Alternatives_Nil  =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Alternatives)
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- AnnotatedType -----------------------------------------------
-- semantic domain
type T_AnnotatedType = (KindConstraints) ->
                       (Int) ->
                       ( (Assumptions),(KindConstraints),(Kind),(Int),(AnnotatedType))
-- cata
sem_AnnotatedType :: (AnnotatedType) ->
                     (T_AnnotatedType)
sem_AnnotatedType ((AnnotatedType_AnnotatedType (_range) (_strict) (_type))) =
    (sem_AnnotatedType_AnnotatedType ((sem_Range (_range))) (_strict) ((sem_Type (_type))))
sem_AnnotatedType_AnnotatedType :: (T_Range) ->
                                   (Bool) ->
                                   (T_Type) ->
                                   (T_AnnotatedType)
sem_AnnotatedType_AnnotatedType (range_) (strict_) (type_) =
    \ _lhsIconstraints
      _lhsIkappaUnique ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOconstraints :: (KindConstraints)
            _lhsOkappa :: (Kind)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (AnnotatedType)
            _rangeIself :: (Range)
            _typeIassumptions :: (Assumptions)
            _typeIconstraints :: (KindConstraints)
            _typeIkappa :: (Kind)
            _typeIkappaUnique :: (Int)
            _typeIself :: (Type)
            _typeOconstraints :: (KindConstraints)
            _typeOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _typeIassumptions,_typeIconstraints,_typeIkappa,_typeIkappaUnique,_typeIself) =
                (type_ (_typeOconstraints) (_typeOkappaUnique))
            (_newConstraint@_) =
                (_typeIkappa <==> star) (mustBeStar _rangeIself "data type declaration" _typeIself)
            (_lhsOconstraints@_) =
                _typeIconstraints ++ [_newConstraint]
            (_self@_) =
                AnnotatedType_AnnotatedType _rangeIself strict_ _typeIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _typeIassumptions
            (_lhsOkappa@_) =
                _typeIkappa
            (_lhsOkappaUnique@_) =
                _typeIkappaUnique
            (_typeOconstraints@_) =
                _lhsIconstraints
            (_typeOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsOassumptions,_lhsOconstraints,_lhsOkappa,_lhsOkappaUnique,_lhsOself)
-- AnnotatedTypes ----------------------------------------------
-- semantic domain
type T_AnnotatedTypes = (KindConstraints) ->
                        (Int) ->
                        ( (Assumptions),(KindConstraints),(Int),(Kinds),(AnnotatedTypes))
-- cata
sem_AnnotatedTypes :: (AnnotatedTypes) ->
                      (T_AnnotatedTypes)
sem_AnnotatedTypes (list) =
    (Prelude.foldr (sem_AnnotatedTypes_Cons) (sem_AnnotatedTypes_Nil) ((Prelude.map sem_AnnotatedType list)))
sem_AnnotatedTypes_Cons :: (T_AnnotatedType) ->
                           (T_AnnotatedTypes) ->
                           (T_AnnotatedTypes)
sem_AnnotatedTypes_Cons (hd_) (tl_) =
    \ _lhsIconstraints
      _lhsIkappaUnique ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOconstraints :: (KindConstraints)
            _lhsOkappaUnique :: (Int)
            _lhsOkappas :: (Kinds)
            _lhsOself :: (AnnotatedTypes)
            _hdIassumptions :: (Assumptions)
            _hdIconstraints :: (KindConstraints)
            _hdIkappa :: (Kind)
            _hdIkappaUnique :: (Int)
            _hdIself :: (AnnotatedType)
            _hdOconstraints :: (KindConstraints)
            _hdOkappaUnique :: (Int)
            _tlIassumptions :: (Assumptions)
            _tlIconstraints :: (KindConstraints)
            _tlIkappaUnique :: (Int)
            _tlIkappas :: (Kinds)
            _tlIself :: (AnnotatedTypes)
            _tlOconstraints :: (KindConstraints)
            _tlOkappaUnique :: (Int)
            ( _hdIassumptions,_hdIconstraints,_hdIkappa,_hdIkappaUnique,_hdIself) =
                (hd_ (_hdOconstraints) (_hdOkappaUnique))
            ( _tlIassumptions,_tlIconstraints,_tlIkappaUnique,_tlIkappas,_tlIself) =
                (tl_ (_tlOconstraints) (_tlOkappaUnique))
            (_lhsOkappas@_) =
                _hdIkappa : _tlIkappas
            (_lhsOassumptions@_) =
                _hdIassumptions `combine` _tlIassumptions
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOconstraints@_) =
                _tlIconstraints
            (_lhsOkappaUnique@_) =
                _tlIkappaUnique
            (_hdOconstraints@_) =
                _lhsIconstraints
            (_hdOkappaUnique@_) =
                _lhsIkappaUnique
            (_tlOconstraints@_) =
                _hdIconstraints
            (_tlOkappaUnique@_) =
                _hdIkappaUnique
        in  ( _lhsOassumptions,_lhsOconstraints,_lhsOkappaUnique,_lhsOkappas,_lhsOself)
sem_AnnotatedTypes_Nil :: (T_AnnotatedTypes)
sem_AnnotatedTypes_Nil  =
    \ _lhsIconstraints
      _lhsIkappaUnique ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOconstraints :: (KindConstraints)
            _lhsOkappaUnique :: (Int)
            _lhsOkappas :: (Kinds)
            _lhsOself :: (AnnotatedTypes)
            (_lhsOkappas@_) =
                []
            (_lhsOassumptions@_) =
                noAssumptions
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOconstraints@_) =
                _lhsIconstraints
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsOassumptions,_lhsOconstraints,_lhsOkappaUnique,_lhsOkappas,_lhsOself)
-- Body --------------------------------------------------------
-- semantic domain
type T_Body = (ImportEnvironment) ->
              (Int) ->
              ( (KindConstraints),(PatternAssumptions),(Int),(Body))
-- cata
sem_Body :: (Body) ->
            (T_Body)
sem_Body ((Body_Body (_range) (_importdeclarations) (_declarations))) =
    (sem_Body_Body ((sem_Range (_range))) ((sem_ImportDeclarations (_importdeclarations))) ((sem_Declarations (_declarations))))
sem_Body_Body :: (T_Range) ->
                 (T_ImportDeclarations) ->
                 (T_Declarations) ->
                 (T_Body)
sem_Body_Body (range_) (importdeclarations_) (declarations_) =
    \ _lhsIimportEnvironment
      _lhsIkappaUnique ->
        let _lhsOconstraints :: (KindConstraints)
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Body)
            _rangeIself :: (Range)
            _importdeclarationsIself :: (ImportDeclarations)
            _declarationsIbindingGroups :: (BindingGroups)
            _declarationsIkappaUnique :: (Int)
            _declarationsIself :: (Declarations)
            _declarationsObindingGroups :: (BindingGroups)
            _declarationsOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _importdeclarationsIself) =
                (importdeclarations_ )
            ( _declarationsIbindingGroups,_declarationsIkappaUnique,_declarationsIself) =
                (declarations_ (_declarationsObindingGroups) (_declarationsOkappaUnique))
            (_kindEnvironment@_) =
                getKindsFromImportEnvironment _lhsIimportEnvironment
            (_newConstraints@_) =
                fst $ (_kindEnvironment .:::. _aset) (\n -> unexpected $ "Body.Body " ++ show n)
            ((_environment@_,_aset@_,_cs@_)) =
                performBindingGroup _declarationsIbindingGroups
            (_lhsOconstraints@_) =
                _newConstraints ++ _cs
            (_declarationsObindingGroups@_) =
                []
            (_self@_) =
                Body_Body _rangeIself _importdeclarationsIself _declarationsIself
            (_lhsOself@_) =
                _self
            (_lhsOenvironment@_) =
                _environment
            (_lhsOkappaUnique@_) =
                _declarationsIkappaUnique
            (_declarationsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsOconstraints,_lhsOenvironment,_lhsOkappaUnique,_lhsOself)
-- Constructor -------------------------------------------------
-- semantic domain
type T_Constructor = (KindConstraints) ->
                     (Int) ->
                     ( (Assumptions),(KindConstraints),(Int),(Constructor))
-- cata
sem_Constructor :: (Constructor) ->
                   (T_Constructor)
sem_Constructor ((Constructor_Constructor (_range) (_constructor) (_types))) =
    (sem_Constructor_Constructor ((sem_Range (_range))) ((sem_Name (_constructor))) ((sem_AnnotatedTypes (_types))))
sem_Constructor ((Constructor_Infix (_range) (_leftType) (_constructorOperator) (_rightType))) =
    (sem_Constructor_Infix ((sem_Range (_range))) ((sem_AnnotatedType (_leftType))) ((sem_Name (_constructorOperator))) ((sem_AnnotatedType (_rightType))))
sem_Constructor ((Constructor_Record (_range) (_constructor) (_fieldDeclarations))) =
    (sem_Constructor_Record ((sem_Range (_range))) ((sem_Name (_constructor))) ((sem_FieldDeclarations (_fieldDeclarations))))
sem_Constructor_Constructor :: (T_Range) ->
                               (T_Name) ->
                               (T_AnnotatedTypes) ->
                               (T_Constructor)
sem_Constructor_Constructor (range_) (constructor_) (types_) =
    \ _lhsIconstraints
      _lhsIkappaUnique ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOconstraints :: (KindConstraints)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Constructor)
            _rangeIself :: (Range)
            _constructorIself :: (Name)
            _typesIassumptions :: (Assumptions)
            _typesIconstraints :: (KindConstraints)
            _typesIkappaUnique :: (Int)
            _typesIkappas :: (Kinds)
            _typesIself :: (AnnotatedTypes)
            _typesOconstraints :: (KindConstraints)
            _typesOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _constructorIself) =
                (constructor_ )
            ( _typesIassumptions,_typesIconstraints,_typesIkappaUnique,_typesIkappas,_typesIself) =
                (types_ (_typesOconstraints) (_typesOkappaUnique))
            (_self@_) =
                Constructor_Constructor _rangeIself _constructorIself _typesIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _typesIassumptions
            (_lhsOconstraints@_) =
                _typesIconstraints
            (_lhsOkappaUnique@_) =
                _typesIkappaUnique
            (_typesOconstraints@_) =
                _lhsIconstraints
            (_typesOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsOassumptions,_lhsOconstraints,_lhsOkappaUnique,_lhsOself)
sem_Constructor_Infix :: (T_Range) ->
                         (T_AnnotatedType) ->
                         (T_Name) ->
                         (T_AnnotatedType) ->
                         (T_Constructor)
sem_Constructor_Infix (range_) (leftType_) (constructorOperator_) (rightType_) =
    \ _lhsIconstraints
      _lhsIkappaUnique ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOconstraints :: (KindConstraints)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Constructor)
            _rangeIself :: (Range)
            _leftTypeIassumptions :: (Assumptions)
            _leftTypeIconstraints :: (KindConstraints)
            _leftTypeIkappa :: (Kind)
            _leftTypeIkappaUnique :: (Int)
            _leftTypeIself :: (AnnotatedType)
            _leftTypeOconstraints :: (KindConstraints)
            _leftTypeOkappaUnique :: (Int)
            _constructorOperatorIself :: (Name)
            _rightTypeIassumptions :: (Assumptions)
            _rightTypeIconstraints :: (KindConstraints)
            _rightTypeIkappa :: (Kind)
            _rightTypeIkappaUnique :: (Int)
            _rightTypeIself :: (AnnotatedType)
            _rightTypeOconstraints :: (KindConstraints)
            _rightTypeOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _leftTypeIassumptions,_leftTypeIconstraints,_leftTypeIkappa,_leftTypeIkappaUnique,_leftTypeIself) =
                (leftType_ (_leftTypeOconstraints) (_leftTypeOkappaUnique))
            ( _constructorOperatorIself) =
                (constructorOperator_ )
            ( _rightTypeIassumptions,_rightTypeIconstraints,_rightTypeIkappa,_rightTypeIkappaUnique,_rightTypeIself) =
                (rightType_ (_rightTypeOconstraints) (_rightTypeOkappaUnique))
            (_lhsOassumptions@_) =
                _leftTypeIassumptions `combine` _rightTypeIassumptions
            (_self@_) =
                Constructor_Infix _rangeIself _leftTypeIself _constructorOperatorIself _rightTypeIself
            (_lhsOself@_) =
                _self
            (_lhsOconstraints@_) =
                _rightTypeIconstraints
            (_lhsOkappaUnique@_) =
                _rightTypeIkappaUnique
            (_leftTypeOconstraints@_) =
                _lhsIconstraints
            (_leftTypeOkappaUnique@_) =
                _lhsIkappaUnique
            (_rightTypeOconstraints@_) =
                _leftTypeIconstraints
            (_rightTypeOkappaUnique@_) =
                _leftTypeIkappaUnique
        in  ( _lhsOassumptions,_lhsOconstraints,_lhsOkappaUnique,_lhsOself)
sem_Constructor_Record :: (T_Range) ->
                          (T_Name) ->
                          (T_FieldDeclarations) ->
                          (T_Constructor)
sem_Constructor_Record (range_) (constructor_) (fieldDeclarations_) =
    \ _lhsIconstraints
      _lhsIkappaUnique ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOconstraints :: (KindConstraints)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Constructor)
            _rangeIself :: (Range)
            _constructorIself :: (Name)
            _fieldDeclarationsIkappaUnique :: (Int)
            _fieldDeclarationsIself :: (FieldDeclarations)
            _fieldDeclarationsOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _constructorIself) =
                (constructor_ )
            ( _fieldDeclarationsIkappaUnique,_fieldDeclarationsIself) =
                (fieldDeclarations_ (_fieldDeclarationsOkappaUnique))
            (_lhsOassumptions@_) =
                internalError "KindInferencing.ag" "n/a" "Record constructors are not supported"
            (_self@_) =
                Constructor_Record _rangeIself _constructorIself _fieldDeclarationsIself
            (_lhsOself@_) =
                _self
            (_lhsOconstraints@_) =
                _lhsIconstraints
            (_lhsOkappaUnique@_) =
                _fieldDeclarationsIkappaUnique
            (_fieldDeclarationsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsOassumptions,_lhsOconstraints,_lhsOkappaUnique,_lhsOself)
-- Constructors ------------------------------------------------
-- semantic domain
type T_Constructors = (KindConstraints) ->
                      (Int) ->
                      ( (Assumptions),(KindConstraints),(Int),(Constructors))
-- cata
sem_Constructors :: (Constructors) ->
                    (T_Constructors)
sem_Constructors (list) =
    (Prelude.foldr (sem_Constructors_Cons) (sem_Constructors_Nil) ((Prelude.map sem_Constructor list)))
sem_Constructors_Cons :: (T_Constructor) ->
                         (T_Constructors) ->
                         (T_Constructors)
sem_Constructors_Cons (hd_) (tl_) =
    \ _lhsIconstraints
      _lhsIkappaUnique ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOconstraints :: (KindConstraints)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Constructors)
            _hdIassumptions :: (Assumptions)
            _hdIconstraints :: (KindConstraints)
            _hdIkappaUnique :: (Int)
            _hdIself :: (Constructor)
            _hdOconstraints :: (KindConstraints)
            _hdOkappaUnique :: (Int)
            _tlIassumptions :: (Assumptions)
            _tlIconstraints :: (KindConstraints)
            _tlIkappaUnique :: (Int)
            _tlIself :: (Constructors)
            _tlOconstraints :: (KindConstraints)
            _tlOkappaUnique :: (Int)
            ( _hdIassumptions,_hdIconstraints,_hdIkappaUnique,_hdIself) =
                (hd_ (_hdOconstraints) (_hdOkappaUnique))
            ( _tlIassumptions,_tlIconstraints,_tlIkappaUnique,_tlIself) =
                (tl_ (_tlOconstraints) (_tlOkappaUnique))
            (_lhsOassumptions@_) =
                _hdIassumptions `combine` _tlIassumptions
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOconstraints@_) =
                _tlIconstraints
            (_lhsOkappaUnique@_) =
                _tlIkappaUnique
            (_hdOconstraints@_) =
                _lhsIconstraints
            (_hdOkappaUnique@_) =
                _lhsIkappaUnique
            (_tlOconstraints@_) =
                _hdIconstraints
            (_tlOkappaUnique@_) =
                _hdIkappaUnique
        in  ( _lhsOassumptions,_lhsOconstraints,_lhsOkappaUnique,_lhsOself)
sem_Constructors_Nil :: (T_Constructors)
sem_Constructors_Nil  =
    \ _lhsIconstraints
      _lhsIkappaUnique ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOconstraints :: (KindConstraints)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Constructors)
            (_lhsOassumptions@_) =
                noAssumptions
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOconstraints@_) =
                _lhsIconstraints
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsOassumptions,_lhsOconstraints,_lhsOkappaUnique,_lhsOself)
-- ContextItem -------------------------------------------------
-- semantic domain
type T_ContextItem = (Int) ->
                     ( (Int),(ContextItem))
-- cata
sem_ContextItem :: (ContextItem) ->
                   (T_ContextItem)
sem_ContextItem ((ContextItem_ContextItem (_range) (_name) (_types))) =
    (sem_ContextItem_ContextItem ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Types (_types))))
sem_ContextItem_ContextItem :: (T_Range) ->
                               (T_Name) ->
                               (T_Types) ->
                               (T_ContextItem)
sem_ContextItem_ContextItem (range_) (name_) (types_) =
    \ _lhsIkappaUnique ->
        let _lhsOkappaUnique :: (Int)
            _lhsOself :: (ContextItem)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _typesIassumptions :: (Assumptions)
            _typesIconstraints :: (KindConstraints)
            _typesIkappaUnique :: (Int)
            _typesIkappas :: (Kinds)
            _typesIself :: (Types)
            _typesOconstraints :: (KindConstraints)
            _typesOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _typesIassumptions,_typesIconstraints,_typesIkappaUnique,_typesIkappas,_typesIself) =
                (types_ (_typesOconstraints) (_typesOkappaUnique))
            (_constraints@_) =
                internalError "KindInferencing.ag" "n/a" "ContextItems are not supported"
            (_self@_) =
                ContextItem_ContextItem _rangeIself _nameIself _typesIself
            (_lhsOself@_) =
                _self
            (_lhsOkappaUnique@_) =
                _typesIkappaUnique
            (_typesOconstraints@_) =
                _constraints
            (_typesOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsOkappaUnique,_lhsOself)
-- ContextItems ------------------------------------------------
-- semantic domain
type T_ContextItems = (Int) ->
                      ( (Int),(ContextItems))
-- cata
sem_ContextItems :: (ContextItems) ->
                    (T_ContextItems)
sem_ContextItems (list) =
    (Prelude.foldr (sem_ContextItems_Cons) (sem_ContextItems_Nil) ((Prelude.map sem_ContextItem list)))
sem_ContextItems_Cons :: (T_ContextItem) ->
                         (T_ContextItems) ->
                         (T_ContextItems)
sem_ContextItems_Cons (hd_) (tl_) =
    \ _lhsIkappaUnique ->
        let _lhsOkappaUnique :: (Int)
            _lhsOself :: (ContextItems)
            _hdIkappaUnique :: (Int)
            _hdIself :: (ContextItem)
            _hdOkappaUnique :: (Int)
            _tlIkappaUnique :: (Int)
            _tlIself :: (ContextItems)
            _tlOkappaUnique :: (Int)
            ( _hdIkappaUnique,_hdIself) =
                (hd_ (_hdOkappaUnique))
            ( _tlIkappaUnique,_tlIself) =
                (tl_ (_tlOkappaUnique))
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOkappaUnique@_) =
                _tlIkappaUnique
            (_hdOkappaUnique@_) =
                _lhsIkappaUnique
            (_tlOkappaUnique@_) =
                _hdIkappaUnique
        in  ( _lhsOkappaUnique,_lhsOself)
sem_ContextItems_Nil :: (T_ContextItems)
sem_ContextItems_Nil  =
    \ _lhsIkappaUnique ->
        let _lhsOkappaUnique :: (Int)
            _lhsOself :: (ContextItems)
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsOkappaUnique,_lhsOself)
-- Declaration -------------------------------------------------
-- semantic domain
type T_Declaration = (BindingGroups) ->
                     (Int) ->
                     ( (BindingGroups),(Int),(Declaration))
-- cata
sem_Declaration :: (Declaration) ->
                   (T_Declaration)
sem_Declaration ((Declaration_Class (_range) (_context) (_simpletype) (_where))) =
    (sem_Declaration_Class ((sem_Range (_range))) ((sem_ContextItems (_context))) ((sem_SimpleType (_simpletype))) ((sem_MaybeDeclarations (_where))))
sem_Declaration ((Declaration_Data (_range) (_context) (_simpletype) (_constructors) (_derivings))) =
    (sem_Declaration_Data ((sem_Range (_range))) ((sem_ContextItems (_context))) ((sem_SimpleType (_simpletype))) ((sem_Constructors (_constructors))) ((sem_Names (_derivings))))
sem_Declaration ((Declaration_Default (_range) (_types))) =
    (sem_Declaration_Default ((sem_Range (_range))) ((sem_Types (_types))))
sem_Declaration ((Declaration_Empty (_range))) =
    (sem_Declaration_Empty ((sem_Range (_range))))
sem_Declaration ((Declaration_Fixity (_range) (_fixity) (_priority) (_operators))) =
    (sem_Declaration_Fixity ((sem_Range (_range))) ((sem_Fixity (_fixity))) ((sem_MaybeInt (_priority))) ((sem_Names (_operators))))
sem_Declaration ((Declaration_FunctionBindings (_range) (_bindings))) =
    (sem_Declaration_FunctionBindings ((sem_Range (_range))) ((sem_FunctionBindings (_bindings))))
sem_Declaration ((Declaration_Instance (_range) (_context) (_name) (_types) (_where))) =
    (sem_Declaration_Instance ((sem_Range (_range))) ((sem_ContextItems (_context))) ((sem_Name (_name))) ((sem_Types (_types))) ((sem_MaybeDeclarations (_where))))
sem_Declaration ((Declaration_Newtype (_range) (_context) (_simpletype) (_constructor) (_derivings))) =
    (sem_Declaration_Newtype ((sem_Range (_range))) ((sem_ContextItems (_context))) ((sem_SimpleType (_simpletype))) ((sem_Constructor (_constructor))) ((sem_Names (_derivings))))
sem_Declaration ((Declaration_PatternBinding (_range) (_pattern) (_righthandside))) =
    (sem_Declaration_PatternBinding ((sem_Range (_range))) ((sem_Pattern (_pattern))) ((sem_RightHandSide (_righthandside))))
sem_Declaration ((Declaration_Type (_range) (_simpletype) (_type))) =
    (sem_Declaration_Type ((sem_Range (_range))) ((sem_SimpleType (_simpletype))) ((sem_Type (_type))))
sem_Declaration ((Declaration_TypeSignature (_range) (_names) (_type))) =
    (sem_Declaration_TypeSignature ((sem_Range (_range))) ((sem_Names (_names))) ((sem_Type (_type))))
sem_Declaration_Class :: (T_Range) ->
                         (T_ContextItems) ->
                         (T_SimpleType) ->
                         (T_MaybeDeclarations) ->
                         (T_Declaration)
sem_Declaration_Class (range_) (context_) (simpletype_) (where_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Declaration)
            _rangeIself :: (Range)
            _contextIkappaUnique :: (Int)
            _contextIself :: (ContextItems)
            _contextOkappaUnique :: (Int)
            _simpletypeIconstraints :: (KindConstraints)
            _simpletypeIdeclared :: (PatternAssumptions)
            _simpletypeIenvironment :: (PatternAssumptions)
            _simpletypeIkappaUnique :: (Int)
            _simpletypeIself :: (SimpleType)
            _simpletypeOconstraints :: (KindConstraints)
            _simpletypeOkappaOfRHS :: (Kind)
            _simpletypeOkappaUnique :: (Int)
            _whereIbindingGroups :: (BindingGroups)
            _whereIkappaUnique :: (Int)
            _whereIself :: (MaybeDeclarations)
            _whereObindingGroups :: (BindingGroups)
            _whereOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _contextIkappaUnique,_contextIself) =
                (context_ (_contextOkappaUnique))
            ( _simpletypeIconstraints,_simpletypeIdeclared,_simpletypeIenvironment,_simpletypeIkappaUnique,_simpletypeIself) =
                (simpletype_ (_simpletypeOconstraints) (_simpletypeOkappaOfRHS) (_simpletypeOkappaUnique))
            ( _whereIbindingGroups,_whereIkappaUnique,_whereIself) =
                (where_ (_whereObindingGroups) (_whereOkappaUnique))
            ((_constraints@_,_kappaOfRHS@_)) =
                internalError "KindInferencing.ag" "n/a" "class decls are not supported"
            (_self@_) =
                Declaration_Class _rangeIself _contextIself _simpletypeIself _whereIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _whereIbindingGroups
            (_lhsOkappaUnique@_) =
                _whereIkappaUnique
            (_contextOkappaUnique@_) =
                _lhsIkappaUnique
            (_simpletypeOconstraints@_) =
                _constraints
            (_simpletypeOkappaOfRHS@_) =
                _kappaOfRHS
            (_simpletypeOkappaUnique@_) =
                _contextIkappaUnique
            (_whereObindingGroups@_) =
                _lhsIbindingGroups
            (_whereOkappaUnique@_) =
                _simpletypeIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Declaration_Data :: (T_Range) ->
                        (T_ContextItems) ->
                        (T_SimpleType) ->
                        (T_Constructors) ->
                        (T_Names) ->
                        (T_Declaration)
sem_Declaration_Data (range_) (context_) (simpletype_) (constructors_) (derivings_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Declaration)
            _rangeIself :: (Range)
            _contextIkappaUnique :: (Int)
            _contextIself :: (ContextItems)
            _contextOkappaUnique :: (Int)
            _simpletypeIconstraints :: (KindConstraints)
            _simpletypeIdeclared :: (PatternAssumptions)
            _simpletypeIenvironment :: (PatternAssumptions)
            _simpletypeIkappaUnique :: (Int)
            _simpletypeIself :: (SimpleType)
            _simpletypeOconstraints :: (KindConstraints)
            _simpletypeOkappaOfRHS :: (Kind)
            _simpletypeOkappaUnique :: (Int)
            _constructorsIassumptions :: (Assumptions)
            _constructorsIconstraints :: (KindConstraints)
            _constructorsIkappaUnique :: (Int)
            _constructorsIself :: (Constructors)
            _constructorsOconstraints :: (KindConstraints)
            _constructorsOkappaUnique :: (Int)
            _derivingsIself :: (Names)
            ( _rangeIself) =
                (range_ )
            ( _contextIkappaUnique,_contextIself) =
                (context_ (_contextOkappaUnique))
            ( _simpletypeIconstraints,_simpletypeIdeclared,_simpletypeIenvironment,_simpletypeIkappaUnique,_simpletypeIself) =
                (simpletype_ (_simpletypeOconstraints) (_simpletypeOkappaOfRHS) (_simpletypeOkappaUnique))
            ( _constructorsIassumptions,_constructorsIconstraints,_constructorsIkappaUnique,_constructorsIself) =
                (constructors_ (_constructorsOconstraints) (_constructorsOkappaUnique))
            ( _derivingsIself) =
                (derivings_ )
            (_newGroup@_) =
                (_simpletypeIdeclared, _constructorsIassumptions, _newConstraints ++ _constructorsIconstraints)
            (_newConstraints@_) =
                fst $ (_simpletypeIenvironment .===. _constructorsIassumptions) (\n -> unexpected $ "Declaration.Data " ++ show n)
            (_lhsObindingGroups@_) =
                _newGroup : _lhsIbindingGroups
            (_simpletypeOkappaOfRHS@_) =
                star
            (_simpletypeOconstraints@_) =
                []
            (_self@_) =
                Declaration_Data _rangeIself _contextIself _simpletypeIself _constructorsIself _derivingsIself
            (_lhsOself@_) =
                _self
            (_lhsOkappaUnique@_) =
                _constructorsIkappaUnique
            (_contextOkappaUnique@_) =
                _lhsIkappaUnique
            (_simpletypeOkappaUnique@_) =
                _contextIkappaUnique
            (_constructorsOconstraints@_) =
                _simpletypeIconstraints
            (_constructorsOkappaUnique@_) =
                _simpletypeIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Declaration_Default :: (T_Range) ->
                           (T_Types) ->
                           (T_Declaration)
sem_Declaration_Default (range_) (types_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Declaration)
            _rangeIself :: (Range)
            _typesIassumptions :: (Assumptions)
            _typesIconstraints :: (KindConstraints)
            _typesIkappaUnique :: (Int)
            _typesIkappas :: (Kinds)
            _typesIself :: (Types)
            _typesOconstraints :: (KindConstraints)
            _typesOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _typesIassumptions,_typesIconstraints,_typesIkappaUnique,_typesIkappas,_typesIself) =
                (types_ (_typesOconstraints) (_typesOkappaUnique))
            (_constraints@_) =
                internalError "KindInferencing.ag" "n/a" "default decls is not supported"
            (_self@_) =
                Declaration_Default _rangeIself _typesIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _typesIkappaUnique
            (_typesOconstraints@_) =
                _constraints
            (_typesOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Declaration_Empty :: (T_Range) ->
                         (T_Declaration)
sem_Declaration_Empty (range_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Declaration)
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_self@_) =
                Declaration_Empty _rangeIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Declaration_Fixity :: (T_Range) ->
                          (T_Fixity) ->
                          (T_MaybeInt) ->
                          (T_Names) ->
                          (T_Declaration)
sem_Declaration_Fixity (range_) (fixity_) (priority_) (operators_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Declaration)
            _rangeIself :: (Range)
            _fixityIself :: (Fixity)
            _priorityIself :: (MaybeInt)
            _operatorsIself :: (Names)
            ( _rangeIself) =
                (range_ )
            ( _fixityIself) =
                (fixity_ )
            ( _priorityIself) =
                (priority_ )
            ( _operatorsIself) =
                (operators_ )
            (_self@_) =
                Declaration_Fixity _rangeIself _fixityIself _priorityIself _operatorsIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Declaration_FunctionBindings :: (T_Range) ->
                                    (T_FunctionBindings) ->
                                    (T_Declaration)
sem_Declaration_FunctionBindings (range_) (bindings_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Declaration)
            _rangeIself :: (Range)
            _bindingsIbindingGroups :: (BindingGroups)
            _bindingsIkappaUnique :: (Int)
            _bindingsIself :: (FunctionBindings)
            _bindingsObindingGroups :: (BindingGroups)
            _bindingsOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _bindingsIbindingGroups,_bindingsIkappaUnique,_bindingsIself) =
                (bindings_ (_bindingsObindingGroups) (_bindingsOkappaUnique))
            (_self@_) =
                Declaration_FunctionBindings _rangeIself _bindingsIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _bindingsIbindingGroups
            (_lhsOkappaUnique@_) =
                _bindingsIkappaUnique
            (_bindingsObindingGroups@_) =
                _lhsIbindingGroups
            (_bindingsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Declaration_Instance :: (T_Range) ->
                            (T_ContextItems) ->
                            (T_Name) ->
                            (T_Types) ->
                            (T_MaybeDeclarations) ->
                            (T_Declaration)
sem_Declaration_Instance (range_) (context_) (name_) (types_) (where_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Declaration)
            _rangeIself :: (Range)
            _contextIkappaUnique :: (Int)
            _contextIself :: (ContextItems)
            _contextOkappaUnique :: (Int)
            _nameIself :: (Name)
            _typesIassumptions :: (Assumptions)
            _typesIconstraints :: (KindConstraints)
            _typesIkappaUnique :: (Int)
            _typesIkappas :: (Kinds)
            _typesIself :: (Types)
            _typesOconstraints :: (KindConstraints)
            _typesOkappaUnique :: (Int)
            _whereIbindingGroups :: (BindingGroups)
            _whereIkappaUnique :: (Int)
            _whereIself :: (MaybeDeclarations)
            _whereObindingGroups :: (BindingGroups)
            _whereOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _contextIkappaUnique,_contextIself) =
                (context_ (_contextOkappaUnique))
            ( _nameIself) =
                (name_ )
            ( _typesIassumptions,_typesIconstraints,_typesIkappaUnique,_typesIkappas,_typesIself) =
                (types_ (_typesOconstraints) (_typesOkappaUnique))
            ( _whereIbindingGroups,_whereIkappaUnique,_whereIself) =
                (where_ (_whereObindingGroups) (_whereOkappaUnique))
            (_constraints@_) =
                internalError "KindInferencing.ag" "n/a" "instance decls are not supported"
            (_self@_) =
                Declaration_Instance _rangeIself _contextIself _nameIself _typesIself _whereIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _whereIbindingGroups
            (_lhsOkappaUnique@_) =
                _whereIkappaUnique
            (_contextOkappaUnique@_) =
                _lhsIkappaUnique
            (_typesOconstraints@_) =
                _constraints
            (_typesOkappaUnique@_) =
                _contextIkappaUnique
            (_whereObindingGroups@_) =
                _lhsIbindingGroups
            (_whereOkappaUnique@_) =
                _typesIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Declaration_Newtype :: (T_Range) ->
                           (T_ContextItems) ->
                           (T_SimpleType) ->
                           (T_Constructor) ->
                           (T_Names) ->
                           (T_Declaration)
sem_Declaration_Newtype (range_) (context_) (simpletype_) (constructor_) (derivings_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Declaration)
            _rangeIself :: (Range)
            _contextIkappaUnique :: (Int)
            _contextIself :: (ContextItems)
            _contextOkappaUnique :: (Int)
            _simpletypeIconstraints :: (KindConstraints)
            _simpletypeIdeclared :: (PatternAssumptions)
            _simpletypeIenvironment :: (PatternAssumptions)
            _simpletypeIkappaUnique :: (Int)
            _simpletypeIself :: (SimpleType)
            _simpletypeOconstraints :: (KindConstraints)
            _simpletypeOkappaOfRHS :: (Kind)
            _simpletypeOkappaUnique :: (Int)
            _constructorIassumptions :: (Assumptions)
            _constructorIconstraints :: (KindConstraints)
            _constructorIkappaUnique :: (Int)
            _constructorIself :: (Constructor)
            _constructorOconstraints :: (KindConstraints)
            _constructorOkappaUnique :: (Int)
            _derivingsIself :: (Names)
            ( _rangeIself) =
                (range_ )
            ( _contextIkappaUnique,_contextIself) =
                (context_ (_contextOkappaUnique))
            ( _simpletypeIconstraints,_simpletypeIdeclared,_simpletypeIenvironment,_simpletypeIkappaUnique,_simpletypeIself) =
                (simpletype_ (_simpletypeOconstraints) (_simpletypeOkappaOfRHS) (_simpletypeOkappaUnique))
            ( _constructorIassumptions,_constructorIconstraints,_constructorIkappaUnique,_constructorIself) =
                (constructor_ (_constructorOconstraints) (_constructorOkappaUnique))
            ( _derivingsIself) =
                (derivings_ )
            ((_constraints@_,_kappaOfRHS@_)) =
                internalError "KindInferencing.ag" "n/a" "newtype decls are not supported"
            (_self@_) =
                Declaration_Newtype _rangeIself _contextIself _simpletypeIself _constructorIself _derivingsIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _constructorIkappaUnique
            (_contextOkappaUnique@_) =
                _lhsIkappaUnique
            (_simpletypeOconstraints@_) =
                _constraints
            (_simpletypeOkappaOfRHS@_) =
                _kappaOfRHS
            (_simpletypeOkappaUnique@_) =
                _contextIkappaUnique
            (_constructorOconstraints@_) =
                _constraints
            (_constructorOkappaUnique@_) =
                _simpletypeIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Declaration_PatternBinding :: (T_Range) ->
                                  (T_Pattern) ->
                                  (T_RightHandSide) ->
                                  (T_Declaration)
sem_Declaration_PatternBinding (range_) (pattern_) (righthandside_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Declaration)
            _rangeIself :: (Range)
            _patternIself :: (Pattern)
            _righthandsideIbindingGroups :: (BindingGroups)
            _righthandsideIkappaUnique :: (Int)
            _righthandsideIself :: (RightHandSide)
            _righthandsideObindingGroups :: (BindingGroups)
            _righthandsideOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _patternIself) =
                (pattern_ )
            ( _righthandsideIbindingGroups,_righthandsideIkappaUnique,_righthandsideIself) =
                (righthandside_ (_righthandsideObindingGroups) (_righthandsideOkappaUnique))
            (_self@_) =
                Declaration_PatternBinding _rangeIself _patternIself _righthandsideIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _righthandsideIbindingGroups
            (_lhsOkappaUnique@_) =
                _righthandsideIkappaUnique
            (_righthandsideObindingGroups@_) =
                _lhsIbindingGroups
            (_righthandsideOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Declaration_Type :: (T_Range) ->
                        (T_SimpleType) ->
                        (T_Type) ->
                        (T_Declaration)
sem_Declaration_Type (range_) (simpletype_) (type_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Declaration)
            _rangeIself :: (Range)
            _simpletypeIconstraints :: (KindConstraints)
            _simpletypeIdeclared :: (PatternAssumptions)
            _simpletypeIenvironment :: (PatternAssumptions)
            _simpletypeIkappaUnique :: (Int)
            _simpletypeIself :: (SimpleType)
            _simpletypeOconstraints :: (KindConstraints)
            _simpletypeOkappaOfRHS :: (Kind)
            _simpletypeOkappaUnique :: (Int)
            _typeIassumptions :: (Assumptions)
            _typeIconstraints :: (KindConstraints)
            _typeIkappa :: (Kind)
            _typeIkappaUnique :: (Int)
            _typeIself :: (Type)
            _typeOconstraints :: (KindConstraints)
            _typeOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _simpletypeIconstraints,_simpletypeIdeclared,_simpletypeIenvironment,_simpletypeIkappaUnique,_simpletypeIself) =
                (simpletype_ (_simpletypeOconstraints) (_simpletypeOkappaOfRHS) (_simpletypeOkappaUnique))
            ( _typeIassumptions,_typeIconstraints,_typeIkappa,_typeIkappaUnique,_typeIself) =
                (type_ (_typeOconstraints) (_typeOkappaUnique))
            (_newGroup@_) =
                (_simpletypeIdeclared, _typeIassumptions, _newConstraints ++ _typeIconstraints)
            (_newConstraints@_) =
                fst $ (_simpletypeIenvironment .===. _typeIassumptions) (\n -> unexpected $ "Declaration.Type " ++ show n)
            (_lhsObindingGroups@_) =
                _newGroup : _lhsIbindingGroups
            (_simpletypeOkappaOfRHS@_) =
                _typeIkappa
            (_simpletypeOconstraints@_) =
                []
            (_self@_) =
                Declaration_Type _rangeIself _simpletypeIself _typeIself
            (_lhsOself@_) =
                _self
            (_lhsOkappaUnique@_) =
                _typeIkappaUnique
            (_simpletypeOkappaUnique@_) =
                _lhsIkappaUnique
            (_typeOconstraints@_) =
                _simpletypeIconstraints
            (_typeOkappaUnique@_) =
                _simpletypeIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Declaration_TypeSignature :: (T_Range) ->
                                 (T_Names) ->
                                 (T_Type) ->
                                 (T_Declaration)
sem_Declaration_TypeSignature (range_) (names_) (type_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Declaration)
            _rangeIself :: (Range)
            _namesIself :: (Names)
            _typeIassumptions :: (Assumptions)
            _typeIconstraints :: (KindConstraints)
            _typeIkappa :: (Kind)
            _typeIkappaUnique :: (Int)
            _typeIself :: (Type)
            _typeOconstraints :: (KindConstraints)
            _typeOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _namesIself) =
                (names_ )
            ( _typeIassumptions,_typeIconstraints,_typeIkappa,_typeIkappaUnique,_typeIself) =
                (type_ (_typeOconstraints) (_typeOkappaUnique))
            (_newGroup@_) =
                (M.empty, _aset, _cset ++ _typeIconstraints ++ [_newConstraint])
            ((_cset@_,_aset@_)) =
                (M.fromList _tvEnv .===. _typeIassumptions) (\n -> unexpected $ "Declaration.TypeSignature " ++ show n)
            (_tvEnv@_) =
                zip (getTypeVariables _typeIassumptions) (map TVar [_typeIkappaUnique..])
            (_newConstraint@_) =
                (_typeIkappa <==> star) (mustBeStar _rangeIself "type signature" _typeIself)
            (_lhsOkappaUnique@_) =
                _typeIkappaUnique + length _tvEnv
            (_lhsObindingGroups@_) =
                _newGroup : _lhsIbindingGroups
            (_typeOconstraints@_) =
                []
            (_self@_) =
                Declaration_TypeSignature _rangeIself _namesIself _typeIself
            (_lhsOself@_) =
                _self
            (_typeOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- Declarations ------------------------------------------------
-- semantic domain
type T_Declarations = (BindingGroups) ->
                      (Int) ->
                      ( (BindingGroups),(Int),(Declarations))
-- cata
sem_Declarations :: (Declarations) ->
                    (T_Declarations)
sem_Declarations (list) =
    (Prelude.foldr (sem_Declarations_Cons) (sem_Declarations_Nil) ((Prelude.map sem_Declaration list)))
sem_Declarations_Cons :: (T_Declaration) ->
                         (T_Declarations) ->
                         (T_Declarations)
sem_Declarations_Cons (hd_) (tl_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Declarations)
            _hdIbindingGroups :: (BindingGroups)
            _hdIkappaUnique :: (Int)
            _hdIself :: (Declaration)
            _hdObindingGroups :: (BindingGroups)
            _hdOkappaUnique :: (Int)
            _tlIbindingGroups :: (BindingGroups)
            _tlIkappaUnique :: (Int)
            _tlIself :: (Declarations)
            _tlObindingGroups :: (BindingGroups)
            _tlOkappaUnique :: (Int)
            ( _hdIbindingGroups,_hdIkappaUnique,_hdIself) =
                (hd_ (_hdObindingGroups) (_hdOkappaUnique))
            ( _tlIbindingGroups,_tlIkappaUnique,_tlIself) =
                (tl_ (_tlObindingGroups) (_tlOkappaUnique))
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _tlIbindingGroups
            (_lhsOkappaUnique@_) =
                _tlIkappaUnique
            (_hdObindingGroups@_) =
                _lhsIbindingGroups
            (_hdOkappaUnique@_) =
                _lhsIkappaUnique
            (_tlObindingGroups@_) =
                _hdIbindingGroups
            (_tlOkappaUnique@_) =
                _hdIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Declarations_Nil :: (T_Declarations)
sem_Declarations_Nil  =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Declarations)
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- Export ------------------------------------------------------
-- semantic domain
type T_Export = ( (Export))
-- cata
sem_Export :: (Export) ->
              (T_Export)
sem_Export ((Export_Module (_range) (_name))) =
    (sem_Export_Module ((sem_Range (_range))) ((sem_Name (_name))))
sem_Export ((Export_TypeOrClass (_range) (_name) (_names))) =
    (sem_Export_TypeOrClass ((sem_Range (_range))) ((sem_Name (_name))) ((sem_MaybeNames (_names))))
sem_Export ((Export_TypeOrClassComplete (_range) (_name))) =
    (sem_Export_TypeOrClassComplete ((sem_Range (_range))) ((sem_Name (_name))))
sem_Export ((Export_Variable (_range) (_name))) =
    (sem_Export_Variable ((sem_Range (_range))) ((sem_Name (_name))))
sem_Export_Module :: (T_Range) ->
                     (T_Name) ->
                     (T_Export)
sem_Export_Module (range_) (name_) =
    let _lhsOself :: (Export)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        (_self@_) =
            Export_Module _rangeIself _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Export_TypeOrClass :: (T_Range) ->
                          (T_Name) ->
                          (T_MaybeNames) ->
                          (T_Export)
sem_Export_TypeOrClass (range_) (name_) (names_) =
    let _lhsOself :: (Export)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        _namesIself :: (MaybeNames)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        ( _namesIself) =
            (names_ )
        (_self@_) =
            Export_TypeOrClass _rangeIself _nameIself _namesIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Export_TypeOrClassComplete :: (T_Range) ->
                                  (T_Name) ->
                                  (T_Export)
sem_Export_TypeOrClassComplete (range_) (name_) =
    let _lhsOself :: (Export)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        (_self@_) =
            Export_TypeOrClassComplete _rangeIself _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Export_Variable :: (T_Range) ->
                       (T_Name) ->
                       (T_Export)
sem_Export_Variable (range_) (name_) =
    let _lhsOself :: (Export)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        (_self@_) =
            Export_Variable _rangeIself _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Exports -----------------------------------------------------
-- semantic domain
type T_Exports = ( (Exports))
-- cata
sem_Exports :: (Exports) ->
               (T_Exports)
sem_Exports (list) =
    (Prelude.foldr (sem_Exports_Cons) (sem_Exports_Nil) ((Prelude.map sem_Export list)))
sem_Exports_Cons :: (T_Export) ->
                    (T_Exports) ->
                    (T_Exports)
sem_Exports_Cons (hd_) (tl_) =
    let _lhsOself :: (Exports)
        _hdIself :: (Export)
        _tlIself :: (Exports)
        ( _hdIself) =
            (hd_ )
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Exports_Nil :: (T_Exports)
sem_Exports_Nil  =
    let _lhsOself :: (Exports)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Expression --------------------------------------------------
-- semantic domain
type T_Expression = (BindingGroups) ->
                    (Int) ->
                    ( (BindingGroups),(Int),(Expression))
-- cata
sem_Expression :: (Expression) ->
                  (T_Expression)
sem_Expression ((Expression_Case (_range) (_expression) (_alternatives))) =
    (sem_Expression_Case ((sem_Range (_range))) ((sem_Expression (_expression))) ((sem_Alternatives (_alternatives))))
sem_Expression ((Expression_Comprehension (_range) (_expression) (_qualifiers))) =
    (sem_Expression_Comprehension ((sem_Range (_range))) ((sem_Expression (_expression))) ((sem_Qualifiers (_qualifiers))))
sem_Expression ((Expression_Constructor (_range) (_name))) =
    (sem_Expression_Constructor ((sem_Range (_range))) ((sem_Name (_name))))
sem_Expression ((Expression_Do (_range) (_statements))) =
    (sem_Expression_Do ((sem_Range (_range))) ((sem_Statements (_statements))))
sem_Expression ((Expression_Enum (_range) (_from) (_then) (_to))) =
    (sem_Expression_Enum ((sem_Range (_range))) ((sem_Expression (_from))) ((sem_MaybeExpression (_then))) ((sem_MaybeExpression (_to))))
sem_Expression ((Expression_If (_range) (_guardExpression) (_thenExpression) (_elseExpression))) =
    (sem_Expression_If ((sem_Range (_range))) ((sem_Expression (_guardExpression))) ((sem_Expression (_thenExpression))) ((sem_Expression (_elseExpression))))
sem_Expression ((Expression_InfixApplication (_range) (_leftExpression) (_operator) (_rightExpression))) =
    (sem_Expression_InfixApplication ((sem_Range (_range))) ((sem_MaybeExpression (_leftExpression))) ((sem_Expression (_operator))) ((sem_MaybeExpression (_rightExpression))))
sem_Expression ((Expression_Lambda (_range) (_patterns) (_expression))) =
    (sem_Expression_Lambda ((sem_Range (_range))) ((sem_Patterns (_patterns))) ((sem_Expression (_expression))))
sem_Expression ((Expression_Let (_range) (_declarations) (_expression))) =
    (sem_Expression_Let ((sem_Range (_range))) ((sem_Declarations (_declarations))) ((sem_Expression (_expression))))
sem_Expression ((Expression_List (_range) (_expressions))) =
    (sem_Expression_List ((sem_Range (_range))) ((sem_Expressions (_expressions))))
sem_Expression ((Expression_Literal (_range) (_literal))) =
    (sem_Expression_Literal ((sem_Range (_range))) ((sem_Literal (_literal))))
sem_Expression ((Expression_Negate (_range) (_expression))) =
    (sem_Expression_Negate ((sem_Range (_range))) ((sem_Expression (_expression))))
sem_Expression ((Expression_NegateFloat (_range) (_expression))) =
    (sem_Expression_NegateFloat ((sem_Range (_range))) ((sem_Expression (_expression))))
sem_Expression ((Expression_NormalApplication (_range) (_function) (_arguments))) =
    (sem_Expression_NormalApplication ((sem_Range (_range))) ((sem_Expression (_function))) ((sem_Expressions (_arguments))))
sem_Expression ((Expression_Parenthesized (_range) (_expression))) =
    (sem_Expression_Parenthesized ((sem_Range (_range))) ((sem_Expression (_expression))))
sem_Expression ((Expression_RecordConstruction (_range) (_name) (_recordExpressionBindings))) =
    (sem_Expression_RecordConstruction ((sem_Range (_range))) ((sem_Name (_name))) ((sem_RecordExpressionBindings (_recordExpressionBindings))))
sem_Expression ((Expression_RecordUpdate (_range) (_expression) (_recordExpressionBindings))) =
    (sem_Expression_RecordUpdate ((sem_Range (_range))) ((sem_Expression (_expression))) ((sem_RecordExpressionBindings (_recordExpressionBindings))))
sem_Expression ((Expression_Tuple (_range) (_expressions))) =
    (sem_Expression_Tuple ((sem_Range (_range))) ((sem_Expressions (_expressions))))
sem_Expression ((Expression_Typed (_range) (_expression) (_type))) =
    (sem_Expression_Typed ((sem_Range (_range))) ((sem_Expression (_expression))) ((sem_Type (_type))))
sem_Expression ((Expression_Variable (_range) (_name))) =
    (sem_Expression_Variable ((sem_Range (_range))) ((sem_Name (_name))))
sem_Expression_Case :: (T_Range) ->
                       (T_Expression) ->
                       (T_Alternatives) ->
                       (T_Expression)
sem_Expression_Case (range_) (expression_) (alternatives_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _expressionIbindingGroups :: (BindingGroups)
            _expressionIkappaUnique :: (Int)
            _expressionIself :: (Expression)
            _expressionObindingGroups :: (BindingGroups)
            _expressionOkappaUnique :: (Int)
            _alternativesIbindingGroups :: (BindingGroups)
            _alternativesIkappaUnique :: (Int)
            _alternativesIself :: (Alternatives)
            _alternativesObindingGroups :: (BindingGroups)
            _alternativesOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionIbindingGroups,_expressionIkappaUnique,_expressionIself) =
                (expression_ (_expressionObindingGroups) (_expressionOkappaUnique))
            ( _alternativesIbindingGroups,_alternativesIkappaUnique,_alternativesIself) =
                (alternatives_ (_alternativesObindingGroups) (_alternativesOkappaUnique))
            (_self@_) =
                Expression_Case _rangeIself _expressionIself _alternativesIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _alternativesIbindingGroups
            (_lhsOkappaUnique@_) =
                _alternativesIkappaUnique
            (_expressionObindingGroups@_) =
                _lhsIbindingGroups
            (_expressionOkappaUnique@_) =
                _lhsIkappaUnique
            (_alternativesObindingGroups@_) =
                _expressionIbindingGroups
            (_alternativesOkappaUnique@_) =
                _expressionIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_Comprehension :: (T_Range) ->
                                (T_Expression) ->
                                (T_Qualifiers) ->
                                (T_Expression)
sem_Expression_Comprehension (range_) (expression_) (qualifiers_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _expressionIbindingGroups :: (BindingGroups)
            _expressionIkappaUnique :: (Int)
            _expressionIself :: (Expression)
            _expressionObindingGroups :: (BindingGroups)
            _expressionOkappaUnique :: (Int)
            _qualifiersIbindingGroups :: (BindingGroups)
            _qualifiersIkappaUnique :: (Int)
            _qualifiersIself :: (Qualifiers)
            _qualifiersObindingGroups :: (BindingGroups)
            _qualifiersOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionIbindingGroups,_expressionIkappaUnique,_expressionIself) =
                (expression_ (_expressionObindingGroups) (_expressionOkappaUnique))
            ( _qualifiersIbindingGroups,_qualifiersIkappaUnique,_qualifiersIself) =
                (qualifiers_ (_qualifiersObindingGroups) (_qualifiersOkappaUnique))
            (_self@_) =
                Expression_Comprehension _rangeIself _expressionIself _qualifiersIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _qualifiersIbindingGroups
            (_lhsOkappaUnique@_) =
                _qualifiersIkappaUnique
            (_expressionObindingGroups@_) =
                _lhsIbindingGroups
            (_expressionOkappaUnique@_) =
                _lhsIkappaUnique
            (_qualifiersObindingGroups@_) =
                _expressionIbindingGroups
            (_qualifiersOkappaUnique@_) =
                _expressionIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_Constructor :: (T_Range) ->
                              (T_Name) ->
                              (T_Expression)
sem_Expression_Constructor (range_) (name_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            (_self@_) =
                Expression_Constructor _rangeIself _nameIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_Do :: (T_Range) ->
                     (T_Statements) ->
                     (T_Expression)
sem_Expression_Do (range_) (statements_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _statementsIbindingGroups :: (BindingGroups)
            _statementsIkappaUnique :: (Int)
            _statementsIself :: (Statements)
            _statementsObindingGroups :: (BindingGroups)
            _statementsOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _statementsIbindingGroups,_statementsIkappaUnique,_statementsIself) =
                (statements_ (_statementsObindingGroups) (_statementsOkappaUnique))
            (_self@_) =
                Expression_Do _rangeIself _statementsIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _statementsIbindingGroups
            (_lhsOkappaUnique@_) =
                _statementsIkappaUnique
            (_statementsObindingGroups@_) =
                _lhsIbindingGroups
            (_statementsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_Enum :: (T_Range) ->
                       (T_Expression) ->
                       (T_MaybeExpression) ->
                       (T_MaybeExpression) ->
                       (T_Expression)
sem_Expression_Enum (range_) (from_) (then_) (to_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _fromIbindingGroups :: (BindingGroups)
            _fromIkappaUnique :: (Int)
            _fromIself :: (Expression)
            _fromObindingGroups :: (BindingGroups)
            _fromOkappaUnique :: (Int)
            _thenIbindingGroups :: (BindingGroups)
            _thenIkappaUnique :: (Int)
            _thenIself :: (MaybeExpression)
            _thenObindingGroups :: (BindingGroups)
            _thenOkappaUnique :: (Int)
            _toIbindingGroups :: (BindingGroups)
            _toIkappaUnique :: (Int)
            _toIself :: (MaybeExpression)
            _toObindingGroups :: (BindingGroups)
            _toOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _fromIbindingGroups,_fromIkappaUnique,_fromIself) =
                (from_ (_fromObindingGroups) (_fromOkappaUnique))
            ( _thenIbindingGroups,_thenIkappaUnique,_thenIself) =
                (then_ (_thenObindingGroups) (_thenOkappaUnique))
            ( _toIbindingGroups,_toIkappaUnique,_toIself) =
                (to_ (_toObindingGroups) (_toOkappaUnique))
            (_self@_) =
                Expression_Enum _rangeIself _fromIself _thenIself _toIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _toIbindingGroups
            (_lhsOkappaUnique@_) =
                _toIkappaUnique
            (_fromObindingGroups@_) =
                _lhsIbindingGroups
            (_fromOkappaUnique@_) =
                _lhsIkappaUnique
            (_thenObindingGroups@_) =
                _fromIbindingGroups
            (_thenOkappaUnique@_) =
                _fromIkappaUnique
            (_toObindingGroups@_) =
                _thenIbindingGroups
            (_toOkappaUnique@_) =
                _thenIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_If :: (T_Range) ->
                     (T_Expression) ->
                     (T_Expression) ->
                     (T_Expression) ->
                     (T_Expression)
sem_Expression_If (range_) (guardExpression_) (thenExpression_) (elseExpression_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _guardExpressionIbindingGroups :: (BindingGroups)
            _guardExpressionIkappaUnique :: (Int)
            _guardExpressionIself :: (Expression)
            _guardExpressionObindingGroups :: (BindingGroups)
            _guardExpressionOkappaUnique :: (Int)
            _thenExpressionIbindingGroups :: (BindingGroups)
            _thenExpressionIkappaUnique :: (Int)
            _thenExpressionIself :: (Expression)
            _thenExpressionObindingGroups :: (BindingGroups)
            _thenExpressionOkappaUnique :: (Int)
            _elseExpressionIbindingGroups :: (BindingGroups)
            _elseExpressionIkappaUnique :: (Int)
            _elseExpressionIself :: (Expression)
            _elseExpressionObindingGroups :: (BindingGroups)
            _elseExpressionOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _guardExpressionIbindingGroups,_guardExpressionIkappaUnique,_guardExpressionIself) =
                (guardExpression_ (_guardExpressionObindingGroups) (_guardExpressionOkappaUnique))
            ( _thenExpressionIbindingGroups,_thenExpressionIkappaUnique,_thenExpressionIself) =
                (thenExpression_ (_thenExpressionObindingGroups) (_thenExpressionOkappaUnique))
            ( _elseExpressionIbindingGroups,_elseExpressionIkappaUnique,_elseExpressionIself) =
                (elseExpression_ (_elseExpressionObindingGroups) (_elseExpressionOkappaUnique))
            (_self@_) =
                Expression_If _rangeIself _guardExpressionIself _thenExpressionIself _elseExpressionIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _elseExpressionIbindingGroups
            (_lhsOkappaUnique@_) =
                _elseExpressionIkappaUnique
            (_guardExpressionObindingGroups@_) =
                _lhsIbindingGroups
            (_guardExpressionOkappaUnique@_) =
                _lhsIkappaUnique
            (_thenExpressionObindingGroups@_) =
                _guardExpressionIbindingGroups
            (_thenExpressionOkappaUnique@_) =
                _guardExpressionIkappaUnique
            (_elseExpressionObindingGroups@_) =
                _thenExpressionIbindingGroups
            (_elseExpressionOkappaUnique@_) =
                _thenExpressionIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_InfixApplication :: (T_Range) ->
                                   (T_MaybeExpression) ->
                                   (T_Expression) ->
                                   (T_MaybeExpression) ->
                                   (T_Expression)
sem_Expression_InfixApplication (range_) (leftExpression_) (operator_) (rightExpression_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _leftExpressionIbindingGroups :: (BindingGroups)
            _leftExpressionIkappaUnique :: (Int)
            _leftExpressionIself :: (MaybeExpression)
            _leftExpressionObindingGroups :: (BindingGroups)
            _leftExpressionOkappaUnique :: (Int)
            _operatorIbindingGroups :: (BindingGroups)
            _operatorIkappaUnique :: (Int)
            _operatorIself :: (Expression)
            _operatorObindingGroups :: (BindingGroups)
            _operatorOkappaUnique :: (Int)
            _rightExpressionIbindingGroups :: (BindingGroups)
            _rightExpressionIkappaUnique :: (Int)
            _rightExpressionIself :: (MaybeExpression)
            _rightExpressionObindingGroups :: (BindingGroups)
            _rightExpressionOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _leftExpressionIbindingGroups,_leftExpressionIkappaUnique,_leftExpressionIself) =
                (leftExpression_ (_leftExpressionObindingGroups) (_leftExpressionOkappaUnique))
            ( _operatorIbindingGroups,_operatorIkappaUnique,_operatorIself) =
                (operator_ (_operatorObindingGroups) (_operatorOkappaUnique))
            ( _rightExpressionIbindingGroups,_rightExpressionIkappaUnique,_rightExpressionIself) =
                (rightExpression_ (_rightExpressionObindingGroups) (_rightExpressionOkappaUnique))
            (_self@_) =
                Expression_InfixApplication _rangeIself _leftExpressionIself _operatorIself _rightExpressionIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _rightExpressionIbindingGroups
            (_lhsOkappaUnique@_) =
                _rightExpressionIkappaUnique
            (_leftExpressionObindingGroups@_) =
                _lhsIbindingGroups
            (_leftExpressionOkappaUnique@_) =
                _lhsIkappaUnique
            (_operatorObindingGroups@_) =
                _leftExpressionIbindingGroups
            (_operatorOkappaUnique@_) =
                _leftExpressionIkappaUnique
            (_rightExpressionObindingGroups@_) =
                _operatorIbindingGroups
            (_rightExpressionOkappaUnique@_) =
                _operatorIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_Lambda :: (T_Range) ->
                         (T_Patterns) ->
                         (T_Expression) ->
                         (T_Expression)
sem_Expression_Lambda (range_) (patterns_) (expression_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _patternsIself :: (Patterns)
            _expressionIbindingGroups :: (BindingGroups)
            _expressionIkappaUnique :: (Int)
            _expressionIself :: (Expression)
            _expressionObindingGroups :: (BindingGroups)
            _expressionOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _patternsIself) =
                (patterns_ )
            ( _expressionIbindingGroups,_expressionIkappaUnique,_expressionIself) =
                (expression_ (_expressionObindingGroups) (_expressionOkappaUnique))
            (_self@_) =
                Expression_Lambda _rangeIself _patternsIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _expressionIbindingGroups
            (_lhsOkappaUnique@_) =
                _expressionIkappaUnique
            (_expressionObindingGroups@_) =
                _lhsIbindingGroups
            (_expressionOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_Let :: (T_Range) ->
                      (T_Declarations) ->
                      (T_Expression) ->
                      (T_Expression)
sem_Expression_Let (range_) (declarations_) (expression_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _declarationsIbindingGroups :: (BindingGroups)
            _declarationsIkappaUnique :: (Int)
            _declarationsIself :: (Declarations)
            _declarationsObindingGroups :: (BindingGroups)
            _declarationsOkappaUnique :: (Int)
            _expressionIbindingGroups :: (BindingGroups)
            _expressionIkappaUnique :: (Int)
            _expressionIself :: (Expression)
            _expressionObindingGroups :: (BindingGroups)
            _expressionOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _declarationsIbindingGroups,_declarationsIkappaUnique,_declarationsIself) =
                (declarations_ (_declarationsObindingGroups) (_declarationsOkappaUnique))
            ( _expressionIbindingGroups,_expressionIkappaUnique,_expressionIself) =
                (expression_ (_expressionObindingGroups) (_expressionOkappaUnique))
            (_self@_) =
                Expression_Let _rangeIself _declarationsIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _expressionIbindingGroups
            (_lhsOkappaUnique@_) =
                _expressionIkappaUnique
            (_declarationsObindingGroups@_) =
                _lhsIbindingGroups
            (_declarationsOkappaUnique@_) =
                _lhsIkappaUnique
            (_expressionObindingGroups@_) =
                _declarationsIbindingGroups
            (_expressionOkappaUnique@_) =
                _declarationsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_List :: (T_Range) ->
                       (T_Expressions) ->
                       (T_Expression)
sem_Expression_List (range_) (expressions_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _expressionsIbindingGroups :: (BindingGroups)
            _expressionsIkappaUnique :: (Int)
            _expressionsIself :: (Expressions)
            _expressionsObindingGroups :: (BindingGroups)
            _expressionsOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionsIbindingGroups,_expressionsIkappaUnique,_expressionsIself) =
                (expressions_ (_expressionsObindingGroups) (_expressionsOkappaUnique))
            (_self@_) =
                Expression_List _rangeIself _expressionsIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _expressionsIbindingGroups
            (_lhsOkappaUnique@_) =
                _expressionsIkappaUnique
            (_expressionsObindingGroups@_) =
                _lhsIbindingGroups
            (_expressionsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_Literal :: (T_Range) ->
                          (T_Literal) ->
                          (T_Expression)
sem_Expression_Literal (range_) (literal_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _literalIself :: (Literal)
            ( _rangeIself) =
                (range_ )
            ( _literalIself) =
                (literal_ )
            (_self@_) =
                Expression_Literal _rangeIself _literalIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_Negate :: (T_Range) ->
                         (T_Expression) ->
                         (T_Expression)
sem_Expression_Negate (range_) (expression_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _expressionIbindingGroups :: (BindingGroups)
            _expressionIkappaUnique :: (Int)
            _expressionIself :: (Expression)
            _expressionObindingGroups :: (BindingGroups)
            _expressionOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionIbindingGroups,_expressionIkappaUnique,_expressionIself) =
                (expression_ (_expressionObindingGroups) (_expressionOkappaUnique))
            (_self@_) =
                Expression_Negate _rangeIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _expressionIbindingGroups
            (_lhsOkappaUnique@_) =
                _expressionIkappaUnique
            (_expressionObindingGroups@_) =
                _lhsIbindingGroups
            (_expressionOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_NegateFloat :: (T_Range) ->
                              (T_Expression) ->
                              (T_Expression)
sem_Expression_NegateFloat (range_) (expression_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _expressionIbindingGroups :: (BindingGroups)
            _expressionIkappaUnique :: (Int)
            _expressionIself :: (Expression)
            _expressionObindingGroups :: (BindingGroups)
            _expressionOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionIbindingGroups,_expressionIkappaUnique,_expressionIself) =
                (expression_ (_expressionObindingGroups) (_expressionOkappaUnique))
            (_self@_) =
                Expression_NegateFloat _rangeIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _expressionIbindingGroups
            (_lhsOkappaUnique@_) =
                _expressionIkappaUnique
            (_expressionObindingGroups@_) =
                _lhsIbindingGroups
            (_expressionOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_NormalApplication :: (T_Range) ->
                                    (T_Expression) ->
                                    (T_Expressions) ->
                                    (T_Expression)
sem_Expression_NormalApplication (range_) (function_) (arguments_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _functionIbindingGroups :: (BindingGroups)
            _functionIkappaUnique :: (Int)
            _functionIself :: (Expression)
            _functionObindingGroups :: (BindingGroups)
            _functionOkappaUnique :: (Int)
            _argumentsIbindingGroups :: (BindingGroups)
            _argumentsIkappaUnique :: (Int)
            _argumentsIself :: (Expressions)
            _argumentsObindingGroups :: (BindingGroups)
            _argumentsOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _functionIbindingGroups,_functionIkappaUnique,_functionIself) =
                (function_ (_functionObindingGroups) (_functionOkappaUnique))
            ( _argumentsIbindingGroups,_argumentsIkappaUnique,_argumentsIself) =
                (arguments_ (_argumentsObindingGroups) (_argumentsOkappaUnique))
            (_self@_) =
                Expression_NormalApplication _rangeIself _functionIself _argumentsIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _argumentsIbindingGroups
            (_lhsOkappaUnique@_) =
                _argumentsIkappaUnique
            (_functionObindingGroups@_) =
                _lhsIbindingGroups
            (_functionOkappaUnique@_) =
                _lhsIkappaUnique
            (_argumentsObindingGroups@_) =
                _functionIbindingGroups
            (_argumentsOkappaUnique@_) =
                _functionIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_Parenthesized :: (T_Range) ->
                                (T_Expression) ->
                                (T_Expression)
sem_Expression_Parenthesized (range_) (expression_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _expressionIbindingGroups :: (BindingGroups)
            _expressionIkappaUnique :: (Int)
            _expressionIself :: (Expression)
            _expressionObindingGroups :: (BindingGroups)
            _expressionOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionIbindingGroups,_expressionIkappaUnique,_expressionIself) =
                (expression_ (_expressionObindingGroups) (_expressionOkappaUnique))
            (_self@_) =
                Expression_Parenthesized _rangeIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _expressionIbindingGroups
            (_lhsOkappaUnique@_) =
                _expressionIkappaUnique
            (_expressionObindingGroups@_) =
                _lhsIbindingGroups
            (_expressionOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_RecordConstruction :: (T_Range) ->
                                     (T_Name) ->
                                     (T_RecordExpressionBindings) ->
                                     (T_Expression)
sem_Expression_RecordConstruction (range_) (name_) (recordExpressionBindings_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _recordExpressionBindingsIbindingGroups :: (BindingGroups)
            _recordExpressionBindingsIkappaUnique :: (Int)
            _recordExpressionBindingsIself :: (RecordExpressionBindings)
            _recordExpressionBindingsObindingGroups :: (BindingGroups)
            _recordExpressionBindingsOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _recordExpressionBindingsIbindingGroups,_recordExpressionBindingsIkappaUnique,_recordExpressionBindingsIself) =
                (recordExpressionBindings_ (_recordExpressionBindingsObindingGroups) (_recordExpressionBindingsOkappaUnique))
            (_self@_) =
                Expression_RecordConstruction _rangeIself _nameIself _recordExpressionBindingsIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _recordExpressionBindingsIbindingGroups
            (_lhsOkappaUnique@_) =
                _recordExpressionBindingsIkappaUnique
            (_recordExpressionBindingsObindingGroups@_) =
                _lhsIbindingGroups
            (_recordExpressionBindingsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_RecordUpdate :: (T_Range) ->
                               (T_Expression) ->
                               (T_RecordExpressionBindings) ->
                               (T_Expression)
sem_Expression_RecordUpdate (range_) (expression_) (recordExpressionBindings_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _expressionIbindingGroups :: (BindingGroups)
            _expressionIkappaUnique :: (Int)
            _expressionIself :: (Expression)
            _expressionObindingGroups :: (BindingGroups)
            _expressionOkappaUnique :: (Int)
            _recordExpressionBindingsIbindingGroups :: (BindingGroups)
            _recordExpressionBindingsIkappaUnique :: (Int)
            _recordExpressionBindingsIself :: (RecordExpressionBindings)
            _recordExpressionBindingsObindingGroups :: (BindingGroups)
            _recordExpressionBindingsOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionIbindingGroups,_expressionIkappaUnique,_expressionIself) =
                (expression_ (_expressionObindingGroups) (_expressionOkappaUnique))
            ( _recordExpressionBindingsIbindingGroups,_recordExpressionBindingsIkappaUnique,_recordExpressionBindingsIself) =
                (recordExpressionBindings_ (_recordExpressionBindingsObindingGroups) (_recordExpressionBindingsOkappaUnique))
            (_self@_) =
                Expression_RecordUpdate _rangeIself _expressionIself _recordExpressionBindingsIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _recordExpressionBindingsIbindingGroups
            (_lhsOkappaUnique@_) =
                _recordExpressionBindingsIkappaUnique
            (_expressionObindingGroups@_) =
                _lhsIbindingGroups
            (_expressionOkappaUnique@_) =
                _lhsIkappaUnique
            (_recordExpressionBindingsObindingGroups@_) =
                _expressionIbindingGroups
            (_recordExpressionBindingsOkappaUnique@_) =
                _expressionIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_Tuple :: (T_Range) ->
                        (T_Expressions) ->
                        (T_Expression)
sem_Expression_Tuple (range_) (expressions_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _expressionsIbindingGroups :: (BindingGroups)
            _expressionsIkappaUnique :: (Int)
            _expressionsIself :: (Expressions)
            _expressionsObindingGroups :: (BindingGroups)
            _expressionsOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionsIbindingGroups,_expressionsIkappaUnique,_expressionsIself) =
                (expressions_ (_expressionsObindingGroups) (_expressionsOkappaUnique))
            (_self@_) =
                Expression_Tuple _rangeIself _expressionsIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _expressionsIbindingGroups
            (_lhsOkappaUnique@_) =
                _expressionsIkappaUnique
            (_expressionsObindingGroups@_) =
                _lhsIbindingGroups
            (_expressionsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_Typed :: (T_Range) ->
                        (T_Expression) ->
                        (T_Type) ->
                        (T_Expression)
sem_Expression_Typed (range_) (expression_) (type_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _expressionIbindingGroups :: (BindingGroups)
            _expressionIkappaUnique :: (Int)
            _expressionIself :: (Expression)
            _expressionObindingGroups :: (BindingGroups)
            _expressionOkappaUnique :: (Int)
            _typeIassumptions :: (Assumptions)
            _typeIconstraints :: (KindConstraints)
            _typeIkappa :: (Kind)
            _typeIkappaUnique :: (Int)
            _typeIself :: (Type)
            _typeOconstraints :: (KindConstraints)
            _typeOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionIbindingGroups,_expressionIkappaUnique,_expressionIself) =
                (expression_ (_expressionObindingGroups) (_expressionOkappaUnique))
            ( _typeIassumptions,_typeIconstraints,_typeIkappa,_typeIkappaUnique,_typeIself) =
                (type_ (_typeOconstraints) (_typeOkappaUnique))
            (_newGroup@_) =
                (M.empty, _aset, _cset ++ _typeIconstraints ++ [_newConstraint])
            ((_cset@_,_aset@_)) =
                (M.fromList _tvEnv .===. _typeIassumptions) (\n -> unexpected $ "Expression.Typed " ++ show n)
            (_tvEnv@_) =
                zip (getTypeVariables _typeIassumptions) (map TVar [_typeIkappaUnique..])
            (_newConstraint@_) =
                (_typeIkappa <==> star) (mustBeStar _rangeIself "type annotation" _typeIself)
            (_lhsOkappaUnique@_) =
                _typeIkappaUnique + length _tvEnv
            (_lhsObindingGroups@_) =
                _newGroup : _expressionIbindingGroups
            (_typeOconstraints@_) =
                []
            (_self@_) =
                Expression_Typed _rangeIself _expressionIself _typeIself
            (_lhsOself@_) =
                _self
            (_expressionObindingGroups@_) =
                _lhsIbindingGroups
            (_expressionOkappaUnique@_) =
                _lhsIkappaUnique
            (_typeOkappaUnique@_) =
                _expressionIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expression_Variable :: (T_Range) ->
                           (T_Name) ->
                           (T_Expression)
sem_Expression_Variable (range_) (name_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expression)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            (_self@_) =
                Expression_Variable _rangeIself _nameIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- Expressions -------------------------------------------------
-- semantic domain
type T_Expressions = (BindingGroups) ->
                     (Int) ->
                     ( (BindingGroups),(Int),(Expressions))
-- cata
sem_Expressions :: (Expressions) ->
                   (T_Expressions)
sem_Expressions (list) =
    (Prelude.foldr (sem_Expressions_Cons) (sem_Expressions_Nil) ((Prelude.map sem_Expression list)))
sem_Expressions_Cons :: (T_Expression) ->
                        (T_Expressions) ->
                        (T_Expressions)
sem_Expressions_Cons (hd_) (tl_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expressions)
            _hdIbindingGroups :: (BindingGroups)
            _hdIkappaUnique :: (Int)
            _hdIself :: (Expression)
            _hdObindingGroups :: (BindingGroups)
            _hdOkappaUnique :: (Int)
            _tlIbindingGroups :: (BindingGroups)
            _tlIkappaUnique :: (Int)
            _tlIself :: (Expressions)
            _tlObindingGroups :: (BindingGroups)
            _tlOkappaUnique :: (Int)
            ( _hdIbindingGroups,_hdIkappaUnique,_hdIself) =
                (hd_ (_hdObindingGroups) (_hdOkappaUnique))
            ( _tlIbindingGroups,_tlIkappaUnique,_tlIself) =
                (tl_ (_tlObindingGroups) (_tlOkappaUnique))
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _tlIbindingGroups
            (_lhsOkappaUnique@_) =
                _tlIkappaUnique
            (_hdObindingGroups@_) =
                _lhsIbindingGroups
            (_hdOkappaUnique@_) =
                _lhsIkappaUnique
            (_tlObindingGroups@_) =
                _hdIbindingGroups
            (_tlOkappaUnique@_) =
                _hdIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Expressions_Nil :: (T_Expressions)
sem_Expressions_Nil  =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Expressions)
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- FieldDeclaration --------------------------------------------
-- semantic domain
type T_FieldDeclaration = (Int) ->
                          ( (Int),(FieldDeclaration))
-- cata
sem_FieldDeclaration :: (FieldDeclaration) ->
                        (T_FieldDeclaration)
sem_FieldDeclaration ((FieldDeclaration_FieldDeclaration (_range) (_names) (_type))) =
    (sem_FieldDeclaration_FieldDeclaration ((sem_Range (_range))) ((sem_Names (_names))) ((sem_AnnotatedType (_type))))
sem_FieldDeclaration_FieldDeclaration :: (T_Range) ->
                                         (T_Names) ->
                                         (T_AnnotatedType) ->
                                         (T_FieldDeclaration)
sem_FieldDeclaration_FieldDeclaration (range_) (names_) (type_) =
    \ _lhsIkappaUnique ->
        let _lhsOkappaUnique :: (Int)
            _lhsOself :: (FieldDeclaration)
            _rangeIself :: (Range)
            _namesIself :: (Names)
            _typeIassumptions :: (Assumptions)
            _typeIconstraints :: (KindConstraints)
            _typeIkappa :: (Kind)
            _typeIkappaUnique :: (Int)
            _typeIself :: (AnnotatedType)
            _typeOconstraints :: (KindConstraints)
            _typeOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _namesIself) =
                (names_ )
            ( _typeIassumptions,_typeIconstraints,_typeIkappa,_typeIkappaUnique,_typeIself) =
                (type_ (_typeOconstraints) (_typeOkappaUnique))
            (_constraints@_) =
                internalError "KindInferencing.ag" "n/a" "Field decls are not supported"
            (_self@_) =
                FieldDeclaration_FieldDeclaration _rangeIself _namesIself _typeIself
            (_lhsOself@_) =
                _self
            (_lhsOkappaUnique@_) =
                _typeIkappaUnique
            (_typeOconstraints@_) =
                _constraints
            (_typeOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsOkappaUnique,_lhsOself)
-- FieldDeclarations -------------------------------------------
-- semantic domain
type T_FieldDeclarations = (Int) ->
                           ( (Int),(FieldDeclarations))
-- cata
sem_FieldDeclarations :: (FieldDeclarations) ->
                         (T_FieldDeclarations)
sem_FieldDeclarations (list) =
    (Prelude.foldr (sem_FieldDeclarations_Cons) (sem_FieldDeclarations_Nil) ((Prelude.map sem_FieldDeclaration list)))
sem_FieldDeclarations_Cons :: (T_FieldDeclaration) ->
                              (T_FieldDeclarations) ->
                              (T_FieldDeclarations)
sem_FieldDeclarations_Cons (hd_) (tl_) =
    \ _lhsIkappaUnique ->
        let _lhsOkappaUnique :: (Int)
            _lhsOself :: (FieldDeclarations)
            _hdIkappaUnique :: (Int)
            _hdIself :: (FieldDeclaration)
            _hdOkappaUnique :: (Int)
            _tlIkappaUnique :: (Int)
            _tlIself :: (FieldDeclarations)
            _tlOkappaUnique :: (Int)
            ( _hdIkappaUnique,_hdIself) =
                (hd_ (_hdOkappaUnique))
            ( _tlIkappaUnique,_tlIself) =
                (tl_ (_tlOkappaUnique))
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOkappaUnique@_) =
                _tlIkappaUnique
            (_hdOkappaUnique@_) =
                _lhsIkappaUnique
            (_tlOkappaUnique@_) =
                _hdIkappaUnique
        in  ( _lhsOkappaUnique,_lhsOself)
sem_FieldDeclarations_Nil :: (T_FieldDeclarations)
sem_FieldDeclarations_Nil  =
    \ _lhsIkappaUnique ->
        let _lhsOkappaUnique :: (Int)
            _lhsOself :: (FieldDeclarations)
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsOkappaUnique,_lhsOself)
-- Fixity ------------------------------------------------------
-- semantic domain
type T_Fixity = ( (Fixity))
-- cata
sem_Fixity :: (Fixity) ->
              (T_Fixity)
sem_Fixity ((Fixity_Infix (_range))) =
    (sem_Fixity_Infix ((sem_Range (_range))))
sem_Fixity ((Fixity_Infixl (_range))) =
    (sem_Fixity_Infixl ((sem_Range (_range))))
sem_Fixity ((Fixity_Infixr (_range))) =
    (sem_Fixity_Infixr ((sem_Range (_range))))
sem_Fixity_Infix :: (T_Range) ->
                    (T_Fixity)
sem_Fixity_Infix (range_) =
    let _lhsOself :: (Fixity)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_self@_) =
            Fixity_Infix _rangeIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Fixity_Infixl :: (T_Range) ->
                     (T_Fixity)
sem_Fixity_Infixl (range_) =
    let _lhsOself :: (Fixity)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_self@_) =
            Fixity_Infixl _rangeIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Fixity_Infixr :: (T_Range) ->
                     (T_Fixity)
sem_Fixity_Infixr (range_) =
    let _lhsOself :: (Fixity)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_self@_) =
            Fixity_Infixr _rangeIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- FunctionBinding ---------------------------------------------
-- semantic domain
type T_FunctionBinding = (BindingGroups) ->
                         (Int) ->
                         ( (BindingGroups),(Int),(FunctionBinding))
-- cata
sem_FunctionBinding :: (FunctionBinding) ->
                       (T_FunctionBinding)
sem_FunctionBinding ((FunctionBinding_FunctionBinding (_range) (_lefthandside) (_righthandside))) =
    (sem_FunctionBinding_FunctionBinding ((sem_Range (_range))) ((sem_LeftHandSide (_lefthandside))) ((sem_RightHandSide (_righthandside))))
sem_FunctionBinding_FunctionBinding :: (T_Range) ->
                                       (T_LeftHandSide) ->
                                       (T_RightHandSide) ->
                                       (T_FunctionBinding)
sem_FunctionBinding_FunctionBinding (range_) (lefthandside_) (righthandside_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (FunctionBinding)
            _rangeIself :: (Range)
            _lefthandsideIself :: (LeftHandSide)
            _righthandsideIbindingGroups :: (BindingGroups)
            _righthandsideIkappaUnique :: (Int)
            _righthandsideIself :: (RightHandSide)
            _righthandsideObindingGroups :: (BindingGroups)
            _righthandsideOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _lefthandsideIself) =
                (lefthandside_ )
            ( _righthandsideIbindingGroups,_righthandsideIkappaUnique,_righthandsideIself) =
                (righthandside_ (_righthandsideObindingGroups) (_righthandsideOkappaUnique))
            (_self@_) =
                FunctionBinding_FunctionBinding _rangeIself _lefthandsideIself _righthandsideIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _righthandsideIbindingGroups
            (_lhsOkappaUnique@_) =
                _righthandsideIkappaUnique
            (_righthandsideObindingGroups@_) =
                _lhsIbindingGroups
            (_righthandsideOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- FunctionBindings --------------------------------------------
-- semantic domain
type T_FunctionBindings = (BindingGroups) ->
                          (Int) ->
                          ( (BindingGroups),(Int),(FunctionBindings))
-- cata
sem_FunctionBindings :: (FunctionBindings) ->
                        (T_FunctionBindings)
sem_FunctionBindings (list) =
    (Prelude.foldr (sem_FunctionBindings_Cons) (sem_FunctionBindings_Nil) ((Prelude.map sem_FunctionBinding list)))
sem_FunctionBindings_Cons :: (T_FunctionBinding) ->
                             (T_FunctionBindings) ->
                             (T_FunctionBindings)
sem_FunctionBindings_Cons (hd_) (tl_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (FunctionBindings)
            _hdIbindingGroups :: (BindingGroups)
            _hdIkappaUnique :: (Int)
            _hdIself :: (FunctionBinding)
            _hdObindingGroups :: (BindingGroups)
            _hdOkappaUnique :: (Int)
            _tlIbindingGroups :: (BindingGroups)
            _tlIkappaUnique :: (Int)
            _tlIself :: (FunctionBindings)
            _tlObindingGroups :: (BindingGroups)
            _tlOkappaUnique :: (Int)
            ( _hdIbindingGroups,_hdIkappaUnique,_hdIself) =
                (hd_ (_hdObindingGroups) (_hdOkappaUnique))
            ( _tlIbindingGroups,_tlIkappaUnique,_tlIself) =
                (tl_ (_tlObindingGroups) (_tlOkappaUnique))
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _tlIbindingGroups
            (_lhsOkappaUnique@_) =
                _tlIkappaUnique
            (_hdObindingGroups@_) =
                _lhsIbindingGroups
            (_hdOkappaUnique@_) =
                _lhsIkappaUnique
            (_tlObindingGroups@_) =
                _hdIbindingGroups
            (_tlOkappaUnique@_) =
                _hdIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_FunctionBindings_Nil :: (T_FunctionBindings)
sem_FunctionBindings_Nil  =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (FunctionBindings)
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- GuardedExpression -------------------------------------------
-- semantic domain
type T_GuardedExpression = (BindingGroups) ->
                           (Int) ->
                           ( (BindingGroups),(Int),(GuardedExpression))
-- cata
sem_GuardedExpression :: (GuardedExpression) ->
                         (T_GuardedExpression)
sem_GuardedExpression ((GuardedExpression_GuardedExpression (_range) (_guard) (_expression))) =
    (sem_GuardedExpression_GuardedExpression ((sem_Range (_range))) ((sem_Expression (_guard))) ((sem_Expression (_expression))))
sem_GuardedExpression_GuardedExpression :: (T_Range) ->
                                           (T_Expression) ->
                                           (T_Expression) ->
                                           (T_GuardedExpression)
sem_GuardedExpression_GuardedExpression (range_) (guard_) (expression_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (GuardedExpression)
            _rangeIself :: (Range)
            _guardIbindingGroups :: (BindingGroups)
            _guardIkappaUnique :: (Int)
            _guardIself :: (Expression)
            _guardObindingGroups :: (BindingGroups)
            _guardOkappaUnique :: (Int)
            _expressionIbindingGroups :: (BindingGroups)
            _expressionIkappaUnique :: (Int)
            _expressionIself :: (Expression)
            _expressionObindingGroups :: (BindingGroups)
            _expressionOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _guardIbindingGroups,_guardIkappaUnique,_guardIself) =
                (guard_ (_guardObindingGroups) (_guardOkappaUnique))
            ( _expressionIbindingGroups,_expressionIkappaUnique,_expressionIself) =
                (expression_ (_expressionObindingGroups) (_expressionOkappaUnique))
            (_self@_) =
                GuardedExpression_GuardedExpression _rangeIself _guardIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _expressionIbindingGroups
            (_lhsOkappaUnique@_) =
                _expressionIkappaUnique
            (_guardObindingGroups@_) =
                _lhsIbindingGroups
            (_guardOkappaUnique@_) =
                _lhsIkappaUnique
            (_expressionObindingGroups@_) =
                _guardIbindingGroups
            (_expressionOkappaUnique@_) =
                _guardIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- GuardedExpressions ------------------------------------------
-- semantic domain
type T_GuardedExpressions = (BindingGroups) ->
                            (Int) ->
                            ( (BindingGroups),(Int),(GuardedExpressions))
-- cata
sem_GuardedExpressions :: (GuardedExpressions) ->
                          (T_GuardedExpressions)
sem_GuardedExpressions (list) =
    (Prelude.foldr (sem_GuardedExpressions_Cons) (sem_GuardedExpressions_Nil) ((Prelude.map sem_GuardedExpression list)))
sem_GuardedExpressions_Cons :: (T_GuardedExpression) ->
                               (T_GuardedExpressions) ->
                               (T_GuardedExpressions)
sem_GuardedExpressions_Cons (hd_) (tl_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (GuardedExpressions)
            _hdIbindingGroups :: (BindingGroups)
            _hdIkappaUnique :: (Int)
            _hdIself :: (GuardedExpression)
            _hdObindingGroups :: (BindingGroups)
            _hdOkappaUnique :: (Int)
            _tlIbindingGroups :: (BindingGroups)
            _tlIkappaUnique :: (Int)
            _tlIself :: (GuardedExpressions)
            _tlObindingGroups :: (BindingGroups)
            _tlOkappaUnique :: (Int)
            ( _hdIbindingGroups,_hdIkappaUnique,_hdIself) =
                (hd_ (_hdObindingGroups) (_hdOkappaUnique))
            ( _tlIbindingGroups,_tlIkappaUnique,_tlIself) =
                (tl_ (_tlObindingGroups) (_tlOkappaUnique))
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _tlIbindingGroups
            (_lhsOkappaUnique@_) =
                _tlIkappaUnique
            (_hdObindingGroups@_) =
                _lhsIbindingGroups
            (_hdOkappaUnique@_) =
                _lhsIkappaUnique
            (_tlObindingGroups@_) =
                _hdIbindingGroups
            (_tlOkappaUnique@_) =
                _hdIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_GuardedExpressions_Nil :: (T_GuardedExpressions)
sem_GuardedExpressions_Nil  =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (GuardedExpressions)
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- Import ------------------------------------------------------
-- semantic domain
type T_Import = ( (Import))
-- cata
sem_Import :: (Import) ->
              (T_Import)
sem_Import ((Import_TypeOrClass (_range) (_name) (_names))) =
    (sem_Import_TypeOrClass ((sem_Range (_range))) ((sem_Name (_name))) ((sem_MaybeNames (_names))))
sem_Import ((Import_TypeOrClassComplete (_range) (_name))) =
    (sem_Import_TypeOrClassComplete ((sem_Range (_range))) ((sem_Name (_name))))
sem_Import ((Import_Variable (_range) (_name))) =
    (sem_Import_Variable ((sem_Range (_range))) ((sem_Name (_name))))
sem_Import_TypeOrClass :: (T_Range) ->
                          (T_Name) ->
                          (T_MaybeNames) ->
                          (T_Import)
sem_Import_TypeOrClass (range_) (name_) (names_) =
    let _lhsOself :: (Import)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        _namesIself :: (MaybeNames)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        ( _namesIself) =
            (names_ )
        (_self@_) =
            Import_TypeOrClass _rangeIself _nameIself _namesIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Import_TypeOrClassComplete :: (T_Range) ->
                                  (T_Name) ->
                                  (T_Import)
sem_Import_TypeOrClassComplete (range_) (name_) =
    let _lhsOself :: (Import)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        (_self@_) =
            Import_TypeOrClassComplete _rangeIself _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Import_Variable :: (T_Range) ->
                       (T_Name) ->
                       (T_Import)
sem_Import_Variable (range_) (name_) =
    let _lhsOself :: (Import)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        (_self@_) =
            Import_Variable _rangeIself _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- ImportDeclaration -------------------------------------------
-- semantic domain
type T_ImportDeclaration = ( (ImportDeclaration))
-- cata
sem_ImportDeclaration :: (ImportDeclaration) ->
                         (T_ImportDeclaration)
sem_ImportDeclaration ((ImportDeclaration_Empty (_range))) =
    (sem_ImportDeclaration_Empty ((sem_Range (_range))))
sem_ImportDeclaration ((ImportDeclaration_Import (_range) (_qualified) (_name) (_asname) (_importspecification))) =
    (sem_ImportDeclaration_Import ((sem_Range (_range))) (_qualified) ((sem_Name (_name))) ((sem_MaybeName (_asname))) ((sem_MaybeImportSpecification (_importspecification))))
sem_ImportDeclaration_Empty :: (T_Range) ->
                               (T_ImportDeclaration)
sem_ImportDeclaration_Empty (range_) =
    let _lhsOself :: (ImportDeclaration)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_self@_) =
            ImportDeclaration_Empty _rangeIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_ImportDeclaration_Import :: (T_Range) ->
                                (Bool) ->
                                (T_Name) ->
                                (T_MaybeName) ->
                                (T_MaybeImportSpecification) ->
                                (T_ImportDeclaration)
sem_ImportDeclaration_Import (range_) (qualified_) (name_) (asname_) (importspecification_) =
    let _lhsOself :: (ImportDeclaration)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        _asnameIself :: (MaybeName)
        _importspecificationIself :: (MaybeImportSpecification)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        ( _asnameIself) =
            (asname_ )
        ( _importspecificationIself) =
            (importspecification_ )
        (_self@_) =
            ImportDeclaration_Import _rangeIself qualified_ _nameIself _asnameIself _importspecificationIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- ImportDeclarations ------------------------------------------
-- semantic domain
type T_ImportDeclarations = ( (ImportDeclarations))
-- cata
sem_ImportDeclarations :: (ImportDeclarations) ->
                          (T_ImportDeclarations)
sem_ImportDeclarations (list) =
    (Prelude.foldr (sem_ImportDeclarations_Cons) (sem_ImportDeclarations_Nil) ((Prelude.map sem_ImportDeclaration list)))
sem_ImportDeclarations_Cons :: (T_ImportDeclaration) ->
                               (T_ImportDeclarations) ->
                               (T_ImportDeclarations)
sem_ImportDeclarations_Cons (hd_) (tl_) =
    let _lhsOself :: (ImportDeclarations)
        _hdIself :: (ImportDeclaration)
        _tlIself :: (ImportDeclarations)
        ( _hdIself) =
            (hd_ )
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_ImportDeclarations_Nil :: (T_ImportDeclarations)
sem_ImportDeclarations_Nil  =
    let _lhsOself :: (ImportDeclarations)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- ImportSpecification -----------------------------------------
-- semantic domain
type T_ImportSpecification = ( (ImportSpecification))
-- cata
sem_ImportSpecification :: (ImportSpecification) ->
                           (T_ImportSpecification)
sem_ImportSpecification ((ImportSpecification_Import (_range) (_hiding) (_imports))) =
    (sem_ImportSpecification_Import ((sem_Range (_range))) (_hiding) ((sem_Imports (_imports))))
sem_ImportSpecification_Import :: (T_Range) ->
                                  (Bool) ->
                                  (T_Imports) ->
                                  (T_ImportSpecification)
sem_ImportSpecification_Import (range_) (hiding_) (imports_) =
    let _lhsOself :: (ImportSpecification)
        _rangeIself :: (Range)
        _importsIself :: (Imports)
        ( _rangeIself) =
            (range_ )
        ( _importsIself) =
            (imports_ )
        (_self@_) =
            ImportSpecification_Import _rangeIself hiding_ _importsIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Imports -----------------------------------------------------
-- semantic domain
type T_Imports = ( (Imports))
-- cata
sem_Imports :: (Imports) ->
               (T_Imports)
sem_Imports (list) =
    (Prelude.foldr (sem_Imports_Cons) (sem_Imports_Nil) ((Prelude.map sem_Import list)))
sem_Imports_Cons :: (T_Import) ->
                    (T_Imports) ->
                    (T_Imports)
sem_Imports_Cons (hd_) (tl_) =
    let _lhsOself :: (Imports)
        _hdIself :: (Import)
        _tlIself :: (Imports)
        ( _hdIself) =
            (hd_ )
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Imports_Nil :: (T_Imports)
sem_Imports_Nil  =
    let _lhsOself :: (Imports)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- LeftHandSide ------------------------------------------------
-- semantic domain
type T_LeftHandSide = ( (LeftHandSide))
-- cata
sem_LeftHandSide :: (LeftHandSide) ->
                    (T_LeftHandSide)
sem_LeftHandSide ((LeftHandSide_Function (_range) (_name) (_patterns))) =
    (sem_LeftHandSide_Function ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Patterns (_patterns))))
sem_LeftHandSide ((LeftHandSide_Infix (_range) (_leftPattern) (_operator) (_rightPattern))) =
    (sem_LeftHandSide_Infix ((sem_Range (_range))) ((sem_Pattern (_leftPattern))) ((sem_Name (_operator))) ((sem_Pattern (_rightPattern))))
sem_LeftHandSide ((LeftHandSide_Parenthesized (_range) (_lefthandside) (_patterns))) =
    (sem_LeftHandSide_Parenthesized ((sem_Range (_range))) ((sem_LeftHandSide (_lefthandside))) ((sem_Patterns (_patterns))))
sem_LeftHandSide_Function :: (T_Range) ->
                             (T_Name) ->
                             (T_Patterns) ->
                             (T_LeftHandSide)
sem_LeftHandSide_Function (range_) (name_) (patterns_) =
    let _lhsOself :: (LeftHandSide)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        _patternsIself :: (Patterns)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        ( _patternsIself) =
            (patterns_ )
        (_self@_) =
            LeftHandSide_Function _rangeIself _nameIself _patternsIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_LeftHandSide_Infix :: (T_Range) ->
                          (T_Pattern) ->
                          (T_Name) ->
                          (T_Pattern) ->
                          (T_LeftHandSide)
sem_LeftHandSide_Infix (range_) (leftPattern_) (operator_) (rightPattern_) =
    let _lhsOself :: (LeftHandSide)
        _rangeIself :: (Range)
        _leftPatternIself :: (Pattern)
        _operatorIself :: (Name)
        _rightPatternIself :: (Pattern)
        ( _rangeIself) =
            (range_ )
        ( _leftPatternIself) =
            (leftPattern_ )
        ( _operatorIself) =
            (operator_ )
        ( _rightPatternIself) =
            (rightPattern_ )
        (_self@_) =
            LeftHandSide_Infix _rangeIself _leftPatternIself _operatorIself _rightPatternIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_LeftHandSide_Parenthesized :: (T_Range) ->
                                  (T_LeftHandSide) ->
                                  (T_Patterns) ->
                                  (T_LeftHandSide)
sem_LeftHandSide_Parenthesized (range_) (lefthandside_) (patterns_) =
    let _lhsOself :: (LeftHandSide)
        _rangeIself :: (Range)
        _lefthandsideIself :: (LeftHandSide)
        _patternsIself :: (Patterns)
        ( _rangeIself) =
            (range_ )
        ( _lefthandsideIself) =
            (lefthandside_ )
        ( _patternsIself) =
            (patterns_ )
        (_self@_) =
            LeftHandSide_Parenthesized _rangeIself _lefthandsideIself _patternsIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Literal -----------------------------------------------------
-- semantic domain
type T_Literal = ( (Literal))
-- cata
sem_Literal :: (Literal) ->
               (T_Literal)
sem_Literal ((Literal_Char (_range) (_value))) =
    (sem_Literal_Char ((sem_Range (_range))) (_value))
sem_Literal ((Literal_Float (_range) (_value))) =
    (sem_Literal_Float ((sem_Range (_range))) (_value))
sem_Literal ((Literal_Int (_range) (_value))) =
    (sem_Literal_Int ((sem_Range (_range))) (_value))
sem_Literal ((Literal_String (_range) (_value))) =
    (sem_Literal_String ((sem_Range (_range))) (_value))
sem_Literal_Char :: (T_Range) ->
                    (String) ->
                    (T_Literal)
sem_Literal_Char (range_) (value_) =
    let _lhsOself :: (Literal)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_self@_) =
            Literal_Char _rangeIself value_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Literal_Float :: (T_Range) ->
                     (String) ->
                     (T_Literal)
sem_Literal_Float (range_) (value_) =
    let _lhsOself :: (Literal)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_self@_) =
            Literal_Float _rangeIself value_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Literal_Int :: (T_Range) ->
                   (String) ->
                   (T_Literal)
sem_Literal_Int (range_) (value_) =
    let _lhsOself :: (Literal)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_self@_) =
            Literal_Int _rangeIself value_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Literal_String :: (T_Range) ->
                      (String) ->
                      (T_Literal)
sem_Literal_String (range_) (value_) =
    let _lhsOself :: (Literal)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_self@_) =
            Literal_String _rangeIself value_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- MaybeDeclarations -------------------------------------------
-- semantic domain
type T_MaybeDeclarations = (BindingGroups) ->
                           (Int) ->
                           ( (BindingGroups),(Int),(MaybeDeclarations))
-- cata
sem_MaybeDeclarations :: (MaybeDeclarations) ->
                         (T_MaybeDeclarations)
sem_MaybeDeclarations ((MaybeDeclarations_Just (_declarations))) =
    (sem_MaybeDeclarations_Just ((sem_Declarations (_declarations))))
sem_MaybeDeclarations ((MaybeDeclarations_Nothing )) =
    (sem_MaybeDeclarations_Nothing )
sem_MaybeDeclarations_Just :: (T_Declarations) ->
                              (T_MaybeDeclarations)
sem_MaybeDeclarations_Just (declarations_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (MaybeDeclarations)
            _declarationsIbindingGroups :: (BindingGroups)
            _declarationsIkappaUnique :: (Int)
            _declarationsIself :: (Declarations)
            _declarationsObindingGroups :: (BindingGroups)
            _declarationsOkappaUnique :: (Int)
            ( _declarationsIbindingGroups,_declarationsIkappaUnique,_declarationsIself) =
                (declarations_ (_declarationsObindingGroups) (_declarationsOkappaUnique))
            (_self@_) =
                MaybeDeclarations_Just _declarationsIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _declarationsIbindingGroups
            (_lhsOkappaUnique@_) =
                _declarationsIkappaUnique
            (_declarationsObindingGroups@_) =
                _lhsIbindingGroups
            (_declarationsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_MaybeDeclarations_Nothing :: (T_MaybeDeclarations)
sem_MaybeDeclarations_Nothing  =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (MaybeDeclarations)
            (_self@_) =
                MaybeDeclarations_Nothing
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- MaybeExports ------------------------------------------------
-- semantic domain
type T_MaybeExports = ( (MaybeExports))
-- cata
sem_MaybeExports :: (MaybeExports) ->
                    (T_MaybeExports)
sem_MaybeExports ((MaybeExports_Just (_exports))) =
    (sem_MaybeExports_Just ((sem_Exports (_exports))))
sem_MaybeExports ((MaybeExports_Nothing )) =
    (sem_MaybeExports_Nothing )
sem_MaybeExports_Just :: (T_Exports) ->
                         (T_MaybeExports)
sem_MaybeExports_Just (exports_) =
    let _lhsOself :: (MaybeExports)
        _exportsIself :: (Exports)
        ( _exportsIself) =
            (exports_ )
        (_self@_) =
            MaybeExports_Just _exportsIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_MaybeExports_Nothing :: (T_MaybeExports)
sem_MaybeExports_Nothing  =
    let _lhsOself :: (MaybeExports)
        (_self@_) =
            MaybeExports_Nothing
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- MaybeExpression ---------------------------------------------
-- semantic domain
type T_MaybeExpression = (BindingGroups) ->
                         (Int) ->
                         ( (BindingGroups),(Int),(MaybeExpression))
-- cata
sem_MaybeExpression :: (MaybeExpression) ->
                       (T_MaybeExpression)
sem_MaybeExpression ((MaybeExpression_Just (_expression))) =
    (sem_MaybeExpression_Just ((sem_Expression (_expression))))
sem_MaybeExpression ((MaybeExpression_Nothing )) =
    (sem_MaybeExpression_Nothing )
sem_MaybeExpression_Just :: (T_Expression) ->
                            (T_MaybeExpression)
sem_MaybeExpression_Just (expression_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (MaybeExpression)
            _expressionIbindingGroups :: (BindingGroups)
            _expressionIkappaUnique :: (Int)
            _expressionIself :: (Expression)
            _expressionObindingGroups :: (BindingGroups)
            _expressionOkappaUnique :: (Int)
            ( _expressionIbindingGroups,_expressionIkappaUnique,_expressionIself) =
                (expression_ (_expressionObindingGroups) (_expressionOkappaUnique))
            (_self@_) =
                MaybeExpression_Just _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _expressionIbindingGroups
            (_lhsOkappaUnique@_) =
                _expressionIkappaUnique
            (_expressionObindingGroups@_) =
                _lhsIbindingGroups
            (_expressionOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_MaybeExpression_Nothing :: (T_MaybeExpression)
sem_MaybeExpression_Nothing  =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (MaybeExpression)
            (_self@_) =
                MaybeExpression_Nothing
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- MaybeImportSpecification ------------------------------------
-- semantic domain
type T_MaybeImportSpecification = ( (MaybeImportSpecification))
-- cata
sem_MaybeImportSpecification :: (MaybeImportSpecification) ->
                                (T_MaybeImportSpecification)
sem_MaybeImportSpecification ((MaybeImportSpecification_Just (_importspecification))) =
    (sem_MaybeImportSpecification_Just ((sem_ImportSpecification (_importspecification))))
sem_MaybeImportSpecification ((MaybeImportSpecification_Nothing )) =
    (sem_MaybeImportSpecification_Nothing )
sem_MaybeImportSpecification_Just :: (T_ImportSpecification) ->
                                     (T_MaybeImportSpecification)
sem_MaybeImportSpecification_Just (importspecification_) =
    let _lhsOself :: (MaybeImportSpecification)
        _importspecificationIself :: (ImportSpecification)
        ( _importspecificationIself) =
            (importspecification_ )
        (_self@_) =
            MaybeImportSpecification_Just _importspecificationIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_MaybeImportSpecification_Nothing :: (T_MaybeImportSpecification)
sem_MaybeImportSpecification_Nothing  =
    let _lhsOself :: (MaybeImportSpecification)
        (_self@_) =
            MaybeImportSpecification_Nothing
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- MaybeInt ----------------------------------------------------
-- semantic domain
type T_MaybeInt = ( (MaybeInt))
-- cata
sem_MaybeInt :: (MaybeInt) ->
                (T_MaybeInt)
sem_MaybeInt ((MaybeInt_Just (_int))) =
    (sem_MaybeInt_Just (_int))
sem_MaybeInt ((MaybeInt_Nothing )) =
    (sem_MaybeInt_Nothing )
sem_MaybeInt_Just :: (Int) ->
                     (T_MaybeInt)
sem_MaybeInt_Just (int_) =
    let _lhsOself :: (MaybeInt)
        (_self@_) =
            MaybeInt_Just int_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_MaybeInt_Nothing :: (T_MaybeInt)
sem_MaybeInt_Nothing  =
    let _lhsOself :: (MaybeInt)
        (_self@_) =
            MaybeInt_Nothing
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- MaybeName ---------------------------------------------------
-- semantic domain
type T_MaybeName = ( (MaybeName))
-- cata
sem_MaybeName :: (MaybeName) ->
                 (T_MaybeName)
sem_MaybeName ((MaybeName_Just (_name))) =
    (sem_MaybeName_Just ((sem_Name (_name))))
sem_MaybeName ((MaybeName_Nothing )) =
    (sem_MaybeName_Nothing )
sem_MaybeName_Just :: (T_Name) ->
                      (T_MaybeName)
sem_MaybeName_Just (name_) =
    let _lhsOself :: (MaybeName)
        _nameIself :: (Name)
        ( _nameIself) =
            (name_ )
        (_self@_) =
            MaybeName_Just _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_MaybeName_Nothing :: (T_MaybeName)
sem_MaybeName_Nothing  =
    let _lhsOself :: (MaybeName)
        (_self@_) =
            MaybeName_Nothing
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- MaybeNames --------------------------------------------------
-- semantic domain
type T_MaybeNames = ( (MaybeNames))
-- cata
sem_MaybeNames :: (MaybeNames) ->
                  (T_MaybeNames)
sem_MaybeNames ((MaybeNames_Just (_names))) =
    (sem_MaybeNames_Just ((sem_Names (_names))))
sem_MaybeNames ((MaybeNames_Nothing )) =
    (sem_MaybeNames_Nothing )
sem_MaybeNames_Just :: (T_Names) ->
                       (T_MaybeNames)
sem_MaybeNames_Just (names_) =
    let _lhsOself :: (MaybeNames)
        _namesIself :: (Names)
        ( _namesIself) =
            (names_ )
        (_self@_) =
            MaybeNames_Just _namesIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_MaybeNames_Nothing :: (T_MaybeNames)
sem_MaybeNames_Nothing  =
    let _lhsOself :: (MaybeNames)
        (_self@_) =
            MaybeNames_Nothing
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Module ------------------------------------------------------
-- semantic domain
type T_Module = (ImportEnvironment) ->
                ([Option]) ->
                ( (IO ()),(KindEnvironment),(KindErrors),(Module))
-- cata
sem_Module :: (Module) ->
              (T_Module)
sem_Module ((Module_Module (_range) (_name) (_exports) (_body))) =
    (sem_Module_Module ((sem_Range (_range))) ((sem_MaybeName (_name))) ((sem_MaybeExports (_exports))) ((sem_Body (_body))))
sem_Module_Module :: (T_Range) ->
                     (T_MaybeName) ->
                     (T_MaybeExports) ->
                     (T_Body) ->
                     (T_Module)
sem_Module_Module (range_) (name_) (exports_) (body_) =
    \ _lhsIimportEnvironment
      _lhsIoptions ->
        let _lhsOdebugIO :: (IO ())
            _lhsOkindEnvironment :: (KindEnvironment)
            _lhsOkindErrors :: (KindErrors)
            _lhsOself :: (Module)
            _rangeIself :: (Range)
            _nameIself :: (MaybeName)
            _exportsIself :: (MaybeExports)
            _bodyIconstraints :: (KindConstraints)
            _bodyIenvironment :: (PatternAssumptions)
            _bodyIkappaUnique :: (Int)
            _bodyIself :: (Body)
            _bodyOimportEnvironment :: (ImportEnvironment)
            _bodyOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _exportsIself) =
                (exports_ )
            ( _bodyIconstraints,_bodyIenvironment,_bodyIkappaUnique,_bodyIself) =
                (body_ (_bodyOimportEnvironment) (_bodyOkappaUnique))
            (_kindEnvironment@_) =
                let f kind = generalizeAll ([] .=>. defaultToStar (_substitution |-> kind))
                in M.map f _bodyIenvironment
            (((SolveResult (_kappaUniqueAtTheEnd@_)(_substitution@_)(_)(_)(_kindErrors@_)),_logEntries@_)) =
                solve (solveOptions { uniqueCounter = _bodyIkappaUnique }) _bodyIconstraints greedyConstraintSolver
            (_bodyOkappaUnique@_) =
                0
            (_lhsOdebugIO@_) =
                putStrLn (show _logEntries)
            (_lhsOkindErrors@_) =
                _substitution |-> (map fst _kindErrors)
            (_self@_) =
                Module_Module _rangeIself _nameIself _exportsIself _bodyIself
            (_lhsOself@_) =
                _self
            (_lhsOkindEnvironment@_) =
                _kindEnvironment
            (_bodyOimportEnvironment@_) =
                _lhsIimportEnvironment
        in  ( _lhsOdebugIO,_lhsOkindEnvironment,_lhsOkindErrors,_lhsOself)
-- Name --------------------------------------------------------
-- semantic domain
type T_Name = ( (Name))
-- cata
sem_Name :: (Name) ->
            (T_Name)
sem_Name ((Name_Identifier (_range) (_module) (_name))) =
    (sem_Name_Identifier ((sem_Range (_range))) ((sem_Strings (_module))) (_name))
sem_Name ((Name_Operator (_range) (_module) (_name))) =
    (sem_Name_Operator ((sem_Range (_range))) ((sem_Strings (_module))) (_name))
sem_Name ((Name_Special (_range) (_module) (_name))) =
    (sem_Name_Special ((sem_Range (_range))) ((sem_Strings (_module))) (_name))
sem_Name_Identifier :: (T_Range) ->
                       (T_Strings) ->
                       (String) ->
                       (T_Name)
sem_Name_Identifier (range_) (module_) (name_) =
    let _lhsOself :: (Name)
        _rangeIself :: (Range)
        _moduleIself :: (Strings)
        ( _rangeIself) =
            (range_ )
        ( _moduleIself) =
            (module_ )
        (_self@_) =
            Name_Identifier _rangeIself _moduleIself name_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Name_Operator :: (T_Range) ->
                     (T_Strings) ->
                     (String) ->
                     (T_Name)
sem_Name_Operator (range_) (module_) (name_) =
    let _lhsOself :: (Name)
        _rangeIself :: (Range)
        _moduleIself :: (Strings)
        ( _rangeIself) =
            (range_ )
        ( _moduleIself) =
            (module_ )
        (_self@_) =
            Name_Operator _rangeIself _moduleIself name_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Name_Special :: (T_Range) ->
                    (T_Strings) ->
                    (String) ->
                    (T_Name)
sem_Name_Special (range_) (module_) (name_) =
    let _lhsOself :: (Name)
        _rangeIself :: (Range)
        _moduleIself :: (Strings)
        ( _rangeIself) =
            (range_ )
        ( _moduleIself) =
            (module_ )
        (_self@_) =
            Name_Special _rangeIself _moduleIself name_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Names -------------------------------------------------------
-- semantic domain
type T_Names = ( (Names))
-- cata
sem_Names :: (Names) ->
             (T_Names)
sem_Names (list) =
    (Prelude.foldr (sem_Names_Cons) (sem_Names_Nil) ((Prelude.map sem_Name list)))
sem_Names_Cons :: (T_Name) ->
                  (T_Names) ->
                  (T_Names)
sem_Names_Cons (hd_) (tl_) =
    let _lhsOself :: (Names)
        _hdIself :: (Name)
        _tlIself :: (Names)
        ( _hdIself) =
            (hd_ )
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Names_Nil :: (T_Names)
sem_Names_Nil  =
    let _lhsOself :: (Names)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Pattern -----------------------------------------------------
-- semantic domain
type T_Pattern = ( (Pattern))
-- cata
sem_Pattern :: (Pattern) ->
               (T_Pattern)
sem_Pattern ((Pattern_As (_range) (_name) (_pattern))) =
    (sem_Pattern_As ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Pattern (_pattern))))
sem_Pattern ((Pattern_Constructor (_range) (_name) (_patterns))) =
    (sem_Pattern_Constructor ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Patterns (_patterns))))
sem_Pattern ((Pattern_InfixConstructor (_range) (_leftPattern) (_constructorOperator) (_rightPattern))) =
    (sem_Pattern_InfixConstructor ((sem_Range (_range))) ((sem_Pattern (_leftPattern))) ((sem_Name (_constructorOperator))) ((sem_Pattern (_rightPattern))))
sem_Pattern ((Pattern_Irrefutable (_range) (_pattern))) =
    (sem_Pattern_Irrefutable ((sem_Range (_range))) ((sem_Pattern (_pattern))))
sem_Pattern ((Pattern_List (_range) (_patterns))) =
    (sem_Pattern_List ((sem_Range (_range))) ((sem_Patterns (_patterns))))
sem_Pattern ((Pattern_Literal (_range) (_literal))) =
    (sem_Pattern_Literal ((sem_Range (_range))) ((sem_Literal (_literal))))
sem_Pattern ((Pattern_Negate (_range) (_literal))) =
    (sem_Pattern_Negate ((sem_Range (_range))) ((sem_Literal (_literal))))
sem_Pattern ((Pattern_NegateFloat (_range) (_literal))) =
    (sem_Pattern_NegateFloat ((sem_Range (_range))) ((sem_Literal (_literal))))
sem_Pattern ((Pattern_Parenthesized (_range) (_pattern))) =
    (sem_Pattern_Parenthesized ((sem_Range (_range))) ((sem_Pattern (_pattern))))
sem_Pattern ((Pattern_Record (_range) (_name) (_recordPatternBindings))) =
    (sem_Pattern_Record ((sem_Range (_range))) ((sem_Name (_name))) ((sem_RecordPatternBindings (_recordPatternBindings))))
sem_Pattern ((Pattern_Successor (_range) (_name) (_literal))) =
    (sem_Pattern_Successor ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Literal (_literal))))
sem_Pattern ((Pattern_Tuple (_range) (_patterns))) =
    (sem_Pattern_Tuple ((sem_Range (_range))) ((sem_Patterns (_patterns))))
sem_Pattern ((Pattern_Variable (_range) (_name))) =
    (sem_Pattern_Variable ((sem_Range (_range))) ((sem_Name (_name))))
sem_Pattern ((Pattern_Wildcard (_range))) =
    (sem_Pattern_Wildcard ((sem_Range (_range))))
sem_Pattern_As :: (T_Range) ->
                  (T_Name) ->
                  (T_Pattern) ->
                  (T_Pattern)
sem_Pattern_As (range_) (name_) (pattern_) =
    let _lhsOself :: (Pattern)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        _patternIself :: (Pattern)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        ( _patternIself) =
            (pattern_ )
        (_self@_) =
            Pattern_As _rangeIself _nameIself _patternIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Pattern_Constructor :: (T_Range) ->
                           (T_Name) ->
                           (T_Patterns) ->
                           (T_Pattern)
sem_Pattern_Constructor (range_) (name_) (patterns_) =
    let _lhsOself :: (Pattern)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        _patternsIself :: (Patterns)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        ( _patternsIself) =
            (patterns_ )
        (_self@_) =
            Pattern_Constructor _rangeIself _nameIself _patternsIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Pattern_InfixConstructor :: (T_Range) ->
                                (T_Pattern) ->
                                (T_Name) ->
                                (T_Pattern) ->
                                (T_Pattern)
sem_Pattern_InfixConstructor (range_) (leftPattern_) (constructorOperator_) (rightPattern_) =
    let _lhsOself :: (Pattern)
        _rangeIself :: (Range)
        _leftPatternIself :: (Pattern)
        _constructorOperatorIself :: (Name)
        _rightPatternIself :: (Pattern)
        ( _rangeIself) =
            (range_ )
        ( _leftPatternIself) =
            (leftPattern_ )
        ( _constructorOperatorIself) =
            (constructorOperator_ )
        ( _rightPatternIself) =
            (rightPattern_ )
        (_self@_) =
            Pattern_InfixConstructor _rangeIself _leftPatternIself _constructorOperatorIself _rightPatternIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Pattern_Irrefutable :: (T_Range) ->
                           (T_Pattern) ->
                           (T_Pattern)
sem_Pattern_Irrefutable (range_) (pattern_) =
    let _lhsOself :: (Pattern)
        _rangeIself :: (Range)
        _patternIself :: (Pattern)
        ( _rangeIself) =
            (range_ )
        ( _patternIself) =
            (pattern_ )
        (_self@_) =
            Pattern_Irrefutable _rangeIself _patternIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Pattern_List :: (T_Range) ->
                    (T_Patterns) ->
                    (T_Pattern)
sem_Pattern_List (range_) (patterns_) =
    let _lhsOself :: (Pattern)
        _rangeIself :: (Range)
        _patternsIself :: (Patterns)
        ( _rangeIself) =
            (range_ )
        ( _patternsIself) =
            (patterns_ )
        (_self@_) =
            Pattern_List _rangeIself _patternsIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Pattern_Literal :: (T_Range) ->
                       (T_Literal) ->
                       (T_Pattern)
sem_Pattern_Literal (range_) (literal_) =
    let _lhsOself :: (Pattern)
        _rangeIself :: (Range)
        _literalIself :: (Literal)
        ( _rangeIself) =
            (range_ )
        ( _literalIself) =
            (literal_ )
        (_self@_) =
            Pattern_Literal _rangeIself _literalIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Pattern_Negate :: (T_Range) ->
                      (T_Literal) ->
                      (T_Pattern)
sem_Pattern_Negate (range_) (literal_) =
    let _lhsOself :: (Pattern)
        _rangeIself :: (Range)
        _literalIself :: (Literal)
        ( _rangeIself) =
            (range_ )
        ( _literalIself) =
            (literal_ )
        (_self@_) =
            Pattern_Negate _rangeIself _literalIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Pattern_NegateFloat :: (T_Range) ->
                           (T_Literal) ->
                           (T_Pattern)
sem_Pattern_NegateFloat (range_) (literal_) =
    let _lhsOself :: (Pattern)
        _rangeIself :: (Range)
        _literalIself :: (Literal)
        ( _rangeIself) =
            (range_ )
        ( _literalIself) =
            (literal_ )
        (_self@_) =
            Pattern_NegateFloat _rangeIself _literalIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Pattern_Parenthesized :: (T_Range) ->
                             (T_Pattern) ->
                             (T_Pattern)
sem_Pattern_Parenthesized (range_) (pattern_) =
    let _lhsOself :: (Pattern)
        _rangeIself :: (Range)
        _patternIself :: (Pattern)
        ( _rangeIself) =
            (range_ )
        ( _patternIself) =
            (pattern_ )
        (_self@_) =
            Pattern_Parenthesized _rangeIself _patternIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Pattern_Record :: (T_Range) ->
                      (T_Name) ->
                      (T_RecordPatternBindings) ->
                      (T_Pattern)
sem_Pattern_Record (range_) (name_) (recordPatternBindings_) =
    let _lhsOself :: (Pattern)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        _recordPatternBindingsIself :: (RecordPatternBindings)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        ( _recordPatternBindingsIself) =
            (recordPatternBindings_ )
        (_self@_) =
            Pattern_Record _rangeIself _nameIself _recordPatternBindingsIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Pattern_Successor :: (T_Range) ->
                         (T_Name) ->
                         (T_Literal) ->
                         (T_Pattern)
sem_Pattern_Successor (range_) (name_) (literal_) =
    let _lhsOself :: (Pattern)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        _literalIself :: (Literal)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        ( _literalIself) =
            (literal_ )
        (_self@_) =
            Pattern_Successor _rangeIself _nameIself _literalIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Pattern_Tuple :: (T_Range) ->
                     (T_Patterns) ->
                     (T_Pattern)
sem_Pattern_Tuple (range_) (patterns_) =
    let _lhsOself :: (Pattern)
        _rangeIself :: (Range)
        _patternsIself :: (Patterns)
        ( _rangeIself) =
            (range_ )
        ( _patternsIself) =
            (patterns_ )
        (_self@_) =
            Pattern_Tuple _rangeIself _patternsIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Pattern_Variable :: (T_Range) ->
                        (T_Name) ->
                        (T_Pattern)
sem_Pattern_Variable (range_) (name_) =
    let _lhsOself :: (Pattern)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        (_self@_) =
            Pattern_Variable _rangeIself _nameIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Pattern_Wildcard :: (T_Range) ->
                        (T_Pattern)
sem_Pattern_Wildcard (range_) =
    let _lhsOself :: (Pattern)
        _rangeIself :: (Range)
        ( _rangeIself) =
            (range_ )
        (_self@_) =
            Pattern_Wildcard _rangeIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Patterns ----------------------------------------------------
-- semantic domain
type T_Patterns = ( (Patterns))
-- cata
sem_Patterns :: (Patterns) ->
                (T_Patterns)
sem_Patterns (list) =
    (Prelude.foldr (sem_Patterns_Cons) (sem_Patterns_Nil) ((Prelude.map sem_Pattern list)))
sem_Patterns_Cons :: (T_Pattern) ->
                     (T_Patterns) ->
                     (T_Patterns)
sem_Patterns_Cons (hd_) (tl_) =
    let _lhsOself :: (Patterns)
        _hdIself :: (Pattern)
        _tlIself :: (Patterns)
        ( _hdIself) =
            (hd_ )
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Patterns_Nil :: (T_Patterns)
sem_Patterns_Nil  =
    let _lhsOself :: (Patterns)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Position ----------------------------------------------------
-- semantic domain
type T_Position = ( (Position))
-- cata
sem_Position :: (Position) ->
                (T_Position)
sem_Position ((Position_Position (_filename) (_line) (_column))) =
    (sem_Position_Position (_filename) (_line) (_column))
sem_Position ((Position_Unknown )) =
    (sem_Position_Unknown )
sem_Position_Position :: (String) ->
                         (Int) ->
                         (Int) ->
                         (T_Position)
sem_Position_Position (filename_) (line_) (column_) =
    let _lhsOself :: (Position)
        (_self@_) =
            Position_Position filename_ line_ column_
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Position_Unknown :: (T_Position)
sem_Position_Unknown  =
    let _lhsOself :: (Position)
        (_self@_) =
            Position_Unknown
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Qualifier ---------------------------------------------------
-- semantic domain
type T_Qualifier = (BindingGroups) ->
                   (Int) ->
                   ( (BindingGroups),(Int),(Qualifier))
-- cata
sem_Qualifier :: (Qualifier) ->
                 (T_Qualifier)
sem_Qualifier ((Qualifier_Empty (_range))) =
    (sem_Qualifier_Empty ((sem_Range (_range))))
sem_Qualifier ((Qualifier_Generator (_range) (_pattern) (_expression))) =
    (sem_Qualifier_Generator ((sem_Range (_range))) ((sem_Pattern (_pattern))) ((sem_Expression (_expression))))
sem_Qualifier ((Qualifier_Guard (_range) (_guard))) =
    (sem_Qualifier_Guard ((sem_Range (_range))) ((sem_Expression (_guard))))
sem_Qualifier ((Qualifier_Let (_range) (_declarations))) =
    (sem_Qualifier_Let ((sem_Range (_range))) ((sem_Declarations (_declarations))))
sem_Qualifier_Empty :: (T_Range) ->
                       (T_Qualifier)
sem_Qualifier_Empty (range_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Qualifier)
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_self@_) =
                Qualifier_Empty _rangeIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Qualifier_Generator :: (T_Range) ->
                           (T_Pattern) ->
                           (T_Expression) ->
                           (T_Qualifier)
sem_Qualifier_Generator (range_) (pattern_) (expression_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Qualifier)
            _rangeIself :: (Range)
            _patternIself :: (Pattern)
            _expressionIbindingGroups :: (BindingGroups)
            _expressionIkappaUnique :: (Int)
            _expressionIself :: (Expression)
            _expressionObindingGroups :: (BindingGroups)
            _expressionOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _patternIself) =
                (pattern_ )
            ( _expressionIbindingGroups,_expressionIkappaUnique,_expressionIself) =
                (expression_ (_expressionObindingGroups) (_expressionOkappaUnique))
            (_self@_) =
                Qualifier_Generator _rangeIself _patternIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _expressionIbindingGroups
            (_lhsOkappaUnique@_) =
                _expressionIkappaUnique
            (_expressionObindingGroups@_) =
                _lhsIbindingGroups
            (_expressionOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Qualifier_Guard :: (T_Range) ->
                       (T_Expression) ->
                       (T_Qualifier)
sem_Qualifier_Guard (range_) (guard_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Qualifier)
            _rangeIself :: (Range)
            _guardIbindingGroups :: (BindingGroups)
            _guardIkappaUnique :: (Int)
            _guardIself :: (Expression)
            _guardObindingGroups :: (BindingGroups)
            _guardOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _guardIbindingGroups,_guardIkappaUnique,_guardIself) =
                (guard_ (_guardObindingGroups) (_guardOkappaUnique))
            (_self@_) =
                Qualifier_Guard _rangeIself _guardIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _guardIbindingGroups
            (_lhsOkappaUnique@_) =
                _guardIkappaUnique
            (_guardObindingGroups@_) =
                _lhsIbindingGroups
            (_guardOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Qualifier_Let :: (T_Range) ->
                     (T_Declarations) ->
                     (T_Qualifier)
sem_Qualifier_Let (range_) (declarations_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Qualifier)
            _rangeIself :: (Range)
            _declarationsIbindingGroups :: (BindingGroups)
            _declarationsIkappaUnique :: (Int)
            _declarationsIself :: (Declarations)
            _declarationsObindingGroups :: (BindingGroups)
            _declarationsOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _declarationsIbindingGroups,_declarationsIkappaUnique,_declarationsIself) =
                (declarations_ (_declarationsObindingGroups) (_declarationsOkappaUnique))
            (_self@_) =
                Qualifier_Let _rangeIself _declarationsIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _declarationsIbindingGroups
            (_lhsOkappaUnique@_) =
                _declarationsIkappaUnique
            (_declarationsObindingGroups@_) =
                _lhsIbindingGroups
            (_declarationsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- Qualifiers --------------------------------------------------
-- semantic domain
type T_Qualifiers = (BindingGroups) ->
                    (Int) ->
                    ( (BindingGroups),(Int),(Qualifiers))
-- cata
sem_Qualifiers :: (Qualifiers) ->
                  (T_Qualifiers)
sem_Qualifiers (list) =
    (Prelude.foldr (sem_Qualifiers_Cons) (sem_Qualifiers_Nil) ((Prelude.map sem_Qualifier list)))
sem_Qualifiers_Cons :: (T_Qualifier) ->
                       (T_Qualifiers) ->
                       (T_Qualifiers)
sem_Qualifiers_Cons (hd_) (tl_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Qualifiers)
            _hdIbindingGroups :: (BindingGroups)
            _hdIkappaUnique :: (Int)
            _hdIself :: (Qualifier)
            _hdObindingGroups :: (BindingGroups)
            _hdOkappaUnique :: (Int)
            _tlIbindingGroups :: (BindingGroups)
            _tlIkappaUnique :: (Int)
            _tlIself :: (Qualifiers)
            _tlObindingGroups :: (BindingGroups)
            _tlOkappaUnique :: (Int)
            ( _hdIbindingGroups,_hdIkappaUnique,_hdIself) =
                (hd_ (_hdObindingGroups) (_hdOkappaUnique))
            ( _tlIbindingGroups,_tlIkappaUnique,_tlIself) =
                (tl_ (_tlObindingGroups) (_tlOkappaUnique))
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _tlIbindingGroups
            (_lhsOkappaUnique@_) =
                _tlIkappaUnique
            (_hdObindingGroups@_) =
                _lhsIbindingGroups
            (_hdOkappaUnique@_) =
                _lhsIkappaUnique
            (_tlObindingGroups@_) =
                _hdIbindingGroups
            (_tlOkappaUnique@_) =
                _hdIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Qualifiers_Nil :: (T_Qualifiers)
sem_Qualifiers_Nil  =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Qualifiers)
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- Range -------------------------------------------------------
-- semantic domain
type T_Range = ( (Range))
-- cata
sem_Range :: (Range) ->
             (T_Range)
sem_Range ((Range_Range (_start) (_stop))) =
    (sem_Range_Range ((sem_Position (_start))) ((sem_Position (_stop))))
sem_Range_Range :: (T_Position) ->
                   (T_Position) ->
                   (T_Range)
sem_Range_Range (start_) (stop_) =
    let _lhsOself :: (Range)
        _startIself :: (Position)
        _stopIself :: (Position)
        ( _startIself) =
            (start_ )
        ( _stopIself) =
            (stop_ )
        (_self@_) =
            Range_Range _startIself _stopIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- RecordExpressionBinding -------------------------------------
-- semantic domain
type T_RecordExpressionBinding = (BindingGroups) ->
                                 (Int) ->
                                 ( (BindingGroups),(Int),(RecordExpressionBinding))
-- cata
sem_RecordExpressionBinding :: (RecordExpressionBinding) ->
                               (T_RecordExpressionBinding)
sem_RecordExpressionBinding ((RecordExpressionBinding_RecordExpressionBinding (_range) (_name) (_expression))) =
    (sem_RecordExpressionBinding_RecordExpressionBinding ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Expression (_expression))))
sem_RecordExpressionBinding_RecordExpressionBinding :: (T_Range) ->
                                                       (T_Name) ->
                                                       (T_Expression) ->
                                                       (T_RecordExpressionBinding)
sem_RecordExpressionBinding_RecordExpressionBinding (range_) (name_) (expression_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (RecordExpressionBinding)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _expressionIbindingGroups :: (BindingGroups)
            _expressionIkappaUnique :: (Int)
            _expressionIself :: (Expression)
            _expressionObindingGroups :: (BindingGroups)
            _expressionOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _expressionIbindingGroups,_expressionIkappaUnique,_expressionIself) =
                (expression_ (_expressionObindingGroups) (_expressionOkappaUnique))
            (_self@_) =
                RecordExpressionBinding_RecordExpressionBinding _rangeIself _nameIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _expressionIbindingGroups
            (_lhsOkappaUnique@_) =
                _expressionIkappaUnique
            (_expressionObindingGroups@_) =
                _lhsIbindingGroups
            (_expressionOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- RecordExpressionBindings ------------------------------------
-- semantic domain
type T_RecordExpressionBindings = (BindingGroups) ->
                                  (Int) ->
                                  ( (BindingGroups),(Int),(RecordExpressionBindings))
-- cata
sem_RecordExpressionBindings :: (RecordExpressionBindings) ->
                                (T_RecordExpressionBindings)
sem_RecordExpressionBindings (list) =
    (Prelude.foldr (sem_RecordExpressionBindings_Cons) (sem_RecordExpressionBindings_Nil) ((Prelude.map sem_RecordExpressionBinding list)))
sem_RecordExpressionBindings_Cons :: (T_RecordExpressionBinding) ->
                                     (T_RecordExpressionBindings) ->
                                     (T_RecordExpressionBindings)
sem_RecordExpressionBindings_Cons (hd_) (tl_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (RecordExpressionBindings)
            _hdIbindingGroups :: (BindingGroups)
            _hdIkappaUnique :: (Int)
            _hdIself :: (RecordExpressionBinding)
            _hdObindingGroups :: (BindingGroups)
            _hdOkappaUnique :: (Int)
            _tlIbindingGroups :: (BindingGroups)
            _tlIkappaUnique :: (Int)
            _tlIself :: (RecordExpressionBindings)
            _tlObindingGroups :: (BindingGroups)
            _tlOkappaUnique :: (Int)
            ( _hdIbindingGroups,_hdIkappaUnique,_hdIself) =
                (hd_ (_hdObindingGroups) (_hdOkappaUnique))
            ( _tlIbindingGroups,_tlIkappaUnique,_tlIself) =
                (tl_ (_tlObindingGroups) (_tlOkappaUnique))
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _tlIbindingGroups
            (_lhsOkappaUnique@_) =
                _tlIkappaUnique
            (_hdObindingGroups@_) =
                _lhsIbindingGroups
            (_hdOkappaUnique@_) =
                _lhsIkappaUnique
            (_tlObindingGroups@_) =
                _hdIbindingGroups
            (_tlOkappaUnique@_) =
                _hdIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_RecordExpressionBindings_Nil :: (T_RecordExpressionBindings)
sem_RecordExpressionBindings_Nil  =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (RecordExpressionBindings)
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- RecordPatternBinding ----------------------------------------
-- semantic domain
type T_RecordPatternBinding = ( (RecordPatternBinding))
-- cata
sem_RecordPatternBinding :: (RecordPatternBinding) ->
                            (T_RecordPatternBinding)
sem_RecordPatternBinding ((RecordPatternBinding_RecordPatternBinding (_range) (_name) (_pattern))) =
    (sem_RecordPatternBinding_RecordPatternBinding ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Pattern (_pattern))))
sem_RecordPatternBinding_RecordPatternBinding :: (T_Range) ->
                                                 (T_Name) ->
                                                 (T_Pattern) ->
                                                 (T_RecordPatternBinding)
sem_RecordPatternBinding_RecordPatternBinding (range_) (name_) (pattern_) =
    let _lhsOself :: (RecordPatternBinding)
        _rangeIself :: (Range)
        _nameIself :: (Name)
        _patternIself :: (Pattern)
        ( _rangeIself) =
            (range_ )
        ( _nameIself) =
            (name_ )
        ( _patternIself) =
            (pattern_ )
        (_self@_) =
            RecordPatternBinding_RecordPatternBinding _rangeIself _nameIself _patternIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- RecordPatternBindings ---------------------------------------
-- semantic domain
type T_RecordPatternBindings = ( (RecordPatternBindings))
-- cata
sem_RecordPatternBindings :: (RecordPatternBindings) ->
                             (T_RecordPatternBindings)
sem_RecordPatternBindings (list) =
    (Prelude.foldr (sem_RecordPatternBindings_Cons) (sem_RecordPatternBindings_Nil) ((Prelude.map sem_RecordPatternBinding list)))
sem_RecordPatternBindings_Cons :: (T_RecordPatternBinding) ->
                                  (T_RecordPatternBindings) ->
                                  (T_RecordPatternBindings)
sem_RecordPatternBindings_Cons (hd_) (tl_) =
    let _lhsOself :: (RecordPatternBindings)
        _hdIself :: (RecordPatternBinding)
        _tlIself :: (RecordPatternBindings)
        ( _hdIself) =
            (hd_ )
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) _hdIself _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_RecordPatternBindings_Nil :: (T_RecordPatternBindings)
sem_RecordPatternBindings_Nil  =
    let _lhsOself :: (RecordPatternBindings)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- RightHandSide -----------------------------------------------
-- semantic domain
type T_RightHandSide = (BindingGroups) ->
                       (Int) ->
                       ( (BindingGroups),(Int),(RightHandSide))
-- cata
sem_RightHandSide :: (RightHandSide) ->
                     (T_RightHandSide)
sem_RightHandSide ((RightHandSide_Expression (_range) (_expression) (_where))) =
    (sem_RightHandSide_Expression ((sem_Range (_range))) ((sem_Expression (_expression))) ((sem_MaybeDeclarations (_where))))
sem_RightHandSide ((RightHandSide_Guarded (_range) (_guardedexpressions) (_where))) =
    (sem_RightHandSide_Guarded ((sem_Range (_range))) ((sem_GuardedExpressions (_guardedexpressions))) ((sem_MaybeDeclarations (_where))))
sem_RightHandSide_Expression :: (T_Range) ->
                                (T_Expression) ->
                                (T_MaybeDeclarations) ->
                                (T_RightHandSide)
sem_RightHandSide_Expression (range_) (expression_) (where_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (RightHandSide)
            _rangeIself :: (Range)
            _expressionIbindingGroups :: (BindingGroups)
            _expressionIkappaUnique :: (Int)
            _expressionIself :: (Expression)
            _expressionObindingGroups :: (BindingGroups)
            _expressionOkappaUnique :: (Int)
            _whereIbindingGroups :: (BindingGroups)
            _whereIkappaUnique :: (Int)
            _whereIself :: (MaybeDeclarations)
            _whereObindingGroups :: (BindingGroups)
            _whereOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionIbindingGroups,_expressionIkappaUnique,_expressionIself) =
                (expression_ (_expressionObindingGroups) (_expressionOkappaUnique))
            ( _whereIbindingGroups,_whereIkappaUnique,_whereIself) =
                (where_ (_whereObindingGroups) (_whereOkappaUnique))
            (_self@_) =
                RightHandSide_Expression _rangeIself _expressionIself _whereIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _whereIbindingGroups
            (_lhsOkappaUnique@_) =
                _whereIkappaUnique
            (_expressionObindingGroups@_) =
                _lhsIbindingGroups
            (_expressionOkappaUnique@_) =
                _lhsIkappaUnique
            (_whereObindingGroups@_) =
                _expressionIbindingGroups
            (_whereOkappaUnique@_) =
                _expressionIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_RightHandSide_Guarded :: (T_Range) ->
                             (T_GuardedExpressions) ->
                             (T_MaybeDeclarations) ->
                             (T_RightHandSide)
sem_RightHandSide_Guarded (range_) (guardedexpressions_) (where_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (RightHandSide)
            _rangeIself :: (Range)
            _guardedexpressionsIbindingGroups :: (BindingGroups)
            _guardedexpressionsIkappaUnique :: (Int)
            _guardedexpressionsIself :: (GuardedExpressions)
            _guardedexpressionsObindingGroups :: (BindingGroups)
            _guardedexpressionsOkappaUnique :: (Int)
            _whereIbindingGroups :: (BindingGroups)
            _whereIkappaUnique :: (Int)
            _whereIself :: (MaybeDeclarations)
            _whereObindingGroups :: (BindingGroups)
            _whereOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _guardedexpressionsIbindingGroups,_guardedexpressionsIkappaUnique,_guardedexpressionsIself) =
                (guardedexpressions_ (_guardedexpressionsObindingGroups) (_guardedexpressionsOkappaUnique))
            ( _whereIbindingGroups,_whereIkappaUnique,_whereIself) =
                (where_ (_whereObindingGroups) (_whereOkappaUnique))
            (_self@_) =
                RightHandSide_Guarded _rangeIself _guardedexpressionsIself _whereIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _whereIbindingGroups
            (_lhsOkappaUnique@_) =
                _whereIkappaUnique
            (_guardedexpressionsObindingGroups@_) =
                _lhsIbindingGroups
            (_guardedexpressionsOkappaUnique@_) =
                _lhsIkappaUnique
            (_whereObindingGroups@_) =
                _guardedexpressionsIbindingGroups
            (_whereOkappaUnique@_) =
                _guardedexpressionsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- SimpleType --------------------------------------------------
-- semantic domain
type T_SimpleType = (KindConstraints) ->
                    (Kind) ->
                    (Int) ->
                    ( (KindConstraints),(PatternAssumptions),(PatternAssumptions),(Int),(SimpleType))
-- cata
sem_SimpleType :: (SimpleType) ->
                  (T_SimpleType)
sem_SimpleType ((SimpleType_SimpleType (_range) (_name) (_typevariables))) =
    (sem_SimpleType_SimpleType ((sem_Range (_range))) ((sem_Name (_name))) ((sem_Names (_typevariables))))
sem_SimpleType_SimpleType :: (T_Range) ->
                             (T_Name) ->
                             (T_Names) ->
                             (T_SimpleType)
sem_SimpleType_SimpleType (range_) (name_) (typevariables_) =
    \ _lhsIconstraints
      _lhsIkappaOfRHS
      _lhsIkappaUnique ->
        let _lhsOconstraints :: (KindConstraints)
            _lhsOdeclared :: (PatternAssumptions)
            _lhsOenvironment :: (PatternAssumptions)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (SimpleType)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            _typevariablesIself :: (Names)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            ( _typevariablesIself) =
                (typevariables_ )
            (_newConstraint@_) =
                (_kappaCon .==. foldr (.->.) _lhsIkappaOfRHS _kappasVars) (unexpected "SimpleType.SimpleType")
            (_kappasVars@_) =
                take (length _typevariablesIself) [ TVar i | i <- [ _lhsIkappaUnique+1 .. ]]
            (_kappaCon@_) =
                TVar _lhsIkappaUnique
            (_lhsOkappaUnique@_) =
                1 + length _typevariablesIself + _lhsIkappaUnique
            (_lhsOconstraints@_) =
                _newConstraint : _lhsIconstraints
            (_lhsOdeclared@_) =
                M.singleton _nameIself _kappaCon
            (_lhsOenvironment@_) =
                M.fromList (zip _typevariablesIself _kappasVars)
            (_self@_) =
                SimpleType_SimpleType _rangeIself _nameIself _typevariablesIself
            (_lhsOself@_) =
                _self
        in  ( _lhsOconstraints,_lhsOdeclared,_lhsOenvironment,_lhsOkappaUnique,_lhsOself)
-- Statement ---------------------------------------------------
-- semantic domain
type T_Statement = (BindingGroups) ->
                   (Int) ->
                   ( (BindingGroups),(Int),(Statement))
-- cata
sem_Statement :: (Statement) ->
                 (T_Statement)
sem_Statement ((Statement_Empty (_range))) =
    (sem_Statement_Empty ((sem_Range (_range))))
sem_Statement ((Statement_Expression (_range) (_expression))) =
    (sem_Statement_Expression ((sem_Range (_range))) ((sem_Expression (_expression))))
sem_Statement ((Statement_Generator (_range) (_pattern) (_expression))) =
    (sem_Statement_Generator ((sem_Range (_range))) ((sem_Pattern (_pattern))) ((sem_Expression (_expression))))
sem_Statement ((Statement_Let (_range) (_declarations))) =
    (sem_Statement_Let ((sem_Range (_range))) ((sem_Declarations (_declarations))))
sem_Statement_Empty :: (T_Range) ->
                       (T_Statement)
sem_Statement_Empty (range_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Statement)
            _rangeIself :: (Range)
            ( _rangeIself) =
                (range_ )
            (_self@_) =
                Statement_Empty _rangeIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Statement_Expression :: (T_Range) ->
                            (T_Expression) ->
                            (T_Statement)
sem_Statement_Expression (range_) (expression_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Statement)
            _rangeIself :: (Range)
            _expressionIbindingGroups :: (BindingGroups)
            _expressionIkappaUnique :: (Int)
            _expressionIself :: (Expression)
            _expressionObindingGroups :: (BindingGroups)
            _expressionOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _expressionIbindingGroups,_expressionIkappaUnique,_expressionIself) =
                (expression_ (_expressionObindingGroups) (_expressionOkappaUnique))
            (_self@_) =
                Statement_Expression _rangeIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _expressionIbindingGroups
            (_lhsOkappaUnique@_) =
                _expressionIkappaUnique
            (_expressionObindingGroups@_) =
                _lhsIbindingGroups
            (_expressionOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Statement_Generator :: (T_Range) ->
                           (T_Pattern) ->
                           (T_Expression) ->
                           (T_Statement)
sem_Statement_Generator (range_) (pattern_) (expression_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Statement)
            _rangeIself :: (Range)
            _patternIself :: (Pattern)
            _expressionIbindingGroups :: (BindingGroups)
            _expressionIkappaUnique :: (Int)
            _expressionIself :: (Expression)
            _expressionObindingGroups :: (BindingGroups)
            _expressionOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _patternIself) =
                (pattern_ )
            ( _expressionIbindingGroups,_expressionIkappaUnique,_expressionIself) =
                (expression_ (_expressionObindingGroups) (_expressionOkappaUnique))
            (_self@_) =
                Statement_Generator _rangeIself _patternIself _expressionIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _expressionIbindingGroups
            (_lhsOkappaUnique@_) =
                _expressionIkappaUnique
            (_expressionObindingGroups@_) =
                _lhsIbindingGroups
            (_expressionOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Statement_Let :: (T_Range) ->
                     (T_Declarations) ->
                     (T_Statement)
sem_Statement_Let (range_) (declarations_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Statement)
            _rangeIself :: (Range)
            _declarationsIbindingGroups :: (BindingGroups)
            _declarationsIkappaUnique :: (Int)
            _declarationsIself :: (Declarations)
            _declarationsObindingGroups :: (BindingGroups)
            _declarationsOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _declarationsIbindingGroups,_declarationsIkappaUnique,_declarationsIself) =
                (declarations_ (_declarationsObindingGroups) (_declarationsOkappaUnique))
            (_self@_) =
                Statement_Let _rangeIself _declarationsIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _declarationsIbindingGroups
            (_lhsOkappaUnique@_) =
                _declarationsIkappaUnique
            (_declarationsObindingGroups@_) =
                _lhsIbindingGroups
            (_declarationsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- Statements --------------------------------------------------
-- semantic domain
type T_Statements = (BindingGroups) ->
                    (Int) ->
                    ( (BindingGroups),(Int),(Statements))
-- cata
sem_Statements :: (Statements) ->
                  (T_Statements)
sem_Statements (list) =
    (Prelude.foldr (sem_Statements_Cons) (sem_Statements_Nil) ((Prelude.map sem_Statement list)))
sem_Statements_Cons :: (T_Statement) ->
                       (T_Statements) ->
                       (T_Statements)
sem_Statements_Cons (hd_) (tl_) =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Statements)
            _hdIbindingGroups :: (BindingGroups)
            _hdIkappaUnique :: (Int)
            _hdIself :: (Statement)
            _hdObindingGroups :: (BindingGroups)
            _hdOkappaUnique :: (Int)
            _tlIbindingGroups :: (BindingGroups)
            _tlIkappaUnique :: (Int)
            _tlIself :: (Statements)
            _tlObindingGroups :: (BindingGroups)
            _tlOkappaUnique :: (Int)
            ( _hdIbindingGroups,_hdIkappaUnique,_hdIself) =
                (hd_ (_hdObindingGroups) (_hdOkappaUnique))
            ( _tlIbindingGroups,_tlIkappaUnique,_tlIself) =
                (tl_ (_tlObindingGroups) (_tlOkappaUnique))
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _tlIbindingGroups
            (_lhsOkappaUnique@_) =
                _tlIkappaUnique
            (_hdObindingGroups@_) =
                _lhsIbindingGroups
            (_hdOkappaUnique@_) =
                _lhsIkappaUnique
            (_tlObindingGroups@_) =
                _hdIbindingGroups
            (_tlOkappaUnique@_) =
                _hdIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
sem_Statements_Nil :: (T_Statements)
sem_Statements_Nil  =
    \ _lhsIbindingGroups
      _lhsIkappaUnique ->
        let _lhsObindingGroups :: (BindingGroups)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Statements)
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsObindingGroups@_) =
                _lhsIbindingGroups
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsObindingGroups,_lhsOkappaUnique,_lhsOself)
-- Strings -----------------------------------------------------
-- semantic domain
type T_Strings = ( (Strings))
-- cata
sem_Strings :: (Strings) ->
               (T_Strings)
sem_Strings (list) =
    (Prelude.foldr (sem_Strings_Cons) (sem_Strings_Nil) (list))
sem_Strings_Cons :: (String) ->
                    (T_Strings) ->
                    (T_Strings)
sem_Strings_Cons (hd_) (tl_) =
    let _lhsOself :: (Strings)
        _tlIself :: (Strings)
        ( _tlIself) =
            (tl_ )
        (_self@_) =
            (:) hd_ _tlIself
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
sem_Strings_Nil :: (T_Strings)
sem_Strings_Nil  =
    let _lhsOself :: (Strings)
        (_self@_) =
            []
        (_lhsOself@_) =
            _self
    in  ( _lhsOself)
-- Type --------------------------------------------------------
-- semantic domain
type T_Type = (KindConstraints) ->
              (Int) ->
              ( (Assumptions),(KindConstraints),(Kind),(Int),(Type))
-- cata
sem_Type :: (Type) ->
            (T_Type)
sem_Type ((Type_Application (_range) (_prefix) (_function) (_arguments))) =
    (sem_Type_Application ((sem_Range (_range))) (_prefix) ((sem_Type (_function))) ((sem_Types (_arguments))))
sem_Type ((Type_Constructor (_range) (_name))) =
    (sem_Type_Constructor ((sem_Range (_range))) ((sem_Name (_name))))
sem_Type ((Type_Exists (_range) (_typevariables) (_type))) =
    (sem_Type_Exists ((sem_Range (_range))) ((sem_Names (_typevariables))) ((sem_Type (_type))))
sem_Type ((Type_Forall (_range) (_typevariables) (_type))) =
    (sem_Type_Forall ((sem_Range (_range))) ((sem_Names (_typevariables))) ((sem_Type (_type))))
sem_Type ((Type_Parenthesized (_range) (_type))) =
    (sem_Type_Parenthesized ((sem_Range (_range))) ((sem_Type (_type))))
sem_Type ((Type_Qualified (_range) (_context) (_type))) =
    (sem_Type_Qualified ((sem_Range (_range))) ((sem_ContextItems (_context))) ((sem_Type (_type))))
sem_Type ((Type_Variable (_range) (_name))) =
    (sem_Type_Variable ((sem_Range (_range))) ((sem_Name (_name))))
sem_Type_Application :: (T_Range) ->
                        (Bool) ->
                        (T_Type) ->
                        (T_Types) ->
                        (T_Type)
sem_Type_Application (range_) (prefix_) (function_) (arguments_) =
    \ _lhsIconstraints
      _lhsIkappaUnique ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOconstraints :: (KindConstraints)
            _lhsOkappa :: (Kind)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Type)
            _rangeIself :: (Range)
            _functionIassumptions :: (Assumptions)
            _functionIconstraints :: (KindConstraints)
            _functionIkappa :: (Kind)
            _functionIkappaUnique :: (Int)
            _functionIself :: (Type)
            _functionOconstraints :: (KindConstraints)
            _functionOkappaUnique :: (Int)
            _argumentsIassumptions :: (Assumptions)
            _argumentsIconstraints :: (KindConstraints)
            _argumentsIkappaUnique :: (Int)
            _argumentsIkappas :: (Kinds)
            _argumentsIself :: (Types)
            _argumentsOconstraints :: (KindConstraints)
            _argumentsOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _functionIassumptions,_functionIconstraints,_functionIkappa,_functionIkappaUnique,_functionIself) =
                (function_ (_functionOconstraints) (_functionOkappaUnique))
            ( _argumentsIassumptions,_argumentsIconstraints,_argumentsIkappaUnique,_argumentsIkappas,_argumentsIself) =
                (arguments_ (_argumentsOconstraints) (_argumentsOkappaUnique))
            (_newConstraint@_) =
                (_functionIkappa <==> foldr (.->.) _kappa _argumentsIkappas) (kindApplication _rangeIself _self _functionIself)
            (_kappa@_) =
                TVar _argumentsIkappaUnique
            (_lhsOkappaUnique@_) =
                _argumentsIkappaUnique + 1
            (_lhsOconstraints@_) =
                _argumentsIconstraints ++ [_newConstraint]
            (_lhsOassumptions@_) =
                _functionIassumptions `combine` _argumentsIassumptions
            (_self@_) =
                Type_Application _rangeIself prefix_ _functionIself _argumentsIself
            (_lhsOself@_) =
                _self
            (_lhsOkappa@_) =
                _kappa
            (_functionOconstraints@_) =
                _lhsIconstraints
            (_functionOkappaUnique@_) =
                _lhsIkappaUnique
            (_argumentsOconstraints@_) =
                _functionIconstraints
            (_argumentsOkappaUnique@_) =
                _functionIkappaUnique
        in  ( _lhsOassumptions,_lhsOconstraints,_lhsOkappa,_lhsOkappaUnique,_lhsOself)
sem_Type_Constructor :: (T_Range) ->
                        (T_Name) ->
                        (T_Type)
sem_Type_Constructor (range_) (name_) =
    \ _lhsIconstraints
      _lhsIkappaUnique ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOconstraints :: (KindConstraints)
            _lhsOkappa :: (Kind)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Type)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            (_kappa@_) =
                TVar _lhsIkappaUnique
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique + 1
            (_lhsOassumptions@_) =
                single _nameIself _kappa
            (_self@_) =
                Type_Constructor _rangeIself _nameIself
            (_lhsOself@_) =
                _self
            (_lhsOconstraints@_) =
                _lhsIconstraints
            (_lhsOkappa@_) =
                _kappa
        in  ( _lhsOassumptions,_lhsOconstraints,_lhsOkappa,_lhsOkappaUnique,_lhsOself)
sem_Type_Exists :: (T_Range) ->
                   (T_Names) ->
                   (T_Type) ->
                   (T_Type)
sem_Type_Exists (range_) (typevariables_) (type_) =
    \ _lhsIconstraints
      _lhsIkappaUnique ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOconstraints :: (KindConstraints)
            _lhsOkappa :: (Kind)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Type)
            _rangeIself :: (Range)
            _typevariablesIself :: (Names)
            _typeIassumptions :: (Assumptions)
            _typeIconstraints :: (KindConstraints)
            _typeIkappa :: (Kind)
            _typeIkappaUnique :: (Int)
            _typeIself :: (Type)
            _typeOconstraints :: (KindConstraints)
            _typeOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _typevariablesIself) =
                (typevariables_ )
            ( _typeIassumptions,_typeIconstraints,_typeIkappa,_typeIkappaUnique,_typeIself) =
                (type_ (_typeOconstraints) (_typeOkappaUnique))
            ((_assumptions@_,_kappa@_)) =
                internalError "KindInferencing.ag" "n/a" "Existential types are not supported"
            (_self@_) =
                Type_Exists _rangeIself _typevariablesIself _typeIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _assumptions
            (_lhsOconstraints@_) =
                _typeIconstraints
            (_lhsOkappa@_) =
                _kappa
            (_lhsOkappaUnique@_) =
                _typeIkappaUnique
            (_typeOconstraints@_) =
                _lhsIconstraints
            (_typeOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsOassumptions,_lhsOconstraints,_lhsOkappa,_lhsOkappaUnique,_lhsOself)
sem_Type_Forall :: (T_Range) ->
                   (T_Names) ->
                   (T_Type) ->
                   (T_Type)
sem_Type_Forall (range_) (typevariables_) (type_) =
    \ _lhsIconstraints
      _lhsIkappaUnique ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOconstraints :: (KindConstraints)
            _lhsOkappa :: (Kind)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Type)
            _rangeIself :: (Range)
            _typevariablesIself :: (Names)
            _typeIassumptions :: (Assumptions)
            _typeIconstraints :: (KindConstraints)
            _typeIkappa :: (Kind)
            _typeIkappaUnique :: (Int)
            _typeIself :: (Type)
            _typeOconstraints :: (KindConstraints)
            _typeOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _typevariablesIself) =
                (typevariables_ )
            ( _typeIassumptions,_typeIconstraints,_typeIkappa,_typeIkappaUnique,_typeIself) =
                (type_ (_typeOconstraints) (_typeOkappaUnique))
            ((_assumptions@_,_kappa@_)) =
                internalError "KindInferencing.ag" "n/a" "Universal types are not supported"
            (_self@_) =
                Type_Forall _rangeIself _typevariablesIself _typeIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _assumptions
            (_lhsOconstraints@_) =
                _typeIconstraints
            (_lhsOkappa@_) =
                _kappa
            (_lhsOkappaUnique@_) =
                _typeIkappaUnique
            (_typeOconstraints@_) =
                _lhsIconstraints
            (_typeOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsOassumptions,_lhsOconstraints,_lhsOkappa,_lhsOkappaUnique,_lhsOself)
sem_Type_Parenthesized :: (T_Range) ->
                          (T_Type) ->
                          (T_Type)
sem_Type_Parenthesized (range_) (type_) =
    \ _lhsIconstraints
      _lhsIkappaUnique ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOconstraints :: (KindConstraints)
            _lhsOkappa :: (Kind)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Type)
            _rangeIself :: (Range)
            _typeIassumptions :: (Assumptions)
            _typeIconstraints :: (KindConstraints)
            _typeIkappa :: (Kind)
            _typeIkappaUnique :: (Int)
            _typeIself :: (Type)
            _typeOconstraints :: (KindConstraints)
            _typeOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _typeIassumptions,_typeIconstraints,_typeIkappa,_typeIkappaUnique,_typeIself) =
                (type_ (_typeOconstraints) (_typeOkappaUnique))
            (_self@_) =
                Type_Parenthesized _rangeIself _typeIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _typeIassumptions
            (_lhsOconstraints@_) =
                _typeIconstraints
            (_lhsOkappa@_) =
                _typeIkappa
            (_lhsOkappaUnique@_) =
                _typeIkappaUnique
            (_typeOconstraints@_) =
                _lhsIconstraints
            (_typeOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsOassumptions,_lhsOconstraints,_lhsOkappa,_lhsOkappaUnique,_lhsOself)
sem_Type_Qualified :: (T_Range) ->
                      (T_ContextItems) ->
                      (T_Type) ->
                      (T_Type)
sem_Type_Qualified (range_) (context_) (type_) =
    \ _lhsIconstraints
      _lhsIkappaUnique ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOconstraints :: (KindConstraints)
            _lhsOkappa :: (Kind)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Type)
            _rangeIself :: (Range)
            _contextIkappaUnique :: (Int)
            _contextIself :: (ContextItems)
            _contextOkappaUnique :: (Int)
            _typeIassumptions :: (Assumptions)
            _typeIconstraints :: (KindConstraints)
            _typeIkappa :: (Kind)
            _typeIkappaUnique :: (Int)
            _typeIself :: (Type)
            _typeOconstraints :: (KindConstraints)
            _typeOkappaUnique :: (Int)
            ( _rangeIself) =
                (range_ )
            ( _contextIkappaUnique,_contextIself) =
                (context_ (_contextOkappaUnique))
            ( _typeIassumptions,_typeIconstraints,_typeIkappa,_typeIkappaUnique,_typeIself) =
                (type_ (_typeOconstraints) (_typeOkappaUnique))
            ((_assumptions@_,_kappa@_)) =
                internalError "KindInferencing.ag" "n/a" "Qualified types are not supported"
            (_self@_) =
                Type_Qualified _rangeIself _contextIself _typeIself
            (_lhsOself@_) =
                _self
            (_lhsOassumptions@_) =
                _assumptions
            (_lhsOconstraints@_) =
                _typeIconstraints
            (_lhsOkappa@_) =
                _kappa
            (_lhsOkappaUnique@_) =
                _typeIkappaUnique
            (_contextOkappaUnique@_) =
                _lhsIkappaUnique
            (_typeOconstraints@_) =
                _lhsIconstraints
            (_typeOkappaUnique@_) =
                _contextIkappaUnique
        in  ( _lhsOassumptions,_lhsOconstraints,_lhsOkappa,_lhsOkappaUnique,_lhsOself)
sem_Type_Variable :: (T_Range) ->
                     (T_Name) ->
                     (T_Type)
sem_Type_Variable (range_) (name_) =
    \ _lhsIconstraints
      _lhsIkappaUnique ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOconstraints :: (KindConstraints)
            _lhsOkappa :: (Kind)
            _lhsOkappaUnique :: (Int)
            _lhsOself :: (Type)
            _rangeIself :: (Range)
            _nameIself :: (Name)
            ( _rangeIself) =
                (range_ )
            ( _nameIself) =
                (name_ )
            (_kappa@_) =
                TVar _lhsIkappaUnique
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique + 1
            (_lhsOassumptions@_) =
                single _nameIself _kappa
            (_self@_) =
                Type_Variable _rangeIself _nameIself
            (_lhsOself@_) =
                _self
            (_lhsOconstraints@_) =
                _lhsIconstraints
            (_lhsOkappa@_) =
                _kappa
        in  ( _lhsOassumptions,_lhsOconstraints,_lhsOkappa,_lhsOkappaUnique,_lhsOself)
-- Types -------------------------------------------------------
-- semantic domain
type T_Types = (KindConstraints) ->
               (Int) ->
               ( (Assumptions),(KindConstraints),(Int),(Kinds),(Types))
-- cata
sem_Types :: (Types) ->
             (T_Types)
sem_Types (list) =
    (Prelude.foldr (sem_Types_Cons) (sem_Types_Nil) ((Prelude.map sem_Type list)))
sem_Types_Cons :: (T_Type) ->
                  (T_Types) ->
                  (T_Types)
sem_Types_Cons (hd_) (tl_) =
    \ _lhsIconstraints
      _lhsIkappaUnique ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOconstraints :: (KindConstraints)
            _lhsOkappaUnique :: (Int)
            _lhsOkappas :: (Kinds)
            _lhsOself :: (Types)
            _hdIassumptions :: (Assumptions)
            _hdIconstraints :: (KindConstraints)
            _hdIkappa :: (Kind)
            _hdIkappaUnique :: (Int)
            _hdIself :: (Type)
            _hdOconstraints :: (KindConstraints)
            _hdOkappaUnique :: (Int)
            _tlIassumptions :: (Assumptions)
            _tlIconstraints :: (KindConstraints)
            _tlIkappaUnique :: (Int)
            _tlIkappas :: (Kinds)
            _tlIself :: (Types)
            _tlOconstraints :: (KindConstraints)
            _tlOkappaUnique :: (Int)
            ( _hdIassumptions,_hdIconstraints,_hdIkappa,_hdIkappaUnique,_hdIself) =
                (hd_ (_hdOconstraints) (_hdOkappaUnique))
            ( _tlIassumptions,_tlIconstraints,_tlIkappaUnique,_tlIkappas,_tlIself) =
                (tl_ (_tlOconstraints) (_tlOkappaUnique))
            (_lhsOkappas@_) =
                _hdIkappa : _tlIkappas
            (_lhsOassumptions@_) =
                _hdIassumptions `combine` _tlIassumptions
            (_self@_) =
                (:) _hdIself _tlIself
            (_lhsOself@_) =
                _self
            (_lhsOconstraints@_) =
                _tlIconstraints
            (_lhsOkappaUnique@_) =
                _tlIkappaUnique
            (_hdOconstraints@_) =
                _lhsIconstraints
            (_hdOkappaUnique@_) =
                _lhsIkappaUnique
            (_tlOconstraints@_) =
                _hdIconstraints
            (_tlOkappaUnique@_) =
                _hdIkappaUnique
        in  ( _lhsOassumptions,_lhsOconstraints,_lhsOkappaUnique,_lhsOkappas,_lhsOself)
sem_Types_Nil :: (T_Types)
sem_Types_Nil  =
    \ _lhsIconstraints
      _lhsIkappaUnique ->
        let _lhsOassumptions :: (Assumptions)
            _lhsOconstraints :: (KindConstraints)
            _lhsOkappaUnique :: (Int)
            _lhsOkappas :: (Kinds)
            _lhsOself :: (Types)
            (_lhsOkappas@_) =
                []
            (_lhsOassumptions@_) =
                noAssumptions
            (_self@_) =
                []
            (_lhsOself@_) =
                _self
            (_lhsOconstraints@_) =
                _lhsIconstraints
            (_lhsOkappaUnique@_) =
                _lhsIkappaUnique
        in  ( _lhsOassumptions,_lhsOconstraints,_lhsOkappaUnique,_lhsOkappas,_lhsOself)


