/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: effect.h,v 1.2.24.1 2004/07/09 01:51:59 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _CIMFEFFECT_H
#define _CIMFEFFECT_H

#include "hxformt.h"
#include "hxplugn.h"
#include "hxfiles.h"

#include "gstring.h"
#include "rect.h"
#include "color.h"
#include "rpfileio.h"

enum
{
    kTypeFill       = 0,
    kTypeFadeIn     = 1,
    kTypeFadeOut    = 2,
    kTypeCrossFade  = 3,
    kTypeWipe       = 4,
    kTypeViewChange = 5,
    kTypeExternal   = 6,
    kTypeAnimate    = 7
};

// Forward declaration of CIMFFileObject
class CIMFFileObject;

class CIMFEffect : public CHXBaseCountingObject
{
protected:
    ULONG32         m_ulStart;
    CIMFDstRect     m_cDstRect;
    GString         m_cURL;
	ULONG32         m_ulMaxFps;
    BOOL            m_bFirstUse;
    BOOL            m_bLastUse;
    CIMFFileObject *m_pFileObject;
    GString         m_cErrorMessage;

    static char m_pszStart[];
    static char m_pszDuration[];
    static char m_pszTarget[];
    static char m_pszAspect[];
    static char m_pszWipeDirection[];
    static char m_pszWipeType[];
    static char m_pszURL[];
    static char m_pszPackage[];
    static char m_pszName[];
    static char m_pszData[];
    static char m_pszFile[];
    static char m_pszMaxFps[];

    ULONG32 RenderBinaryType(unsigned char *pBuffer, ULONG32 ulValue)
    {
        pBuffer[0] = (unsigned char) ((ulValue >> 24) & 0x000000FF);
        pBuffer[1] = (unsigned char) ((ulValue >> 16) & 0x000000FF);
        pBuffer[2] = (unsigned char) ((ulValue >>  8) & 0x000000FF);
        pBuffer[3] = (unsigned char) ( ulValue        & 0x000000FF);

        return 4;
    };

    ULONG32 InitFromBinaryType(unsigned char *pBuffer, ULONG32 &rulValue)
    {
        rulValue = ((pBuffer[0] << 24) & 0xFF000000) |
                   ((pBuffer[1] << 16) & 0x00FF0000) |
                   ((pBuffer[2] <<  8) & 0x0000FF00) |
                   ( pBuffer[3]        & 0x000000FF);

        return 4;
    };

    ULONG32 RenderBinaryType(unsigned char *pBuffer, UINT16 usValue)
    {
        pBuffer[0] = (unsigned char) ((usValue >> 8) & 0x00FF);
        pBuffer[1] = (unsigned char) ( usValue       & 0x00FF);

        return 2;
    };

    ULONG32 InitFromBinaryType(unsigned char *pBuffer, UINT16 &rusValue)
    {
        rusValue = ((pBuffer[0] << 8) & 0xFF00) |
                   ( pBuffer[1]       & 0x00FF);

        return 2;
    };

    ULONG32 RenderBinaryType(unsigned char *pBuffer, BOOL bValue)
    {
        return RenderBinaryType(pBuffer, (ULONG32) bValue);
    };

    ULONG32 InitFromBinaryType(unsigned char *pBuffer, BOOL &rbValue)
    {
        ULONG32 ulTmp;
        ULONG32 ulRetVal = InitFromBinaryType(pBuffer, ulTmp);
        rbValue          = ulTmp;

        return ulRetVal;
    };

    ULONG32 RenderBinaryType(unsigned char *pBuffer, GString &rString)
    {
        ULONG32 ulCurPos = 0;
        ulCurPos += RenderBinaryType(pBuffer + ulCurPos, (UINT16) rString.length());
        if (rString.length() > 0)
        {
            memcpy(pBuffer + ulCurPos, rString.c_str(), rString.length());
        }

        return 2 + rString.length();
    };

    ULONG32 InitFromBinaryType(unsigned char *pBuffer, GString &rString)
    {
        ULONG32 ulCurPos = 0;
        UINT16  usSize;
        ulCurPos += InitFromBinaryType(pBuffer + ulCurPos, usSize);
        rString.CopyN(pBuffer + ulCurPos, (ULONG32) usSize);

        return (ULONG32) 2 + usSize;
    };
public:
    CIMFEffect();

    CIMFEffect(CIMFFileObject *pFileObject);

    CIMFEffect(const CIMFEffect &rEffect);

    ~CIMFEffect();

    const CIMFEffect & operator = (const CIMFEffect &rEffect)
    {
        m_ulStart    = rEffect.m_ulStart;
        m_cDstRect   = rEffect.m_cDstRect;
        m_cURL       = rEffect.m_cURL;
		m_ulMaxFps	 = rEffect.m_ulMaxFps;
        return *this;
    };

    ULONG32             GetStart()        const { return m_ulStart;       }
	ULONG32             GetMaxFps()       const { return m_ulMaxFps;      }
    BOOL                GetFirstUse()     const { return m_bFirstUse;     }
    BOOL                GetLastUse()      const { return m_bLastUse;      }
    const CIMFDstRect & GetDstRect()      const { return m_cDstRect;      }
    GString     & GetURL()			{ return m_cURL;          }
    GString     & GetErrorMessage()		{ return m_cErrorMessage; }
                                             
    void SetStart(ULONG32 ulStart)                  { m_ulStart = ulStart; }
    void SetDstRect(ULONG32 ulX, ULONG32 ulY, ULONG32 ulW, ULONG32 ulH) { m_cDstRect.Set(ulX, ulY, ulW, ulH); }
    void SetDstRect(const CIMFRect &rRect)          { m_cDstRect = rRect; }
    void SetURL(const char *pszURL)                 { m_cURL = pszURL; }
	void SetDefaultMaxFps(ULONG32 ulMaxFps)         { m_ulMaxFps = ulMaxFps;};
    void SetFirstUse(BOOL bFirstUse)                { m_bFirstUse = bFirstUse; }
    void SetLastUse(BOOL bLastUse)                  { m_bLastUse  = bLastUse; }
    void SetFileObject(CIMFFileObject *pFileObject) { m_pFileObject = pFileObject; }

    ULONG32 ComputeTransmissionDuration(ULONG32 ulBitrate)
    {
        if (ulBitrate)
        {
            return ((GetBinaryLength() * 8000) / ulBitrate) + 1; // round up one ms
        }
        else
        {
            return 0;
        }
    };

    virtual ULONG32 GetType()              = 0;
    virtual BOOL    HasTargetImage()       = 0;
    virtual BOOL    HasDuration()          = 0;
    virtual ULONG32 GetDuration()          = 0;
    virtual BOOL    HasAspectFlag()        = 0;
    virtual ULONG32 GetTargetImageHandle() = 0;

    virtual ULONG32 GetBinaryLength()                  = 0;
    virtual ULONG32 RenderBinary(unsigned char *pBuffer)       = 0;
    virtual ULONG32 InitFromBinary(unsigned char *pBuffer)     = 0;

    virtual void    RenderText(GString &rText)         = 0;
    virtual BOOL    InitFromText(GString &rText) = 0;

    virtual void    RenderToolData(IMFEFFECT& imfEffect)=0;
    virtual BOOL    InitFromToolData(IMFEFFECT imfEffect)=0;

};
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
class CIMFFadeinEffect : public CIMFEffect
{
protected:  
    ULONG32     m_ulDuration;
    ULONG32     m_ulTarget;
    CIMFSrcRect m_cSrcRect;
    BOOL        m_bAspectFlag;
    BOOL        m_bAspectDefault;
public:
    CIMFFadeinEffect() : CIMFEffect(),
                         m_ulTarget(0),
                         m_cSrcRect(),
                         m_bAspectFlag(TRUE),
                         m_ulDuration(0),
                         m_bAspectDefault(TRUE)
    {};

    CIMFFadeinEffect(CIMFFileObject *pFileObject) : CIMFEffect(pFileObject),
                                                    m_ulTarget(0),
                                                    m_cSrcRect(),
                                                    m_bAspectFlag(TRUE),
                                                    m_ulDuration(0),
                                                    m_bAspectDefault(TRUE)
    {};

    CIMFFadeinEffect(const CIMFFadeinEffect &rEffect) : CIMFEffect(rEffect),
                                                        m_ulDuration(rEffect.m_ulDuration),
                                                        m_ulTarget(rEffect.m_ulTarget),
                                                        m_cSrcRect(rEffect.m_cSrcRect),
                                                        m_bAspectFlag(rEffect.m_bAspectFlag),
                                                        m_bAspectDefault(rEffect.m_bAspectDefault)
    {};

    ~CIMFFadeinEffect() {};

    virtual ULONG32 GetType()              { return kTypeFadeIn; }
    virtual BOOL    HasAspectFlag()        { return FALSE;}
    BOOL    GetAspectDefault() const              { return m_bAspectDefault; }
    void    SetAspectDefault(BOOL bAspectDefault) { m_bAspectDefault = bAspectDefault; }
    BOOL    GetAspectFlag()                       { return m_bAspectFlag;}
    void    SetAspectFlag(BOOL bVal)              { m_bAspectFlag = bVal;}    

    const CIMFSrcRect& GetSrcRect() const { return m_cSrcRect; }

    virtual BOOL    HasDuration()          { return TRUE;}
    void            SetDuration(ULONG32 ulVal){m_ulDuration=ulVal;}   
    virtual ULONG32 GetDuration(){return m_ulDuration;}

    virtual BOOL    HasTargetImage()       { return TRUE; }
    virtual ULONG32 GetTargetImageHandle() { return m_ulTarget; }
    void    SetTargetImageHandle(ULONG32 ulHandle) { m_ulTarget=ulHandle;}

    virtual ULONG32 GetBinaryLength();
    virtual ULONG32 RenderBinary(unsigned char *pBuffer);
    virtual ULONG32 InitFromBinary(unsigned char *pBuffer);
    virtual void    RenderToolData(IMFEFFECT& imfEffect);
    virtual BOOL    InitFromToolData(IMFEFFECT imfEffect);

    virtual void    RenderText(GString &rText);
    virtual BOOL    InitFromText(GString &rText);
};
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
class CIMFCrossfadeEffect : public CIMFEffect
{
protected:    
    ULONG32     m_ulDuration;
    ULONG32     m_ulTarget;
    CIMFSrcRect m_cSrcRect;
    BOOL        m_bAspectFlag;
    BOOL        m_bAspectDefault;
public:
    CIMFCrossfadeEffect() : CIMFEffect(),
                            m_ulTarget(0),
                            m_cSrcRect(),
                            m_bAspectFlag(TRUE),
                            m_ulDuration(0),
                            m_bAspectDefault(TRUE) {};

    CIMFCrossfadeEffect(CIMFFileObject *pFileObject) : CIMFEffect(pFileObject),
                                                       m_ulTarget(0),
                                                       m_cSrcRect(),
                                                       m_bAspectFlag(TRUE),
                                                       m_ulDuration(0),
                                                       m_bAspectDefault(TRUE)
    {};

    CIMFCrossfadeEffect(const CIMFCrossfadeEffect &rEffect) : CIMFEffect(rEffect),
                                                              m_ulDuration(rEffect.m_ulDuration),
                                                              m_ulTarget(rEffect.m_ulTarget),
                                                              m_cSrcRect(rEffect.m_cSrcRect),
                                                              m_bAspectFlag(rEffect.m_bAspectFlag),
                                                              m_bAspectDefault(rEffect.m_bAspectDefault) {};
    ~CIMFCrossfadeEffect() {};

    virtual ULONG32 GetType()              { return kTypeCrossFade; }
    virtual BOOL    HasAspectFlag()        { return TRUE;};
    BOOL    GetAspectDefault() const              { return m_bAspectDefault; }
    void    SetAspectDefault(BOOL bAspectDefault) { m_bAspectDefault = bAspectDefault; }
    BOOL    GetAspectFlag()                       { return m_bAspectFlag;}
    void    SetAspectFlag(BOOL bVal)              { m_bAspectFlag = bVal;}

    const CIMFSrcRect& GetSrcRect() const { return m_cSrcRect; }

    virtual BOOL    HasDuration()          { return TRUE;};
    void            SetDuration(ULONG32 ulVal){m_ulDuration=ulVal;}   
    virtual ULONG32 GetDuration(){return m_ulDuration;}

    virtual BOOL    HasTargetImage()       { return TRUE; }
    virtual ULONG32 GetTargetImageHandle() { return m_ulTarget; }
    void    SetTargetImageHandle(ULONG32 ulHandle) { m_ulTarget=ulHandle;}

    virtual ULONG32 GetBinaryLength();
    virtual ULONG32 RenderBinary(unsigned char *pBuffer);
    virtual ULONG32 InitFromBinary(unsigned char *pBuffer);

    virtual void    RenderText(GString &rText);
    virtual BOOL    InitFromText(GString &rText);

    virtual void    RenderToolData(IMFEFFECT& imfEffect);
    virtual BOOL    InitFromToolData(IMFEFFECT imfEffect);

};
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
class CIMFFillEffect : public CIMFEffect
{
protected:
    CIMFColor m_cColor;
public:
    CIMFFillEffect() : CIMFEffect(),
                       m_cColor()
    {};

    CIMFFillEffect(CIMFFileObject *pFileObject) : CIMFEffect(pFileObject),
                                                  m_cColor()
    {};

    CIMFFillEffect(const CIMFFillEffect &rEffect) : CIMFEffect(rEffect),
                                                    m_cColor(rEffect.m_cColor) {};

    ~CIMFFillEffect() {};
    virtual ULONG32 GetType()              { return kTypeFill; }
    virtual BOOL    HasAspectFlag()        { return FALSE;};
    BOOL    GetAspectDefault() const              { return 0; }
    void    SetAspectDefault(BOOL bAspectDefault) { bAspectDefault=bAspectDefault; }
    BOOL    GetAspectFlag()                       { return 0;}
    void    SetAspectFlag(BOOL bVal)              { bVal=bVal;}

    virtual BOOL    HasDuration()          { return FALSE;};
    virtual ULONG32 GetDuration()          { return 0; };

    virtual BOOL    HasTargetImage()       { return FALSE; }
    virtual ULONG32 GetTargetImageHandle() { return 0; }
    void    SetTargetImageHandle(ULONG32 ulHandle) {}

    const CIMFColor& GetColor() { return m_cColor; }

    virtual ULONG32 GetBinaryLength();
    virtual ULONG32 RenderBinary(unsigned char *pBuffer);
    virtual ULONG32 InitFromBinary(unsigned char *pBuffer);

    virtual void    RenderText(GString &rText);
    virtual BOOL    InitFromText(GString &rText);

    virtual void    RenderToolData(IMFEFFECT& imfEffect);
    virtual BOOL    InitFromToolData(IMFEFFECT imfEffect);

};
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
class CIMFFadeoutEffect : public CIMFEffect
{
protected: 
    CIMFColor m_cColor;
    ULONG32   m_ulDuration;
public:
    CIMFFadeoutEffect() : CIMFEffect(),
                          m_cColor()
    {};

    CIMFFadeoutEffect(CIMFFileObject *pFileObject) : CIMFEffect(pFileObject),
                                                     m_cColor()
    {};

    CIMFFadeoutEffect(const CIMFFadeoutEffect &rEffect) : CIMFEffect(rEffect),
                                                          m_cColor(rEffect.m_cColor)
    {};

    ~CIMFFadeoutEffect() {};
    
    virtual ULONG32 GetType()              { return kTypeFadeOut; }
    virtual BOOL    HasAspectFlag()        { return FALSE;};
    virtual BOOL    HasDuration()          { return TRUE;};
    void            SetDuration(ULONG32 ulVal){m_ulDuration=ulVal;}   
    virtual ULONG32 GetDuration(){return m_ulDuration;}

    virtual BOOL    HasTargetImage()       { return FALSE; }
    virtual ULONG32 GetTargetImageHandle() { return 0; }
    void    SetTargetImageHandle(ULONG32 ulHandle) {}

    virtual ULONG32 GetBinaryLength();
    virtual ULONG32 RenderBinary(unsigned char *pBuffer);
    virtual ULONG32 InitFromBinary(unsigned char *pBuffer);

    virtual void    RenderText(GString &rText);
    virtual BOOL    InitFromText(GString &rText);

    virtual void    RenderToolData(IMFEFFECT& imfEffect);
    virtual BOOL    InitFromToolData(IMFEFFECT imfEffect);

    const CIMFColor& GetColor() { return m_cColor; }

};
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
class CIMFWipeEffect : public CIMFEffect
{
public:
    enum {kDirectionUp, kDirectionDown, kDirectionLeft, kDirectionRight};
    enum {kTypeNormal, kTypePush};
protected:
    ULONG32     m_ulDuration;
    ULONG32     m_ulTarget;
    CIMFSrcRect m_cSrcRect;
    BOOL        m_bAspectFlag;
    BOOL        m_bAspectDefault;
    ULONG32     m_ulDirection;
    ULONG32     m_ulType;

    static char m_pszWipeDirectionUp[];
    static char m_pszWipeDirectionDown[];
    static char m_pszWipeDirectionLeft[];
    static char m_pszWipeDirectionRight[];
    static char m_pszWipeTypeNormal[];
    static char m_pszWipeTypePush[];
public:
    CIMFWipeEffect() : CIMFEffect(),
                       m_ulTarget(0),
                       m_cSrcRect(),
                       m_bAspectFlag(TRUE),
                       m_bAspectDefault(TRUE),
                       m_ulDirection(kDirectionLeft),
                       m_ulType(kTypeNormal)
    {};

    CIMFWipeEffect(CIMFFileObject *pFileObject) : CIMFEffect(pFileObject),
                                                  m_ulTarget(0),
                                                  m_cSrcRect(),
                                                  m_bAspectFlag(TRUE),
                                                  m_bAspectDefault(TRUE),
                                                  m_ulDirection(kDirectionLeft),
                                                  m_ulType(kTypeNormal)
    {};

    CIMFWipeEffect(const CIMFWipeEffect &rEffect) : CIMFEffect(rEffect),
                                                    m_ulDuration(rEffect.m_ulDuration),
                                                    m_ulTarget(rEffect.m_ulTarget),
                                                    m_bAspectFlag(rEffect.m_bAspectFlag),
                                                    m_bAspectDefault(rEffect.m_bAspectDefault),
                                                    m_ulDirection(rEffect.m_ulDirection),
                                                    m_ulType(rEffect.m_ulType)
    {};

    ~CIMFWipeEffect() {};

    
    ULONG32 GetDirection()                 { return m_ulDirection;}
    virtual BOOL    HasAspectFlag()        { return TRUE;};
    BOOL    GetAspectDefault() const              { return m_bAspectDefault; }
    void    SetAspectDefault(BOOL bAspectDefault) { m_bAspectDefault = bAspectDefault; }
    BOOL    GetAspectFlag()                       { return m_bAspectFlag;}
    void    SetAspectFlag(BOOL bVal)              { m_bAspectFlag = bVal;}    

    const CIMFSrcRect& GetSrcRect() const { return m_cSrcRect; }

    virtual BOOL    HasDuration()          { return TRUE;};
    void            SetDuration(ULONG32 ulVal){m_ulDuration=ulVal;}   
    virtual ULONG32 GetDuration(){return m_ulDuration;}

    virtual ULONG32 GetType()              { return kTypeWipe; }
    virtual BOOL    HasTargetImage()       { return TRUE; }
    virtual ULONG32 GetTargetImageHandle() { return m_ulTarget; }
    void    SetTargetImageHandle(ULONG32 ulHandle) { m_ulTarget=ulHandle;}

    BYTE GetWipeDirection() { return (BYTE) m_ulDirection; }
    BYTE GetWipeType()      { return (BYTE) m_ulType;      }
    

    virtual ULONG32 GetBinaryLength();
    virtual ULONG32 RenderBinary(unsigned char *pBuffer);
    virtual ULONG32 InitFromBinary(unsigned char *pBuffer);

    virtual void    RenderText(GString &rText);
    virtual BOOL    InitFromText(GString &rText);

    virtual void    RenderToolData(IMFEFFECT& imfEffect);
    virtual BOOL    InitFromToolData(IMFEFFECT imfEffect);

};
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
class CIMFViewchangeEffect : public CIMFEffect
{
protected:
    CIMFSrcRect m_cSrcRect;
    ULONG32 m_ulDuration;
    UINT32  m_ulHandle;
public:
    CIMFViewchangeEffect() : CIMFEffect(),
                             m_ulDuration(0),
                             m_ulHandle(0),
                             m_cSrcRect()
    {};

    CIMFViewchangeEffect(CIMFFileObject *pFileObject) : CIMFEffect(pFileObject),
                                                        m_ulDuration(0),
                                                        m_ulHandle(0),
                                                        m_cSrcRect()
    {};

    CIMFViewchangeEffect(const CIMFViewchangeEffect &rEffect) : CIMFEffect(rEffect),
                                                                m_ulDuration(rEffect.m_ulDuration),
                                                                m_ulHandle(rEffect.m_ulHandle),
                                                                m_cSrcRect(rEffect.m_cSrcRect)
    {};

    ~CIMFViewchangeEffect() {};

    virtual ULONG32 GetType()              { return kTypeViewChange; }
    virtual BOOL    HasAspectFlag()        { return TRUE;};
    BOOL    GetAspectDefault() const              { return TRUE; }
    void    SetAspectDefault(BOOL bAspectDefault) { bAspectDefault=bAspectDefault; }
    BOOL    GetAspectFlag()                       { return TRUE;}
    void    SetAspectFlag(BOOL bVal)              { bVal=bVal;}

    const CIMFSrcRect& GetSrcRect() const { return m_cSrcRect; }


    virtual BOOL    HasDuration()          { return TRUE;};
    void            SetDuration(ULONG32 ulVal){m_ulDuration=ulVal;}   
    virtual ULONG32 GetDuration(){return m_ulDuration;}

    virtual BOOL    HasTargetImage()       { return TRUE; }
    virtual ULONG32 GetTargetImageHandle() { return m_ulHandle; }
    void    SetTargetImageHandle(ULONG32 ulHandle) { m_ulHandle = ulHandle; }     

    
    virtual ULONG32 GetBinaryLength();
    virtual ULONG32 RenderBinary(unsigned char *pBuffer);
    virtual ULONG32 InitFromBinary(unsigned char *pBuffer);

    virtual void    RenderText(GString &rText);
    virtual BOOL    InitFromText(GString &rText);

    virtual void    RenderToolData(IMFEFFECT& imfEffect);
    virtual BOOL    InitFromToolData(IMFEFFECT imfEffect);

};
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
class CIMFExternalEffect : public CIMFEffect
{
protected:
    ULONG32     m_ulDuration;
    ULONG32     m_ulTarget;
    CIMFSrcRect m_cSrcRect;
    BOOL        m_bAspectFlag;
    BOOL        m_bAspectDefault;
    GString     m_cPackage;
    GString     m_cName;
    GString     m_cData;
    GString     m_cFile;
public:
    CIMFExternalEffect() : CIMFEffect(),
                           m_ulDuration(0),
                           m_ulTarget(0),
                           m_cSrcRect(),
                           m_bAspectFlag(TRUE),
                           m_bAspectDefault(TRUE),
                           m_cPackage(),
                           m_cName(),
                           m_cData(),
                           m_cFile()
    {};

    CIMFExternalEffect(CIMFFileObject *pFileObject) : CIMFEffect(pFileObject),
                                                      m_ulDuration(0),
                                                      m_ulTarget(0),
                                                      m_cSrcRect(),
                                                      m_bAspectFlag(TRUE),
                                                      m_bAspectDefault(TRUE),
                                                      m_cPackage(),
                                                      m_cName(), 
                                                      m_cData(),
                                                      m_cFile()
    {};

    CIMFExternalEffect(const CIMFExternalEffect &rEffect) : CIMFEffect(rEffect),
                                                            m_ulDuration(rEffect.m_ulDuration),
                                                            m_ulTarget(rEffect.m_ulTarget),
                                                            m_cSrcRect(rEffect.m_cSrcRect),
                                                            m_bAspectFlag(rEffect.m_bAspectFlag),
                                                            m_bAspectDefault(rEffect.m_bAspectDefault),
                                                            m_cPackage(rEffect.m_cPackage),
                                                            m_cName(rEffect.m_cName),
                                                            m_cData(rEffect.m_cData),
                                                            m_cFile(rEffect.m_cFile)
    {};

    ~CIMFExternalEffect() {};

    BOOL    GetAspectFlag()                       { return m_bAspectFlag;}
    void    SetAspectFlag(BOOL bVal)              { m_bAspectFlag = bVal;}
    BOOL    GetAspectDefault() const              { return m_bAspectDefault; }
    void    SetAspectDefault(BOOL bAspectDefault) { m_bAspectDefault = bAspectDefault; }

    const CIMFSrcRect& GetSrcRect() const { return m_cSrcRect; }


    GString & GetPackage()               { return m_cPackage; }
    GString & GetData()                  { return m_cData; }
    GString & GetFile()                  { return m_cFile; }
    GString & GetName()                  { return m_cName; }
    void  SetPackage(GString str){m_cPackage=str;};
    void  SetData(GString str){m_cData=str;};
    void  SetFile(GString str){m_cFile=str;};
    void  SetName(GString str){m_cName=str;};

    virtual BOOL    HasAspectFlag()            { return TRUE;};
    virtual BOOL    HasDuration()              { return TRUE;};
    void            SetDuration(ULONG32 ulVal){m_ulDuration=ulVal;}   
    virtual ULONG32 GetDuration(){return m_ulDuration;}

    virtual ULONG32 GetType()                  { return kTypeExternal; }
    virtual BOOL    HasTargetImage()           { return TRUE; }
    virtual ULONG32 GetTargetImageHandle()     { return m_ulTarget; }
    void    SetTargetImageHandle(ULONG32 ulHandle) { m_ulTarget=ulHandle;}

    virtual ULONG32 GetBinaryLength();
    virtual ULONG32 RenderBinary(unsigned char *pBuffer);
    virtual ULONG32 InitFromBinary(unsigned char *pBuffer);

    virtual void    RenderText(GString &rText);
    virtual BOOL    InitFromText(GString &rText);

    virtual void    RenderToolData(IMFEFFECT& imfEffect);
    virtual BOOL    InitFromToolData(IMFEFFECT imfEffect);
};

class CIMFAnimateEffect : public CIMFEffect
{
protected:  
    ULONG32     m_ulDuration;
    ULONG32     m_ulTarget;
    CIMFSrcRect m_cSrcRect;
    BOOL        m_bAspectFlag;
    BOOL        m_bAspectDefault;
public:
    CIMFAnimateEffect() : CIMFEffect(),
                          m_ulTarget(0),
                          m_cSrcRect(),
                          m_bAspectFlag(TRUE),
                          m_ulDuration(0),
                          m_bAspectDefault(TRUE)
    {};

    CIMFAnimateEffect(CIMFFileObject *pFileObject) : CIMFEffect(pFileObject),
                                                     m_ulTarget(0),
                                                     m_cSrcRect(),
                                                     m_bAspectFlag(TRUE),
                                                     m_ulDuration(0),
                                                     m_bAspectDefault(TRUE)
    {};

    CIMFAnimateEffect(const CIMFAnimateEffect &rEffect) : CIMFEffect(rEffect),
                                                          m_ulDuration(rEffect.m_ulDuration),
                                                          m_ulTarget(rEffect.m_ulTarget),
                                                          m_cSrcRect(rEffect.m_cSrcRect),
                                                          m_bAspectFlag(rEffect.m_bAspectFlag),
                                                          m_bAspectDefault(rEffect.m_bAspectDefault)
    {};

    ~CIMFAnimateEffect() {};

    virtual ULONG32 GetType()              { return kTypeAnimate; }
    virtual BOOL    HasAspectFlag()        { return TRUE;}
    BOOL    GetAspectDefault() const              { return m_bAspectDefault; }
    void    SetAspectDefault(BOOL bAspectDefault) { m_bAspectDefault = bAspectDefault; }
    BOOL    GetAspectFlag()                       { return m_bAspectFlag;}
    void    SetAspectFlag(BOOL bVal)              { m_bAspectFlag = bVal;}    

    const CIMFSrcRect& GetSrcRect() const { return m_cSrcRect; }

    virtual BOOL    HasDuration()          { return TRUE;}
    void            SetDuration(ULONG32 ulVal){m_ulDuration=ulVal;}   
    virtual ULONG32 GetDuration(){return m_ulDuration;}

    virtual BOOL    HasTargetImage()       { return TRUE; }
    virtual ULONG32 GetTargetImageHandle() { return m_ulTarget; }
    void    SetTargetImageHandle(ULONG32 ulHandle) { m_ulTarget=ulHandle;}

    virtual ULONG32 GetBinaryLength();
    virtual ULONG32 RenderBinary(unsigned char *pBuffer);
    virtual ULONG32 InitFromBinary(unsigned char *pBuffer);
    virtual void    RenderToolData(IMFEFFECT& imfEffect);
    virtual BOOL    InitFromToolData(IMFEFFECT imfEffect);

    virtual void    RenderText(GString &rText);
    virtual BOOL    InitFromText(GString &rText);
};

class CIMFEffectFactory
{
    public:
        CIMFEffectFactory(){};
        ~CIMFEffectFactory(){};
        CIMFEffect* CreateInstance(IMFEFFECT& imfEffect);
};

#endif
//////////////////////////////////////////////////////////////////////////////


