/* 
 * Copyright (C) 2001-2013 Michael Fuchs
 *
 * This file is part of herold.
 * 
 * herold is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * herold is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with herold.  If not, see <http://www.gnu.org/licenses/>.  
 */
package org.dbdoclet.tag.dita;

import org.dbdoclet.xiphias.dom.ElementImpl;

public class DitaElement extends ElementImpl {

	public static final String DITA_NAMESPACE = "http://dita.oasis-open.org/architecture/2005/";
	private boolean contentModel = false;

	public DitaElement(String name) {
		super(name);
	}

	public boolean isContentModel() {
		return contentModel;
	}

	protected void isContentModel(boolean contentModel) {
		this.contentModel = contentModel;
	}

	public boolean isValidParent(DitaElement parent) {
		return true;
	}

	public void setRemap(String remap) {
		
		String value = getAttribute("otherprops");
		
		if (value == null) {
			value = "remap(" + remap + ")";
		} else {
			value += " remap(" + remap + ")";
		}
		
		setAttribute("otherprops", value);
	}
}
