{- This module was generated from data in the Kate syntax highlighting file cpp.xml, version 1.41,
   by   -}

module Text.Highlighting.Kate.Syntax.Cpp ( highlight, parseExpression, syntaxName, syntaxExtensions ) where
import Text.Highlighting.Kate.Definitions
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Doxygen
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec
import Control.Monad (when)
import Data.Map (fromList)
import Data.Maybe (fromMaybe, maybeToList)

import qualified Data.Set as Set
-- | Full name of language.
syntaxName :: String
syntaxName = "C++"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.c++;*.cxx;*.cpp;*.cc;*.C;*.h;*.hh;*.H;*.h++;*.hxx;*.hpp;*.hcc;*.moc"

-- | Highlight source code using this syntax definition.
highlight :: String -> Either String [SourceLine]
highlight input =
  case runParser parseSource startingState "source" input of
    Left err     -> Left $ show err
    Right result -> Right result

-- | Parse an expression using appropriate local context.
parseExpression :: GenParser Char SyntaxState LabeledSource
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "C++" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

parseSource = do 
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents }
  result <- manyTill parseSourceLine eof
  return $ map normalizeHighlighting result

startingState = SyntaxState {synStContexts = fromList [("C++",["Normal"])], synStLanguage = "C++", synStCurrentLine = "", synStCharsParsedInLine = 0, synStPrevChar = '\n', synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

parseSourceLine = manyTill parseExpressionInternal pEndLine

pEndLine = do
  newline <|> (eof >> return '\n')
  context <- currentContext
  case context of
    "Normal" -> return ()
    "String" -> (popContext >> return ())
    "Region Marker" -> (popContext >> return ())
    "Commentar 1" -> (popContext >> return ())
    "Commentar 2" -> return ()
    "AfterHash" -> (popContext >> return ())
    "Preprocessor" -> (popContext >> return ())
    "Define" -> (popContext >> return ())
    "Commentar/Preprocessor" -> return ()
    "Outscoped" -> return ()
    "Outscoped intern" -> return ()
    _ -> return ()
  lineContents <- lookAhead wholeLine
  updateState $ \st -> st { synStCurrentLine = lineContents, synStCharsParsedInLine = 0, synStPrevChar = '\n' }

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  let labs = attr : maybeToList (lookup attr styles)
  st <- getState
  let oldCharsParsed = synStCharsParsedInLine st
  let prevchar = if null txt then '\n' else last txt
  updateState $ \st -> st { synStCharsParsedInLine = oldCharsParsed + length txt, synStPrevChar = prevchar } 
  return (labs, txt)

styles = [("Keyword","kw"),("Extensions","kw"),("Data Type","dt"),("Decimal","dv"),("Octal","bn"),("Hex","bn"),("Float","fl"),("Char","ch"),("String","st"),("String Char","ch"),("Comment","co"),("Preprocessor","ot"),("Prep. Lib","ot"),("Region Marker","re"),("Error","er")]

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe "" $ lookup context defaultAttributes))

list_keywords = Set.fromList $ words $ "asm break case catch class const_cast continue default delete do dynamic_cast else enum explicit export extern false friend for goto if inline namespace new operator private protected public qobject_cast reinterpret_cast return sizeof static_cast struct switch template this throw true try typedef typeid type_info typename union using virtual while and and_eq bad_cast bad_typeid bitand bitor compl not not_eq or or_eq xor xor_eq except finally xalloc"
list_extensions = Set.fromList $ words $ "K_DCOP SLOT SIGNAL Q_CLASSINFO Q_ENUMS Q_EXPORT Q_OBJECT Q_OVERRIDE Q_PROPERTY Q_SETS Q_SIGNALS Q_SLOTS Q_FOREACH Q_DECLARE_FLAGS Q_INIT_RESOURCE Q_CLEANUP_RESOURCE Q_GLOBAL_STATIC Q_GLOBAL_STATIC_WITH_ARGS Q_DECLARE_INTERFACE Q_DECLARE_TYPEINFO Q_DECLARE_SHARED Q_DECLARE_FLAGS Q_DECLARE_OPERATORS_FOR_FLAGS Q_FOREVER Q_DECLARE_PRIVATE Q_DECLARE_PUBLIC Q_D Q_Q Q_DISABLE_COPY Q_INTERFACES Q_FLAGS Q_SCRIPTABLE Q_INVOKABLE Q_GADGET Q_ARG Q_RETURN_ARG Q_ASSERT Q_ASSERT_X Q_PRIVATE_SLOT Q_DECLARE_METATYPE Q_NOREPLY TRUE FALSE connect disconnect emit signals slots foreach forever"
list_types = Set.fromList $ words $ "auto bool char const double float int long mutable register short signed static unsigned void volatile uchar uint int8_t int16_t int32_t int64_t uint8_t uint16_t uint32_t uint64_t wchar_t"

regex_'23'5cs'2aif'5cs'2b0 = compileRegex "#\\s*if\\s+0"
regex_'23'5cs'2aif'28'3f'3adef'7cndef'29'3f'28'3f'3d'5cs'2b'5cS'29 = compileRegex "#\\s*if(?:def|ndef)?(?=\\s+\\S)"
regex_'23'5cs'2aendif = compileRegex "#\\s*endif"
regex_'23'5cs'2adefine'2e'2a'28'28'3f'3d'5c'5c'29'29 = compileRegex "#\\s*define.*((?=\\\\))"
regex_'23'5cs'2a'28'3f'3ael'28'3f'3ase'7cif'29'7cinclude'28'3f'3a'5fnext'29'3f'7cdefine'7cundef'7cline'7cerror'7cwarning'7cpragma'29 = compileRegex "#\\s*(?:el(?:se|if)|include(?:_next)?|define|undef|line|error|warning|pragma)"
regex_'23'5cs'2b'5b0'2d9'5d'2b = compileRegex "#\\s+[0-9]+"
regex_'23'5cs'2aif = compileRegex "#\\s*if"
regex_'23'5cs'2ael'28'3f'3ase'7cif'29 = compileRegex "#\\s*el(?:se|if)"

defaultAttributes = [("Normal","Normal Text"),("String","String"),("Region Marker","Region Marker"),("Commentar 1","Comment"),("Commentar 2","Comment"),("AfterHash","Error"),("Preprocessor","Preprocessor"),("Define","Preprocessor"),("Commentar/Preprocessor","Comment"),("Outscoped","Comment"),("Outscoped intern","Comment")]

parseRules "Normal" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Normal Text"))
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif'5cs'2b0 >>= withAttribute "Preprocessor") >>~ pushContext "Outscoped")
                        <|>
                        ((pFirstNonSpace >> lookAhead (pDetectChar False '#') >> return ([],"") ) >>~ pushContext "AfterHash")
                        <|>
                        ((pFirstNonSpace >> pString False "//BEGIN" >>= withAttribute "Region Marker") >>~ pushContext "Region Marker")
                        <|>
                        ((pFirstNonSpace >> pString False "//END" >>= withAttribute "Region Marker") >>~ pushContext "Region Marker")
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute "Keyword"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_extensions >>= withAttribute "Extensions"))
                        <|>
                        ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_types >>= withAttribute "Data Type"))
                        <|>
                        ((pHlCChar >>= withAttribute "Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "String")
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Normal Text"))
                        <|>
                        (withChildren (pFloat >>= withAttribute "Float") ((pAnyChar "fF" >>= withAttribute "Float")))
                        <|>
                        ((pHlCOct >>= withAttribute "Octal"))
                        <|>
                        ((pHlCHex >>= withAttribute "Hex"))
                        <|>
                        (withChildren (pInt >>= withAttribute "Decimal") (((pString False "ULL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LUL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LLU" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "UL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LU" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "LL" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "U" >>= withAttribute "Decimal"))
                                                                          <|>
                                                                          ((pString False "L" >>= withAttribute "Decimal"))))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression))
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "Commentar 1")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "Commentar 2")
                        <|>
                        ((pDetectChar False '{' >>= withAttribute "Symbol"))
                        <|>
                        ((pDetectChar False '}' >>= withAttribute "Symbol"))
                        <|>
                        ((pAnyChar ":!%&()+,-/.*<=>?[]{|}~^;" >>= withAttribute "Symbol")))
     return (attr, result)

parseRules "String" = 
  do (attr, result) <- (((pLineContinue >>= withAttribute "String"))
                        <|>
                        ((pHlCStringChar >>= withAttribute "String Char"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ (popContext >> return ())))
     return (attr, result)

parseRules "Region Marker" = 
  pzero

parseRules "Commentar 1" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Comment"))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Alert.parseExpression))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Comment")))
     return (attr, result)

parseRules "Commentar 2" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Comment"))
                        <|>
                        ((pDetect2Chars False '*' '/' >>= withAttribute "Comment") >>~ (popContext >> return ()))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Alert.parseExpression))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Comment")))
     return (attr, result)

parseRules "AfterHash" = 
  do (attr, result) <- (((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif'28'3f'3adef'7cndef'29'3f'28'3f'3d'5cs'2b'5cS'29 >>= withAttribute "Preprocessor") >>~ pushContext "Preprocessor")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute "Preprocessor") >>~ pushContext "Preprocessor")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2adefine'2e'2a'28'28'3f'3d'5c'5c'29'29 >>= withAttribute "Preprocessor") >>~ pushContext "Define")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2a'28'3f'3ael'28'3f'3ase'7cif'29'7cinclude'28'3f'3a'5fnext'29'3f'7cdefine'7cundef'7cline'7cerror'7cwarning'7cpragma'29 >>= withAttribute "Preprocessor") >>~ pushContext "Preprocessor")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2b'5b0'2d9'5d'2b >>= withAttribute "Preprocessor") >>~ pushContext "Preprocessor"))
     return (attr, result)

parseRules "Preprocessor" = 
  do (attr, result) <- (((pLineContinue >>= withAttribute "Preprocessor"))
                        <|>
                        ((pRangeDetect '"' '"' >>= withAttribute "Prep. Lib"))
                        <|>
                        ((pRangeDetect '<' '>' >>= withAttribute "Prep. Lib"))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression))
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "Commentar/Preprocessor")
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "Commentar 1"))
     return (attr, result)

parseRules "Define" = 
  do (attr, result) <- ((pLineContinue >>= withAttribute "Preprocessor"))
     return (attr, result)

parseRules "Commentar/Preprocessor" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Comment"))
                        <|>
                        ((pDetect2Chars False '*' '/' >>= withAttribute "Comment") >>~ (popContext >> return ()))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Comment")))
     return (attr, result)

parseRules "Outscoped" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Comment"))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Alert.parseExpression))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Comment"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "String")
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression))
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "Commentar 1")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "Commentar 2")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute "Comment") >>~ pushContext "Outscoped intern")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2ael'28'3f'3ase'7cif'29 >>= withAttribute "Preprocessor") >>~ (popContext >> return ()))
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute "Preprocessor") >>~ (popContext >> return ())))
     return (attr, result)

parseRules "Outscoped intern" = 
  do (attr, result) <- (((pDetectSpaces >>= withAttribute "Comment"))
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Alert.parseExpression))
                        <|>
                        ((pDetectIdentifier >>= withAttribute "Comment"))
                        <|>
                        ((pDetectChar False '"' >>= withAttribute "String") >>~ pushContext "String")
                        <|>
                        ((Text.Highlighting.Kate.Syntax.Doxygen.parseExpression))
                        <|>
                        ((pDetect2Chars False '/' '/' >>= withAttribute "Comment") >>~ pushContext "Commentar 1")
                        <|>
                        ((pDetect2Chars False '/' '*' >>= withAttribute "Comment") >>~ pushContext "Commentar 2")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aif >>= withAttribute "Comment") >>~ pushContext "Outscoped intern")
                        <|>
                        ((pFirstNonSpace >> pRegExpr regex_'23'5cs'2aendif >>= withAttribute "Comment") >>~ (popContext >> return ())))
     return (attr, result)

parseRules x = fail $ "Unknown context" ++ x
