{- This module was generated from data in the Kate syntax
   highlighting file prolog.xml, version 1.04, by  -}

module Text.Highlighting.Kate.Syntax.Prolog
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Prolog"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.prolog"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Prolog" }
  context <- currentContext <|> (pushContext "normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Prolog",["normal"])], synStLanguage = "Prolog", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "normal" -> return ()
    "comment" -> (popContext) >> pEndLine
    "string" -> return ()
    "string2" -> return ()
    "comment region" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_keywordl = Set.fromList $ words $ "abstract align as and class clauses constants database determ domains elsedef endclass enddef erroneous facts failure global goal if ifdef ifndef implement include language multi nocopy nondeterm object or procedure protected predicates reference single static struct this"
list_keywordu = Set.fromList $ words $ "ABSTRACT ALIGN AS AND CLASS CLAUSES CONSTANTS DATABASE DETERM DOMAINS ELSEDEF ENDCLASS ENDDEF ERRONEOUS FACTS FAILURE GLOBAL GOAL IF IFDEF IFNDEF IMPLEMENT INCLUDE LANGUAGE MULTI NOCOPY NONDETERM OBJECT OR PROCEDURE PROTECTED PREDICATES REFERENCE SINGLE STATIC STRUCT THIS"
list_special = Set.fromList $ words $ "assert asserta assertz bound chain_inserta chain_insertafter chain_insertz chain_terms consult db_btrees db_chains fail findall format free msgrecv msgsend nl not readterm ref_term retract retractall save term_bin term_replace term_str trap write writef"
list_compiler = Set.fromList $ words $ "bgidriver bgifont check_determ code config diagnostics error errorlevel heap gstacksize nobreak nowarnings printermenu project"
list_arith = Set.fromList $ words $ "mod div abs exp ln log sqrt round trunc val cos sin tan arctan random randominit"
list_basetype = Set.fromList $ words $ "char real string symbol byte sbyte short ushort word integer unsigned dword long ulong binary ref"
list_keywords = Set.fromList $ words $ "true false"

regex_'5bA'2dZ'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex "[A-Z_][A-Za-z0-9_]*"
regex_'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a = compileRegex "[a-z][A-Za-z0-9_]*"

defaultAttributes = [("normal",NormalTok),("comment",CommentTok),("string",StringTok),("string2",StringTok),("comment region",CommentTok)]

parseRules "normal" =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywordl >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywordu >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_arith >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_compiler >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_special >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_basetype >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5bA'2dZ'5f'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '%' >>= withAttribute CommentTok) >>~ pushContext "comment")
   <|>
   ((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext "comment region")
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "string")
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "string2")
   <|>
   ((pAnyChar "~!^*()-+=[]|\\:;,./?&<>" >>= withAttribute NormalTok)))

parseRules "comment" =
  pzero

parseRules "string" =
  ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))

parseRules "string2" =
  ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext))

parseRules "comment region" =
  ((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))

parseRules "" = parseRules "normal"

parseRules x = fail $ "Unknown context" ++ x
