;; -*- Mode: Emacs-Lisp -*-
;; $Id: mail2nikki.el,v 1.1 1999/04/07 14:17:21 ari Exp $
;;
;; [mail2nikki]
;;  (c)1999 Akihiro Arisawa <ari@nijino.com>
;;	         http://www.nijino.com/ari/
;;
;; ڻȤ
;; M-x mew-nikki-send
;; M-x message-nikki-send
;;
;; 
;; (autoload 'mew-nikki-send "mail2nikki" nil t)
;; (autoload 'message-nikki-send "mail2nikki" nil t)
;; (setq mail2nikki:to-address "hoge@foo.bar.jp")
;; (setq mail2nikki:password "hirakegoma")
;;
;; ڤ¾
;; Υץϡfree softwareǤGPL2 ΤȤˡΥץ
;; ѤꤷƤ⤫ޤޤ
;; ΥץˤäƵ̤ˤĤƤʤݾڤԤޤ

(defvar mail2nikki:to-address nil
  "Υ᡼륢ɥ쥹ꤷޤ")

(defvar mail2nikki:cc-address nil
  "Cc˻ꤹ᡼륢ɥ쥹Ǥ")

(defvar mail2nikki:password nil
  "mail2nikkiΥѥɤꤷޤ")

(defvar mail2nikki:subject-list '("hnf:ADD" "hnf:DEL" "hnf:DEL&ADD" "hnf:GET")
  "mail2nikkiSubjectꥹȤǻꤷޤǽǤǥեȤȤʤޤ"
  )

(defvar mail2nikki:insert-end t
  "non-nilꤹ*-nikki-send¹ԻENDޤ")

(defvar mail2nikki-hook nil
  "*-nikki-sendhook")

(require 'hnf-mode)
(if hnf:font-lock (require 'font-lock))

(defvar mew-nikki-mode-map nil)
(defvar message-nikki-mode-map nil)

;;;###autoload
(defun mew-nikki-send (&optional arg)
  (interactive "P")
  (or (featurep 'mail2nikki:mew) (mail2nikki:mew-setup))
  (mail2nikki:nikki-send 'mail2nikki:mew-func mew-nikki-mode-map
			 'mew-nikki-font-lock-keywords arg))

;;;###autoload
(defun message-nikki-send (&optional arg)
  (interactive "P")
  (or (featurep 'mail2nikki:message) (mail2nikki:message-setup))
  (mail2nikki:nikki-send 'mail2nikki:message-func message-nikki-mode-map
			 'message-nikki-font-lock-keywords arg))

(defun mail2nikki:nikki-send (mail-func map keywords arg)
  ; ɥեȤѰ
  (let ((subject (if arg
		     (completing-read "Subject: "
				      (mapcar 'list mail2nikki:subject-list)
				      nil t "hnf:")
		   (car mail2nikki:subject-list))))
    (funcall mail-func mail2nikki:to-address mail2nikki:cc-address subject))
  ; 
  (insert (format "PASSWORD: %s\n" mail2nikki:password))
  (insert (format "DATE: %s\n\n" (format-time-string "%Y%m%d" (current-time))))
  (if mail2nikki:insert-end (save-excursion (insert "\nEND\n")))
  ; ޥåפѹ
  (make-local-variable 'hnf:tab-command)
  (setq hnf:tab-command (key-binding "\t"))
  (use-local-map map)
  ; font-lockط
  (if hnf:font-lock
      (progn
	(make-local-variable 'font-lock-defaults)
	(setq font-lock-defaults `(,keywords t))
	(turn-on-font-lock)))
  ; 䴰Ĵ
  (make-local-variable 'hnf:commands)
  (setq hnf:commands (append hnf:commands '(("END"))))
  (make-local-variable 'hnf:complete-ok)
  (setq hnf:complete-ok nil)
  ; ¿ʤ
  (set-buffer-modified-p nil)
  (run-hooks 'mail2nikki-hook))

(defun mail2nikki:mew-setup ()
  (require 'mew)

  (defvar mew-nikki-font-lock-keywords hnf:font-lock-keywords)

  (if mew-nikki-mode-map
      ()
    (setq mew-nikki-mode-map (copy-keymap mew-draft-mode-map))
    (define-key mew-nikki-mode-map "\t" 'hnf:tab-complete))
  
  (defun mail2nikki:mew-func (to cc subject)
    (mew-send to cc subject)
    (goto-char (mew-header-end))
    (forward-line 1))

  (provide 'mail2nikki:mew))

(defun mail2nikki:message-setup ()
  (require 'message)

  (defvar message-nikki-font-lock-keywords
    (append message-font-lock-keywords hnf:font-lock-keywords))

  (if message-nikki-mode-map
      ()
    (setq message-nikki-mode-map (copy-keymap message-mode-map))
    (define-key message-nikki-mode-map "\t" 'hnf:tab-complete))

  (defun mail2nikki:message-func (to cc subject)
    (message-mail to subject (and cc `((Cc . ,cc))))
    (message-goto-body))

  (provide 'mail2nikki:message))

(provide 'mail2nikki)
