/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HRN_QUEUE_H
#define _HRN_QUEUE_H

#include <clutter/clutter.h>
#include <bickley/bkl-item.h>
#include <bognor/br-queue.h>

#include "hrn-source-manager.h"

G_BEGIN_DECLS

#define HRN_TYPE_QUEUE    hrn_queue_get_type ()

#define HRN_QUEUE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_QUEUE, HrnQueue))

#define HRN_QUEUE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), HRN_TYPE_QUEUE, HrnQueueClass))

#define HRN_IS_QUEUE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_QUEUE))

#define HRN_IS_QUEUE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), HRN_TYPE_QUEUE))

#define HRN_QUEUE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), HRN_TYPE_QUEUE, HrnQueueClass))

typedef struct _HrnQueue HrnQueue;
typedef struct _HrnQueueClass HrnQueueClass;
typedef struct _HrnQueuePrivate HrnQueuePrivate;

struct _HrnQueue
{
  NbtkBin       parent_instance;
  HrnQueuePrivate *priv;
};

struct _HrnQueueClass
{
  /*< private >*/
  NbtkBinClass parent_class;
};

GType     hrn_queue_get_type (void) G_GNUC_CONST;

HrnQueue *hrn_queue_new (BrQueue          *br_queue,
                         HrnSourceManager *manager);

/* In a hornsey queue the 0th element is the currently playing
 * element
 */

/* A queue can have a random emitter enabled on the bottom, the
 * random emitter generates a playqueue on the go*/

void         hrn_queue_set_name            (HrnQueue    *queue,
                                            const gchar *name);
const gchar *hrn_queue_get_name            (HrnQueue *queue);
void         hrn_queue_append              (HrnQueue *queue,
                                            BklItem  *item);
void         hrn_queue_prepend_list        (HrnQueue *queue,
                                            GList    *items);
gint         hrn_queue_get_length          (HrnQueue *queue);
void         hrn_queue_insert              (HrnQueue *queue,
                                            gint      pos,
                                            BklItem  *item);
void         hrn_queue_remove              (HrnQueue *queue,
                                            gint      pos);
BklItem *    hrn_queue_get                 (HrnQueue *queue,
                                            gint      pos);
void         hrn_queue_set_active_audio    (HrnQueue *queue,
                                            BklItem  *item,
                                            const gchar *uri);
BklItem *    hrn_queue_get_active_audio    (HrnQueue *queue);
BklItem *    hrn_queue_proceed             (HrnQueue *queue,
                                            gint      item_type_mask);
gboolean     hrn_queue_get_playing         (HrnQueue *queue);

void         hrn_queue_set_playing         (HrnQueue *queue,
                                            gboolean  playing);
void         hrn_queue_audio_finished      (HrnQueue *queue);
void         hrn_queue_hide_audio_progress (HrnQueue *queue);
void         hrn_queue_show_audio_progress (HrnQueue *queue);
void         hrn_queue_audio_peek          (HrnQueue *queue);
gboolean     hrn_cluster_dropped           (ClutterActor *actor,
                                            ClutterActor *dropped_on,
                                            gint          x,
                                            gint          y,
                                            gpointer      userdata);
void         hrn_queue_play_now            (HrnQueue *queue,
                                            BklItem  *item);
void         hrn_queue_play_uri_now        (HrnQueue    *queue,
                                            const gchar *uri);


G_END_DECLS

#endif
