/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2007, 2008, 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __HRN_SQUARE_CLONE_H__
#define __HRN_SQUARE_CLONE_H__

#include <clutter/clutter.h>

G_BEGIN_DECLS

#define HRN_TYPE_SQUARE_CLONE    (hrn_square_clone_get_type ())
#define HRN_SQUARE_CLONE(obj)  \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_SQUARE_CLONE, HrnSquareClone))

#define HRN_SQUARE_CLONE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), HRN_TYPE_SQUARE_CLONE,HrnSquareCloneClass))

#define HRN_IS_SQUARE_CLONE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_SQUARE_CLONE))

#define HRN_IS_SQUARE_CLONE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), HRN_TYPE_SQUARE_CLONE))

#define HRN_SQUARE_CLONE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), HRN_TYPE_SQUARE_CLONE,HrnSquareCloneClass)) 
typedef struct _HrnSquareClone HrnSquareClone;
typedef struct _HrnSquareClonePrivate HrnSquareClonePrivate;
typedef struct _HrnSquareCloneClass HrnSquareCloneClass;

struct _HrnSquareClone
{
  /*< private >*/
  ClutterActor parent_instance;

  HrnSquareClonePrivate *priv;
};

struct _HrnSquareCloneClass
{
  ClutterActorClass parent_class;
};

GType           hrn_square_clone_get_type (void) G_GNUC_CONST;
ClutterActor *  hrn_square_clone_new                (ClutterTexture *texture);
void            hrn_square_clone_set_parent_texture (HrnSquareClone *frame,
                                                     ClutterTexture *texture);
ClutterTexture *hrn_square_clone_get_parent_texture (HrnSquareClone *frame);

G_END_DECLS

#endif /* __HRN_SQUARE_CLONE_H__ */
