#ifndef __HRN_TILEABLE_H__
#define __HRN_TILEABLE_H__

#include <glib-object.h>
#include <clutter/clutter.h>

#include "hrn-cluster-node.h"

G_BEGIN_DECLS

#define HRN_TYPE_TILEABLE (hrn_tileable_get_type ())
#define HRN_TILEABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_TILEABLE, HrnTileable))
#define HRN_IS_TILEABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_TILEABLE))
#define HRN_TILEABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), HRN_TYPE_TILEABLE, HrnTileableInterface))

typedef struct _HrnTileable HrnTileable;
typedef struct _HrnTileableInterface HrnTileableInterface;

typedef enum _HrnTileableAction {
    HRN_TILEABLE_ACTION_PLAY,
    HRN_TILEABLE_ACTION_ENQUEUE,
    HRN_TILEABLE_ACTION_SEARCH,
    HRN_TILEABLE_ACTION_EXPANDED,
    HRN_TILEABLE_ACTION_EXPAND, /* an application will not receive this action
                                  any HrnTiler that receives it will expand
                                  the cluster and forward EXPANDED to the
                                  application */
    HRN_TILEABLE_ACTION_UP_LEVEL,
    HRN_TILEABLE_ACTION_SHOW_ALL,
    HRN_TILEABLE_ACTION_LEVEL_CHANGE,
} HrnTileableAction;

struct _HrnTileableInterface {
    GTypeInterface base_iface;

    guint (*get_count) (HrnTileable *tileable);
    ClutterActor * (*get_thumbnail) (HrnTileable *tileable);
    void (*set_position) (HrnTileable *tileable,
                          guint        x,
                          guint        y);
    HrnClusterNode *(*get_node) (HrnTileable *tileable);
};

GType hrn_tileable_get_type (void);
guint hrn_tileable_get_count (HrnTileable *tileable);
ClutterActor *hrn_tileable_get_thumbnail (HrnTileable *tileable);
void hrn_tileable_set_position (HrnTileable *tileable,
                                guint        x,
                                guint        y);
void hrn_tileable_activated (HrnTileable      *tileable,
                             HrnTileableAction action,
                             gpointer          payload);
void hrn_tileable_item_count_changed (HrnTileable *tileable,
                                      int          old_count,
                                      int          new_count);
HrnClusterNode *hrn_tileable_get_node (HrnTileable *tileable);
void hrn_tileable_visibility_changed (HrnTileable *tileable,
                                      gboolean     hidden);

G_END_DECLS

#endif
