/* This file is part of MemMXtest
 * Copyright (C) 1999, 2000  J.A. Bezemer
 * This program is licensed under the GNU General Public License,
 * see the top-level README file for details.
 */

/* First part, common to all march elements */


#include "defines.h"

					/* Check for defines */
#if ! defined (NormalEl)	\
 && ! defined (PseudoRDEl)
	ErrorUnsupportedTypeForMarchelmltemplateS
#endif


#define FillAmount	64
#define FillNOPs	.fill FillAmount, 1, 0x90	/* 0x90 = NOP */


/* Preparations *************************************************************/

/* Save old registers and flags */
	pusha				/* Should be `pushad' and `pushfd' */
	pushf				/* but `as' doesn't know that */

	/* Do code mutations, load standard values */
#ifdef NormalEl
	movb  param+P_CONDITION*4, %dl	/* dl = condition (jae or jbe) */
	movb  %dl, conditionbyte	/* store it in the code */
#endif
#ifdef PseudoRDEl
	movl  pseudor_end1, %edx	/* Store end adr of table in code */
	movl  %edx, chkendtab+2		/* (edx = temp) */
#endif
	movl  $16, %edx			/* mm3 = shift amount */
	movd  %edx, %mm3		/* (edx = temp) */

/* Pre-charge the cache if needed */
	movl  param+P_CACHEMODE*4, %edx	/* This only if cache = HALF */
	cmpl  $P_CACHEMODE_HALF, %edx
	jne   getrealparams

	/* Get "pre" parameters */
	pxor  %mm0, %mm0		/* pattern: all-zero */
	pxor  %mm1, %mm1		/* ebp = 0: no errors are detected */
	pxor  %mm5, %mm5		/* mm5 = PR xormask */
	movl  param+P_UPADRCODEPRE*4, %eax /* eax = "pre" upadrcode start */
	movl  param+P_UPADRLENPRE*4, %ebp  /* ebp = "pre" upadrcode length */

	/* Copy "pre" update_adr code */
	movl  $update_adr_start, %ecx	/* eax = source */
	movl  %ebp, %ebx		/* ecx = destination */
copyupadr_pre_loop:			/* ebx = length */
	movl  (%eax), %edx		/* edx = temp */
	movl  %edx, (%ecx)
	addl  $4, %eax
	addl  $4, %ecx
	subl  $4, %ebx
	jg    copyupadr_pre_loop

	/* Invalidate cache */
	wbinvd

FillNOPs				/* Real invalidation happens halfway
					   here due to pre-fetching etc. */

	/* Read error reporting area */
	movl  error_p, %eax		/* eax = start */
	movl  lasterror_p, %ebx		/* ebx = end */
readerr_pre_loop:			/* edx = temp */
	movl  (%eax), %edx
	addl  $4, %eax
	cmpl  %ebx, %eax
	jb    readerr_pre_loop

	/* Prepare update_adr */
	call  update_adr_start		/* Prepare addressing */
					/* Sets eax, ebx, esi, edi */

	/* Execute "pre"-test */
	movl  $0x00000000, %ebp		/* ebp is `test' mask */
#ifdef PseudoRDEl
	movd  %ebp, %mm4		/* ebp to mm4, esi to mm6 because we */
	movd  %esi, %mm6		/* need ebp and esi for other things */
#endif

	call  begintest

	/* Cache to no-fill -- we don't want to spoil it */
	movl  %cr0, %edx		/* In control reg #0, */
	orl   $0x60000000, %edx		/* set CD=1 and NW=1 */
	movl  %edx, %cr0

FillNOPs				/* Real switch happens halfway
					   here due to pre-fetching etc. */

	/* Get real parameters */
getrealparams:
	movq  param+P_POSPATTERNU*4, %mm0  /* mm0 = positive pattern */
	movq  param+P_NEGPATTERNU*4, %mm1  /* mm1 = negative pattern */
	movq  param+P_PSEUDORMASKU*4, %mm5 /* mm5 = PR xormask */
	movl  param+P_UPADRCODE*4, %eax	/* eax = real upadrcode start */
	movl  param+P_UPADRLEN*4, %ebp	/* ebp = real upadrcode length */

	/* Copy real update_adr code */
	movl  $update_adr_start, %ecx	/* eax = source */
	movl  %ebp, %ebx		/* ecx = destination */
copyupadr_real_loop:			/* ebx = length */
	movl  (%eax), %edx		/* edx = temp */
	movl  %edx, (%ecx)
	addl  $4, %eax
	addl  $4, %ecx
	subl  $4, %ebx
	jg    copyupadr_real_loop

	movl  param+P_CACHEMODE*4, %ecx	/* This only if cache = HALF */
	cmpl  $P_CACHEMODE_HALF, %ecx	/* We'll use ecx later */
	jne   callupadrstart_real

	/* Cache to fill */
	movl  %cr0, %edx		/* In control reg #0, */
	andl  $0x9fffffff, %edx		/* set CD=0 and NW=0 */
	movl  %edx, %cr0

FillNOPs				/* Real switch happens halfway
					   here due to pre-fetching etc. */

	/* Prepare update_adr */
callupadrstart_real:
	call  update_adr_start		/* Prepare addressing */
					/* Sets eax, ebx, esi, edi */

	cmpl  $P_CACHEMODE_ON, %ecx	/* Skip this if cache = ON */
	je    calltest_real

#ifdef PseudoRDEl
	/* Read PR tables as far as needed */
	movl  pseudor_start1, %ebp	/* ebp = start (rest is used already)*/
readprtab_real_loop:			/* edx = temp */
	movl  (%ebp), %edx
	addl  $4, %ebp
	cmpl  pseudor_end2, %ebp	/* end of table 2 */
	jb    readprtab_real_loop
#endif

	/* Cache to no-fill */
	movl  %cr0, %edx		/* In control reg #0, */
	orl   $0x60000000, %edx		/* set CD=1 and NW=1 */
	movl  %edx, %cr0

FillNOPs				/* Real switch happens halfway
					   here due to pre-fetching etc. */

	cmpl  $P_CACHEMODE_OFF, %ecx    /* This only if cache = OFF */
	jne   calltest_real

	/* Invalidate cache */
	wbinvd

FillNOPs				/* Real invalidation happens halfway
					   here due to pre-fetching etc. */

	/* Execute real test */
calltest_real:
	movl  $0xFFFFFFFF, %ebp		/* ebp is `test' mask */
#ifdef PseudoRDEl
	movd  %ebp, %mm4		/* ebp to mm4, esi to mm6 because we */
	movd  %esi, %mm6		/* need ebp and esi for other things */
#endif

	call  begintest

	/* Cache to fill */
	movl  %cr0, %edx		/* In control reg #0, */
	andl  $0x9fffffff, %edx		/* set CD=0 and NW=0 */
	movl  %edx, %cr0

	/* Invalidate cache */
	wbinvd

#ifdef PseudoRDEl
	/* Write back updated PR values */
	movq  %mm0, param+P_POSPATTERNU*4  /* mm0 = `positive' PR value */
	movq  %mm1, param+P_NEGPATTERNU*4  /* mm1 = `negative' PR value */
#endif

/* Restore old flags and registers */
	popf
	popa

/* Return */
	ret

