/*
 * Hydrogen
 * Copyright(c) 2002-2004 by Alex >Comix< Cominu [comix@users.sourceforge.net]
 *
 * http://hydrogen.sourceforge.net
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY, without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * $Id: Object.cpp,v 1.7 2004/06/29 10:56:48 comix Exp $
 *
 */

#include "Object.h"
#include "config.h"

unsigned int Object::nObjects = 0;
bool Object::m_bUseLog = false;
map<string, int> Object::m_ObjectMap;




//----------------------------------------------------------------------------
/**
 * Constructor
 */
Object::Object( string sClassName ) {
	nObjects++;
	m_sClassName = sClassName;
//	infoLog( "NEW " + m_sClassName );

	if (m_bUseLog) {
		int nInstances = m_ObjectMap[ m_sClassName ];
		nInstances++;
		m_ObjectMap[ m_sClassName ] = nInstances;
	}
}


/**
 * Copy constructor
 */
Object::Object( const Object& obj ) {
	nObjects++;
	m_sClassName = obj.m_sClassName;
//	std::cout << "copy constructor of " << m_sClassName << std::endl;

	if (m_bUseLog) {
		int nInstances = m_ObjectMap[ m_sClassName ];
		nInstances++;
		m_ObjectMap[ m_sClassName ] = nInstances;
	}
}


//----------------------------------------------------------------------------
/**
 * Destructor
 */
Object::~Object() {
	nObjects--;
//	infoLog( "DESTROY " + m_sClassName );

	if (m_bUseLog) {
		int nInstances = m_ObjectMap[ m_sClassName ];
		nInstances--;
		m_ObjectMap[ m_sClassName ] = nInstances;
	}
}





//----------------------------------------------------------------------------
/**
 * Return the number of Objects not deleted
 */
uint Object::getNObjects() {
	return nObjects;
}



//----------------------------------------------------------------------------
/**
 *
 */
void Object::infoLog(string msg) {
	if (m_bUseLog) {
		logger.info(this, msg);
	}
}




//----------------------------------------------------------------------------
/**
 *
 */
void Object::warningLog(string msg) {
	logger.warning(this, msg);
}




//----------------------------------------------------------------------------
/**
 *
 */
void Object::errorLog(string msg) {
	logger.error(this, msg);
}


void Object::useVerboseLog( bool bUse )
{
	m_bUseLog = bUse;
}

bool Object::isUsingVerboseLog()
{
	return m_bUseLog;
}



void Object::printObjectMap()
{
	std::cout << "[Object::printObjectMap]" << std::endl;

	map<string, int>::iterator iter = m_ObjectMap.begin();
	int nTotal = 0;
	do {
		int nInstances = (*iter).second;
		string sObject = (*iter).first;
		if ( nInstances != 0 ) {
			std::cout << nInstances << "\t" << sObject << std::endl;
		}
		nTotal += nInstances;
		iter++;
	} while ( iter != m_ObjectMap.end() );

	std::cout << "Total : " << nTotal << " objects." << std::endl;
}







//----------------------------------------------------------------------------
/**
 * Constructor
 */
Logger::Logger() {
}




//----------------------------------------------------------------------------
/**
 * Destructor
 */
Logger::~Logger() {
}





//----------------------------------------------------------------------------
/**
 * Simple log
 */
void Logger::log(string logMsg) {
	std::cout << "[LOG] > " << logMsg.c_str() << std::endl;
}





//----------------------------------------------------------------------------
/**
 * Information Log
 */
void Logger::info(Object *obj, string logMsg) {
	std::cout << "\033[32m" << "[INFO]      " << obj->getClassName() << "   \t" << logMsg.c_str()  << "\033[0m" << std::endl;
}




//----------------------------------------------------------------------------
/**
 * Warning Log
 */
void Logger::warning(Object *obj, string logMsg) {
	std::cout << "\033[36m" << "[WARNING]   " << obj->getClassName() << "   \t" << logMsg.c_str()  << "\033[0m" << std::endl;
}



//----------------------------------------------------------------------------
/**
 * Error Log
 */
void Logger::error(Object *obj, string errorMsg) {
	std::cout << "\033[31m"<< "[ERROR]     " << obj->getClassName() << "   \t" << errorMsg.c_str() << "\033[0m" <<  std::endl;
}


