
#ifndef _SHOUT_H_
#define _SHOUT_H_

#include "util.h"
#include "config.h"

/* Set this to the password on your server */
#define PASSWORD "letmein"

/* And the name */
#define NAME "Radio AP!"

/* And the genre */
#define GENRE "Monkey Music"

/* And the url */
#define URL "http://www.apan.com/"

#define DESCRIPTION "The best monkey music monkeys can buy"

#define MOUNTPOINT "default"

/* This is the directory where shout puts the following files:
   shout.pid
   shout.playlist
   shout.cue
   shout.log
*/
#ifndef _WIN32
#define DEFAULT_BASE_DIR "/tmp"
#endif

#ifndef _WIN32
#define DELIMITER '/'
#else
#define DELIMITER '\\'
#endif

/* Run system (DJPROGRAM) before every song
   Please note that this is terribly inefficient */
#define DJPROGRAM "/usr/local/bin/im_the_dj -with -lots -of -cool -options"

/* This is the default config file. 
   Note that this _always_ gets parsed, even if you supply another
   config file as an argument */
#define DEFAULT_CONFIG_FILE "shout.conf"

/* Connect to this port on the server, (Don't think you can change this) */
#define PORTNUM 8000

/* Play at this bitrate unless specified otherwise */
#define DEFAULT_BITRATE 128000


#ifdef DIE_ON_SMALL_ERRORS
# define exit_or_return(x) px_shutdown (x);
#else
# define exit_or_return(x) 
#endif 

/* Levels for scream() */
#define NORMAL 0
#define VERBOSE 1
#define TOERROR 2


/* Things for exit_or_return() */
#define EXISTS 100
#define READ 101

/* This should be set to something optimal on your system */
#define DEFAULT_BUFFER_SIZE 4096

/* This is just for scream() */
#define BUFSIZE 1024

#ifdef __GNUC__
#define HAVE_LONG_LONG
#endif


/* Functions in shout.c */
void setup_signal_traps ();
void play_song (char *ap, int rate, const char *command);
int play_from_playlist (const int which);
void play_loop ();

void add_file_to_playlist (char *file);
void add_list_to_playlist (char *file);
void setup_defaults ();
int parse_arguments (int argc, char **argv);

void do_the_dj_thing (const char *command);
void put_in_cue_file (char *filename, int size, int rate, int seconds, 
		      int played, int index);
void usage ();
void s1gnal (const int sig);
void setup_playlist ();
void px_shutdown (const int err);
void show_settings ();
void post_config ();

/* In rand.c */
void rand_file (FILE *fp, FILE *out);

/* In mpeg.c */
int bitrate_of (const char *filename);

/* In configfile.c */
int parse_config_file (char *path, char *file);

void scream (int where, char *how, ...);
void xaudio_login ();
void icy_login ();
void login ();
void update_meta_info_on_server (char *filename, unsigned long int size);

/* Global program setting */
typedef struct setSt
{
  unsigned int autodetection:1;
  unsigned int shuffle_playlist:1; /* Shuffle the playlist */
  unsigned int loop:1;             /* Loop forever */
  unsigned int shortfilenames:1;    /* shorten file names (no dir) for streaming */
  unsigned int verbose:1;
  unsigned int autocorrection:1;
  unsigned int setup_playlist:1;
  unsigned int truncate:1;
  unsigned int use_cue_file:1;
  unsigned int use_id3:1;
  unsigned int update_cue_file:1;
  unsigned int use_dj:1;
  unsigned int public:1;
  unsigned int skip:1;
  unsigned int use_icy:1;
  unsigned int logged_in:1;
  unsigned int titlestreaming:1;
  unsigned int daemon:1;
  double overhead;
  double buffer_overhead;
  int current_bitrate;
  int playlist_index;
  int port;
  int graphics;
  char description[BUFSIZE];
  char mount_name[BUFSIZE];
  char configfile[BUFSIZE];
  char servername[BUFSIZE];
  char playlist[BUFSIZE];
  char cuefile[BUFSIZE];
  char logfilename[BUFSIZE];
  char password[BUFSIZE];
  char djfile[BUFSIZE];
  char url[BUFSIZE];
  char pidfile[BUFSIZE];
  char genre[BUFSIZE];
  char name[BUFSIZE]; 
  char autodump[BUFSIZE];
  char *etcdir;
  char *logdir;
  FILE *logfile;
  my_long_t latency;
}set_t;

/* types of files we want to open so we look for them in the correct dirs */
typedef enum { conf_file_e = 1, log_file_e = 2 } filetype_t;

/* Define this if you're interested in cluttering up your screen */
#undef DEBUG_BITRATE 
#undef DEBUG_ALLOC

#endif
