#ifndef _SOCK_H_
#define _SOCK_H_
#if _WIN32
#include <winsock.h>
#else
#endif

#ifdef _WIN32
typedef SOCKET sock_t;
#else
typedef int sock_t;
#endif

#ifndef _WIN32
#define INVALID_SOCKET -1
#define SOCKET_ERROR -1
#endif

sock_t sock_connect(char *hostname, int port);
int sock_close(sock_t sockfd);
int sock_write(sock_t sockfd, char *fmt, ...);


char *url_encode (char *str, char **result_p);

int is_recoverable (int error);

#endif
