/**
 * IceMC - a menu editor for IceWM
 * Copyright (c) 2000 Georg Mittendorfer
 */

// IceListView.cpp
// created: mig 001001

#include"IceListView.h"

#include<qevent.h>

//////////////////////////////////////////////////////////////
// constructor & destructor
//////////////////////////////////////////////////////////////

IceListView::IceListView(QWidget* parent=0, const char* name=0)
  : QListView(parent,name)
{
  dndItem = 0;
  dnd = false;
  dragColor = QColor(200,200,200);
}

IceListView::~IceListView() {}

/////////////////////////////////////////////////////////////
// public static data
/////////////////////////////////////////////////////////////

QColor IceListView::executable = QColor(0,0,0);
QColor IceListView::notExecutable = QColor(200,0,0);

QString IceListView::iconPath = 0;
QString IceListView::path = 0;
//QString IceListView::path = std::getenv("PATH");


/////////////////////////////////////////////////////////////
// public methods
/////////////////////////////////////////////////////////////

IceListViewItem* IceListView::selectedItem() const // virtual
{
  return (IceListViewItem*)(QListView::selectedItem());
}

IceListViewItem* IceListView::currentItem() const // virtual
{
  return (IceListViewItem*)(QListView::currentItem());
}

IceListViewItem* IceListView::firstChild() const // virtual
{
  return (IceListViewItem*)(QListView::firstChild());
}

IceListViewItem* IceListView::createItem(IceListViewItem* after, QString info = QString::null) // virtual
{
  IceListViewItem* item;

  if (after) {
    IceListViewItem* above = after;
    IceListViewItem* parent;
    if (above->isOpen()) {
      item = new IceListViewItem(above, above, info);
    }
    else {
      parent = above->parent();
      if (!parent)
				item = new IceListViewItem(this, above, info);
      else
				item = new IceListViewItem(parent, above, info);
    }
  }
  else
    item = new IceListViewItem(this,info);

  if (info == "menu") {
    item->setExpandable(true);
  }

  return item;
}

void IceListView::updateList() // virtual
{
  //  ASSERT(typeid(this->firstChild()) == typeid(IceListViewItem*));
  updateListRec(this->firstChild());
}

void IceListView::updateFolder(IceListViewItem* item) // virtual
{
  // comments vgl IceListView::updateListRec(...)
  // here we don't have to check the siblings for parent
  bool own = false;
  if (item->isExpandable()) {
    ;//qDebug("DEBUG: updateFolder: " + item->text(0));
    if (!item->firstChild()) {
      item->setIcon();
      item->setColor(notExecutable);
    }
    else { // folder
      // check own childs
      own = updateListRec(item->firstChild());
      if (own) // set folder executable if own children are
				item->setColor(executable);
      else
				item->setColor(notExecutable);
      item->setIcon();
    }
  }
  else
    qWarning("WARNING: IceListView::updateFolder(...) => item isn't a folder!");
}

void IceListView::updateRootFolder(IceListViewItem* item) // virtual
{
  if (item) {
    ;//qDebug("DEBUG: updateRootFolder: " + item->text(0));
    IceListViewItem* parent;
    parent = item->parent();
    if (parent) {
      while (parent->parent())
				parent = parent->parent();
      updateFolder(parent);
    }
    else if (item->isExpandable())
      updateFolder(item);
  }
  else
    qWarning("WARNING: IceListView::updateRootFolder: null pointer!");
}

//////////////////////////////////////////////////////////////
// protected methods
//////////////////////////////////////////////////////////////

bool IceListView::updateListRec(IceListViewItem* item) // virtual
{
  // updates all items in list and
  // checks subfolders to get execstate of parent
  bool own = false; // own visible state
  bool siblings = false; // state of siblings
  bool parent = false; // state of item above own
  if (item) { // normal item
    if (!item->firstChild()) {
      // check siblings and get their return value
      siblings = updateListRec(item->nextSibling());
      if (siblings)
	parent = true;
      // check own return value
      item->setIcon();
      own = item->setExecState();
      if (own)
	parent = true;
    }
    else { // folder
      // check own childs
      own = updateListRec(item->firstChild());
      if (own) {
	parent = true;
	// set folder executable if own chids are
	item->setColor(executable);
      }
      else
	item->setColor(notExecutable);
      item->setIcon();
      // check siblings and their return value
      siblings = updateListRec(item->nextSibling());
      if (siblings)
	parent = true;
    }
  }
  // return true if own state or state of one sibling is true
  return parent;
}

//  void IceListView::dragEnterEvent(QDragEnterEvent* e)
//  {
//    ;//qDebug("DEBUG: IceListView::dragEnterEvent(...)");
//  }

//  void IceListView::dropEvent(QDropEvent* e)
//  {
//    ;//qDebug("DEBUG: IceListView::dropEvent(...)");
//  }

void IceListView::contentsMousePressEvent(QMouseEvent* e) // virtual
{
  // vorbereitungen fuer d'n'd treffen (dnd = true); dnditem*
  QListView::contentsMousePressEvent(e);
  if ((e->button() == QMouseEvent::LeftButton) && (dndItem = this->selectedItem()) && (!dnd)) {
    ;//qDebug("DEBUG: IceListView::contentsMousePressEvent(...) LeftButton pressed => start dragging");
    QApplication::setOverrideCursor(Qt::pointingHandCursor);
    dropColor = dndItem->getColor();
    dndItem->setColor(dragColor);
    dnd = true;
  }
}

void IceListView::contentsMouseMoveEvent ( QMouseEvent* e) // virtual
{
  QListView::contentsMouseMoveEvent(e);
  if ((e->state() == QMouseEvent::LeftButton) && (dnd)) {
    //    ;//qDebug("DEBUG: IceListView::contentsMouseMoveEvent(...) LeftButton pressed => dragging");
  }
}

void IceListView::contentsMouseReleaseEvent(QMouseEvent* e) // virtual
{
  QListView::contentsMouseReleaseEvent(e);
  if ((e->button() == QMouseEvent::LeftButton) && (dnd)) {
    ;//qDebug("DEBUG: IceListView::contentsMouseReleaseEvent(...) LeftButton released");
    QApplication::restoreOverrideCursor();
    if (dndItem != this->selectedItem()) {
      ;//qDebug("DEBUG: IceListView::contentsMouseReleaseEvent(...) drop");
      if (e->state() & ControlButton) { // copy
				dropItem(this->selectedItem(),false);
      }
      else { // cut
				dropItem(this->selectedItem(),true);
      }
    }
    dnd = false;
		if (dndItem) { 
      dndItem->setColor(dropColor);
      dndItem->repaint();
    }
  }
}

///////////////////////////////////////////////////////////////////
// protected methods
///////////////////////////////////////////////////////////////////

void IceListView::dropItem(IceListViewItem* after, bool cut=true) // virtual
{
  ;//qDebug("IceListView::dropItem(...)");
  QApplication::setOverrideCursor(Qt::waitCursor);
  IceListViewItem* parent = after;
  while ((parent = parent->parent()) && (parent != dndItem)) { }
  if (parent == dndItem) {
    // TODO: errorhandling
    qWarning("WARNING: drop into itself not permitted!");
  }
  else {

    IceListViewItem* item = createItem(after);
    dndItem->deepCopy(item);

    parent = item->parent();
    if (item->getInfo() == "menu") { // folder
      if (!parent)
				this->updateFolder(item);
    }
    else { // no folder
      item->setExecState();
      item->setIcon();
    }

    if (parent) // for all
      this->updateRootFolder(item);

    if (cut) {
      if ((parent = dndItem->parent())) {
				parent->takeItem(dndItem);
				updateRootFolder(parent);
      }
      else
				this->takeItem(dndItem);
      delete dndItem;
      dndItem = 0;
    }

  }
  QApplication::restoreOverrideCursor();
}












