#include <iostream.h>
#include <id3/tag.h>
#include <stdlib.h>

void DeleteTag(int argc, char *argv[], int optind, int whichTags)
{
    for (size_t nIndex = optind; nIndex < argc; nIndex++)
    {
      try
      {
        ID3_Tag myTag;

        cout << "Stripping id3 tag in \"";
        cout << argv[nIndex] << "\"...";

        myTag.Clear();
        myTag.Link(argv[nIndex], (luint) ID3TT_ALL);

        luint nTags;
        switch(whichTags) 
        {
          case 1: 
            nTags = myTag.Strip(ID3TT_ID3V1);
            cout << "id3v1 ";
            break;
          case 2:
            nTags = myTag.Strip(ID3TT_ID3V2);
            cout << "id3v2 ";
            break; 
          case 0:
          default:
            nTags = myTag.Strip(ID3TT_ID3);
            cout << "id3v1 and v2 ";
        }

        cout << "stripped." << endl;
      }

      catch(ID3_Error err)
      {
        cout << endl;
        cout << err.GetErrorFile() << " (" << err.GetErrorLine() << "): "
             << err.GetErrorType() << ": " << err.GetErrorDesc() << endl;
        exit(1);
      }
    }

  return;
}


void ConvertTag(int argc, char *argv[], int optind)
{
    for (size_t nIndex = optind; nIndex < argc; nIndex++)
    {
      try
      {
        ID3_Tag myTag;

        cout << "Converting id3v1 tag to id3v2 in ";
        cout << argv[nIndex] << "...";

        myTag.Clear();
        myTag.Link(argv[nIndex], (luint) ID3TT_ALL);

        luint nTags;

        nTags = myTag.Update(ID3TT_ID3V2);
        cout << " converted ";
        cout << endl;
      }

      catch(ID3_Error err)
      {
        cout << endl;
        cout << err.GetErrorFile() << " (" << err.GetErrorLine() << "): "
             << err.GetErrorType() << ": " << err.GetErrorDesc() << endl;
        exit(1);
      }
    }

  return;
}
