/*
 * $Id: usblinux.c,v 1.8 2001/11/27 21:13:56 rousseau Exp $
 *
 * Author : David Corcoran Title : usblinux.h
 * Purpose: To provide Linux abstraction to searaching the USB layer. 
 * Updated: Ludovic Rousseau, Nov 2001
 *
 * License:   See file COPYING
 *
 */

#include <unistd.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <limits.h>
#include <dirent.h>
#include <stdlib.h>
#include <usblinux.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include "Config.h"
#include "GCdebug.h"

#define PCSCLITE_USB_PATH      "/proc/bus/usb"

int open_linux_usb_dev(unsigned int manuID, unsigned int prodID,
	unsigned int lunNum)
{
	DIR *dir, *dirB = NULL;
	struct dirent *entry, *entryB;
	char dirpath[PATH_MAX];
	struct usb_device_descriptor usbDescriptor;

	DEBUG_COMM("Opening directory " PCSCLITE_USB_PATH);
	dir = opendir(PCSCLITE_USB_PATH);
	if (!dir)
	{
		DEBUG_CRITICAL2("Cannot Open USB Path Directory "
			PCSCLITE_USB_PATH ": %s", strerror(errno));
		return -1;
	}

	while ((entry = readdir(dir)) != NULL)
	{
		/*
		 * Skip anything starting with a '.' 
		 */
		if (entry->d_name[0] == '.')
			continue;

		/* ends with digit? */
		if (!strchr("0123456789", entry->d_name[strlen(entry->d_name) - 1]))
			continue;

		sprintf(dirpath, "%s/%s", PCSCLITE_USB_PATH, entry->d_name);

		DEBUG_COMM2("Opening directory %s", dirpath);
		dirB = opendir(dirpath);

		if (!dirB)
			DEBUG_CRITICAL3("Path %s does not exist: %s - do you have USB?",
				dirpath, strerror(errno));

		while ((entryB = readdir(dirB)) != NULL)
		{
			char filename[PATH_MAX + 1];
			int fd,
			 ret;

			/*
			 * Skip anything starting with a . 
			 */
			if (entryB->d_name[0] == '.')
				continue;

			sprintf(filename, "%s/%s", dirpath, entryB->d_name);

			DEBUG_COMM2("Opening %s", filename);

			fd = open(filename, O_RDONLY);
			if (fd < 0)
			{
				DEBUG_CRITICAL3("Open failed %s: %s", filename,
					strerror(errno));
				continue;
			}

			ret = read(fd, (void *) &usbDescriptor, sizeof(usbDescriptor));
			if (ret < 0)
			{
				DEBUG_CRITICAL3("Read error on %s: %s", filename,
					strerror(errno));
				close(fd);
				continue;
			}

			close (fd);

			/*
			 * Device is found and we don't know about it 
			 */
			DEBUG_COMM2("idVendor: 0x%04X", usbDescriptor.idVendor);
			DEBUG_COMM2("idProduct: 0x%04X", usbDescriptor.idProduct);
			if (usbDescriptor.idVendor == manuID &&
				usbDescriptor.idProduct == prodID)
			{
				fd = open(filename, O_RDWR);

				if (fd < 0)
				{
					DEBUG_CRITICAL3("Open failed %s: %s", filename,
						strerror(errno));
					continue;
				}

				closedir(dir);
				closedir(dirB);

				return fd;
			}
			else
				DEBUG_COMM("Wrong device");
		}
	}

	closedir(dir);
	closedir(dirB);

	return -1;
} /* open_linux_usb_dev */

int close_linux_usb_dev(int fd)
{
	return close(fd);
} /* close_linux_usb_dev */

int bulk_linux_usb_dev(int fd, int pipeNum, unsigned char *buffer,
	int *length, int timeout)
{

	struct usb_bulktransfer bulk;
	int ret;

	bulk.ep = pipeNum;
	bulk.len = *length;
	bulk.timeout = timeout;
	bulk.data = buffer;

	ret = ioctl(fd, IOCTL_USB_BULK, &bulk);

	if (ret < 0)
	{
		*length = 0;
		return -1;
	}

	*length = ret;

	return ret;
} /* bulk_linux_usb_dev */

