/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#ifndef ISURFACEPIPELINE_H
#define ISURFACEPIPELINE_H


#include "iviewsubjectpipeline.h"


class iBoundedPlaneSource;
class iBoundedSphereSource;
class iContourFilter;
class iFlipNormalsFilter;
class iIdentityFilter;
class iOptimizePolyDataFilter;
class iProbeFilter;
class iReducePolyDataFilter;
class iReducePolyDataFilter2;
class iReplicatedPolyData;
class iShiftPolyDataFilter;
class iSmoothPolyDataFilter;
class iSurfaceViewSubject;


class iSurfacePipeline : public iViewSubjectPipeline
{

	friend class iSurfaceViewSubject;

public:
	
	enum
	{
		_FixedSurfacePosition = iViewSubjectPipeline::__Last,
		_FixedSurfaceSize,
		_IsoSurfaceLevel,
		_IsoSurfacePipeline,
		_IsoSurfaceVar,
		_Method,
		_NormalsFlipped,
		_PlaneDirection,
		_PlaneResolution,
		_SphereResolution,
		_VarPaint,
		__Last
	};

	virtual void UpdateContents(int n, int info = 0);

protected:
	
	iSurfacePipeline(iSurfaceViewSubject *s);
	virtual ~iSurfacePipeline();

	virtual void ProduceOutput();
	virtual float GetContentsMemorySize() const;

	//
	//  Pipeline operation
	//
	virtual void UpdateFixedSurfacePosition();
	virtual void UpdateFixedSurfaceSize();
	virtual void UpdateIsoSurfaceLevel();
	virtual void UpdateIsoSurfacePipeline(int force);
	virtual void UpdateIsoSurfaceVar();
	virtual void UpdateMethod();
	virtual void UpdateNormalsFlipped();
	virtual void UpdatePlaneDirection();
	virtual void UpdatePlaneResolution();
	virtual void UpdateReplicas();
	virtual void UpdateSphereResolution();
	virtual void UpdateVarPaint(int s);

	iSurfaceViewSubject *mParent;

	//
	//  VTK stuff
	//
	iIdentityFilter *mGateway, *mIsoSurfaceEntryGateway, *mIsoSurfaceExitGateway;
	iContourFilter *mIsoSurfaceSource;
	iReplicatedPolyData *mDataReplicated[2];
	iProbeFilter *mProbeFilter[2];

	iShiftPolyDataFilter *mShiftFilter;
	iReducePolyDataFilter *mReduceFilter;
	iReducePolyDataFilter2 *mReduce2Filter;
	iSmoothPolyDataFilter *mSmoothFilter;
	iFlipNormalsFilter *mFlipNormalsFilter[2];
	iOptimizePolyDataFilter *mOptimizeFilter;

	iBoundedSphereSource *mSphereSource;
	iBoundedPlaneSource *mPlaneSource;

	int mSpecialVar;
};

#endif // ISURFACEPIPELINE_H

