/* IIWU Synth  A soundfont synthesizer
 *
 * Copyright (C)  2001 Peter Hanappe
 * Author: Peter Hanappe, peter@hanappe.com
 *
 * This file is part of the IIWU program. 
 * IIWU is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 *
 */
#ifndef _IIWU_AUPORT_H
#define _IIWU_AUPORT_H

#include "iiwusynth_priv.h"

#ifndef DISABLE_AUPORT

enum iiwu_auport_status
{
  IIWU_AUPORT_CLEAN,
  IIWU_AUPORT_PLAYING,
  IIWU_AUPORT_QUIET,
  IIWU_AUPORT_STOPPED
};

typedef struct _iiwu_pcm_data_t iiwu_pcm_data_t;

/* iiwu_auport */
void iiwu_auport_write(iiwu_auport_t* p, void* buf, int frames);
int iiwu_auport_get_state(iiwu_auport_t* p);
iiwu_pcm_data_t* iiwu_auport_get_dev_format(iiwu_auport_t* p);
int iiwu_auport_get_buffer_size(iiwu_auport_t* p);
int iiwu_auport_get_queue_size(iiwu_auport_t* p);
char* iiwu_auport_get_device_name(iiwu_auport_t* p);
void iiwu_auport_set_device_name(iiwu_auport_t* p, char* name);

/* iiwu_pcm_data */
int iiwu_pcm_data_framesize(iiwu_pcm_data_t* format);
int iiwu_pcm_data_get_bps(iiwu_pcm_data_t* format);
int iiwu_pcm_data_get_channels(iiwu_pcm_data_t* format);
int iiwu_pcm_data_get_format(iiwu_pcm_data_t* format);
int iiwu_pcm_data_get_sample_rate(iiwu_pcm_data_t* format);

/*
 * iiwu_audio_driver
 *
 * the low level audio device interface
 */
typedef struct _iiwu_audio_driver_t iiwu_audio_driver_t;

iiwu_audio_driver_t* new_iiwu_audio_driver(iiwu_auport_t* port);
int iiwu_audio_driver_close(iiwu_audio_driver_t* dev);

#endif /* DISABLE_AUPORT */

#endif /* _IIWU_AUPORT_H */
