#ifndef _HZINPUT_H_
#define _HZINPUT_H_

#include <X11/Xmd.h>

/***************************************************************************/
/*                          Key  Definition                                */
/***************************************************************************/

/* Key Used by Input Method Manager */
#define IMM_NOT_USED_KEY		0
#define IMM_USED_KEY			1
#define FULL_HALF_WIDTH_SWITCH_KEY	2
#define EN_CH_PUNCT_SWITCH_KEY		3
#define ENGLISH_CHINESE_SWITCH_KEY	4
#define ROUND_SWITCH_KEY		5

#define SWITCH_F1_KEY			6
#define SWITCH_F2_KEY			(SWITCH_F1_KEY+1)
#define SWITCH_F3_KEY			(SWITCH_F1_KEY+2)
#define SWITCH_F4_KEY			(SWITCH_F1_KEY+3)
#define SWITCH_F5_KEY			(SWITCH_F1_KEY+4)
#define SWITCH_F6_KEY			(SWITCH_F1_KEY+5)
#define SWITCH_F7_KEY			(SWITCH_F1_KEY+6)
#define SWITCH_F8_KEY			(SWITCH_F1_KEY+7)
#define SWITCH_F9_KEY			(SWITCH_F1_KEY+8)
#define SWITCH_F10_KEY			(SWITCH_F1_KEY+9)
#define SWITCH_F11_KEY			(SWITCH_F1_KEY+10)
#define SWITCH_F12_KEY			(SWITCH_F1_KEY+11)

/* Key Used by Input Method Entry */
#define IME_NOT_USED_KEY		0
#define IME_USED_KEY			1
#define ESC_KEY               		2
#define BACKSPACE_KEY        		3
#define RETURN_KEY            		4
#define INSERT_KEY			5
#define DELETE_KEY			6
#define HOME_KEY			7
#define END_KEY				8
#define PAGEUP_KEY             		9
#define PAGEDOWN_KEY           		10
#define SPACE_KEY           		0x20

/***************************************************************************/
/*                    Input Method Engine  Definition                      */
/***************************************************************************/
#define	MAX_CANDIDATES_NUM		16
#define MAX_INPUT_KEY_NUM		256
#define MAX_PREEDIT_CHAR_NUM		256
#define MAX_CANDIDATE_CHAR_NUM 		256
#define MAX_STATUS_CHAR_NUM    		256
#define MAX_COMMIT_CHAR_NUM    		512

#define MAX_KEYMAP_KEY_NUM		95

#define IME_PREEDIT_AREA 		1
#define IME_LOOKUP_AREA  		2
#define IME_STATUS_AREA  		4
#define IME_COMMIT       		8

#define ENGINE_NOT_INSTALLED 		1
#define ENGINE_NOT_INITIATED 		2
#define ENGINE_INITIATED     		3

#define DEFAULT_ENGINE_PATH		"/usr/lib/im/locale"
#define DEFAULT_DICT_PATH		"data"
#define COMMON_ENGINE_PATH		"common"
#define CODETABLE_ENGINE_NAME    	"ctim"
#define USER_PROFILE_PATH      		".Xlocale"
#define USER_PROFILE_NAME      		"ime.cfg"
#define SYSTEM_PROFILE_NAME      	"sysime.cfg"
#define USER_OPTION_FILE_NAME      	"options.cfg"

#define NUMERIC0_LABEL			3
#define NUMERIC_LABEL			0
#define LOWER_LABEL			1
#define UPPER_LABEL			2

#define NUMERIC0_LABEL_LIST_STR		"0123456789abcdefghijklmnopqrstuvwxyz"
#define NUMERIC_LABEL_LIST_STR		"1234567890abcdefghijklmnopqrstuvwxyz"
#define LOWER_LABEL_LIST_STR		"abcdefghijklmnopqrstuvwxyz"
#define UPPER_LABEL_LIST_STR		"ABCDEFGHIJKLMNOPQRSTUVWXYZ"

#define MAX_ENGINE_NUM			127
#define MAX_NAME_LEN			16

#define MAX_ARGS_NUM			10

/***************************************************************************/
/*         Protocol used by Auxiliary window and Language Engine           */
/***************************************************************************/
/* Conversion Status */
#define CONVERSION_OFF 			0
#define CONVERSION_ON 			1

/* Types of Input Method Switching */
#define IME_ROUND_SWITCH  		0
#define IME_SELECT_SWITCH		1

/* Protocol Number between Auxiliary Window and Language Engine */
/* For PaletteAux */
#define PALETTEAUX_CONNECT			1
#define PALETTEAUX_SWITCH_CONVERSION		2
#define PALETTEAUX_SWITCH_IME			3
#define PALETTEAUX_SWITCH_QJBJ			4
#define PALETTEAUX_SWITCH_PUNCT			5
#define PALETTEAUX_CHANGE_POSITION		6
#define PALETTEAUX_SHOW_OPTIONAUX		7
#define PALETTEAUX_SHOW_SELECTAUX		8
#define PALETTEAUX_SHOW_KEYBOARDAUX		9
#define PALETTEAUX_SHOW_LOOKUPAUX		10
#define PALETTEAUX_START_ACTION			11

#define PALETTEAUX_UPDATE_IMEINFO_NOTIFY	12
#define PALETTEAUX_SWITCH_CONVERSION_NOTIFY	13
#define PALETTEAUX_SWITCH_IME_NOTIFY		14
#define PALETTEAUX_SWITCH_QJBJ_NOTIFY		15
#define PALETTEAUX_SWITCH_PUNCT_NOTIFY		16

/* For Common used protocol */
#define COMMONAUX_COMMIT_KEY			20
#define COMMONAUX_COMMIT_STRING			21
#define COMMONAUX_UPDATE_OPTIONSINFO		22
#define COMMONAUX_LOST_FOCUS			23

#define COMMONAUX_CHANGE_FOCUS_NOTIFY		24
#define COMMONAUX_UPDATE_KEYMAPINFO_NOTIFY	25
#define COMMONAUX_SET_IME_NEW_NOTIFY		26
#define COMMONAUX_SET_IME_INFO_NOTIFY		27
#define COMMONAUX_SET_IME_END_NOTIFY		28

/* For OptionAux */
#define OPTIONAUX_CONNECT			30
#define OPTIONAUX_CHANGE_STATUS			31

#define OPTIONAUX_SHOW_NOTIFY			32
#define OPTIONAUX_HIDE_NOTIFY			33
#define OPTIONAUX_UPDATE_ARGS_NEW_NOTIFY	34
#define OPTIONAUX_UPDATE_ARGS_INFO_NOTIFY	35

/* For SelectAux */
#define SELECTAUX_CONNECT			40
#define SELECTAUX_UPDATE_IMEINFO		41
#define SELECTAUX_CHANGE_STATUS			42

#define SELECTAUX_SHOW_NOTIFY			43
#define SELECTAUX_HIDE_NOTIFY			44

/* For KeyboardAux */
#define KEYBOARDAUX_CONNECT			50
#define KEYBOARDAUX_CHANGE_POSITION		51
#define KEYBOARDAUX_CHANGE_KEY_STATUS		52

#define KEYBOARDAUX_SHOW_NOTIFY			53
#define KEYBOARDAUX_HIDE_NOTIFY			54
#define KEYBOARDAUX_PRESS_KEY_NOTIFY		55

/* For LookupAux */
#define LOOKUPAUX_CONNECT			60
#define LOOKUPAUX_CHANGE_STATUS			61
#define LOOKUPAUX_CHANGE_POSITION		62

#define LOOKUPAUX_SHOW_NOTIFY			63
#define LOOKUPAUX_HIDE_NOTIFY			64

/* For ActionAux */
#define ACTIONAUX_CONNECT			70
#define ACTIONAUX_START_ACTION_NOTIFY		71

/* For CompositeAux */
#define COMPOSITEAUX_DRAW_NOTIFY		80
#define COMPOSITEAUX_DRAW_PREEDIT_NOTIFY	81
#define COMPOSITEAUX_DRAW_LOOKUP_NOTIFY		82
#define COMPOSITEAUX_SHOW_NOTIFY		83
#define COMPOSITEAUX_HIDE_NOTIFY		84
#define COMPOSITEAUX_CONNECT      		85

/***************************************************************************/
/*         IME Char Decoration used by Language Engine                     */
/***************************************************************************/
typedef enum _IMDecULineType {
    ULINE_NONE = 0,
    ULINE_SINGLE = 1,
    ULINE_DOUBLE = 2,
    ULINE_LOW = 3
} IMDecULineType;

#define CA_COLOR_NONE                  0

#define CA_COLOR_PRE_NORMAL            1
#define CA_COLOR_PRE_NORMAL_SIMBOL     2
#define CA_COLOR_PRE_NORMAL_PUNC       3
#define CA_COLOR_PRE_NORMAL_SEPERATOR  4
#define CA_COLOR_PRE_NORMAL_CONVERTED  5
#define CA_COLOR_PRE_NORMAL_SELECTED   6

#define CA_COLOR_PRE_LIGHT_SEPERATOR   7

#define CA_COLOR_ERROR                 8

#define CA_COLOR_LKP_NORMAL            9
#define CA_COLOR_LKP_BESTSENTENCE      10
#define CA_COLOR_LKP_FIRST             11
#define CA_COLOR_LKP_MARK              12


typedef struct _IMCharDecoration {
      unsigned        fgcolor_idx:8;
      unsigned        bgcolor_idx:8;
      unsigned        ulcolor_idx:8;
      unsigned        underline:3;
      unsigned        bold:1;
      unsigned        italic:1;
      unsigned        reserve:3;
} IMCharDecoration;

/***************************************************************************/
/*                 IME structure used by Language Engine                   */
/***************************************************************************/
typedef struct {
        int 		encode;
        int		inputkey_len;
        int		preedit_len;
        int		lookup_num;
        int		commit_len;
        int		status_len;
        char 		*inputkey_buf;  	/* buffer for input keys */
        unsigned char 	*commit_buf;		/* buffer for commit string */
        unsigned char  	*preedit_buf;		/* buffer for preedit area */
        unsigned char 	*status_buf;		/* buffer for status area  */
        unsigned char 	**lookup_buf;		/* buffer for lookup area  */
        unsigned char 	**candidates_buf;  	/* buffer for candidates strings    */
        unsigned char 	**additions_buf;	/* buffer for candidates additions  */

        int		preedit_caretpos;
        int		cur_lookup_pos;
        CARD8		lookup_label_type;
        CARD8 		return_status;

        unsigned short	session_id;

        /* Decorations used by IME to render the client presentation */
        int                 preedit_deco_len;
        IMCharDecoration   *preedit_deco;

        int                *lookup_deco_len;
        IMCharDecoration  **lookup_deco;

        int                ime_session_data_engine;
        void               *ime_session_data;
} IMEBufferRec, *IMEBuffer;

/* IMEBaseRec that shared between Language Engine and Auxiliary WIndow. */
typedef struct {
        CARD8 		engine_id;		/* engine identity */
        CARD8 		locale_id;		/* supported locale idendity */
        CARD8 		encode_id;		/* encode that dictionary used */
        CARD8 		status;			/* engine status: initialized or installed */
        char		*ename; 		/* English name of this engine */
        char 		*cname;			/* Chinese Name of this engine */
} IMEBaseRec, *IMEBase;

/* Arguments:
system arguments ---> IMECoreRec
user defined arguments   ---> Desktop_data
*/
typedef struct {
        char		*name;
        CARD8		type;
        CARD8 		value;
} IMEArgRec, *IMEArg;

typedef struct {
        int 		args_num;
        IMEArgRec	args[MAX_ARGS_NUM];
} IMEArgListRec, *IMEArgList;

/* Runtime Environment */
typedef struct {
        CARD8 		output_encode_id;	/* encode that IME need output */
        char 		*lang_name;		/* language name such as zh_CN/zh_TW... */
        char 		*locale_name;		/* locale name defined in config file */
        char 		*data_path;		/* directory for dictionary */
        char 		*data_ptr;		/* memory pointer for dictionary data */
} IMEEnvListRec, *IMEEnvList;

/* Keymap Information */
typedef struct {
        char 		bSet;			/* whether be set by IM engine */
        char 		*keymap[MAX_KEYMAP_KEY_NUM];
} IMEKeyMapRec, *IMEKeyMap;

/* IME Core Information */
typedef struct {
        IMEBaseRec	baseinfo;		/* Input Method Entry information */
        IMEEnvListRec	envinfo;		/* runtime environment of IME engine */
        IMEArgListRec	argsinfo;		/* system arguments setting */
        IMEKeyMapRec	keymapinfo;		/* key mapping for the IM */
} IMECoreRec, *IMECore;

typedef struct {
        int  		keyCode;
        int 		keyChar;
        int 		modifier;
} IMEKeyRec, *IMEKey;

typedef struct _method_t {
        int  (*IME_SetOptions)(IMECore, char *);
        int  (*IME_SetValues)(IMECore, IMEArgList, int);
        int  (*IME_Init)(IMECore);
        int  (*IME_Open)(IMECore, IMEBuffer);
        int  (*IME_Filter)(IMECore, IMEKey, IMEArgList, IMEBuffer);
        void (*IME_Close)(IMECore);
        void*(*IME_AllocSessionData)(IMECore);     //could be NULL
        void (*IME_FreeSessionData)(void* ime_session_data);    // could be NULL
        void (*IME_ClearSessionData)(void* ime_session_data);   // could be NULL
//        void*(*IME_ConvertionOff)(IMECore, IMEBuffer);
//        void (*IME_ConvertionOn)(IMECore, IMEBuffer);
} IMEMethodsRec, *IMEMethods;

typedef struct {
        IMECoreRec	core;
        IMEMethods	so_methods;
        void		*so_handler;
} IMEEngineRec, *IMEEngine;

typedef struct {
        int 		nIME_Num;
        IMEBaseRec	*arrIME_Base[MAX_ENGINE_NUM];
} IMEListRec;

#endif   /* _HZINPUT_H_  */

