/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include "PYIM.h"

/* 0x6e  0xoe   4  ==>  */
/* 0x70  0x10   4  <==  */

JINT   IsWantedKeysym(JINT *pks);
JINT   IsQuitKeysym(JINT *pks);
JINT   IsQpSpSwitchKeysym(JINT *pks);
JINT   IsEditKeysym(JINT *pks);
JINT   IsPageKeysym(JINT *pks);
JINT   IsSelectKeysym(JINT *pks);
JINT   IsPyKeysym(JINT *pks);

static JINT IsAlphaNum(JINT *pks);
JWORD  GetQuanjiaoSymbol(JINT *pks, JINT IsChnPunc, JINT IsChnAscii);

JINT IsQuitKeysym(JINT *pks)
{
	if (pks[0] == IMXK_QUIT_PYIM)
		return TRUE;
	return FALSE;	
}


JINT IsQpSpSwitchKeysym(JINT *pks)
{
	if (pks[0] == IMXK_ALT_QP_SP)
		return TRUE;
	return FALSE;	
}


JINT IsWantedKeysym(JINT *pks)
{
	JINT   i, nLen;
	
	nLen = 0;
	for (i = 0; (i < SUN_NUM_KEYSYM) && (pks[i] != 0x0L); i++)
		nLen ++;
		
	if (nLen == 0)
		return FALSE;
	
	/*
	**  The following range is fetched from file "IMKeyMap.h"
	**  There maybe some ingoration about "IMXK_KP_xxx". Check it later.
	**
	**  Notice: Internal pesudo_keysym REDRAW_INTERNAL was added !!!! 0xEEEE
	*/
	if( ( pks[0] == IMXK_BackSpace)	 ||
	    ( pks[0] == IMXK_Linefeed)   ||
	    ( pks[0] == IMXK_Return)     ||
	    ( pks[0] == IMXK_Escape)     ||
	    ( pks[0] == IMXK_Multi_key)  ||
	    ( pks[0] == IMXK_MOUSEPREV)  ||
	    ( pks[0] == IMXK_MOUSENEXT)  ||
	    ( pks[0] == IMXK_Clear)        ||
	    ((pks[0] >= IMXK_Home) && (pks[0] <= IMXK_Begin))           ||
	    ((pks[0] >= IMSunXK_AltGraph) && (pks[0] <= IMXK_KP_Space)) ||
	    ((pks[0] >= IMXK_KP_Home) && (pks[0] <= IMXK_KP_Begin))     ||
	    ( pks[0] == IMXK_KP_Delete)  ||
	    ((pks[0] >= IMXK_KP_Multiply) && (pks[0] <= IMXK_KP_9))     ||
	    ((pks[0] >= IMXK_Shift_L) && (pks[0] <= IMXK_Alt_R))        ||
	    ((pks[0] >= IMXK_space) && (pks[0] <= IMXK_asciitilde))     ||
	    ( pks[0] == IMXK_Delete)	 ||
	    ( pks[0] == IMXK_REDRAW_INTERNAL)	
	  )
		return TRUE;
	  	
	return FALSE;
}


JINT IsEditKeysym(JINT *pks)
{
	JINT   i, nLen;
	
	nLen = 0;
	for (i = 0; (i < SUN_NUM_KEYSYM) && (pks[i] != 0x0L); i++)
		nLen ++;
		
	if (nLen == 0)
		return FALSE;
	
	/*
	**  The following range is fetched from file "IMWantedKey.h"
	**  There maybe some ingoration about "IMXK_KP_xxx". Check it later.
	**
	**  Notice: A Self defined Keysym IMXK_REDRAW_INTERNAL was added! 0xEEEE
	*/
	if( (pks[0] == IMXK_Escape)      ||
	    (pks[0] == IMXK_quoteright)  ||
	    (pks[0] == IMXK_Delete)      ||
	    (pks[0] == IMXK_BackSpace)   ||
	    (pks[0] == IMXK_Left)        ||
	    (pks[0] == IMXK_Right)       ||
	    (pks[0] == IMXK_Home)        ||
	    (pks[0] == IMXK_End)         ||
	    (pks[0] == IMXK_REDRAW_INTERNAL)	||
	    ((pks[0] >= IMXK_a) && (pks[0] <= IMXK_z)) 
	  )
	  	return TRUE;
	return FALSE;
}


JINT IsPyKeysym(JINT *pks)
{
	JINT   i, nLen;
	
	nLen = 0;
	for (i = 0; (i < SUN_NUM_KEYSYM) && (pks[i] != 0x0L); i++)
		nLen ++;
		
	if (nLen == 0)
		return FALSE;
	
	/*
	**  The following range is fetched from file "IMWantedKey.h"
	**  There maybe some ingoration about "IMXK_KP_xxx". Check it later.
	**
	**  Notice: A Self defined Keysym IMXK_REDRAW_INTERNAL was added! 0xEEEE
	*/
	if( (pks[0] == IMXK_Escape)      ||
	    (pks[0] == IMXK_quoteright)  ||
	    (pks[0] == IMXK_REDRAW_INTERNAL)	||
	    ((pks[0] >= IMXK_a) && (pks[0] <= IMXK_z)) 
	  )
	  	return TRUE;
	return FALSE;
}


JINT IsPageKeysym(JINT *pks)
{
	JINT   i, nLen;
	
	nLen = 0;
	for (i = 0; (i < SUN_NUM_KEYSYM) && (pks[i] != 0x0L); i++)
		nLen ++;
		
	if (nLen == 0)
		return FALSE;
	
	if( (pks[0] == IMXK_minus)	    ||
	    (pks[0] == IMXK_equal)          ||
	    (pks[0] == IMXK_bracketleft)    ||
	    (pks[0] == IMXK_bracketright)   ||
	    (pks[0] == IMXK_comma)          ||
	    (pks[0] == IMXK_MOUSEPREV)      ||
	    (pks[0] == IMXK_MOUSENEXT)      ||
	    (pks[0] == IMXK_period)         ||
	    (pks[0] == IMXK_Return) )
	  	return TRUE;
	return FALSE;
}


JINT IsSelectKeysym(JINT *pks)
{
	JINT   i, nLen;
	
	nLen = 0;
	for (i = 0; (i < SUN_NUM_KEYSYM) && (pks[i] != 0x0L); i++)
		nLen ++;
		
	if (nLen == 0)
		return FALSE;
	
	if( (pks[0] == IMXK_space)	||
	    ((pks[0] >= IMXK_0) && (pks[0] <= IMXK_9)) )
	  	return TRUE;
	return FALSE;
}


/* SP, 0~9, A~Z, a~z */
/* Chinese Punctation and English Chars */
static JWORD pwPuncArray[2][96] = {
	{ 0xA1A1, 0xA3A1, 0xA1B0, 0xA3A3, 0xA1E7, 0xA3A5, 0xA1EC, 0xA1AE,
	0xA3A8, 0xA1B2, 0xA1C1, 0xA3AB, 0xA3AC, 0xA3AD, 0xA1A3, 0xA1A2,
	0xA3B0, 0xA3B1, 0xA3B2, 0xA3B3, 0xA3B4, 0xA3B5, 0xA3B6, 0xA3B7,
	0xA3B8, 0xA3B9, 0xA3BA, 0xA3BB, 0xA1B8, 0xA3BD, 0xA1BA, 0xA3BF,
	0xA1E6, 0xA3C1, 0xA3C2, 0xA3C3, 0xA3C4, 0xA3C5, 0xA3C6, 0xA3C7,
	0xA3C8, 0xA3C9, 0xA3CA, 0xA3CB, 0xA3CC, 0xA3CD, 0xA3CE, 0xA3CF,
	0xA3D0, 0xA3D1, 0xA3D2, 0xA3D3, 0xA3D4, 0xA3D5, 0xA3D6, 0xA3D7,
	0xA3D8, 0xA3D9, 0xA3DA, 0xA1BC, 0xA1C2, 0xA1BE, 0xA3A4, 0xA1AD,
	0xA1A4, 0xA3E1, 0xA3E2, 0xA3E3, 0xA3E4, 0xA3E5, 0xA3E6, 0xA3E7,
	0xA3E8, 0xA3E9, 0xA3EA, 0xA3EB, 0xA3EC, 0xA3ED, 0xA3EE, 0xA3EF,
	0xA3F0, 0xA3F1, 0xA3F2, 0xA3F3, 0xA3F4, 0xA3F5, 0xA3F6, 0xA3F7,
	0xA3F8, 0xA3F9, 0xA3FA, 0xA1B6, 0xA1F9, 0xA1B4, 0xA1AB, 0x0000 },

	{ 0xA1A1, 0xA3A1, 0xA1B1, 0xA3A3, 0xA1E7, 0xA3A5, 0xA1EC, 0xA1AF,
	0xA3A9, 0xA1B3, 0xA1C1, 0xA3AB, 0xA3AC, 0xA3AD, 0xA1A3, 0xA1A2,
	0xA3B0, 0xA3B1, 0xA3B2, 0xA3B3, 0xA3B4, 0xA3B5, 0xA3B6, 0xA3B7,
	0xA3B8, 0xA3B9, 0xA3BA, 0xA3BB, 0xA1B9, 0xA3BD, 0xA1BB, 0xA3BF,
	0xA1E6, 0xA3C1, 0xA3C2, 0xA3C3, 0xA3C4, 0xA3C5, 0xA3C6, 0xA3C7,
	0xA3C8, 0xA3C9, 0xA3CA, 0xA3CB, 0xA3CC, 0xA3CD, 0xA3CE, 0xA3CF,
	0xA3D0, 0xA3D1, 0xA3D2, 0xA3D3, 0xA3D4, 0xA3D5, 0xA3D6, 0xA3D7,
	0xA3D8, 0xA3D9, 0xA3DA, 0xA1BD, 0xA1C2, 0xA1BF, 0xA3A4, 0xA1AD,
	0xA1A4, 0xA3E1, 0xA3E2, 0xA3E3, 0xA3E4, 0xA3E5, 0xA3E6, 0xA3E7,
	0xA3E8, 0xA3E9, 0xA3EA, 0xA3EB, 0xA3EC, 0xA3ED, 0xA3EE, 0xA3EF,
	0xA3F0, 0xA3F1, 0xA3F2, 0xA3F3, 0xA3F4, 0xA3F5, 0xA3F6, 0xA3F7,
	0xA3F8, 0xA3F9, 0xA3FA, 0xA1B7, 0xA1F9, 0xA1B5, 0xA1AB, 0x0000 }
};


/*
 * Get the Quanjiao[Full Width] symbol of a single 0x20~0x7F Ascii Key.
 * ChnAscii only valid for [SP, 0~9, A~Z, a~z]
 * Return 0x0000 if invalid
 */
JWORD GetQuanjiaoSymbol(JINT *pks, JINT IsChnPunc, JINT IsChnAscii)
{
	JWORD   wTmp;
	JWORD   wRet;
	
	wRet = 0x0000;
	if ((pks[0] < 0x20) || (pks[0] >= 0x7F))
		return wRet;
	
	if ( ((IsChnPunc == TRUE) && (IsChnAscii == TRUE))  || 
	    ((IsChnPunc == TRUE) && (IsChnAscii != TRUE) && (IsAlphaNum(pks) == FALSE)) ||  /* Chinese Punctation Only */
	    ((IsChnPunc != TRUE) && (IsChnAscii == TRUE) && (IsAlphaNum(pks) == TRUE)) )    /* Chinese Ascii Only */
	{
		wRet = pwPuncArray[0][pks[0] - 0x20];
		
		wTmp = pwPuncArray[0][pks[0] - 0x20];
		pwPuncArray[0][pks[0] - 0x20] = pwPuncArray[1][pks[0] - 0x20];
		pwPuncArray[1][pks[0] - 0x20] = wTmp;
	}
	else
		wRet = 0x0000;
		
	return wRet;
}


/* is SP or 0~9, A~Z, a~z, return TRUE, else, return FALSE */
static JINT IsAlphaNum(JINT *pks)
{
	if( (pks[0] == 0x20) || 
	    ((pks[0] >= '0') && (pks[0] <= '9')) ||
	    ((pks[0] >= 'A') && (pks[0] <= 'Z')) ||
	    ((pks[0] >= 'a') && (pks[0] <= 'z')) )
		return TRUE;
	else
		return FALSE;
}


    /* SKB_SYMBSCIENT */
static unsigned short wNewpySym0[] = 
  { 0xA1A4, 0xA1A5, 0xA1A6, 0xA1A7, 0xA1A8, 0xA1A9, 0xA1AA, 0xA1AB, 0xA1AC, 0xA1AD,
    0xA1C0, 0xA1C1, 0xA1C2, 0xA1C3, 0xA1C4, 0xA1C5, 0xA1C6, 0xA1C7, 0xA1C8, 0xA1C9,
    0xA1CA, 0xA1CB, 0xA1CC, 0xA1CD, 0xA1CE,
    0xA1CF, 0xA1D0, 0xA1D1, 0xA1D2, 0xA1D3, 0xA1D4, 0xA1D5, 0xA1D6, 0xA1D7, 0xA1D8,
    0xA1D9, 0xA1DA, 0xA1DB, 0xA1DC, 0xA1DD, 0xA1DE, 0xA1DF, 0xA1E0, 0xA1E1, 0xA1E2,
    0xA1E3, 0xA1E4, 0xA1E5, 0xA1EE, 0xA1EF,
    0xA1F0, 0xA1F1, 0xA1F2, 0xA1F3, 0xA1F4, 0xA1F5, 0xA1F6, 0xA1F7, 0xA1F8, 0xA1F9,
    0xA1FA, 0xA1FB, 0xA1FC, 0xA1FD, 0xA1FE, 0xA1E6, 0xA1E7, 0xA1E8, 0xA1E9, 0xA1EA,
    0xA1EB, 0xA1EC, 0xA1ED,
    0xA3A2, 0xA3E0, 0xA3A7, 0xA3AA, 0xA3C0, 0xA3DE, 0xA3DF, 0xA3FE, 0xA3FC, 0x0000 };

    /* SKB_SERIESONE */
static unsigned short wNewpySym1[] = 
  { 0xA2B1, 0xA2B2, 0xA2B3, 0xA2B4, 0xA2B5, 0xA2B6, 0xA2B7, 0xA2B8, 0xA2B9, 0xA2BA,
    0xA2BB, 0xA2BC, 0xA2BD, 0xA2BE, 0xA2BF, 0xA2C0, 0xA2C1, 0xA2C2, 0xA2C3, 0xA2C4, 
    0x0000 };

    /* SKB_SERIESTWO */
static unsigned short wNewpySym2[] = 
  { 0xA2C5, 0xA2C6, 0xA2C7, 0xA2C8, 0xA2C9, 0xA2CA, 0xA2CB, 0xA2CC, 0xA2CD, 0xA2CE,
    0xA2CF, 0xA2D0, 0xA2D1, 0xA2D2, 0xA2D3, 0xA2D4, 0xA2D5, 0xA2D6, 0xA2D7, 0xA2D8, 
    0x0000 };
 
    /* SKB_SERIESTHREE */
static unsigned short wNewpySym3[] = 
  { 0xA2D9, 0xA2DA, 0xA2DB, 0xA2DC, 0xA2DD, 0xA2DE, 0xA2DF, 0xA2E0, 0xA2E1, 0xA2E2,
    0xA2E5, 0xA2E6, 0xA2E7, 0xA2E8, 0xA2E9, 0xA2EA, 0xA2EB, 0xA2EC, 0xA2ED, 0xA2EE, 
    0x0000 };
    
    /* SKB_SERIESFOUR */
static unsigned short wNewpySym4[] = 
  { 0xA2F1, 0xA2F2, 0xA2F3, 0xA2F4, 0xA2F5, 0xA2F6, 0xA2F7, 0xA2F8, 0xA2F9, 0xA2FA,
    0xA2FB, 0xA2FC,
    0xA2A1, 0xA2A2, 0xA2A3, 0xA2A4, 0xA2A5, 0xA2A6, 0xA2A7, 0xA2A8, 0xA2A9, 0xA2AA, 
    0x0000 };

    /* SKB_GREECE */
static unsigned short wNewpySym5[] = 
  { 0xA6A1, 0xA6A2, 0xA6A3, 0xA6A4, 0xA6A5, 0xA6A6, 0xA6A7, 0xA6A8, 0xA6A9, 0xA6AA,
    0xA6AB, 0xA6AC, 0xA6AD, 0xA6AE, 0xA6AF, 0xA6B0, 0xA6B1, 0xA6B2, 0xA6B3, 0xA6B4,
    0xA6B5, 0xA6B6, 0xA6B7, 0xA6B8,
    0xA6C1, 0xA6C2, 0xA6C3, 0xA6C4, 0xA6C5, 0xA6C6, 0xA6C7, 0xA6C8, 0xA6C9, 0xA6CA,
    0xA6CB, 0xA6CC, 0xA6CD, 0xA6CE, 0xA6CF, 0xA6D0, 0xA6D1, 0xA6D2, 0xA6D3, 0xA6D4,
    0xA6D5, 0xA6D6, 0xA6D7, 0xA6D8, 0x0000 };

    /* SKB_RUSSIAN */
static unsigned short wNewpySym6[] = 
  { 0xA7A1, 0xA7A2, 0xA7A3, 0xA7A4, 0xA7A5, 0xA7A6, 0xA7A7, 0xA7A8, 0xA7A9, 0xA7AA,
    0xA7AB, 0xA7AC, 0xA7AD, 0xA7AE, 0xA7AF, 0xA7B0, 0xA7B1, 0xA7B2, 0xA7B3, 0xA7B4,
    0xA7B5, 0xA7B6, 0xA7B7, 0xA7B8, 0xA7B9, 0xA7BA, 0xA7BB, 0xA7BC, 0xA7BD, 0xA7BE,
    0xA7BF, 0xA7C0, 0xA7C1,
    0xA7D1, 0xA7D2, 0xA7D3, 0xA7D4, 0xA7D5, 0xA7D6, 0xA7D7, 0xA7D8, 0xA7D9, 0xA7DA,
    0xA7DB, 0xA7DC, 0xA7DD, 0xA7DE, 0xA7DF, 0xA7E0, 0xA7E1, 0xA7E2, 0xA7E3, 0xA7E4,
    0xA7E5, 0xA7E6, 0xA7E7, 0xA7E8, 0xA7E9, 0xA7EA, 0xA7EB, 0xA7EC, 0xA7ED, 0xA7EE,
    0xA7EF, 0xA7F0, 0xA7F1, 0x0000 };

    /* SKB_PYSYM */
static unsigned short wNewpySym7[] = 
  { 0xA8A1, 0xA8A2, 0xA8A3, 0xA8A4, 0xA8A5, 0xA8A6, 0xA8A7, 0xA8A8, 0xA8A9, 0xA8AA,
    0xA8AB, 0xA8AC, 0xA8AD, 0xA8AE, 0xA8AF, 0xA8B0, 0xA8B1, 0xA8B2, 0xA8B3, 0xA8B4,
    0xA8B5, 0xA8B6, 0xA8B7, 0xA8B8, 0xA8B9, 0xA8BA, 0xA8BB, 0xA8BC, 0xA8BD, 0xA8BE,
    0xA8BF, 0xA8C0,
    0xA8C5, 0xA8C6, 0xA8C7, 0xA8C8, 0xA8C9, 0xA8CA, 0xA8CB, 0xA8CC, 0xA8CD, 0xA8CE,
    0xA8CF, 0xA8D0, 0xA8D1, 0xA8D2, 0xA8D3, 0xA8D4, 0xA8D5, 0xA8D6, 0xA8D7, 0xA8D8,
    0xA8D9, 0xA8DA, 0xA8DB, 0xA8DC, 0xA8DD, 0xA8DE, 0xA8DF, 0xA8E0, 0xA8E1, 0xA8E2,
    0xA8E3, 0xA8E4, 0xA8E5, 0xA8E6, 0xA8E7, 0xA8E8, 0xA8E9, 0x0000 };

    /* SKB_JAPPIN */
static unsigned short wNewpySym8[] = 
  { 0xA4A1, 0xA4A2, 0xA4A3, 0xA4A4, 0xA4A5, 0xA4A6, 0xA4A7, 0xA4A8, 0xA4A9, 0xA4AA,
    0xA4AB, 0xA4AC, 0xA4AD, 0xA4AE, 0xA4AF, 0xA4B0, 0xA4B1, 0xA4B2, 0xA4B3, 0xA4B4,
    0xA4B5, 0xA4B6, 0xA4B7, 0xA4B8, 0xA4B9, 0xA4BA, 0xA4BB, 0xA4BC, 0xA4BD, 0xA4BE,
    0xA4BF, 0xA4C0, 0xA4C1, 0xA4C2, 0xA4C3, 0xA4C4, 0xA4C5, 0xA4C6, 0xA4C7, 0xA4C8,
    0xA4C9, 0xA4CA, 0xA4CB, 0xA4CC, 0xA4CD, 0xA4CE, 0xA4CF, 0xA4D0, 0xA4D1, 0xA4D2,
    0xA4D3, 0xA4D4, 0xA4D5, 0xA4D6, 0xA4D7, 0xA4D8, 0xA4D9, 0xA4DA, 0xA4DB, 0xA4DC,
    0xA4DD, 0xA4DE, 0xA4DF, 0xA4E0, 0xA4E1, 0xA4E2, 0xA4E3, 0xA4E4, 0xA4E5, 0xA4E6,
    0xA4E7, 0xA4E8, 0xA4E9, 0xA4EA, 0xA4EB, 0xA4EC, 0xA4ED, 0xA4EE, 0xA4EF, 0xA4F0,
    0xA4F1, 0xA4F2, 0xA4F3, 0x0000 };

    /* SKB_JAPPIAN */
static unsigned short wNewpySym9[] = 
  { 0xA5A1, 0xA5A2, 0xA5A3, 0xA5A4, 0xA5A5, 0xA5A6, 0xA5A7, 0xA5A8, 0xA5A9, 0xA5AA,
    0xA5AB, 0xA5AC, 0xA5AD, 0xA5AE, 0xA5AF, 0xA5B0, 0xA5B1, 0xA5B2, 0xA5B3, 0xA5B4,
    0xA5B5, 0xA5B6, 0xA5B7, 0xA5B8, 0xA5B9, 0xA5BA, 0xA5BB, 0xA5BC, 0xA5BD, 0xA5BE,
    0xA5BF, 0xA5C0, 0xA5C1, 0xA5C2, 0xA5C3, 0xA5C4, 0xA5C5, 0xA5C6, 0xA5C7, 0xA5C8,
    0xA5C9, 0xA5CA, 0xA5CB, 0xA5CC, 0xA5CD, 0xA5CE, 0xA5CF, 0xA5D0, 0xA5D1, 0xA5D2,
    0xA5D3, 0xA5D4, 0xA5D5, 0xA5D6, 0xA5D7, 0xA5D8, 0xA5D9, 0xA5DA, 0xA5DB, 0xA5DC,
    0xA5DD, 0xA5DE, 0xA5DF, 0xA5E0, 0xA5E1, 0xA5E2, 0xA5E3, 0xA5E4, 0xA5E5, 0xA5E6,
    0xA5E7, 0xA5E8, 0xA5E9, 0xA5EA, 0xA5EB, 0xA5EC, 0xA5ED, 0xA5EE, 0xA5EF, 0xA5F0,
    0xA5F1, 0xA5F2, 0xA5F3, 0xA5F4, 0xA5F5, 0xA5F6, 0x0000 };
    
    /* SKB_TABSYMB */
static unsigned short wNewpySym10[] = 
  { 0xA9A4, 0xA9A5, 0xA9A6, 0xA9A7, 0xA9A8, 0xA9A9, 0xA9AA, 0xA9AB, 0xA9AC, 0xA9AD,
    0xA9AE, 0xA9AF, 0xA9B0, 0xA9B1, 0xA9B2, 0xA9B3, 0xA9B4, 0xA9B5, 0xA9B6, 0xA9B7,
    0xA9B8, 0xA9B9, 0xA9BA, 0xA9BB, 0xA9BC, 0xA9BD, 0xA9BE, 0xA9BF, 0xA9C0, 0xA9C1,
    0xA9C2, 0xA9C3, 0xA9C4, 0xA9C5, 0xA9C6, 0xA9C7, 0xA9C8, 0xA9C9, 0xA9CA, 0xA9CB,
    0xA9CC, 0xA9CD, 0xA9CE, 0xA9CF, 0xA9D0, 0xA9D1, 0xA9D2, 0xA9D3, 0xA9D4, 0xA9D5,
    0xA9D6, 0xA9D7, 0xA9D8, 0xA9D9, 0xA9DA, 0xA9DB, 0xA9DC, 0xA9DD, 0xA9DE, 0xA9DF,
    0xA9E0, 0xA9E1, 0xA9E2, 0xA9E3, 0xA9E4, 0xA9E5, 0xA9E6, 0xA9E7, 0xA9E8, 0xA9E9,
    0xA9EA, 0xA9EB, 0xA9EC, 0xA9ED, 0xA9EE, 0xA9EF, 0x0000 };
    
    /* SKB_GBKEXTSYM1 */
static unsigned short wNewpySym11[] = 
  { 0xA6E0, 0xA6E1, 0xA6E2, 0xA6E3, 0xA6E4, 0xA6E5, 0xA6E6, 0xA6E7, 0xA6E8, 0xA6E9,
    0xA6EA, 0xA6EB, 0xA6EE, 0xA6EF, 0xA6F0, 0xA6F1, 0xA6F2, 0xA6F4, 0xA6F5, 0xA840,
    0xA841, 0xA842, 0xA843, 0xA844, 0xA845, 0xA846, 0xA847, 0xA848, 0xA849, 0xA84A,
    0xA84B, 0xA84C, 0xA84D, 0xA84E, 0xA84F, 0xA850, 0xA851, 0xA852, 0xA853, 0xA854,
    0xA855, 0xA856, 0xA857, 0xA858, 0xA859, 0xA85A, 0xA85B, 0xA85C, 0xA85D, 0xA85E,
    0xA85F, 0xA860, 0xA861, 0xA862, 0xA863, 0xA864, 0xA865, 0xA866, 0xA867, 0xA868,
    0xA869, 0xA86A, 0xA86B, 0xA86C, 0xA86D, 0xA86E, 0xA86F, 0xA870, 0xA871, 0xA872,
    0xA873, 0xA874, 0xA875, 0xA876, 0xA877, 0xA878, 0xA879, 0xA87A, 0xA87B, 0xA87C,
    0xA87D, 0xA87E, 0xA880, 0xA881, 0xA882, 0xA883, 0xA884, 0xA885, 0xA886, 0xA887,
    0xA888, 0xA889, 0xA88A, 0xA88B, 0xA88C, 0xA88D, 0xA88E, 0xA88F, 0xA890, 0xA891,
    0xA892, 0xA893, 0xA894, 0xA895, 0x0000 };
    
    /* SKB_GBKEXTSYM2 */
static unsigned short wNewpySym12[] = 
  { 0xA940, 0xA941, 0xA942, 0xA943, 0xA944, 0xA945, 0xA946, 0xA947, 0xA948, 0xA949,
    0xA94A, 0xA94B, 0xA94C, 0xA94D, 0xA94E, 0xA94F, 0xA950, 0xA951, 0xA952, 0xA953,
    0xA954, 0xA955, 0xA956, 0xA957, 0xA959, 0xA95A, 0xA95C, 0xA960, 0xA961, 0xA962,
    0xA963, 0xA964, 0xA965, 0xA966, 0xA967, 0xA968, 0xA969, 0xA96A, 0xA96B, 0xA96C,
    0xA96D, 0xA96E, 0xA96F, 0xA970, 0xA971, 0xA972, 0xA973, 0xA974, 0xA975, 0xA976,
    0xA977, 0xA978, 0xA979, 0xA97A, 0xA97B, 0xA97C, 0xA97D, 0xA97E, 0xA980, 0xA981,
    0xA982, 0xA983, 0xA984, 0xA985, 0xA986, 0xA987, 0xA988, 0xA989, 0xA98A, 0xA98B,
    0xA98C, 0xA98D, 0xA98E, 0xA98F, 0xA990, 0xA991, 0xA992, 0xA993, 0xA994, 0xA995,
    0xA996, 0xA9A4, 0xA9A5, 0xA9A6, 0xA9A7, 0xA9A8, 0xA9A9, 0xA9AA, 0xA9AB, 0xA9AC,
    0xA9AD, 0xA9AE, 0xA9AF, 0x0000, 0x0000 };


unsigned short *pwNewpySym[13] = {
	wNewpySym0,
	wNewpySym1,
	wNewpySym2,
	wNewpySym3,
	wNewpySym4,
	wNewpySym5,
	wNewpySym6,
	wNewpySym7,
	wNewpySym8,
	wNewpySym9,
	wNewpySym10,
	wNewpySym11,
	wNewpySym12
};


/********
` 1 2 3 4 5 6 7 8 9 0 - =
~ ! @ # $ % ^ & * ( ) _ +
棣磥
棣磥

[ ] \ ; ' , . /
£
£

{ } | : " < > ?



0 1 2 3 4 5 6 7 8 9 - = `

£ãģţƣǣȣɣʣˣ̣ͣΣϣУѣңӣԣգ֣ףأ٣


     1          0xA1AB            0xA1AB            0xA1BC           0xA1BD
     2          0xA3A1            0xA3A1            0xA1BE           0xA1BF
     3          0xA1E6            0xA1E6            0xA1C2           0xA1C2
     4          0xA3A3            0xA3A3            0xA3BB           0xA3BB
     5          0xA1E7            0xA1E7            0xA1AE           0xA1AF
     6          0xA3A5            0xA3A5            0xA3AC           0xA3AC
     7          0xA3A4            0xA3A4            0xA1A3           0xA1A3
     8          0xA1EC            0xA1EC            0xA1A2           0xA1A2
     9          0xA1C1            0xA1C1
    10          0xA3A8            0xA3A9
    11          0xA1B2            0xA1B3            0xA3C1        0xA3E1
    12          0xA1AD            0xA1AD            0xA3C2        0xA3E2
    13          0xA3AB            0xA3AB            0xA3C3        0xA3E3
    14                                                  0xA3C4        0xA3E4
    15          0xA1B6            0xA1B7            0xA3C5        0xA3E5
    16          0xA1B4            0xA1B5            0xA3C6        0xA3E6
    17          0xA1F9            0xA1F9            0xA3C7        0xA3E7
    18          0xA3BA            0xA3BA            0xA3C8        0xA3E8
    19          0xA1B0            0xA1B1            0xA3C9        0xA3E9
    20          0xA1B8            0xA1B9            0xA3CA        0xA3EA
    21          0xA1BA            0xA1BB            0xA3CB        0xA3EB
    22          0xA3BF            0xA3BF            0xA3CC        0xA3EC
    23                                                  0xA3CD        0xA3ED
    24          0xA3B0                                0xA3CE        0xA3EE
    25          0xA3B1                                0xA3CF        0xA3EF
    26          0xA3B2                                0xA3D0        0xA3F0
    27          0xA3B3                                0xA3D1        0xA3F1
    28          0xA3B4                                0xA3D2        0xA3F2
    29          0xA3B5                                0xA3D3        0xA3F3
    30          0xA3B6                                0xA3D4        0xA3F4
    31          0xA3B7                                0xA3D5        0xA3F5
    32          0xA3B8                                0xA3D6        0xA3F6
    33          0xA3B9                                0xA3D7        0xA3F7
    34          0xA3AD                                0xA3D8        0xA3F8
    35          0xA3BD                                0xA3D9        0xA3F9
    36          0xA1A4                                0xA3DA        0xA3FA
    37

	| SP 	|  ! 	|  " 	|  # 	|  $ 	|  % 	|  & 	|  ' 	|  0x20
	0xA1A1, 0xA3A1, 0xA1B0, 0xA3A3, 0xA1E7, 0xA3A5, 0xA1EC, 0xA1AE,
	0xA1A1, 0xA3A1, 0xA1B1, 0xA3A3, 0xA1E7, 0xA3A5, 0xA1EC, 0xA1AF,

	|  ( 	|  ) 	|  * 	|  + 	|  , 	|  - 	|  . 	|  / 	|  0x28
	0xA3A8, 0xA1B2, 0xA1C1, 0xA3AB, 0xA3AC, 0xA3AD, 0xA1A3, 0xA1A2,
	0xA3A9, 0xA1B3, 0xA1C1, 0xA3AB, 0xA3AC, 0xA3AD, 0xA1A3, 0xA1A2,
	
	|  0 	|  1 	|  2 	|  3 	|  4 	|  5 	|  6 	|  7 	|  0x30
	0xA3B0, 0xA3B1, 0xA3B2, 0xA3B3, 0xA3B4, 0xA3B5, 0xA3B6, 0xA3B7,
	0xA3B0, 0xA3B1, 0xA3B2, 0xA3B3, 0xA3B4, 0xA3B5, 0xA3B6, 0xA3B7,

	|  8 	|  9 	|  : 	|  ; 	|  < 	|  = 	|  > 	|  ? 	|  0x38
	0xA3B8, 0xA3B9, 0xA3BA, 0xA3BB, 0xA1B8, 0xA3BD, 0xA1BA, 0xA3BF,
	0xA3B8, 0xA3B9, 0xA3BA, 0xA3BB, 0xA1B9, 0xA3BD, 0xA1BB, 0xA3BF,

	|  @ 	|  A 	|  B 	|  C 	|  D 	|  E 	|  F 	|  G 	|  0x40
	0xA1E6, 0xA3C1, 0xA3C2, 0xA3C3, 0xA3C4, 0xA3C5, 0xA3C6, 0xA3C7,
	0xA1E6, 0xA3C1, 0xA3C2, 0xA3C3, 0xA3C4, 0xA3C5, 0xA3C6, 0xA3C7,

	|  H 	|  I 	|  J 	|  K 	|  L 	|  M 	|  N 	|  O 	|  0x48
	0xA3C8, 0xA3C9, 0xA3CA, 0xA3CB, 0xA3CC, 0xA3CD, 0xA3CE, 0xA3CF,
	0xA3C8, 0xA3C9, 0xA3CA, 0xA3CB, 0xA3CC, 0xA3CD, 0xA3CE, 0xA3CF,

	|  P 	|  Q 	|  R 	|  S 	|  T 	|  U 	|  V 	|  W 	|  0x50
	0xA3D0, 0xA3D1, 0xA3D2, 0xA3D3, 0xA3D4, 0xA3D5, 0xA3D6, 0xA3D7,
	0xA3D0, 0xA3D1, 0xA3D2, 0xA3D3, 0xA3D4, 0xA3D5, 0xA3D6, 0xA3D7,

	|  X 	|  Y 	|  Z 	|  [ 	|  \ 	|  ] 	|  ^ 	|  _ 	|  0x58
	0xA3D8, 0xA3D9, 0xA3DA, 0xA1BC, 0xA1C2, 0xA1BE, 0xA3A4, 0xA1AD,
	0xA3D8, 0xA3D9, 0xA3DA, 0xA1BD, 0xA1C2, 0xA1BF, 0xA3A4, 0xA1AD,

	|  ` 	|  a 	|  b 	|  c 	|  d 	|  e 	|  f 	|  g 	|  0x60
	0xA1A4, 0xA3E1, 0xA3E2, 0xA3E3, 0xA3E4, 0xA3E5, 0xA3E6, 0xA3E7,
	0xA1A4, 0xA3E1, 0xA3E2, 0xA3E3, 0xA3E4, 0xA3E5, 0xA3E6, 0xA3E7,

	|  h 	|  i 	|  j 	|  k 	|  l 	|  m 	|  n 	|  o 	|  0x68
	0xA3E8, 0xA3E9, 0xA3EA, 0xA3EB, 0xA3EC, 0xA3ED, 0xA3EE, 0xA3EF,
	0xA3E8, 0xA3E9, 0xA3EA, 0xA3EB, 0xA3EC, 0xA3ED, 0xA3EE, 0xA3EF,

	|  p 	|  q 	|  r 	|  s 	|  t 	|  u 	|  v 	|  w 	|  0x70
	0xA3F0, 0xA3F1, 0xA3F2, 0xA3F3, 0xA3F4, 0xA3F5, 0xA3F6, 0xA3F7,
	0xA3F0, 0xA3F1, 0xA3F2, 0xA3F3, 0xA3F4, 0xA3F5, 0xA3F6, 0xA3F7,

	|  x 	|  y 	|  z 	|  { 	|  | 	|  } 	|  ~ 	| DEL	|  0x78
	0xA3F8, 0xA3F9, 0xA3FA, 0xA1B6, 0xA1F9, 0xA1B4, 0xA1AB, 0x0000
	0xA3F8, 0xA3F9, 0xA3FA, 0xA1B7, 0xA1F9, 0xA1B5, 0xA1AB, 0x0000

*******/

